/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import com.wowza.wms.rtp.transport.IUDPTransport;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.rtp.transport.RTPUDPHandler;
import com.wowza.wms.rtp.transport.UDPTransportBase;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.mina.common.ExpiringSessionRecycler;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.IoSessionRecycler;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.executor.ExecutorExecutor;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.DatagramConnector;
import org.apache.mina.transport.socket.nio.DatagramConnectorConfig;
import org.apache.mina.transport.socket.nio.DatagramSessionConfig;

public class RTPUDPTransportMina
extends UDPTransportBase
implements IUDPTransport {
    Map<InetSocketAddress, AcceptorHolder> handlers = new HashMap<InetSocketAddress, AcceptorHolder>();

    private boolean testBind(InetSocketAddress inetSocketAddress) {
        boolean bl = false;
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = new DatagramSocket(inetSocketAddress);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
            datagramSocket = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public InetSocketAddress bind(RTPUDPDatagramConfig rTPUDPDatagramConfig, IUDPMessageHandler iUDPMessageHandler, String string, int n, String string2, int n2, int n3) {
        InetSocketAddress inetSocketAddress;
        block17: {
            inetSocketAddress = string == null ? new InetSocketAddress(n) : new InetSocketAddress(string, n);
            boolean bl = this.acquireSocketAddress(inetSocketAddress);
            if (!bl) {
                WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).warn("RTPUDPTransport.bind: Address already in use: " + inetSocketAddress.toString());
                return null;
            }
            if (string != null && !this.testBind(inetSocketAddress)) {
                this.releaseSocketAddress(inetSocketAddress);
                inetSocketAddress = new InetSocketAddress(inetSocketAddress.getPort());
                bl = this.acquireSocketAddress(inetSocketAddress);
                if (!bl) {
                    WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).warn("RTPUDPTransport.bind: Address already in use: " + inetSocketAddress.toString());
                    return null;
                }
            }
            Executor executor = this.getExecutor();
            try {
                Object object;
                if (n3 == 2) {
                    Object object2;
                    InetSocketAddress inetSocketAddress2 = null;
                    if (n2 > 0) {
                        inetSocketAddress2 = string2 == null ? new InetSocketAddress(n2) : new InetSocketAddress(string2, n2);
                    }
                    DatagramConnectorConfig datagramConnectorConfig = new DatagramConnectorConfig();
                    datagramConnectorConfig.setThreadModel(ThreadModel.MANUAL);
                    datagramConnectorConfig.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)new ExecutorExecutor(executor)));
                    datagramConnectorConfig.setSessionRecycler((IoSessionRecycler)new ExpiringSessionRecycler(0));
                    IoSessionConfig ioSessionConfig = datagramConnectorConfig.getSessionConfig();
                    if (rTPUDPDatagramConfig != null && ioSessionConfig instanceof DatagramSessionConfig) {
                        object2 = (DatagramSessionConfig)ioSessionConfig;
                        rTPUDPDatagramConfig.configureSessionConfig((DatagramSessionConfig)object2);
                    }
                    object2 = new RTPUDPHandler(iUDPMessageHandler, inetSocketAddress, this.rtpContext);
                    DatagramConnector datagramConnector = this.rtpContext.getUDPTransportManager().getNextConnector().getConnector();
                    boolean bl2 = false;
                    String string3 = "Cause unknown";
                    try {
                        datagramConnector.connect((SocketAddress)inetSocketAddress2, (SocketAddress)inetSocketAddress, (IoHandler)object2, (IoServiceConfig)datagramConnectorConfig);
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        string3 = exception.toString();
                    }
                    if (bl2) {
                        WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("RTPUDPTransport.bind: " + inetSocketAddress.toString());
                    } else {
                        WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).warn("RTPUDPTransport.bind: Failure to bind to address[" + inetSocketAddress.toString() + "]: " + string3);
                    }
                    this.handlers.put(inetSocketAddress, new AcceptorHolder((RTPUDPHandler)((Object)object2), null, n3));
                    break block17;
                }
                DatagramAcceptorConfig datagramAcceptorConfig = new DatagramAcceptorConfig();
                datagramAcceptorConfig.setThreadModel(ThreadModel.MANUAL);
                datagramAcceptorConfig.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)new ExecutorExecutor(executor)));
                datagramAcceptorConfig.setDisconnectOnUnbind(false);
                IoSessionConfig ioSessionConfig = datagramAcceptorConfig.getSessionConfig();
                if (rTPUDPDatagramConfig != null && ioSessionConfig instanceof DatagramSessionConfig) {
                    object = (DatagramSessionConfig)ioSessionConfig;
                    rTPUDPDatagramConfig.configureSessionConfig((DatagramSessionConfig)object);
                }
                object = new RTPUDPHandler(iUDPMessageHandler, inetSocketAddress, this.rtpContext);
                DatagramAcceptor datagramAcceptor = this.rtpContext.getUDPTransportManager().getNextAcceptor().getAcceptor();
                boolean bl3 = false;
                String string4 = "Cause unknown";
                try {
                    datagramAcceptor.bind((SocketAddress)inetSocketAddress, (IoHandler)object, (IoServiceConfig)datagramAcceptorConfig);
                    bl3 = true;
                }
                catch (Exception exception) {
                    string4 = exception.toString();
                }
                if (bl3) {
                    WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("RTPUDPTransport.bind: " + inetSocketAddress.toString());
                } else {
                    WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).warn("RTPUDPTransport.bind: Failure to bind to address[" + inetSocketAddress.toString() + "]: " + string4);
                }
                this.handlers.put(inetSocketAddress, new AcceptorHolder((RTPUDPHandler)((Object)object), datagramAcceptor, n3));
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).error("RTPUDPTransportMina.bind: " + exception.toString());
                exception.printStackTrace();
            }
        }
        return inetSocketAddress;
    }

    public void unbindAll() {
        Iterator<InetSocketAddress> iterator = null;
        try {
            for (InetSocketAddress inetSocketAddress : this.handlers.keySet()) {
                AcceptorHolder acceptorHolder = this.handlers.get(inetSocketAddress);
                if (acceptorHolder == null) continue;
                this.releaseSocketAddress(inetSocketAddress);
                if (acceptorHolder.acceptor != null) {
                    acceptorHolder.acceptor.unbind((SocketAddress)inetSocketAddress);
                }
                IoSession ioSession2 = acceptorHolder.handlerAdapter.unbind();
                List<IoSession> list = acceptorHolder.handlerAdapter.getActiveSessions();
                for (IoSession ioSession2 : list) {
                    ioSession2.close();
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).error("RTPUDPTransportMina.unbindAll: " + exception.toString());
            exception.printStackTrace();
        }
        this.handlers.clear();
    }

    public void unbind(InetSocketAddress inetSocketAddress) {
        AcceptorHolder acceptorHolder = this.handlers.remove(inetSocketAddress);
        try {
            if (acceptorHolder != null) {
                this.releaseSocketAddress(inetSocketAddress);
                if (acceptorHolder.acceptor != null) {
                    acceptorHolder.acceptor.unbind((SocketAddress)inetSocketAddress);
                }
                IoSession ioSession2 = acceptorHolder.handlerAdapter.unbind();
                List<IoSession> list = acceptorHolder.handlerAdapter.getActiveSessions();
                for (IoSession ioSession2 : list) {
                    ioSession2.close();
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).error("RTPUDPTransportMina.unbind: " + exception.toString());
            exception.printStackTrace();
        }
        WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("RTPUDPTransport.unbind: " + inetSocketAddress.toString());
    }

    class AcceptorHolder {
        public RTPUDPHandler handlerAdapter = null;
        public DatagramAcceptor acceptor = null;
        public int direction = 0;

        public AcceptorHolder(RTPUDPHandler rTPUDPHandler, DatagramAcceptor datagramAcceptor, int n) {
            this.acceptor = datagramAcceptor;
            this.handlerAdapter = rTPUDPHandler;
            this.direction = n;
        }
    }
}

