/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.rtp.model.RTPContext;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;

public class UDPTransportBase {
    protected RTPContext rtpContext = null;
    protected int timeToLive = 63;
    protected InetAddress multicastInterfaceAddress = null;

    public void setRTPContext(RTPContext rTPContext) {
        this.rtpContext = rTPContext;
    }

    public void setTimeToLive(int n) {
        this.timeToLive = n;
    }

    protected Executor getExecutor() {
        return this.rtpContext.getVHost().getTransportThreadPool().getExecutor();
    }

    protected boolean acquireSocketAddress(SocketAddress socketAddress) {
        boolean bl = true;
        if (this.rtpContext != null) {
            bl = this.rtpContext.acquireSocketAddress(socketAddress);
        }
        return bl;
    }

    protected boolean releaseSocketAddress(SocketAddress socketAddress) {
        boolean bl = true;
        if (this.rtpContext != null) {
            bl = this.rtpContext.releaseSocketAddress(socketAddress);
        }
        return bl;
    }

    public void setMulticastInterfaceAddress(InetAddress inetAddress) {
        this.multicastInterfaceAddress = inetAddress;
    }
}

