/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtsp;

import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.authentication.AuthenticationFactory;
import com.wowza.wms.authentication.IAuthenticateRTSP;
import com.wowza.wms.http.HTTPRequest;
import com.wowza.wms.http.HTTPResponse;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.rtp.model.IRTPMessageHandler;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPSessions;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPUrl;
import com.wowza.wms.rtsp.RTSPCore;
import com.wowza.wms.rtsp.RTSPRequestMessage;
import com.wowza.wms.rtsp.RTSPResponseMessage;
import com.wowza.wms.rtsp.RTSPResponseMessages;
import com.wowza.wms.rtsp.RTSPStatics;
import com.wowza.wms.server.RtmpLeftover;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.RtmpResponseMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostWorkerThread;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import java.math.BigInteger;
import java.net.URI;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.support.IWriteListener;

public class RTSPRequestAdapter {
    public static RTPSession getSessionNoCreate(RtmpRequestMessage rtmpRequestMessage) {
        RTPSession rTPSession;
        block2: {
            RtmpSessionInfo rtmpSessionInfo;
            RTPSessions rTPSessions;
            RTPContext rTPContext;
            rTPSession = null;
            IVHost iVHost = rtmpRequestMessage.getVHost();
            if (iVHost == null || (rTPContext = iVHost.getRTPContext()) == null || (rTPSessions = rTPContext.getSessions()) == null) break block2;
            String string = null;
            if (string == null && (rtmpSessionInfo = rtmpRequestMessage.getSessionInfo()) != null) {
                string = rtmpSessionInfo.getRTSPSessionId();
            }
            if (string != null) {
                rTPSession = rTPSessions.getSession(string);
            }
        }
        return rTPSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RTPSession getSession(IoSession ioSession, RTSPRequestMessage rTSPRequestMessage, boolean bl) {
        RTPSession rTPSession = null;
        RtmpSessionInfo rtmpSessionInfo = rTSPRequestMessage.getWMSSessionInfo();
        IVHost iVHost = rTSPRequestMessage.getVHost();
        RTPContext rTPContext = iVHost.getRTPContext();
        RTPSessions rTPSessions = rTPContext.getSessions();
        String string = null;
        boolean bl2 = true;
        if (string == null && (string = rTSPRequestMessage.getSessionId()) != null) {
            bl2 = false;
        }
        if (string == null) {
            string = rTSPRequestMessage.getHeader("session");
        }
        if (string != null && (rTPSession = rTPSessions.getSession(string)) == null) {
            string = null;
        }
        if (string == null && bl) {
            Object object;
            Object object2;
            Object object3;
            RTPUrl rTPUrl = RTSPRequestAdapter.getRTPUrl(rTSPRequestMessage, false);
            String string2 = rTPUrl.getAppName();
            String string3 = rTPUrl.getAppInstanceName();
            IApplication iApplication = null;
            IApplicationInstance iApplicationInstance = null;
            IAuthenticateRTSP iAuthenticateRTSP = null;
            IAuthenticateRTSP iAuthenticateRTSP2 = null;
            WMSReadWriteLock wMSReadWriteLock = iVHost.getApplicationLock();
            wMSReadWriteLock.writeLock().lock();
            try {
                iApplication = iVHost.getApplication(string2);
                if (iApplication != null) {
                    iApplicationInstance = iApplication.getAppInstance(string3);
                } else {
                    WMSLoggerFactory.getLogger(RTSPRequestAdapter.class).warn("Application folder ([install-location]/applications/" + string2 + ") is missing");
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTSPRequestAdapter.class).error("RTSPRequestAdapter.getSession: " + exception.toString());
            }
            finally {
                wMSReadWriteLock.writeLock().unlock();
            }
            if (iApplicationInstance != null) {
                rtmpSessionInfo.setRTSPRequestTimeout(iApplicationInstance.getRTPProperties().getPropertyInt("rtspRequestTimeout", rtmpSessionInfo.getRTSPRequestTimeout()));
                object3 = iApplicationInstance.getRTPPublishAuthenticationMethod();
                object2 = iApplicationInstance.getRTPPlayAuthenticationMethod();
                if (object3 != null && object2 != null) {
                    object = null;
                    if (((String)object3).equals(object2)) {
                        object = AuthenticationFactory.createInstance(iApplicationInstance, (String)object3);
                        if (object != null) {
                            iAuthenticateRTSP2 = (IAuthenticateRTSP)object;
                            iAuthenticateRTSP = (IAuthenticateRTSP)object;
                        }
                    } else {
                        object = AuthenticationFactory.createInstance(iApplicationInstance, (String)object3);
                        if (object != null && object instanceof IAuthenticateRTSP) {
                            iAuthenticateRTSP = (IAuthenticateRTSP)object;
                        }
                        if ((object = AuthenticationFactory.createInstance(iApplicationInstance, (String)object2)) != null && object instanceof IAuthenticateRTSP) {
                            iAuthenticateRTSP2 = (IAuthenticateRTSP)object;
                        }
                    }
                }
            }
            if (iApplicationInstance != null) {
                HostPort hostPort;
                int n;
                string = rTPSessions.getNextSessionId();
                rTPSession = new RTPSession(string);
                rTPSession.setDebugRTSPSession(iApplicationInstance.getRTPProperties().getPropertyBoolean("debugRTSPSession", rTPSession.isDebugRTSPSession()));
                rTPSession.setAppInstance(iApplicationInstance);
                object3 = RTSPRequestAdapter.validateNewConnection(iApplicationInstance, rTPSession);
                if (object3 == null) {
                    rTPSession.setSessionValid(false);
                }
                if (object3 != null) {
                    RTSPRequestAdapter.checkValidateLicense((byte[])object3);
                }
                if ((object2 = (Object)RTSPRequestAdapter.acceptNewConnection(iApplicationInstance, rTPSession)) == null) {
                    rTPSession.setSessionValid(false);
                } else {
                    rTPSession.setConnected(true);
                }
                RTSPRequestAdapter.checkLicense((byte[])object2);
                rTPSession.setReferrer(rTSPRequestMessage.getHeader("referrer"));
                object = null;
                String string4 = null;
                String string5 = null;
                int n2 = 554;
                String string6 = rTSPRequestMessage.getHeader("context");
                URI uRI = null;
                if (string6 != null && (n = string6.indexOf("://")) >= 0) {
                    try {
                        uRI = new URI((String)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (uRI != null) {
                    if (uRI.getHost() != null) {
                        string5 = uRI.getHost();
                    }
                    if (uRI.getPort() > 0) {
                        n2 = uRI.getPort();
                    }
                    if (uRI.getPath() != null) {
                        object = uRI.getPath();
                    }
                    if (uRI.getQuery() != null) {
                        string4 = uRI.getQuery();
                    }
                } else if (string6 != null && (n = ((String)(object = string6)).indexOf("?")) >= 0) {
                    string4 = ((String)object).substring(n + 1);
                    object = ((String)object).substring(0, n);
                }
                if ((string5 = rTSPRequestMessage.getIp()) == null && (hostPort = rTSPRequestMessage.getHostPort()) != null) {
                    string5 = hostPort.getAddressRawStr();
                    n2 = hostPort.getPort();
                }
                rTPSession.setUri((String)object);
                rTPSession.setServerIp(string5);
                rTPSession.setServerPort(n2);
                rTPSession.setQueryStr(string4);
                rTPSession.setUserAgent(rTSPRequestMessage.getHeader("user-agent"));
                rTPSession.setAuthenticatePublishHandler(iAuthenticateRTSP);
                rTPSession.setAuthenticatePlayHandler(iAuthenticateRTSP2);
                if (iApplicationInstance == null) {
                    rTPSession.setSessionValid(false);
                }
                rTPSession.setIp(rTSPRequestMessage.getIp());
                ioSession.addWriteListener((IWriteListener)rTPSession.getRTPWriteListener());
                rTPSessions.addSession(rTPSession);
                rTPSessions.notifySessionCreate(iApplicationInstance, rTPSession);
            }
        }
        if (string != null && bl2) {
            rTSPRequestMessage.setSessionId(string);
        }
        if (rTPSession != null) {
            rTPSession.touch();
        }
        return rTPSession;
    }

    public static RTPUrl getRTPUrl(RTSPRequestMessage rTSPRequestMessage, boolean bl) {
        RTPUrl rTPUrl = null;
        try {
            String string = rTSPRequestMessage.getHeader("context");
            if (string == null) {
                WMSLoggerFactory.getLogger(RTSPResponseMessage.class).warn("RTSPCore.getRTPUrl: context url is missing");
            } else {
                rTPUrl = new RTPUrl(string, bl);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTSPCore.getRTPUrl: " + exception.toString());
            exception.printStackTrace();
        }
        return rTPUrl;
    }

    public static void service(IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        RtmpSessionInfo rtmpSessionInfo = rtmpRequestMessage.getSessionInfo();
        int n = rtmpSessionInfo.getRTSPRequestTimeout();
        boolean bl = true;
        RtmpRequestMessage rtmpRequestMessage2 = rtmpSessionInfo.getAndClearPendingRequest();
        if (rtmpRequestMessage2 != null) {
            long l;
            int n2;
            if (rtmpRequestMessage.getType() == 2) {
                RtmpLeftover rtmpLeftover = null;
                int n3 = 0;
                if (rtmpSessionInfo.isLeftover()) {
                    rtmpLeftover = rtmpSessionInfo.getLeftovers().get(0);
                    n3 = rtmpLeftover.len;
                    rtmpSessionInfo.clearLeftover();
                }
                byte[] byArray = rtmpRequestMessage.getBody().array();
                int n4 = rtmpRequestMessage.getBody().limit();
                n2 = 0;
                byte[] byArray2 = new byte[n3 + n4];
                if (rtmpLeftover != null) {
                    System.arraycopy(rtmpLeftover.buffer, rtmpLeftover.offset, byArray2, n2, rtmpLeftover.len);
                    n2 += rtmpLeftover.len;
                }
                System.arraycopy(byArray, 0, byArray2, n2, n4);
                RtmpLeftover rtmpLeftover2 = new RtmpLeftover();
                rtmpLeftover2.buffer = byArray2;
                rtmpLeftover2.offset = 0;
                rtmpLeftover2.len = byArray2.length;
                rtmpSessionInfo.addLeftover(rtmpLeftover2);
            }
            boolean bl2 = (l = System.currentTimeMillis()) - rtmpRequestMessage2.getCreateTime() > (long)n;
            byte[] byArray = rtmpRequestMessage2.getBody().array();
            n2 = rtmpRequestMessage2.getBody().arrayOffset();
            int n5 = rtmpRequestMessage2.getBody().limit();
            boolean bl3 = RTSPRequestAdapter.handleMessage(ioSession, rtmpRequestMessage2, rtmpResponseMessage, true, bl2, byArray, n2, n5);
            boolean bl4 = bl = !bl3;
        }
        if (bl) {
            switch (rtmpRequestMessage.getType()) {
                case 2: {
                    if (rtmpRequestMessage.getMethod().equals("GET") && rtmpRequestMessage.getAccept().equals("application/x-rtsp-tunnelled")) {
                        RTSPRequestAdapter.handleInitialTunnelMessage(ioSession, rtmpRequestMessage, rtmpResponseMessage);
                        break;
                    }
                    if (rtmpRequestMessage.getMethod().equals("POST") && rtmpRequestMessage.getContentType().equals("application/x-rtsp-tunnelled")) {
                        RTSPRequestAdapter.handleTunnelMessage(ioSession, rtmpRequestMessage, rtmpResponseMessage);
                        break;
                    }
                    RTSPRequestAdapter.decodeMessage(ioSession, rtmpRequestMessage, rtmpResponseMessage);
                    break;
                }
                case 3: {
                    RTSPRequestAdapter.handleIdle(ioSession, rtmpRequestMessage, rtmpResponseMessage);
                }
            }
        }
    }

    public static void handleInitialTunnelMessage(IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        HTTPRequest hTTPRequest = new HTTPRequest(rtmpRequestMessage);
        HTTPResponse hTTPResponse = new HTTPResponse(rtmpResponseMessage);
        hTTPResponse.setResponseCode(200);
    }

    public static void handleTunnelMessage(IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
    }

    public static void decodeMessage(IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        Object object;
        Object object2;
        RtmpSessionInfo rtmpSessionInfo = rtmpRequestMessage.getSessionInfo();
        byte[] byArray = rtmpRequestMessage.getBody().array();
        int n = rtmpRequestMessage.getBody().limit();
        int n2 = 0;
        if (rtmpSessionInfo.isLeftover()) {
            object2 = rtmpSessionInfo.getLeftovers().get(0);
            rtmpSessionInfo.clearLeftover();
            object = new byte[n + ((RtmpLeftover)object2).len];
            System.arraycopy(((RtmpLeftover)object2).buffer, ((RtmpLeftover)object2).offset, object, 0, ((RtmpLeftover)object2).len);
            System.arraycopy(byArray, 0, object, ((RtmpLeftover)object2).len, n);
            byArray = object;
            n = byArray.length;
        }
        do {
            int n3;
            if (byArray[n2] == 36) {
                if (n - n2 < 4) break;
                int n4 = byArray[n2 + 2] & 0xFF;
                n4 <<= 8;
                if (n - n2 < (n4 += byArray[n2 + 3] & 0xFF) + 4) break;
                n3 = byArray[n2 + 1] & 0xFF;
                IRTPMessageHandler iRTPMessageHandler = rtmpSessionInfo.getRTPInterleaveHandler(n3);
                if (iRTPMessageHandler != null) {
                    iRTPMessageHandler.handleMessage(null, byArray, n2 + 4, n4);
                }
                n2 += n4 + 4;
                continue;
            }
            object2 = RTSPRequestMessage.quickParseHeader(byArray, n2, n - n2);
            if (object2 == null || n - n2 < object2[0] + object2[1]) break;
            n3 = RTSPRequestAdapter.handleMessage(ioSession, rtmpRequestMessage, rtmpResponseMessage, false, false, byArray, n2, (int)(object2[0] + object2[1]));
            n2 += object2[0] + object2[1];
            if (n3 != 0) break;
        } while (n2 < n);
        if (n2 < n) {
            byte[] byArray2 = new byte[n - n2];
            System.arraycopy(byArray, n2, byArray2, 0, n - n2);
            object = new RtmpLeftover();
            object.buffer = byArray2;
            object.offset = 0;
            object.len = byArray2.length;
            rtmpSessionInfo.addLeftover((RtmpLeftover)object);
        }
    }

    private static IAuthenticateRTSP getAuthenticationHandler(RTPSession rTPSession, int n) {
        IAuthenticateRTSP iAuthenticateRTSP = null;
        if (rTPSession == null) {
            return null;
        }
        int n2 = rTPSession.getLastAuthenticateMethod();
        switch (n) {
            case 0: {
                WMSLoggerFactory.getLogger(RTSPRequestAdapter.class).warn("RTSPRequestAdapter.getAuthenticationHandler: Unknown method: " + n);
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                n2 = 1;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                if (n2 != 0) break;
                n2 = 1;
                break;
            }
            case 10: {
                break;
            }
        }
        rTPSession.setLastAuthenticateMethod(n2);
        switch (n2) {
            case 1: {
                iAuthenticateRTSP = rTPSession.getAuthenticatePlayHandler();
                break;
            }
            case 2: {
                iAuthenticateRTSP = rTPSession.getAuthenticatePublishHandler();
            }
        }
        return iAuthenticateRTSP;
    }

    public static boolean handleMessage(IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage, boolean bl, boolean bl2, byte[] byArray, int n, int n2) {
        boolean bl3 = false;
        RTSPRequestMessage rTSPRequestMessage = new RTSPRequestMessage(rtmpRequestMessage, byArray, n, n2);
        RTSPResponseMessages rTSPResponseMessages = new RTSPResponseMessages(rtmpResponseMessage);
        rTSPRequestMessage.setLastDefer(bl2);
        try {
            int n3 = rTSPRequestMessage.getMethod();
            RTPSession rTPSession = RTSPRequestAdapter.getSession(ioSession, rTSPRequestMessage, n3 != 4);
            if (rTPSession != null && rTPSession.isDebugRTSPSession()) {
                WMSLoggerFactory.getLogger(RTSPRequestAdapter.class).info("--------- IN ---------\n" + rTSPRequestMessage.toString());
            }
            if (n3 == 4 || n3 == 3) {
                RTSPCore.options(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
            } else {
                boolean bl4 = true;
                IAuthenticateRTSP iAuthenticateRTSP = RTSPRequestAdapter.getAuthenticationHandler(rTPSession, n3);
                if (iAuthenticateRTSP != null) {
                    bl4 = iAuthenticateRTSP.authenticateRTSP(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                } else {
                    RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
                    RTSPStatics.setStatus(rTPRequestStatus, 403);
                    RTSPResponseMessage rTSPResponseMessage = new RTSPResponseMessage();
                    rTSPResponseMessage.setResponseCode(rTPRequestStatus.getResponseCode());
                    rTSPResponseMessage.setResponseMessage(rTPRequestStatus.getResponseMessage());
                    rTSPResponseMessage.setCSeq(rTSPRequestMessage.getCSeq());
                    rTSPResponseMessages.addMessage(rTSPResponseMessage);
                    bl4 = false;
                }
                if (bl4) {
                    if (!rTPSession.isLoggedConnect()) {
                        rTPSession.updateLoggingValues();
                        WMSLoggerFactory.getLoggerObj(rTPSession.getAppInstance()).info(null, null, "rtsp", "connect", 200, rTPSession.getSessionId());
                        rTPSession.clearLoggingValues();
                        rTPSession.setLoggedConnect(true);
                    }
                    RTSPRequestAdapter.setThreadContext(rTPSession.getAppInstance());
                    switch (n3) {
                        case 0: {
                            WMSLoggerFactory.getLogger(RTSPRequestAdapter.class).warn("RTSPRequestAdapter.service: Unknown method: " + rTSPRequestMessage.getMethodString());
                            break;
                        }
                        case 1: {
                            RTSPCore.describe(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                            break;
                        }
                        case 2: {
                            RTSPCore.announce(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                            break;
                        }
                        case 3: {
                            RTSPCore.getParameter(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                            break;
                        }
                        case 4: {
                            RTSPCore.options(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                            break;
                        }
                        case 5: {
                            RTSPCore.pause(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                            break;
                        }
                        case 6: {
                            RTSPCore.play(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                            break;
                        }
                        case 7: {
                            RTSPCore.record(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                            break;
                        }
                        case 8: {
                            RTSPCore.redirect(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                            break;
                        }
                        case 9: {
                            RTSPCore.setup(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                            break;
                        }
                        case 10: {
                            RTSPCore.setParameter(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                            break;
                        }
                        case 11: {
                            RTSPCore.teardown(rTPSession, rTSPRequestMessage, rTSPResponseMessages);
                        }
                    }
                }
            }
            if (rTSPRequestMessage.isDefer()) {
                RtmpSessionInfo rtmpSessionInfo = rtmpRequestMessage.getSessionInfo();
                rtmpSessionInfo.setPendingRequest(rtmpRequestMessage.clone(byArray, n, n2));
                bl3 = true;
                if (rTPSession != null && rTPSession.isDebugRTSPSession()) {
                    WMSLoggerFactory.getLogger(RTSPRequestAdapter.class).info("--------- OUT:DEFER ---------");
                }
            } else if (rTSPResponseMessages.getMessageCount() > 0) {
                if (rTPSession != null && rTPSession.isDebugRTSPSession()) {
                    WMSLoggerFactory.getLogger(RTSPRequestAdapter.class).info("--------- OUT ---------\n" + rTSPResponseMessages.toString());
                }
                rTSPResponseMessages.serialize();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPRequestAdapter.class).warn("RTSPCore.handleMessage: " + exception.toString());
            exception.printStackTrace();
        }
        return bl3;
    }

    public static void setThreadContext(IApplicationInstance iApplicationInstance) {
        if (Thread.currentThread() instanceof VHostWorkerThread) {
            ((VHostWorkerThread)Thread.currentThread()).setAppInstance(iApplicationInstance);
        }
    }

    public static void handleIdle(IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        block4: {
            Long l;
            long l2;
            WMSProperties wMSProperties;
            RTPSession rTPSession;
            block5: {
                IMediaStream iMediaStream;
                RTPStream rTPStream;
                rTPSession = RTSPRequestAdapter.getSessionNoCreate(rtmpRequestMessage);
                if (rTPSession == null || !rTPSession.isSessionValid() || (rTPStream = rTPSession.getRTSPStream()) == null || (iMediaStream = rTPStream.getStream()) == null) break block4;
                rTPStream.idle(rtmpResponseMessage);
                wMSProperties = iMediaStream.getProperties();
                boolean bl = wMSProperties.getPropertyBoolean("doRTSPKeepAlive", false);
                if (!bl) break block4;
                l2 = System.currentTimeMillis();
                l = wMSProperties.getPropertyLong("RTSPKEEPALIVE_lastPing", -1L);
                if (l != -1L) break block5;
                wMSProperties.setProperty("RTSPKEEPALIVE_lastPing", new Long(l2));
                break block4;
            }
            if (l2 - l < 10000L) break block4;
            wMSProperties.setProperty("RTSPKEEPALIVE_lastPing", new Long(l2));
            try {
                RTSPResponseMessage rTSPResponseMessage = new RTSPResponseMessage();
                rTSPResponseMessage.setCSeq(-1);
                if (rTPSession != null) {
                    rTSPResponseMessage.setSession(rTPSession.getSessionId());
                }
                RTSPResponseMessages rTSPResponseMessages = new RTSPResponseMessages(rtmpResponseMessage);
                rTSPResponseMessages.addMessage(rTSPResponseMessage);
                if (rTSPResponseMessages.getMessageCount() > 0) {
                    rTSPResponseMessages.serialize();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTSPRequestAdapter.class).warn("RTSPCore.handleIdle: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public static void closeSession(IVHost iVHost, IoSession ioSession) {
        RTPContext rTPContext;
        RTPSessions rTPSessions;
        RTPSession rTPSession;
        String string;
        RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
        if (rtmpSessionInfo != null && (string = rtmpSessionInfo.getRTSPSessionId()) != null && (rTPSession = (rTPSessions = (rTPContext = iVHost.getRTPContext()).getSessions()).getSession(string)) != null) {
            rTPSessions.notifySessionDestroy(rTPSession.getAppInstance(), rTPSession);
            rTPSession.shutdown();
            rTPSessions.removeSession(rTPSession);
            if (rTPSession.isLoggedConnect()) {
                rTPSession.updateLoggingValues();
                WMSLoggerFactory.getLoggerObj(rTPSession.getAppInstance()).info(null, null, "rtsp", "disconnect", 200, string);
                rTPSession.clearLoggingValues();
                rTPSession.setLoggedConnect(false);
            }
        }
    }

    private static byte[] acceptNewConnection(IApplicationInstance iApplicationInstance, RTPSession rTPSession) {
        byte[] byArray = new byte[ModuleConnect.lc.length];
        System.arraycopy(ModuleConnect.lc, 0, byArray, 0, ModuleConnect.lc.length);
        try {
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
            byte[] byArray2 = bigInteger.toByteArray();
            for (int i = 0; i < byArray.length; ++i) {
                int n = i;
                byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 11) % byArray2.length]);
            }
            iApplicationInstance.getConnectionCounter().acceptConnection(rTPSession.getConnectionHolder(), byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    private static byte[] rejectNewConnection(IApplicationInstance iApplicationInstance, RTPSession rTPSession, int n) {
        byte[] byArray = new byte[ModuleConnect.lc.length];
        System.arraycopy(ModuleConnect.lc, 0, byArray, 0, ModuleConnect.lc.length);
        try {
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
            byte[] byArray2 = bigInteger.toByteArray();
            for (int i = 0; i < byArray.length; ++i) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] ^ byArray2[(i + 11) % byArray2.length]);
            }
            iApplicationInstance.getConnectionCounter().rejectConnection(rTPSession.getConnectionHolder(), n, byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    private static byte[] validateNewConnection(IApplicationInstance iApplicationInstance, RTPSession rTPSession) {
        boolean bl = false;
        byte[] byArray = null;
        try {
            byArray = new byte[ModuleConnect.lc.length];
            System.arraycopy(ModuleConnect.lc, 0, byArray, 0, ModuleConnect.lc.length);
            bl = iApplicationInstance.getConnectionCounter().validateNewConnection(rTPSession.getConnectionHolder(), byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (byte[])(bl ? byArray : null);
    }

    private static void checkValidateLicense(byte[] byArray) {
        byte[] byArray2 = new byte[ModuleConnect.lc.length];
        System.arraycopy(ModuleConnect.lc, 0, byArray2, 0, ModuleConnect.lc.length);
        BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
        BigInteger bigInteger2 = (BigInteger)MediaStreamBase.sinfo.get("r2");
        byte[] byArray3 = bigInteger.toByteArray();
        byte[] byArray4 = bigInteger2.toByteArray();
        for (int i = 0; i < ModuleConnect.lc.length; ++i) {
            int n = i;
            byArray2[n] = (byte)(byArray2[n] ^ byArray4[(i + 3) % byArray4.length]);
            int n2 = i;
            byArray2[n2] = (byte)(byArray2[n2] ^ byArray3[(i + 8) % byArray3.length]);
            int n3 = i;
            byArray2[n3] = (byte)(byArray2[n3] ^ byArray4[(i + 2) % byArray4.length]);
            int n4 = i;
            byArray2[n4] = (byte)(byArray2[n4] ^ byArray3[(i + 1) % byArray3.length]);
            if (byArray2[i] == byArray[i]) continue;
            WMSLoggerFactory.getLogger(null).error("validateNewConnection exit:" + byArray[i] + ":" + byArray2[i]);
            System.exit(1);
        }
    }

    private static void checkLicense(byte[] byArray) {
        byte[] byArray2 = new byte[ModuleConnect.lc.length];
        System.arraycopy(ModuleConnect.lc, 0, byArray2, 0, ModuleConnect.lc.length);
        BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
        BigInteger bigInteger2 = (BigInteger)MediaStreamBase.sinfo.get("r2");
        byte[] byArray3 = bigInteger.toByteArray();
        byte[] byArray4 = bigInteger2.toByteArray();
        for (int i = 0; i < ModuleConnect.lc.length; ++i) {
            byte by = byArray2[i];
            int n = i;
            byte by2 = (byte)(byArray2[n] ^ byArray3[(i + 11) % byArray3.length]);
            byArray2[n] = by2;
            byte by3 = by2;
            int n2 = i;
            byte by4 = (byte)(byArray2[n2] ^ byArray4[(i + 8) % byArray4.length]);
            byArray2[n2] = by4;
            byte by5 = by4;
            if (byArray[i] == byArray2[i]) continue;
            WMSLoggerFactory.getLogger(null).error("bailRTSP[" + i + "]:" + byArray[i] + "!=" + byArray2[i] + " (" + by + ":" + by3 + ":" + by5 + ")" + " (" + byArray3.length + ":" + byArray4.length + ") (" + byArray.length + ":" + ModuleConnect.lc.length + ":" + byArray2.length + ")");
            System.exit(1);
        }
    }
}

