/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtsp;

import com.wowza.util.DebugUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.ReleaseInfo;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class RTSPResponseMessage {
    private static final String CRLF_STR = "\r\n";
    Map<String, String> headerMap = new HashMap<String, String>();
    ByteArrayOutputStream byteOut = null;
    DataOutputStream dataOut = null;
    int responseCode = 200;
    String responseMessage = "OK";
    String method = "RTSP/1.0";

    public RTSPResponseMessage() {
        this.initHeaders();
    }

    private void initHeaders() {
        this.headerMap.put("Server", ReleaseInfo.getProject() + " " + ReleaseInfo.getVersion() + " build" + ReleaseInfo.getBuildNumber());
    }

    public DataOutput getOutputStream() {
        if (this.byteOut == null) {
            this.byteOut = new ByteArrayOutputStream();
            this.dataOut = new DataOutputStream(this.byteOut);
        }
        return this.dataOut;
    }

    public void setHeader(String string, String string2) {
        this.headerMap.put(string, string2);
    }

    public String getHeader(String string) {
        return this.headerMap.get(string);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int n) {
        this.responseCode = n;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String string) {
        this.responseMessage = string;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public void setCSeq(int n) {
        this.setHeader("Cseq", n + "");
    }

    public void setSession(String string) {
        this.setHeader("Session", string + ";timeout=60");
    }

    public void serialize(OutputStream outputStream) {
        try {
            int n = 0;
            if (this.byteOut != null) {
                n = this.byteOut.size();
            }
            if (n > 0) {
                this.setHeader("Content-Length", n + "");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.method + " " + this.responseCode + " " + this.responseMessage + CRLF_STR);
            for (String string : this.headerMap.keySet()) {
                stringBuffer.append(string + ": " + this.headerMap.get(string) + CRLF_STR);
            }
            stringBuffer.append(CRLF_STR);
            outputStream.write(stringBuffer.toString().getBytes("UTF-8"));
            if (n > 0) {
                outputStream.write(this.byteOut.toByteArray());
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPResponseMessage.class).error("RTSPResponseMessage.serialize: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.method + " " + this.responseCode + " " + this.responseMessage + "\n");
        for (String string : this.headerMap.keySet()) {
            stringBuffer.append(string + ": " + this.headerMap.get(string) + "\n");
        }
        if (this.byteOut != null) {
            System.out.println(DebugUtils.formatBytes(this.byteOut.toByteArray()));
        }
        return stringBuffer.toString();
    }
}

