/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.demux.MessageDecoderAdapter;
import org.apache.mina.filter.codec.demux.MessageDecoderResult;

public class RtmpRequestDecoder
extends MessageDecoderAdapter {
    public static byte PACKETDECODE_RTSPINTERLEAVECHAR = (byte)36;
    List<Integer> decodes = new ArrayList<Integer>();

    public RtmpRequestDecoder() {
        String[] stringArray = new String[]{"POST", "GET", "HEAD", "DELETE", "OPTION", "TRACE", "PUT", "CONNECT", "DESCRIBE", "SETUP", "TEARDOWN", "PLAY", "PAUSE", "OPTIONS", "ANNOUNCE", "RECORD", "REDIRECT", "GET_PARAMETER", "SET_PARAMETER"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.length() > 4) {
                string = string.substring(0, 4);
            }
            while (string.length() < 4) {
                string = string + " ";
            }
            byte[] byArray = string.getBytes();
            int n = 0;
            for (int j = 0; j < byArray.length; ++j) {
                n <<= 8;
                n |= (byte)(byArray[j] & 0xFF);
            }
            Integer n2 = new Integer(n);
            if (this.decodes.contains(n2)) continue;
            this.decodes.add(n2);
        }
    }

    public void finishDecode(IoSession ioSession, ProtocolDecoderOutput protocolDecoderOutput) {
        WMSLoggerFactory.getLogger(RtmpRequestDecoder.class).info("RtmpRequestDecoder: finishDecode");
    }

    public MessageDecoderResult decodable(IoSession ioSession, ByteBuffer byteBuffer) {
        try {
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            int n = rtmpSessionInfo.getProtocol();
            if (n == 0) {
                if (byteBuffer.limit() >= 4) {
                    int n2 = 0;
                    for (int i = 0; i < 4; ++i) {
                        n2 <<= 8;
                        n2 |= (byte)(byteBuffer.get(i) & 0xFF);
                    }
                    n = this.decodes.contains(new Integer(n2)) ? 32 : 1;
                    rtmpSessionInfo.setProtocol(n);
                } else {
                    return MessageDecoderResult.NEED_DATA;
                }
            }
            switch (n) {
                case 1: {
                    rtmpSessionInfo.setContentLength(byteBuffer.limit());
                    return MessageDecoderResult.OK;
                }
                case 3: 
                case 32: 
                case 33: 
                case 35: 
                case 37: {
                    if (!rtmpSessionInfo.gotHeader()) {
                        this.getHeaderInfo(ioSession, byteBuffer);
                    }
                    if (rtmpSessionInfo.gotHeader() && byteBuffer.limit() >= rtmpSessionInfo.getReqSize()) {
                        return MessageDecoderResult.OK;
                    }
                    return MessageDecoderResult.NEED_DATA;
                }
                case 34: {
                    rtmpSessionInfo.setContentLength(byteBuffer.limit());
                    return MessageDecoderResult.OK;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return MessageDecoderResult.NOT_OK;
    }

    private boolean getRTSPPacketInfo(IoSession ioSession, ByteBuffer byteBuffer) {
        boolean bl = false;
        if (byteBuffer.limit() >= 4) {
            int n = byteBuffer.get(2) & 0xFF;
            n <<= 8;
            n += byteBuffer.get(3);
        }
        return bl;
    }

    private void getHeaderInfo(IoSession ioSession, ByteBuffer byteBuffer) {
        int n = byteBuffer.limit();
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            if (byteBuffer.get(i) != 13 || i + 3 >= n || byteBuffer.get(i) != 13 || byteBuffer.get(i + 1) != 10 || byteBuffer.get(i + 2) != 13 || byteBuffer.get(i + 3) != 10) continue;
            int n2 = i + 4;
            byte[] byArray = new byte[n2];
            byteBuffer.get(byArray);
            String string = new String(byArray);
            while (((stringArray = string.substring(0, 1)).equals("\n") || stringArray.equals("\r")) && (string = string.substring(1)).length() != 0) {
            }
            string = string.replace("\r\n", "\n").replace("\r", "\n");
            stringArray = string.split("\n");
            int n3 = 0;
            String string2 = "";
            String string3 = "";
            String string4 = "HTTP/1.1";
            String string5 = null;
            String string6 = "";
            String string7 = "";
            for (int j = 0; j < stringArray.length; ++j) {
                String[] stringArray2;
                if (stringArray[j].length() == 0) continue;
                if (j == 0) {
                    stringArray2 = stringArray[j].split(" ");
                    if (stringArray2.length > 0) {
                        string3 = stringArray2[0];
                    }
                    if (stringArray2.length > 1) {
                        string2 = stringArray2[1].substring(1);
                    }
                    if (stringArray2.length <= 2) continue;
                    string4 = stringArray2[2];
                    continue;
                }
                stringArray2 = stringArray[j].split(": ");
                if (stringArray2.length != 2) continue;
                if (stringArray2[0].equalsIgnoreCase("Content-Length")) {
                    n3 = Integer.parseInt(stringArray2[1]);
                    continue;
                }
                if (stringArray2[0].equalsIgnoreCase("User-Agent")) {
                    string5 = stringArray2[1];
                    continue;
                }
                if (stringArray2[0].equalsIgnoreCase("Content-Type")) {
                    string6 = stringArray2[1];
                    continue;
                }
                if (!stringArray2[0].equalsIgnoreCase("Accept")) continue;
                string7 = stringArray2[1];
            }
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            rtmpSessionInfo.setHeaderLength(n2);
            rtmpSessionInfo.setContentLength(n3);
            rtmpSessionInfo.setPath(string2);
            rtmpSessionInfo.setUserAgent(string5);
            rtmpSessionInfo.setProtocolStr(string4);
            rtmpSessionInfo.setContentType(string6);
            rtmpSessionInfo.setAccept(string7);
            rtmpSessionInfo.setMethod(string3);
            break;
        }
    }

    public MessageDecoderResult decode(IoSession ioSession, ByteBuffer byteBuffer, ProtocolDecoderOutput protocolDecoderOutput) throws Exception {
        MessageDecoderResult messageDecoderResult = MessageDecoderResult.OK;
        RtmpRequestMessage rtmpRequestMessage = this.decodeBody(ioSession, byteBuffer);
        if (rtmpRequestMessage == null) {
            messageDecoderResult = MessageDecoderResult.NEED_DATA;
        } else {
            protocolDecoderOutput.write((Object)rtmpRequestMessage);
        }
        return messageDecoderResult;
    }

    private RtmpRequestMessage decodeBody(IoSession ioSession, ByteBuffer byteBuffer) {
        RtmpRequestMessage rtmpRequestMessage = new RtmpRequestMessage();
        boolean bl = this.parseRequest(ioSession, byteBuffer, rtmpRequestMessage);
        if (bl) {
            return rtmpRequestMessage;
        }
        return null;
    }

    private boolean parseRequest(IoSession ioSession, ByteBuffer byteBuffer, RtmpRequestMessage rtmpRequestMessage) {
        boolean bl = true;
        try {
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            int n = rtmpSessionInfo.getProtocol();
            rtmpRequestMessage.setProtocol(n);
            rtmpRequestMessage.setSSL(rtmpSessionInfo.isSSL());
            rtmpRequestMessage.setSessionInfo(rtmpSessionInfo);
            rtmpRequestMessage.setHeaderLength(rtmpSessionInfo.getHeaderLength());
            rtmpRequestMessage.setContentLength(rtmpSessionInfo.getContentLength());
            rtmpRequestMessage.setUserAgent(rtmpSessionInfo.getUserAgent());
            rtmpRequestMessage.setProtocolStr(rtmpSessionInfo.getProtocolStr());
            rtmpRequestMessage.setContentType(rtmpSessionInfo.getContentType());
            rtmpRequestMessage.setAccept(rtmpSessionInfo.getAccept());
            rtmpRequestMessage.setMethod(rtmpSessionInfo.getMethod());
            rtmpRequestMessage.setPath(rtmpSessionInfo.getPath());
            byteBuffer.acquire();
            rtmpRequestMessage.setBody(byteBuffer);
            switch (n) {
                case 3: 
                case 32: 
                case 33: 
                case 35: 
                case 37: {
                    rtmpRequestMessage.decodeHeader(rtmpSessionInfo.getVHost(), rtmpSessionInfo.getUserAgent(), rtmpSessionInfo.getServer() != null ? rtmpSessionInfo.getServer().getUserAgents() : null, rtmpSessionInfo.getHostPort(), rtmpSessionInfo.getPath());
                    rtmpSessionInfo.setProtocol(rtmpRequestMessage.getProtocol());
                    rtmpSessionInfo.setHTTPStreamerAdapter(rtmpRequestMessage.getHTTPStreamerAdapter());
                    break;
                }
                case 34: {
                    rtmpRequestMessage.setType(2);
                }
            }
            byteBuffer.position(byteBuffer.limit());
            rtmpSessionInfo.resetHeader();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }
}

