/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.server.ServerHandler;
import com.wowza.wms.server.ServerHandlerThreadedSession;
import java.util.concurrent.Executor;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;

public class ServerHandlerThreaded
extends IoHandlerAdapter {
    public static final String MESSAGEQUEUE = "SHThreaded";
    private ServerHandler handler = null;
    private Executor executor = null;

    public ServerHandlerThreaded(ServerHandler serverHandler, Executor executor) {
        this.handler = serverHandler;
        this.executor = executor;
    }

    private ServerHandlerThreadedSession getThreadedSession(IoSession ioSession) {
        return (ServerHandlerThreadedSession)ioSession.getAttribute(MESSAGEQUEUE);
    }

    private void addEvent(IoSession ioSession, int n, Object object, IdleStatus idleStatus, Throwable throwable) {
        ServerHandlerThreadedSession serverHandlerThreadedSession = this.getThreadedSession(ioSession);
        serverHandlerThreadedSession.addEvent(n, object, idleStatus, throwable);
    }

    private void addEvent(ServerHandlerThreadedSession serverHandlerThreadedSession, IoSession ioSession, int n, Object object, IdleStatus idleStatus, Throwable throwable) {
        serverHandlerThreadedSession.addEvent(n, object, idleStatus, throwable);
    }

    public void sessionCreated(IoSession ioSession) {
        ServerHandlerThreadedSession serverHandlerThreadedSession = new ServerHandlerThreadedSession(ioSession, this.handler, this.executor);
        ioSession.setAttribute(MESSAGEQUEUE, (Object)serverHandlerThreadedSession);
        this.handler.sessionCreated(ioSession);
    }

    public void sessionOpened(IoSession ioSession) throws Exception {
        this.handler.sessionOpened(ioSession);
    }

    public void sessionClosed(IoSession ioSession) {
        ServerHandlerThreadedSession serverHandlerThreadedSession = this.getThreadedSession(ioSession);
        if (serverHandlerThreadedSession.isThreaded()) {
            this.addEvent(serverHandlerThreadedSession, ioSession, 3, null, null, null);
        } else {
            this.handler.sessionClosed(ioSession);
        }
    }

    public void messageReceived(IoSession ioSession, Object object) {
        ServerHandlerThreadedSession serverHandlerThreadedSession = this.getThreadedSession(ioSession);
        RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
        if (rtmpSessionInfo != null) {
            serverHandlerThreadedSession.setProtocol(rtmpSessionInfo.getProtocol());
        }
        if (serverHandlerThreadedSession.isThreaded()) {
            this.addEvent(serverHandlerThreadedSession, ioSession, 4, object, null, null);
        } else {
            this.handler.messageReceived(ioSession, object);
        }
    }

    public void sessionIdle(IoSession ioSession, IdleStatus idleStatus) {
        ServerHandlerThreadedSession serverHandlerThreadedSession = this.getThreadedSession(ioSession);
        if (serverHandlerThreadedSession.isThreaded()) {
            this.addEvent(serverHandlerThreadedSession, ioSession, 5, null, idleStatus, null);
        } else {
            this.handler.sessionIdle(ioSession, idleStatus);
        }
    }

    public void exceptionCaught(IoSession ioSession, Throwable throwable) {
        ServerHandlerThreadedSession serverHandlerThreadedSession = this.getThreadedSession(ioSession);
        if (serverHandlerThreadedSession.isThreaded()) {
            this.addEvent(serverHandlerThreadedSession, ioSession, 6, null, null, throwable);
        } else {
            this.handler.exceptionCaught(ioSession, throwable);
        }
    }

    public ServerHandler getServerHandler() {
        return this.handler;
    }
}

