/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.sharedobject;

import com.wowza.util.Base64;
import com.wowza.util.XMLUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataContextDeserialize;
import com.wowza.wms.amf.AMFDataContextSerialize;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.sharedobject.ISharedObjectSlot;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SharedObjectSlot
implements ISharedObjectSlot {
    String name;
    AMFData data;
    int slotVersion;
    int soVersion;
    int lastOperation = 0;
    int lastClientId = 0;

    public SharedObjectSlot(String string) {
        this.init(string, null, 0);
    }

    public SharedObjectSlot(String string, AMFData aMFData) {
        this.init(string, aMFData, 0);
    }

    public void init(String string, AMFData aMFData, int n) {
        this.name = string;
        this.soVersion = 0;
        this.data = aMFData == null ? new AMFDataItem() : aMFData;
        this.slotVersion = n;
    }

    public AMFData getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        this.setData(byArray, null);
    }

    public void setData(byte[] byArray, AMFDataContextDeserialize aMFDataContextDeserialize) {
        if (byArray == null) {
            this.data = new AMFDataItem();
        } else if (byArray.length == 0) {
            this.data = new AMFDataItem();
        } else {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            this.data = null;
            try {
                if (aMFDataContextDeserialize == null) {
                    aMFDataContextDeserialize = AMFData.createContextDeserialize();
                }
                this.data = AMFData.deserializeInnerObject(byteBuffer, aMFDataContextDeserialize);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).error("SharedObjectSlot.setData: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public void setData(AMFData aMFData) {
        this.data = aMFData == null ? new AMFDataItem() : aMFData;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getSlotVersion() {
        return this.slotVersion;
    }

    public void setSlotVersion(int n) {
        this.slotVersion = n;
    }

    public void incSlotVersion() {
        ++this.slotVersion;
    }

    public int getSoVersion() {
        return this.soVersion;
    }

    public void setSoVersion(int n) {
        this.soVersion = n;
    }

    public int getLastOperation() {
        return this.lastOperation;
    }

    public void setLastOperation(int n) {
        this.lastOperation = n;
    }

    public int getLastClientId() {
        return this.lastClientId;
    }

    public void setLastClientId(int n) {
        this.lastClientId = n;
    }

    public void flush(PrintWriter printWriter, String string) {
        block6: {
            try {
                printWriter.println(string + "<Name>" + this.name + "</Name>");
                printWriter.println(string + "<SlotVersion>" + this.slotVersion + "</SlotVersion>");
                printWriter.println(string + "<SOVersion>" + this.soVersion + "</SOVersion>");
                printWriter.println(string + "<LastOperation>" + this.lastOperation + "</LastOperation>");
                printWriter.println(string + "<LastClientID>" + this.lastClientId + "</LastClientID>");
                if (this.data == null) {
                    printWriter.println(string + "<Data>null</Data>");
                    break block6;
                }
                AMFDataContextSerialize aMFDataContextSerialize = AMFData.createContextSerialize(3);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.write(17);
                this.data.serialize(dataOutputStream, aMFDataContextSerialize);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                String string2 = "null";
                try {
                    if (byArray != null) {
                        string2 = Base64.encodeBytes(byArray);
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(SharedObjectSlot.class).error("SharedObjectSlot: flush: Base64.encodeBytes: " + exception.toString());
                }
                printWriter.println(string + "<Data>" + string2 + "</Data>");
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(SharedObjectSlot.class).error("SharedObjectSlot: flush: " + exception.toString());
            }
        }
    }

    public static SharedObjectSlot load(Element element) {
        SharedObjectSlot sharedObjectSlot;
        block12: {
            sharedObjectSlot = null;
            try {
                Node node = XMLUtils.getNodeByTagName(element, "Name");
                Node node2 = XMLUtils.getNodeByTagName(element, "SlotVersion");
                Node node3 = XMLUtils.getNodeByTagName(element, "SOVersion");
                Node node4 = XMLUtils.getNodeByTagName(element, "LastOperation");
                Node node5 = XMLUtils.getNodeByTagName(element, "LastClientID");
                Node node6 = XMLUtils.getNodeByTagName(element, "Data");
                if (node == null || node2 == null || node3 == null || node4 == null || node5 == null || node6 == null) break block12;
                String string = XMLUtils.getNodeValue(node);
                String string2 = XMLUtils.getNodeValue(node2);
                String string3 = XMLUtils.getNodeValue(node3);
                String string4 = XMLUtils.getNodeValue(node4);
                String string5 = XMLUtils.getNodeValue(node5);
                String string6 = XMLUtils.getNodeValue(node6);
                int n = Integer.parseInt(string2);
                int n2 = Integer.parseInt(string3);
                int n3 = Integer.parseInt(string4);
                int n4 = Integer.parseInt(string5);
                AMFData aMFData = null;
                if (!string6.equals("null")) {
                    byte[] byArray = null;
                    try {
                        byArray = Base64.decode(string6);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(SharedObjectSlot.class).error("SharedObjectSlot: load: Base64.decode: " + exception.toString());
                    }
                    if (byArray != null) {
                        if (byArray == null) {
                            aMFData = new AMFDataItem();
                        } else if (byArray.length == 0) {
                            aMFData = new AMFDataItem();
                        } else {
                            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                            try {
                                aMFData = AMFData.deserializeInnerObject(byteBuffer, AMFData.createContextDeserialize());
                            }
                            catch (Exception exception) {
                                WMSLoggerFactory.getLogger(null).error("SharedObjectSlot.load: " + exception.toString());
                                exception.printStackTrace();
                            }
                        }
                    }
                }
                sharedObjectSlot = new SharedObjectSlot(string, aMFData);
                sharedObjectSlot.setSlotVersion(n);
                sharedObjectSlot.setSoVersion(n2);
                sharedObjectSlot.setLastOperation(n3);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(SharedObjectSlot.class).error("SharedObjectSlot: load: " + exception.toString());
            }
        }
        return sharedObjectSlot;
    }
}

