/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.publish;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.publish.IPublishingProvider;
import com.wowza.wms.stream.publish.Publisher;
import java.util.List;

public class PublishingProviderLive
implements IPublishingProvider {
    private long timeoffset = 0L;
    private String streamName = null;
    private boolean isFirstPacket = true;
    private long lastSeq = -1L;
    private long firstLiveTimecode = -1L;
    private long firstRealTimecode = -1L;
    private boolean waitForKeyFrame = true;
    private boolean isDebugLog = false;
    private boolean isFirstVideo = true;
    private boolean isFirstAudio = true;
    private long duration = 0L;
    private boolean moreInFile = true;
    private long streamStartTime = -1L;

    public PublishingProviderLive(Publisher publisher, long l, String string) {
        this.timeoffset = l;
        this.streamName = string;
        IApplicationInstance iApplicationInstance = publisher.getAppInstance();
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        IMediaStream iMediaStream = mediaStreamMap.getStream(this.streamName);
        if (iMediaStream == null) {
            return;
        }
        List<AMFPacket> list = iMediaStream.getPlayPackets();
        if (list.size() == 0) {
            return;
        }
        AMFPacket aMFPacket = list.get(list.size() - 1);
        this.lastSeq = aMFPacket.getSeq();
        this.firstLiveTimecode = aMFPacket.getAbsTimecode();
        this.isDebugLog = WMSLoggerFactory.getLogger(PublishingProviderLive.class).isDebugEnabled();
    }

    public void close() {
    }

    public boolean play(Publisher publisher) {
        IApplicationInstance iApplicationInstance = publisher.getAppInstance();
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        long l = System.currentTimeMillis();
        if (this.streamStartTime < 0L) {
            this.streamStartTime = l;
        }
        if (this.duration > 0L && l - this.streamStartTime >= this.duration) {
            this.moreInFile = false;
        } else {
            List<AMFPacket> list;
            IMediaStream iMediaStream = mediaStreamMap.getStream(this.streamName);
            if (iMediaStream != null && (list = iMediaStream.getPlayPackets()).size() > 0) {
                AMFPacket aMFPacket;
                if (this.firstRealTimecode < 0L) {
                    this.firstRealTimecode = l;
                }
                if (this.isFirstPacket) {
                    AMFPacket aMFPacket2;
                    aMFPacket = list.get(list.size() - 1);
                    if (this.lastSeq == -1L) {
                        this.lastSeq = aMFPacket.getSeq();
                        this.firstLiveTimecode = aMFPacket.getAbsTimecode();
                    }
                    if ((aMFPacket2 = iMediaStream.getLastKeyFrame()) != null) {
                        this.writePacket(iMediaStream, publisher, null, this.firstLiveTimecode);
                        this.writePacket(iMediaStream, publisher, aMFPacket2, this.firstLiveTimecode);
                    }
                    this.isFirstPacket = false;
                }
                if ((aMFPacket = list.get(list.size() - 1)).getSeq() != this.lastSeq) {
                    WMSLoggerFactory.getLogger(PublishingProviderLive.class).debug("start: " + list.size() + ":" + aMFPacket.getSeq() + ":" + this.lastSeq);
                    int n = (int)((long)list.size() - (aMFPacket.getSeq() - this.lastSeq));
                    if (n < 0) {
                        this.waitForKeyFrame = true;
                        n = 0;
                    }
                    for (int i = n; i < list.size(); ++i) {
                        AMFPacket aMFPacket3 = list.get(i);
                        if (this.waitForKeyFrame && aMFPacket3.getType() == 9) {
                            if (!FLVUtils.isVideoKeyFrame(aMFPacket3)) continue;
                            this.waitForKeyFrame = false;
                        }
                        this.writePacket(iMediaStream, publisher, aMFPacket3, -1L);
                        this.lastSeq = aMFPacket3.getSeq();
                    }
                }
            }
        }
        return this.moreInFile;
    }

    private void writePacket(IMediaStream iMediaStream, Publisher publisher, AMFPacket aMFPacket, long l) {
        long l2 = 0L;
        long l3 = (l < 0L ? aMFPacket.getAbsTimecode() : l) - this.firstLiveTimecode;
        if (l3 < 0L) {
            return;
        }
        l2 = l3 + this.timeoffset;
        if (aMFPacket == null) {
            if (this.isDebugLog) {
                WMSLoggerFactory.getLogger(PublishingProviderLive.class).debug("live: aud:" + l2 + ":zero");
            }
            byte[] byArray = new byte[]{};
            publisher.addAudioData(byArray, 0, l2);
        } else {
            switch (aMFPacket.getType()) {
                case 8: {
                    if (this.isDebugLog) {
                        WMSLoggerFactory.getLogger(PublishingProviderLive.class).debug("live: aud:" + l2 + ":" + aMFPacket.getSeq());
                    }
                    if (this.isFirstAudio) {
                        AMFPacket aMFPacket2 = iMediaStream.getAudioCodecConfigPacket(aMFPacket.getAbsTimecode());
                        if (aMFPacket2 != null) {
                            publisher.addAudioData(aMFPacket2.getData(), aMFPacket2.getSize(), l2);
                        }
                        this.isFirstAudio = false;
                    }
                    publisher.addAudioData(aMFPacket.getData(), aMFPacket.getSize(), l2);
                    break;
                }
                case 9: {
                    if (this.isDebugLog) {
                        WMSLoggerFactory.getLogger(PublishingProviderLive.class).debug("live: vi" + (FLVUtils.isVideoKeyFrame(aMFPacket) ? "k" : "p") + ":" + l2 + ":" + aMFPacket.getSeq());
                    }
                    if (this.isFirstVideo) {
                        AMFPacket aMFPacket3 = iMediaStream.getVideoCodecConfigPacket(aMFPacket.getAbsTimecode());
                        if (aMFPacket3 != null) {
                            publisher.addVideoData(aMFPacket3.getData(), aMFPacket3.getSize(), l2);
                        }
                        this.isFirstVideo = false;
                    }
                    publisher.addVideoData(aMFPacket.getData(), aMFPacket.getSize(), l2);
                    break;
                }
                case 15: 
                case 18: {
                    if (this.isDebugLog) {
                        WMSLoggerFactory.getLogger(PublishingProviderLive.class).debug("live: dat:" + l2 + ":" + aMFPacket.getSeq());
                    }
                    publisher.addDataData(aMFPacket.getData(), aMFPacket.getSize(), l2);
                }
            }
        }
    }

    public boolean seek(long l) {
        return false;
    }

    public boolean seek(long l, int n) {
        return false;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    public void setRealTimeStartTime(long l) {
        this.firstRealTimecode = l;
    }
}

