/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.publish;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.MediaReaderFactory;
import com.wowza.wms.stream.PlaylistSeekResult;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import com.wowza.wms.stream.publish.IPublishingProvider;
import com.wowza.wms.stream.publish.Publisher;
import com.wowza.wms.stream.publish.PublishingProviderLive;
import com.wowza.wms.util.ModuleUtils;
import java.util.ArrayList;

public class PublishingProviderMediaReader
implements IPublishingProvider {
    private String streamName = "unknown";
    private String streamExt = "flv";
    private long timeoffset = 0L;
    private long throttleTime = -1L;
    private Publisher publisher = null;
    private long startTimecode = 0L;
    private IMediaReader mediaReader = null;
    private PlaylistCursor flvCursor = null;
    private long[] playSizes;
    private boolean isDebugLog = false;
    private long duration = 0L;

    public PublishingProviderMediaReader(Publisher publisher, long l, String string) {
        this.publisher = publisher;
        this.timeoffset = l;
        try {
            String string2 = "";
            String string3 = "flv";
            String[] stringArray = ModuleUtils.decodeStreamExtension(string, string3);
            string = stringArray[0];
            string3 = stringArray[1];
            boolean bl = string.indexOf("://") >= 0;
            int n = string.indexOf("?");
            if (!bl && n >= 0) {
                string2 = string.substring(n + 1);
                string = string.substring(0, n);
            }
            this.streamName = string;
            this.streamExt = string3;
            IApplicationInstance iApplicationInstance = publisher.getAppInstance();
            this.mediaReader = this.getMediaReader(iApplicationInstance);
            this.flvCursor = new PlaylistCursor();
            this.playSizes = new long[8];
            this.isDebugLog = WMSLoggerFactory.getLogger(PublishingProviderLive.class).isDebugEnabled();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(PublishingProviderMediaReader.class).error("PublishingProviderMediaReader.constructor: " + exception.toString());
        }
    }

    private IMediaReader getMediaReader(IApplicationInstance iApplicationInstance) {
        String string = this.streamExt.toLowerCase();
        IMediaReader iMediaReader = MediaReaderFactory.getInstance(iApplicationInstance, iApplicationInstance.getVHost().getMediaReaders(), string);
        if (iMediaReader != null) {
            String string2 = iApplicationInstance.getStreamStoragePath();
            iMediaReader.init(iApplicationInstance, this.publisher.getStream(), this.streamExt, string2, this.streamName);
            iMediaReader.open(string2, this.streamName);
        }
        return iMediaReader;
    }

    public boolean seek(long l) {
        return this.seek(l, 3);
    }

    public boolean seek(long l, int n) {
        boolean bl;
        block6: {
            PlaylistSeekResult playlistSeekResult;
            bl = false;
            if (!this.mediaReader.isOpen() || (playlistSeekResult = this.mediaReader.seek(l, n)) == null) break block6;
            long l2 = 0L;
            switch (1) {
                case 1: {
                    boolean bl2;
                    boolean bl3 = bl2 = playlistSeekResult.getVideoStreamPos() == null ? false : playlistSeekResult.getVideoStreamPos().isValid();
                    if (bl2) {
                        l2 = playlistSeekResult.getResultVideoTimecode();
                        this.mediaReader.setStreamPosition(playlistSeekResult.getVideoStreamPos());
                        break;
                    }
                    l2 = playlistSeekResult.getResultTimecode();
                    this.mediaReader.setStreamPosition(playlistSeekResult.getStreamPos());
                    break;
                }
                case 3: {
                    l2 = playlistSeekResult.getResultTimecode();
                    this.mediaReader.setStreamPosition(playlistSeekResult.getStreamPos());
                    break;
                }
                case 4: {
                    l2 = playlistSeekResult.getResultTimecode();
                    this.mediaReader.setStreamPosition(playlistSeekResult.getStreamPos());
                }
            }
            this.startTimecode = l2;
        }
        return bl;
    }

    public boolean play(Publisher publisher) {
        boolean bl;
        block14: {
            bl = true;
            if (this.throttleTime == -1L) {
                this.throttleTime = System.currentTimeMillis();
            }
            try {
                long l = System.currentTimeMillis();
                long l2 = this.startTimecode + (l - this.throttleTime);
                if (!this.mediaReader.isOpen()) {
                    bl = false;
                    break block14;
                }
                PlaylistWriteControl playlistWriteControl = this.flvCursor.getWriteControl();
                PlaylistReaderWriteResults playlistReaderWriteResults = this.flvCursor.getWriteResults();
                playlistWriteControl.setMaxTC(l2);
                ArrayList<AMFPacket> arrayList = new ArrayList<AMFPacket>();
                this.mediaReader.writePackets(arrayList, this.flvCursor, playlistWriteControl, playlistReaderWriteResults, this.playSizes, null);
                bl = !playlistReaderWriteResults.isHitEnd();
                for (AMFPacket aMFPacket : arrayList) {
                    long l3 = aMFPacket.getAbsTimecode() - this.startTimecode;
                    if (l3 < 0L) continue;
                    long l4 = l3 + this.timeoffset;
                    if (this.duration > 0L && l3 > this.duration) {
                        bl = false;
                        break;
                    }
                    switch (aMFPacket.getType()) {
                        case 8: {
                            if (this.isDebugLog) {
                                WMSLoggerFactory.getLogger(PublishingProviderLive.class).info("mediareader: aud:" + l4);
                            }
                            publisher.addAudioData(aMFPacket.getData(), aMFPacket.getSize(), l4);
                            break;
                        }
                        case 9: {
                            if (this.isDebugLog) {
                                WMSLoggerFactory.getLogger(PublishingProviderLive.class).info("mediareader: vi" + (FLVUtils.isVideoKeyFrame(aMFPacket) ? "k" : "p") + ":" + l4);
                            }
                            publisher.addVideoData(aMFPacket.getData(), aMFPacket.getSize(), l4);
                            break;
                        }
                        case 15: 
                        case 18: {
                            if (this.isDebugLog) {
                                WMSLoggerFactory.getLogger(PublishingProviderLive.class).info("mediareader: dat:" + l4);
                            }
                            publisher.addDataData(aMFPacket.getData(), aMFPacket.getSize(), l4);
                        }
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(PublishingProviderMediaReader.class).error("PublishingProviderMediaReader.play: " + exception.toString());
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public void close() {
        try {
            if (this.mediaReader != null) {
                this.mediaReader.close();
            }
            this.mediaReader = null;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(PublishingProviderMediaReader.class).error("PublishingProviderMediaReader.close: " + exception.toString());
        }
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    public void setRealTimeStartTime(long l) {
        this.throttleTime = l;
    }
}

