/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transport.udp;

import com.wowza.wms.transport.udp.IUDPSender;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class UDPSender
implements Runnable {
    private long packetCount = 0L;
    private boolean running = false;
    private List<UDPMessage> messages = new ArrayList<UDPMessage>();
    private Executor executor = null;

    public UDPSender(Executor executor) {
        this.executor = executor;
    }

    public long incPacketCount() {
        return ++this.packetCount;
    }

    public synchronized void handleMessage(IUDPSender iUDPSender, byte[] byArray, int n, int n2) {
        this.messages.add(new UDPMessage(iUDPSender, byArray, n, n2));
        if (!this.running) {
            this.running = true;
            this.executor.execute(this);
        }
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            UDPMessage uDPMessage = null;
            UDPSender uDPSender = this;
            synchronized (uDPSender) {
                if (this.messages.size() <= 0) {
                    this.running = false;
                    break;
                }
                uDPMessage = this.messages.remove(0);
            }
            if (uDPMessage == null) continue;
            uDPMessage.handler.handleSendMessage(uDPMessage.buffer, uDPMessage.offset, uDPMessage.len);
        }
    }

    class UDPMessage {
        public IUDPSender handler = null;
        public byte[] buffer = null;
        public int offset = 0;
        public int len = 0;

        public UDPMessage(IUDPSender iUDPSender, byte[] byArray, int n, int n2) {
            this.handler = iUDPSender;
            this.buffer = byArray;
            this.offset = n;
            this.len = n2;
        }
    }
}

