/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.XMLUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.client.Client;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.module.ModuleItem;
import com.wowza.wms.module.ModuleList;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.util.ModuleUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApplicationUtils {
    public static boolean isGood() {
        return MediaStreamBase.sinfo.get("l") != null;
    }

    public static void gs(String string) {
        Closeable closeable;
        String string2 = "";
        String string3 = Bootstrap.getServerHome((int)2);
        if (string3 == null) {
            System.out.println("ERROR: " + RTMPRequestAdapter.fN(ModuleConnect.getN(0)) + " missing. No config home. Exiting.");
            System.exit(0);
        } else if (!new File(string3).exists()) {
            System.out.println("ERROR: " + RTMPRequestAdapter.fN(ModuleConnect.getN(0)) + " missing. Config home missing. Exiting.");
            System.exit(0);
        }
        string3 = string3 + File.separatorChar + "conf" + File.separatorChar + RTMPRequestAdapter.fN(ModuleConnect.getN(0));
        File file = new File(string3);
        try {
            if (file.exists() && !file.canWrite()) {
                System.out.println("ERROR: Cannot write to serial number file:");
                System.out.println("  " + file.getPath());
                System.out.println("Please modify file permission to make this file writable by the server");
                Thread.currentThread();
                Thread.sleep(10000L);
                System.exit(0);
            }
            while (true) {
                closeable = new InputStreamReader(System.in);
                BufferedReader bufferedReader = new BufferedReader((Reader)closeable);
                if (string.length() > 0) {
                    System.out.println("Serial number invalid: " + string);
                }
                System.out.println("Please enter serial number:");
                System.out.println("XXXXX-XXXXX-XXXXX-XXXXX-XXXXX");
                string2 = bufferedReader.readLine();
                string2 = string2.trim().toUpperCase();
                if (string2.length() < 25 || !Client.decodeSS(string2)) {
                    string = string2;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("error: " + exception.toString());
        }
        try {
            if (string2.length() > 0) {
                closeable = new PrintWriter(file);
                ((PrintWriter)closeable).println(string2);
                ((PrintWriter)closeable).close();
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: Cannot write to serial number file:");
            System.out.println("  " + file.getPath());
            System.out.println("Please modify file permission to make this file writable by the server");
            try {
                Thread.currentThread();
                Thread.sleep(10000L);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    private static void loadModules(IApplicationInstance iApplicationInstance, Element element) {
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            String string = "/Root/Application/Modules/Module";
            XPathExpression xPathExpression = xPath.compile(string);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Object object;
                    Node node = nodeList.item(i);
                    Element element2 = (Element)node;
                    Node node2 = XMLUtils.getNodeByTagName(element2, "Name");
                    Node node3 = XMLUtils.getNodeByTagName(element2, "Class");
                    Node node4 = XMLUtils.getNodeByTagName(element2, "Description");
                    Node node5 = XMLUtils.getNodeByTagName(element2, "Component");
                    ModuleList moduleList = iApplicationInstance.getModuleList();
                    if (node2 == null || node3 == null) continue;
                    Object object2 = XMLUtils.getNodeValue(node2);
                    String string2 = XMLUtils.getNodeValue(node3);
                    String string3 = null;
                    if (node4 != null) {
                        string3 = XMLUtils.getNodeValue(node4);
                    }
                    String string4 = null;
                    if (node5 != null) {
                        string4 = XMLUtils.getNodeValue(node5);
                    }
                    if (moduleList.exists((String)object2)) {
                        int n = 1;
                        while (moduleList.exists((String)(object = (String)object2 + "[" + n + "]"))) {
                            ++n;
                        }
                        object2 = object;
                    }
                    object = null;
                    if (string4 == null) {
                        object = ModuleUtils.addModuleToApp(iApplicationInstance, (String)object2, string2);
                    } else {
                        ModuleUtils.addComponentModuleToApp(iApplicationInstance, string4, (String)object2, string2);
                    }
                    ModuleItem moduleItem = new ModuleItem((String)object2, string2);
                    if (string3 != null) {
                        moduleItem.setDescription(string3);
                    }
                    if (string4 != null) {
                        moduleItem.setComponent(string4);
                    }
                    moduleItem.setInstance(object);
                    moduleList.put((String)object2, moduleItem);
                }
            } else {
                WMSLoggerFactory.getLogger(ApplicationUtils.class).error("loadConfigFile: error parsing application config file: XPath " + string + " missing");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationUtils.class).error("error parsing application properties: " + exception.toString());
            exception.printStackTrace();
        }
    }

    private static void loadClientAccess(IApplicationInstance iApplicationInstance, Element element, String string) {
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string);
            Node node = (Node)xPathExpression.evaluate(element, XPathConstants.NODE);
            if (node != null) {
                String string2;
                String string3;
                String string4;
                String string5;
                String string6;
                Element element2 = (Element)node;
                String string7 = XMLUtils.getNodeValueByTagName(element2, "SharedObjectReadAccess");
                if (string7 != null) {
                    iApplicationInstance.setSharedObjectReadAccess(string7);
                }
                if ((string6 = XMLUtils.getNodeValueByTagName(element2, "SharedObjectWriteAccess")) != null) {
                    iApplicationInstance.setSharedObjectWriteAccess(string6);
                }
                if ((string5 = XMLUtils.getNodeValueByTagName(element2, "StreamReadAccess")) != null) {
                    iApplicationInstance.setStreamReadAccess(string5);
                }
                if ((string4 = XMLUtils.getNodeValueByTagName(element2, "StreamWriteAccess")) != null) {
                    iApplicationInstance.setStreamWriteAccess(string4);
                }
                if ((string3 = XMLUtils.getNodeValueByTagName(element2, "StreamAudioSampleAccess")) != null) {
                    iApplicationInstance.setStreamAudioSampleAccess(string3);
                }
                if ((string2 = XMLUtils.getNodeValueByTagName(element2, "StreamVideoSampleAccess")) != null) {
                    iApplicationInstance.setStreamVideoSampleAccess(string2);
                }
                if (WMSLoggerFactory.getLogger(null).isDebugEnabled()) {
                    WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("SharedObjectReadAccess: " + iApplicationInstance.getSharedObjectReadAccess());
                    WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("SharedObjectWriteAccess: " + iApplicationInstance.getSharedObjectWriteAccess());
                    WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("StreamReadAccess: " + iApplicationInstance.getStreamReadAccess());
                    WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("StreamWriteAccess: " + iApplicationInstance.getStreamWriteAccess());
                    WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("StreamAudioSampleAccess: " + iApplicationInstance.getStreamAudioSampleAccess());
                    WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("StreamVideoSampleAccess: " + iApplicationInstance.getStreamVideoSampleAccess());
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationUtils.class).error("loadClientAccess: error parsing application properties: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadConfigFile(IApplicationInstance iApplicationInstance, String string) {
        block23: {
            WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("Loading Application.xml: " + string);
            try {
                String string2;
                int n;
                String string3;
                String[] stringArray;
                String string4;
                String string5;
                XPathExpression xPathExpression;
                Node node;
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(string);
                XPathFactory xPathFactory = XMLUtils.newXPathFactory();
                XPath xPath = xPathFactory.newXPath();
                if (document == null) break block23;
                Element element = document.getDocumentElement();
                String string6 = "/Root/Application/Properties/Property";
                WMSProperties wMSProperties = iApplicationInstance.getProperties();
                XMLUtils.loadConfigProperies(element, string6, wMSProperties);
                String string7 = "/Root/Application/Streams/Properties/Property";
                WMSProperties wMSProperties2 = iApplicationInstance.getStreamProperties();
                XMLUtils.loadConfigProperies(element, string7, wMSProperties2);
                String string8 = "/Root/Application/MediaCaster/Properties/Property";
                WMSProperties wMSProperties3 = iApplicationInstance.getMediaCasterProperties();
                XMLUtils.loadConfigProperies(element, string8, wMSProperties3);
                String string9 = "/Root/Application/MediaReader/Properties/Property";
                WMSProperties wMSProperties4 = iApplicationInstance.getMediaReaderProperties();
                XMLUtils.loadConfigProperies(element, string9, wMSProperties4);
                String string10 = "/Root/Application/MediaWriter/Properties/Property";
                WMSProperties wMSProperties5 = iApplicationInstance.getMediaWriterProperties();
                XMLUtils.loadConfigProperies(element, string10, wMSProperties5);
                String string11 = "/Root/Application/RTP/Properties/Property";
                WMSProperties wMSProperties6 = iApplicationInstance.getRTPProperties();
                XMLUtils.loadConfigProperies(element, string11, wMSProperties6);
                String string12 = "/Root/Application/LiveStreamPacketizer/Properties/Property";
                WMSProperties wMSProperties7 = iApplicationInstance.getLiveStreamPacketizerProperties();
                XMLUtils.loadConfigProperies(element, string12, wMSProperties7);
                String string13 = "/Root/Application/HTTPStreamer/Properties/Property";
                WMSProperties wMSProperties8 = iApplicationInstance.getHTTPStreamerProperties();
                XMLUtils.loadConfigProperies(element, string13, wMSProperties8);
                ApplicationUtils.loadModules(iApplicationInstance, element);
                ApplicationUtils.loadClientAccess(iApplicationInstance, element, "/Root/Application/Client/Access");
                iApplicationInstance.setClientIdleFrequency(XMLUtils.getXMLPropertyInt(xPath, "/Root/Application/Client/IdleFrequency", element, iApplicationInstance.getClientIdleFrequency()));
                iApplicationInstance.setStreamType(XMLUtils.getXMLPropertyStr(xPath, "/Root/Application/Streams/StreamType", element, iApplicationInstance.getStreamType()));
                iApplicationInstance.setHTTPStreamerList(XMLUtils.getXMLPropertyStr(xPath, "/Root/Application/HTTPStreamers", element, iApplicationInstance.getHTTPStreamerList()));
                iApplicationInstance.setLiveStreamPacketizerList(XMLUtils.getXMLPropertyStr(xPath, "/Root/Application/Streams/LiveStreamPacketizers", element, iApplicationInstance.getLiveStreamPacketizerList()));
                iApplicationInstance.setMaxStorageDirDepth(XMLUtils.getXMLPropertyInt(xPath, "/Root/Application/MaximumStorageDirDepth", element, iApplicationInstance.getMaxStorageDirDepth()));
                iApplicationInstance.setStreamStorageDir(XMLUtils.getXMLPropertyStr(xPath, "/Root/Application/Streams/StorageDir", element, iApplicationInstance.getStreamStorageDir()));
                iApplicationInstance.setStreamKeyDir(XMLUtils.getXMLPropertyStr(xPath, "/Root/Application/Streams/KeyDir", element, iApplicationInstance.getStreamKeyDir()));
                iApplicationInstance.setRsoStorageDir(XMLUtils.getXMLPropertyStr(xPath, "/Root/Application/SharedObjects/StorageDir", element, iApplicationInstance.getRsoStorageDir()));
                iApplicationInstance.setAcceptConnection(XMLUtils.getXMLPropertyBool(xPath, "/Root/Application/Connections/AutoAccept", element, iApplicationInstance.isAcceptConnection()));
                iApplicationInstance.setApplicationTimeout(XMLUtils.getXMLPropertyInt(xPath, "/Root/Application/ApplicationTimeout", element, iApplicationInstance.getApplicationTimeout()));
                iApplicationInstance.setPingTimeout(XMLUtils.getXMLPropertyInt(xPath, "/Root/Application/PingTimeout", element, iApplicationInstance.getPingTimeout()));
                iApplicationInstance.setValidationFrequency(XMLUtils.getXMLPropertyInt(xPath, "/Root/Application/ValidationFrequency", element, iApplicationInstance.getValidationFrequency()));
                iApplicationInstance.setMaximumPendingWriteBytes(XMLUtils.getXMLPropertyInt(xPath, "/Root/Application/MaximumPendingWriteBytes", element, iApplicationInstance.getMaximumPendingWriteBytes()));
                iApplicationInstance.setMaximumSetBufferTime(XMLUtils.getXMLPropertyInt(xPath, "/Root/Application/MaximumSetBufferTime", element, iApplicationInstance.getMaximumSetBufferTime()));
                iApplicationInstance.setRepeaterOriginUrl(XMLUtils.getXMLPropertyStr(xPath, "/Root/Application/Repeater/OriginURL", element, iApplicationInstance.getRepeaterOriginUrl()));
                iApplicationInstance.setRepeaterQueryString(XMLUtils.getXMLPropertyStr(xPath, "/Root/Application/Repeater/QueryString", element, iApplicationInstance.getRepeaterQueryString()));
                iApplicationInstance.setRTPMaxRTCPWaitTime(XMLUtils.getXMLPropertyInt(xPath, "/Root/Application/RTP/MaxRTCPWaitTime", element, iApplicationInstance.getRTPMaxRTCPWaitTime()));
                iApplicationInstance.setRTPIdleFrequency(XMLUtils.getXMLPropertyInt(xPath, "/Root/Application/RTP/IdleFrequency", element, iApplicationInstance.getRTPIdleFrequency()));
                String string14 = XMLUtils.getXMLPropertyStr(xPath, "/Root/Application/RTP/Authentication/Method", element);
                if (string14 != null) {
                    iApplicationInstance.setRTPPublishAuthenticationMethod(string14);
                    iApplicationInstance.setRTPPlayAuthenticationMethod(string14);
                }
                if ((node = (Node)(xPathExpression = xPath.compile(string5 = "/Root/Application/RTP/IncomingDatagramPortRanges")).evaluate(element, XPathConstants.NODE)) == null) {
                    iApplicationInstance.addRTPIncomingDatagramPortAll();
                } else {
                    string4 = XMLUtils.getXMLPropertyStr(xPath, string5, element, null);
                    if (string4 != null) {
                        string4 = string4.replace(",", ";");
                        stringArray = string4.split("[;]");
                        for (int i = 0; i < stringArray.length; ++i) {
                            string3 = stringArray[i].trim();
                            if (string3.length() <= 0) continue;
                            if (string3.equals("*")) {
                                iApplicationInstance.addRTPIncomingDatagramPortAll();
                                continue;
                            }
                            n = string3.indexOf("-");
                            if (n >= 0) {
                                String string15 = string3.substring(0, n).trim();
                                String string16 = string3.substring(n + 1).trim();
                                int n2 = -1;
                                try {
                                    n2 = Integer.parseInt(string15);
                                }
                                catch (Exception exception) {
                                    n2 = -1;
                                }
                                int n3 = -1;
                                try {
                                    n3 = Integer.parseInt(string16);
                                }
                                catch (Exception exception) {
                                    n3 = -1;
                                }
                                if (n2 < 0 || n3 < 0) continue;
                                iApplicationInstance.addRTPIncomingDatagramPortRange(n2, n3);
                                continue;
                            }
                            int n4 = -1;
                            try {
                                n4 = Integer.parseInt(string3);
                            }
                            catch (Exception exception) {
                                n4 = -1;
                            }
                            if (n4 < 0) continue;
                            iApplicationInstance.addRTPIncomingDatagramPortRange(n4, n4);
                        }
                    }
                }
                string4 = XMLUtils.getXMLPropertyStr(xPath, "/Root/Application/RTP/Authentication/PublishMethod", element);
                if (string4 != null) {
                    iApplicationInstance.setRTPPublishAuthenticationMethod(string4);
                }
                if ((stringArray = XMLUtils.getXMLPropertyStr(xPath, "/Root/Application/RTP/Authentication/PlayMethod", element)) != null) {
                    iApplicationInstance.setRTPPlayAuthenticationMethod((String)stringArray);
                }
                if ((string2 = XMLUtils.getXMLPropertyStr(xPath, "/Root/Application/RTP/AVSyncMethod", element)) != null) {
                    iApplicationInstance.setRTPAVSyncMethod(RTPStream.avSyncNameToId(string2));
                }
                if ((string3 = XMLUtils.getXMLPropertyStr(xPath, "/Root/Application/Connections/AllowDomains", element, null)) != null) {
                    WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("allowDomainsStr: " + string3);
                    if (string3.trim().length() > 0) {
                        n = 1;
                        String string17 = System.getProperty("com.wowza.wms.AllowDomains.enable");
                        if (string17 != null) {
                            int n5 = n = string17.trim().toLowerCase().equals("true") || string17.trim().toLowerCase().equals("yes") ? 1 : 0;
                        }
                        if (n != 0) {
                            iApplicationInstance.parseAllowDomains(string3);
                        } else {
                            WMSLoggerFactory.getLogger(ApplicationUtils.class).warn("AllowDomains.enable: AllowDomains is currently disabled, following value will be ignored: " + string3);
                        }
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ApplicationUtils.class).error("loadConfigFile: error parsing application config file: (" + string + ") error: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }
}

