/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.XMLUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerFactory;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerList;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPIdleHandler;
import com.wowza.wms.rtp.model.RTPPushPublishSession;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPSessions;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtsp.RTSPRequestMessage;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.util.IdleWorkersUtil;
import com.wowza.wms.util.MediaWriterUtils;
import com.wowza.wms.util.ModuleUtils;
import com.wowza.wms.vhost.IVHost;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPUtils {
    public static void stopRTPPull(RTPPushPublishSession rTPPushPublishSession) {
        try {
            IApplicationInstance iApplicationInstance;
            RTPSession rTPSession = rTPPushPublishSession.getRTPSession();
            if (rTPSession != null && (iApplicationInstance = rTPSession.getAppInstance()) != null) {
                Object object;
                IVHost iVHost = iApplicationInstance.getVHost();
                RTPIdleHandler rTPIdleHandler = rTPSession.getIdleHandler();
                if (rTPIdleHandler != null) {
                    object = iVHost.getIdleWorkers();
                    ((IdleWorkersUtil)object).unregisterIdleClient(rTPIdleHandler);
                }
                object = new RTPRequestStatus();
                if (rTPSession != null) {
                    rTPSession.shutdown((RTPRequestStatus)object);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).warn("RTPUtils.stopRTPPull: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static RTPPushPublishSession startRTPPull(IApplicationInstance iApplicationInstance, String string, boolean bl, String string2, int n, boolean bl2) {
        return RTPUtils.startRTPPull(iApplicationInstance, string, bl, string2, n, -1, bl2);
    }

    public static RTPPushPublishSession startRTPPull(IApplicationInstance iApplicationInstance, String string, boolean bl, String string2, int n) {
        return RTPUtils.startRTPPull(iApplicationInstance, string, bl, string2, n, -1, true);
    }

    public static RTPPushPublishSession startRTPPull(IApplicationInstance iApplicationInstance, String string, boolean bl, String string2, int n, int n2) {
        return RTPUtils.startRTPPull(iApplicationInstance, string, bl, string2, n, n2, true);
    }

    public static RTPPushPublishSession startRTPPull(IApplicationInstance iApplicationInstance, String string, boolean bl, String string2, int n, int n2, boolean bl2) {
        RTPPushPublishSession rTPPushPublishSession = null;
        RTPSession rTPSession = null;
        String string3 = null;
        try {
            IVHost iVHost = iApplicationInstance.getVHost();
            RTPContext rTPContext = iVHost.getRTPContext();
            RTPSessions rTPSessions = rTPContext.getSessions();
            String string4 = rTPSessions.getNextSessionId();
            rTPSession = new RTPSession(string4);
            rTPSessions.addSession(rTPSession);
            String string5 = iApplicationInstance.getApplication().getName() + "/" + iApplicationInstance.getName() + "/" + string;
            RTPStream rTPStream = new RTPStream(rTPContext, string5);
            rTPStream.setRTSP(true);
            rTPStream.setMode(1);
            rTPStream.setOutHost(string2);
            rTPSession.addRTSPStream(rTPStream);
            rTPSession.setAppInstance(iApplicationInstance);
            rTPStream.setAppName(iApplicationInstance.getApplication().getName());
            rTPStream.setAppInstanceName(iApplicationInstance.getName());
            String string6 = "mp4";
            String[] stringArray = ModuleUtils.decodeStreamExtension(string, string6);
            string = stringArray[0];
            string6 = stringArray[1];
            rTPStream.setStreamName(string);
            rTPStream.setStreamNameLogging(string);
            rTPStream.setStreamExt(string6);
            rTPStream.setCheckSSRC(false);
            rTPStream.setCheckIpAddr(true);
            rTPSessions.notifySessionCreate(iApplicationInstance, rTPSession);
            RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
            rTPSession.setDescribe(true);
            string3 = rTPStream.describe(rTPSession, bl ? 1 : -1, rTPRequestStatus);
            if (!rTPStream.streamExists()) {
                rTPStream.createStream(rTPRequestStatus);
            }
            if (rTPStream.streamExists()) {
                Object object;
                RTPTrack rTPTrack = rTPStream.getStreamTrack();
                if (rTPTrack != null) {
                    int n3 = Math.max(n, n2);
                    rTPTrack.setup(rTPRequestStatus, "client_port=" + n3 + "-" + (n3 + 1));
                    rTPTrack.setRTPWrapped(bl2);
                } else {
                    RTPTrack rTPTrack2 = rTPStream.getVideoTrack();
                    if (rTPTrack2 != null) {
                        rTPTrack2.setup(rTPRequestStatus, "client_port=" + n2 + "-" + (n2 + 1));
                        rTPTrack2.setRTPWrapped(bl2);
                    }
                    if ((object = rTPStream.getVideoTrack()) != null) {
                        ((RTPTrack)object).setup(rTPRequestStatus, "client_port=" + n + "-" + (n + 1));
                        ((RTPTrack)object).setRTPWrapped(bl2);
                    }
                }
                rTPStream.play(rTPRequestStatus);
                rTPStream.getMetadataPacket();
                RTPIdleHandler rTPIdleHandler = new RTPIdleHandler(rTPSession);
                rTPSession.setIdleHandler(rTPIdleHandler);
                object = iVHost.getIdleWorkers();
                ((IdleWorkersUtil)object).registerIdleClient(rTPIdleHandler);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).warn("RTPUtils.startRTPPull: " + exception.toString());
            exception.printStackTrace();
        }
        if (rTPSession != null) {
            rTPPushPublishSession = new RTPPushPublishSession();
            rTPPushPublishSession.setRTPSession(rTPSession);
            rTPPushPublishSession.setSDPData(string3);
        }
        return rTPPushPublishSession;
    }

    public static void writeCodecConfig(RTPTrack rTPTrack, long l, byte[] byArray) {
        try {
            byte[] byArray2 = null;
            byArray2 = rTPTrack.isAudio() ? new byte[]{-81, 0} : new byte[]{23, 0, 0, 0, 0};
            int n = byArray.length + byArray2.length;
            IMediaStream iMediaStream = rTPTrack.getRTPStream().getStream();
            if (iMediaStream != null) {
                if (rTPTrack.isAudio()) {
                    iMediaStream.setAudioTC(l, true);
                    iMediaStream.setAudioSize(n);
                    iMediaStream.startAudioPacket();
                    iMediaStream.addAudioData(byArray2, 0, byArray2.length);
                    iMediaStream.addAudioData(byArray, 0, byArray.length);
                } else {
                    iMediaStream.setVideoTC(l, true);
                    iMediaStream.setVideoSize(n);
                    iMediaStream.startVideoPacket();
                    iMediaStream.addVideoData(byArray2, 0, byArray2.length);
                    iMediaStream.addVideoData(byArray, 0, byArray.length);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).warn("RTPUtils.writeCodecConfig: " + exception.toString());
            exception.printStackTrace();
        }
    }

    private static void loadDePacketizers(RTPContext rTPContext, Element element) {
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            String string = "/Root/RTP/DePacketizers/DePacketizer";
            XPathExpression xPathExpression = xPath.compile(string);
            String string2 = "Properties/Property";
            XPathExpression xPathExpression2 = xPath.compile(string2);
            String string3 = "../Properties/Property";
            XPathExpression xPathExpression3 = xPath.compile(string3);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Object object;
                    Node node = nodeList.item(i);
                    Element element2 = (Element)node;
                    Node node2 = XMLUtils.getNodeByTagName(element2, "Name");
                    Node node3 = XMLUtils.getNodeByTagName(element2, "Class");
                    Node node4 = XMLUtils.getNodeByTagName(element2, "Description");
                    RTPDePacketizerList rTPDePacketizerList = rTPContext.getDePacketizerList();
                    if (node2 == null || node3 == null) continue;
                    Object object2 = XMLUtils.getNodeValue(node2);
                    String string4 = XMLUtils.getNodeValue(node3);
                    String string5 = null;
                    if (node4 != null) {
                        string5 = XMLUtils.getNodeValue(node4);
                    }
                    if (rTPDePacketizerList.exists((String)object2)) {
                        int n = 1;
                        while (rTPDePacketizerList.exists((String)(object = (String)object2 + "[" + n + "]"))) {
                            ++n;
                        }
                        object2 = object;
                    }
                    object = new RTPDePacketizerItem((String)object2, string4);
                    if (string5 != null) {
                        ((RTPDePacketizerItem)object).setDescription(string5);
                    }
                    WMSProperties wMSProperties = ((RTPDePacketizerItem)object).getProperties();
                    NodeList nodeList2 = (NodeList)xPathExpression3.evaluate(element2, XPathConstants.NODESET);
                    if (nodeList2 != null) {
                        XMLUtils.loadConfigProperies(nodeList2, wMSProperties);
                    }
                    if ((nodeList2 = (NodeList)xPathExpression2.evaluate(element2, XPathConstants.NODESET)) != null) {
                        XMLUtils.loadConfigProperies(nodeList2, wMSProperties);
                    }
                    IRTPDePacketizer iRTPDePacketizer = RTPDePacketizerFactory.createInstance(rTPContext, (RTPDePacketizerItem)object);
                    ((RTPDePacketizerItem)object).setInstance(iRTPDePacketizer);
                    if (iRTPDePacketizer == null) continue;
                    rTPDePacketizerList.put((String)object2, (RTPDePacketizerItem)object);
                    if (!WMSLoggerFactory.getLogger(MediaWriterUtils.class).isDebugEnabled()) continue;
                    WMSLoggerFactory.getLogger(MediaWriterUtils.class).debug(((RTPDePacketizerItem)object).toString());
                }
            } else {
                WMSLoggerFactory.getLogger(RTPUtils.class).error("loadConfigFile: error parsing RTP config file: XPath " + string + " missing");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("error parsing RTP properties: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadConfigFile(RTPContext rTPContext, String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                Element element = document.getDocumentElement();
                RTPUtils.loadDePacketizers(rTPContext, element);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("error parsing RTP properties (" + string + "): " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static RTPStream decodeStreamInfo(RTPContext rTPContext, String string, String string2) {
        RTPStream rTPStream = new RTPStream(rTPContext, string);
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(RTSPRequestMessage.class);
        if (!wMSLogger.isDebugEnabled()) {
            wMSLogger = null;
        }
        RTPTrack rTPTrack = null;
        String string3 = "";
        string2 = string2.replace("\r\n", "\n").replace("\r", "\n");
        String[] stringArray = string2.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            String string4;
            int n;
            Object object;
            String string5 = stringArray[i].trim();
            if (wMSLogger != null) {
                wMSLogger.debug("sdp: " + string5);
            }
            if (string5.startsWith("m=")) {
                if (rTPTrack != null) {
                    rTPTrack.setAnnounceData(string3);
                    if (rTPTrack.getTrackId().equals("unknown")) {
                        if (rTPTrack.isVideo()) {
                            rTPTrack.setTrackId("video");
                        }
                        if (rTPTrack.isAudio()) {
                            rTPTrack.setTrackId("audio");
                        }
                    }
                    rTPStream.addTrack(rTPTrack);
                    string3 = "";
                }
                rTPTrack = null;
                rTPTrack = new RTPTrack("unknown");
                rTPTrack.setStream(rTPStream);
                object = string5.substring(2).split("[ ]");
                String string6 = object[0].trim().toLowerCase();
                if (string6.startsWith("audio")) {
                    rTPTrack.setTrackType(8);
                } else if (string6.startsWith("video")) {
                    rTPTrack.setTrackType(9);
                } else if (string6.startsWith("mpegts-transport")) {
                    rTPTrack.setRTCP(false);
                }
                if (((String[])object).length > 1) {
                    try {
                        String string7 = object[1];
                        String[] stringArray2 = string7.split("/");
                        n = Integer.parseInt(stringArray2[0]);
                        if (n > 0) {
                            rTPTrack.setRTPInPortNum(n);
                            rTPTrack.setRTCPInPortNum(n + 1);
                        }
                    }
                    catch (Exception exception) {}
                }
            } else if (string5.startsWith("a=videoPID") || string5.startsWith("a=audioPID")) {
                int n2 = -1;
                int n3 = string5.indexOf(":");
                if (n3 >= 0) {
                    String string8 = string5.substring(n3 + 1).trim();
                    int n4 = 10;
                    if (string8.startsWith("0x")) {
                        n4 = 16;
                        string8 = string8.substring(2);
                    }
                    try {
                        n2 = Integer.parseInt(string8, n4);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n2 >= 0) {
                    if (string5.startsWith("a=videoPID")) {
                        rTPStream.setMPEGTSVideoPID(n2);
                    }
                    if (string5.startsWith("a=audioPID")) {
                        rTPStream.setMPEGTSAudioPID(n2);
                    }
                }
            } else if (string5.startsWith("a=rtpmap")) {
                if (rTPTrack != null) {
                    String[] stringArray3;
                    int n5 = string5.indexOf(":");
                    if (n5 >= 0) {
                        string5 = string5.substring(n5 + 1);
                    }
                    if ((stringArray3 = string5.split(" ")).length > 0) {
                        int n6 = -1;
                        try {
                            n6 = Integer.parseInt(stringArray3[0].trim());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        rTPTrack.setRTPMapType(n6);
                    }
                    if (stringArray3.length > 1) {
                        String string9 = stringArray3[stringArray3.length - 1].trim();
                        String[] stringArray4 = string9.split("[/]");
                        if (stringArray4.length > 0) {
                            rTPTrack.addTrackInfo("sample-type", stringArray4[0]);
                            rTPTrack.setSampleType(stringArray4[0]);
                            if (stringArray4[0].startsWith("MP2T")) {
                                rTPTrack.setRTCP(false);
                            }
                        }
                        if (stringArray4.length > 1) {
                            rTPTrack.addTrackInfo("timescale", stringArray4[1]);
                            try {
                                rTPTrack.setTimescale(Integer.parseInt(stringArray4[1]));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (rTPTrack.isAudio() && stringArray4.length > 2) {
                            rTPTrack.addTrackInfo("channel-count", stringArray4[2]);
                            try {
                                rTPTrack.setChannelCount(Integer.parseInt(stringArray4[2]));
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            } else if (string5.startsWith("a=fmtp")) {
                int n7;
                if (rTPTrack != null && (n7 = string5.indexOf(" ")) >= 0) {
                    String string10 = string5.substring(n7 + 1).trim();
                    String[] stringArray5 = string10.split("[;]");
                    for (int j = 0; j < stringArray5.length; ++j) {
                        int n8;
                        String string11 = stringArray5[j].trim();
                        if (string11.length() == 0 || (n8 = string11.indexOf("=")) < 0) continue;
                        String string12 = string11.substring(0, n8).trim().toLowerCase();
                        string4 = string11.substring(n8 + 1).trim();
                        rTPTrack.addTrackInfo(string12, string4);
                    }
                }
            } else if (string5.startsWith("a=control")) {
                int n9;
                if (rTPTrack != null && (n9 = string5.indexOf(":")) >= 0) {
                    String string13 = string5.substring(n9 + 1);
                    rTPTrack.setTrackId(string13);
                }
            } else if (string5.startsWith("a=cliprect")) {
                int n10;
                if (rTPTrack != null && (n10 = string5.indexOf(":")) >= 0) {
                    String string14 = string5.substring(n10 + 1).trim();
                    rTPTrack.addTrackInfo("cliprect", string14);
                }
            } else if (string5.startsWith("a=framesize")) {
                String[] stringArray6;
                String string15;
                String[] stringArray7;
                int n11;
                if (rTPTrack != null && (n11 = string5.indexOf(":")) >= 0 && (stringArray7 = (string15 = string5.substring(n11 + 1).trim()).split("[ ]")).length >= 2 && (stringArray6 = stringArray7[1].split("[-]")).length >= 2) {
                    try {
                        rTPTrack.setWidth(Integer.parseInt(stringArray6[0]));
                        rTPTrack.setHeight(Integer.parseInt(stringArray6[1]));
                    }
                    catch (Exception exception) {}
                }
            } else if (string5.startsWith("a=ssrc-high")) {
                String string16;
                String[] stringArray8;
                long l = 0L;
                int n12 = string5.indexOf(":");
                if (n12 >= 0 && (stringArray8 = (string16 = string5.substring(n12 + 1).trim()).split("[ ]")).length > 0) {
                    int n13 = 10;
                    if (stringArray8[0].startsWith("0x")) {
                        n13 = 16;
                        stringArray8[0] = stringArray8[0].substring(2);
                    }
                    try {
                        l = Long.parseLong(stringArray8[0], n13);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (rTPTrack != null) {
                        long l2 = rTPTrack.getSSRC();
                        l2 = (l2 & 0xFFFFFFFFL) + (l << 32);
                        rTPTrack.setSSRC(l2);
                    }
                }
            } else if (string5.startsWith("a=ssrc-low")) {
                String string17;
                String[] stringArray9;
                long l = 0L;
                int n14 = string5.indexOf(":");
                if (n14 >= 0 && (stringArray9 = (string17 = string5.substring(n14 + 1).trim()).split("[ ]")).length > 0) {
                    int n15 = 10;
                    if (stringArray9[0].startsWith("0x")) {
                        n15 = 16;
                        stringArray9[0] = stringArray9[0].substring(2);
                    }
                    try {
                        l = Long.parseLong(stringArray9[0], n15);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (rTPTrack != null) {
                        long l3 = rTPTrack.getSSRC();
                        l3 = (l3 & 0xFFFFFFFF00000000L) + l;
                        rTPTrack.setSSRC(l3);
                    }
                }
            } else if (string5.startsWith("a=ssrc")) {
                String string18;
                String[] stringArray10;
                long l = 0L;
                int n16 = string5.indexOf(":");
                if (n16 >= 0 && (stringArray10 = (string18 = string5.substring(n16 + 1).trim()).split("[ ]")).length > 0) {
                    int n17 = 10;
                    if (stringArray10[0].startsWith("0x")) {
                        n17 = 16;
                        stringArray10[0] = stringArray10[0].substring(2);
                    }
                    try {
                        l = Long.parseLong(stringArray10[0], n17);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (rTPTrack != null) {
                        rTPTrack.setSSRC(l);
                    }
                }
            } else if (rTPTrack == null && string5.startsWith("v=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("protocolversion", (String)object);
                }
            } else if (rTPTrack == null && string5.startsWith("o=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("origin", (String)object);
                    String[] stringArray11 = ((String)object).split("[ ]");
                    if (stringArray11.length > 1) {
                        long l = -1L;
                        try {
                            l = Long.parseLong(stringArray11[1]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        rTPStream.setStreamSessionId(l);
                    }
                    if (stringArray11.length > 2) {
                        long l = -1L;
                        try {
                            l = Long.parseLong(stringArray11[2]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        rTPStream.setStreamSessionVersion(l);
                    }
                    if (stringArray11.length > 5) {
                        rTPStream.setStreamSessionIp(stringArray11[5]);
                    }
                }
            } else if (rTPTrack == null && string5.startsWith("s=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("name", (String)object);
                }
            } else if (rTPTrack == null && string5.startsWith("i=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("information", (String)object);
                }
            } else if (rTPTrack == null && string5.startsWith("u=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("uri", (String)object);
                }
            } else if (rTPTrack == null && string5.startsWith("e=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("emailaddress", (String)object);
                }
            } else if (rTPTrack == null && string5.startsWith("p=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("phonenumber", (String)object);
                }
            } else if (string5.startsWith("c=")) {
                object = string5.substring(2).trim();
                if (rTPTrack == null) {
                    if (((String)object).length() > 0) {
                        rTPStream.addStreamInfo("connectiondata", (String)object);
                        String[] stringArray12 = ((String)object).split("[ ]");
                        if (stringArray12.length >= 3) {
                            String string19 = stringArray12[2].trim();
                            int n18 = string19.indexOf("/");
                            if (n18 >= 0) {
                                string19 = string19.substring(0, n18);
                            }
                            rTPStream.setHost(string19);
                        }
                    }
                } else {
                    String[] stringArray13 = ((String)object).split("[ ]");
                    if (stringArray13.length >= 3) {
                        String string20 = stringArray13[2].trim();
                        int n19 = string20.indexOf("/");
                        if (n19 >= 0) {
                            string20 = string20.substring(0, n19);
                        }
                        rTPTrack.setHost(string20);
                    }
                    if (((String)object).length() > 0) {
                        rTPTrack.addTrackInfo("connectiondata", (String)object);
                    }
                }
            } else if (string5.startsWith("b=AS")) {
                if (rTPTrack != null) {
                    int n20 = string5.indexOf(":");
                    if (n20 >= 0) {
                        string5 = string5.substring(n20 + 1).trim();
                    }
                    try {
                        int n21 = Integer.parseInt(string5);
                        rTPTrack.setBitrate(n21 *= 1024);
                    }
                    catch (Exception exception) {}
                }
            } else if (string5.startsWith("b=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    if (rTPTrack == null) {
                        rTPStream.addStreamInfo("bandwidth", (String)object);
                    } else {
                        rTPTrack.addTrackInfo("bandwidth", (String)object);
                    }
                }
            } else if (rTPTrack == null && string5.startsWith("t=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("timing", (String)object);
                }
            } else if (rTPTrack == null && string5.startsWith("r=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("repeattimes", (String)object);
                }
            } else if (rTPTrack == null && string5.startsWith("z=")) {
                object = string5.substring(2).trim();
                if (((String)object).length() > 0) {
                    rTPStream.addStreamInfo("timezones", (String)object);
                }
            } else if (string5.startsWith("a=proto")) {
                String string21;
                String[] stringArray14;
                int n22;
                if (rTPTrack != null && (n22 = ((String)(object = string5.substring(2).trim())).indexOf(":")) >= 0 && (stringArray14 = (string21 = ((String)object).substring(n22 + 1).trim()).split("[;]"))[0].endsWith("/TCP")) {
                    rTPTrack.setInterleaved(true);
                    for (n = 1; n < stringArray14.length; ++n) {
                        int n23;
                        String string22 = stringArray14[n].trim();
                        if (!string22.startsWith("interleaved=") || (n23 = string22.indexOf("=")) < 0) continue;
                        string4 = string22.substring(n23 + 1);
                        int n24 = string4.indexOf("-");
                        if (n24 > 0) {
                            try {
                                int n25 = Integer.parseInt(string4.substring(0, n24));
                                int n26 = Integer.parseInt(string4.substring(n24 + 1));
                                rTPTrack.setRTPInPortNum(n25);
                                rTPTrack.setRTCPInPortNum(n26);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        try {
                            int n27 = Integer.parseInt(string4.substring(0, n24));
                            rTPTrack.setRTPInPortNum(n27);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            } else if (string5.startsWith("a=") && ((String)(object = string5.substring(2).trim())).length() != 0) {
                int n28 = ((String)object).indexOf(":");
                Object object2 = null;
                String string23 = null;
                if (n28 >= 0) {
                    object2 = ((String)object).substring(0, n28).trim();
                    string23 = ((String)object).substring(n28 + 1).trim();
                } else {
                    object2 = object;
                }
                if (rTPTrack != null) {
                    rTPTrack.addTrackInfo((String)object2, string23);
                } else {
                    rTPStream.addStreamAttribute((String)object2, string23);
                }
            }
            string3 = string3 + string5 + "\n";
        }
        if (rTPTrack != null) {
            rTPTrack.setAnnounceData(string3);
            if (rTPTrack.getTrackId().equals("unknown")) {
                if (rTPTrack.isVideo()) {
                    rTPTrack.setTrackId("video");
                }
                if (rTPTrack.isAudio()) {
                    rTPTrack.setTrackId("audio");
                }
            }
            rTPStream.addTrack(rTPTrack);
        }
        rTPTrack = null;
        rTPStream.extractCodecConfigFromTrackInfo();
        return rTPStream;
    }

    public static byte[] formatH264CodecConfigPacket(byte[] byArray, List<byte[]> list, byte[] byArray2) {
        byte[] byArray3 = null;
        byte[] byArray4 = RTPUtils.formatH264CodecConfig(byArray, list, byArray2);
        if (byArray4 != null) {
            byArray3 = new byte[5 + byArray4.length];
            int n = 7;
            int n2 = 1;
            byArray3[0] = (byte)(n + (n2 << 4));
            byArray3[1] = 1;
            byArray3[2] = 0;
            byArray3[3] = 0;
            byArray3[4] = 0;
            System.arraycopy(byArray4, 0, byArray3, 5, byArray4.length);
        }
        return byArray3;
    }

    public static byte[] formatH264CodecConfig(byte[] byArray, List<byte[]> list, byte[] byArray2) {
        byte[] byArray3 = null;
        int n = 8 + byArray.length + 1;
        for (byte[] byArray4 : list) {
            n += 2 + byArray4.length;
        }
        byArray3 = new byte[n];
        byArray3[0] = 1;
        boolean bl = false;
        if (byArray2 != null && byArray2.length >= 3) {
            byArray3[1] = byArray2[0];
            byArray3[2] = byArray2[1];
            byArray3[3] = byArray2[2];
            bl = true;
        }
        if (!bl) {
            byArray3[1] = byArray[1];
            byArray3[2] = byArray[2];
            byArray3[3] = byArray[3];
        }
        byArray3[4] = -1;
        byArray3[5] = -31;
        byArray3[6] = (byte)(byArray.length >> 8 & 0xFF);
        byArray3[7] = (byte)(byArray.length >> 0 & 0xFF);
        System.arraycopy(byArray, 0, byArray3, 8, byArray.length);
        byArray3[8 + byArray.length] = (byte)(list.size() & 0xFF);
        Iterator<byte[]> iterator = list.iterator();
        int n2 = 9 + byArray.length;
        while (iterator.hasNext()) {
            byte[] byArray5 = iterator.next();
            byArray3[n2 + 0] = (byte)(byArray5.length >> 8 & 0xFF);
            byArray3[n2 + 1] = (byte)(byArray5.length >> 0 & 0xFF);
            System.arraycopy(byArray5, 0, byArray3, n2 + 2, byArray5.length);
            n2 += 2 + byArray5.length;
        }
        return byArray3;
    }
}

