/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.IFasterByteArrayWriteReference;
import com.wowza.util.XMLUtils;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaReaderFactory;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.util.ApplicationUtils;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.StreamList;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StreamUtils {
    public static double getStreamLength(IMediaStream iMediaStream) {
        double d = 0.0;
        MediaStreamMap mediaStreamMap = iMediaStream.getStreams();
        IApplicationInstance iApplicationInstance = mediaStreamMap.getAppInstance();
        IMediaReader iMediaReader = MediaReaderFactory.getInstance(iApplicationInstance, iApplicationInstance.getVHost().getMediaReaders(), iMediaStream.getExt());
        if (iMediaReader != null) {
            String string = iApplicationInstance.getStreamStoragePath();
            iMediaReader.init(iApplicationInstance, iMediaStream, iMediaStream.getExt(), string, iMediaStream.getName());
            long l = iMediaReader.getDuration();
            d = (double)l / 1000.0;
            iMediaReader.close();
        }
        return d;
    }

    public static int directOutput(byte[] byArray, int[] nArray, boolean bl, int n, OutputStream outputStream, AMFObj aMFObj, byte[] byArray2, int n2) {
        int n3 = 0;
        try {
            long l = (long)nArray[2] & 0xFFFFFFFFL;
            int n4 = nArray[1];
            int n5 = nArray[0];
            int n6 = aMFObj.getId();
            boolean bl2 = aMFObj.isNew();
            boolean bl3 = bl2 | bl;
            aMFObj.setNew(false);
            int n7 = 1;
            byArray2[0] = (byte)(0xFF & n6);
            if (bl3 || aMFObj.getSrc() != n) {
                byArray2[8] = (byte)(0xFF & n);
                byArray2[9] = (byte)(0xFF & n >> 8);
                byArray2[10] = (byte)(0xFF & n >> 16);
                byArray2[11] = (byte)(0xFF & n >> 24);
                aMFObj.setSrc(n);
                n7 += 4;
                bl3 = true;
            }
            if (bl3 || aMFObj.getSize() != n4) {
                byArray2[4] = (byte)(0xFF & n4 >> 16);
                byArray2[5] = (byte)(0xFF & n4 >> 8);
                byArray2[6] = (byte)(0xFF & n4);
                byArray2[7] = (byte)n5;
                aMFObj.setSize(n4);
                aMFObj.setType(n5);
                n7 += 4;
                bl3 = true;
            }
            boolean bl4 = false;
            if (bl3 || aMFObj.getTimecode() != l) {
                if (l >= 0xFFFFFFL) {
                    byArray2[1] = -1;
                    byArray2[2] = -1;
                    byArray2[3] = -1;
                    bl4 = true;
                } else {
                    byArray2[1] = (byte)(0xFFL & l >> 16);
                    byArray2[2] = (byte)(0xFFL & l >> 8);
                    byArray2[3] = (byte)(0xFFL & l);
                }
                aMFObj.setTimecode(l);
                n7 += 3;
                bl3 = true;
            }
            if (n6 >= 64) {
                byte[] byArray3 = new byte[2];
                switch (n7) {
                    case 12: {
                        byArray3[0] = 0;
                        break;
                    }
                    case 8: {
                        byArray3[0] = 64;
                        break;
                    }
                    case 4: {
                        byArray3[0] = -128;
                        break;
                    }
                    case 1: {
                        byArray3[0] = -64;
                    }
                }
                byArray3[1] = (byte)(n6 - 64 & 0xFF);
                outputStream.write(byArray3, 0, 2);
                outputStream.write(byArray2, 1, n7 - 1);
                n3 += n7 + 1;
            } else {
                switch (n7) {
                    case 12: {
                        break;
                    }
                    case 8: {
                        byArray2[0] = (byte)(byArray2[0] | 0x40);
                        break;
                    }
                    case 4: {
                        byArray2[0] = (byte)(byArray2[0] | 0x80);
                        break;
                    }
                    case 1: {
                        byArray2[0] = (byte)(byArray2[0] | 0xC0);
                    }
                }
                outputStream.write(byArray2, 0, n7);
                n3 += n7;
            }
            if (bl4) {
                byArray2[0] = (byte)(0xFFL & l >> 24);
                byArray2[1] = (byte)(0xFFL & l >> 16);
                byArray2[2] = (byte)(0xFFL & l >> 8);
                byArray2[3] = (byte)(0xFFL & l);
                outputStream.write(byArray2, 0, 4);
                n3 = 4;
            }
            if (n4 > 0) {
                int n8 = n4;
                int n9 = 0;
                int n10 = 0;
                do {
                    if (n9 > 0) {
                        if (n6 >= 64) {
                            byArray2[0] = -64;
                            byArray2[1] = (byte)(n6 - 64 & 0xFF);
                            outputStream.write(byArray2, 0, 2);
                            n3 += 2;
                        } else {
                            byArray2[0] = (byte)(0xFF & n6 | 0xC0);
                            outputStream.write(byArray2, 0, 1);
                            ++n3;
                        }
                        if (bl4) {
                            byArray2[0] = (byte)(0xFFL & l >> 24);
                            byArray2[1] = (byte)(0xFFL & l >> 16);
                            byArray2[2] = (byte)(0xFFL & l >> 8);
                            byArray2[3] = (byte)(0xFFL & l);
                            outputStream.write(byArray2, 0, 4);
                            n3 = 4;
                        }
                    }
                    if ((n10 = n2) > n8 - n9) {
                        n10 = n8 - n9;
                    }
                    outputStream.write(byArray, n9, n10);
                    n3 += n10;
                } while ((n9 += n10) != n8);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(StreamUtils.class).error("directOutput: " + exception.toString());
            exception.printStackTrace();
        }
        return n3;
    }

    public static int packetOutput(OutputStream outputStream, IMediaStream iMediaStream, AMFPacket aMFPacket, long l, AMFObj aMFObj, byte[] byArray, int n) {
        return StreamUtils.packetOutput(outputStream, iMediaStream, aMFPacket, l, aMFObj, byArray, n, true);
    }

    public static int packetOutput(OutputStream outputStream, IMediaStream iMediaStream, AMFPacket aMFPacket, long l, AMFObj aMFObj, byte[] byArray, int n, boolean bl) {
        int n2 = 0;
        try {
            byte[] byArray2;
            int n3;
            byte[] byArray3 = aMFPacket.getData();
            int n4 = aMFObj.getId();
            int n5 = iMediaStream.getSrc();
            int n6 = byArray3 != null ? byArray3.length : 0;
            int n7 = aMFPacket.getType();
            boolean bl2 = aMFObj.isNew();
            IFasterByteArrayWriteReference iFasterByteArrayWriteReference = null;
            if (bl && outputStream instanceof IFasterByteArrayWriteReference) {
                iFasterByteArrayWriteReference = (IFasterByteArrayWriteReference)((Object)outputStream);
            }
            if (!bl2) {
                bl2 = l < aMFObj.getAbsTimecode();
            }
            long l2 = bl2 ? l : l - aMFObj.getAbsTimecode();
            aMFObj.setAbsTimecodeLong(l);
            boolean bl3 = bl2;
            aMFObj.setNew(false);
            int n8 = 1;
            byArray[0] = (byte)(0xFF & n4);
            if (bl3 || aMFObj.getSrc() != n5) {
                byArray[8] = (byte)(0xFF & n5);
                byArray[9] = (byte)(0xFF & n5 >> 8);
                byArray[10] = (byte)(0xFF & n5 >> 16);
                byArray[11] = (byte)(0xFF & n5 >> 24);
                aMFObj.setSrc(n5);
                n8 += 4;
                bl3 = true;
            }
            if (bl3 || aMFObj.getSize() != n6) {
                byArray[4] = (byte)(0xFF & n6 >> 16);
                byArray[5] = (byte)(0xFF & n6 >> 8);
                byArray[6] = (byte)(0xFF & n6);
                byArray[7] = (byte)n7;
                aMFObj.setSize(n6);
                aMFObj.setType(n7);
                n8 += 4;
                bl3 = true;
            }
            boolean bl4 = false;
            if (bl3 || aMFObj.getTimecode() != l2 || aMFObj.isLastSentAbsTimecode()) {
                long l3 = l2 & 0xFFFFFFL;
                if (l3 == 0xFFFFFFL) {
                    l3 = 0L;
                }
                byArray[1] = (byte)(0xFFL & l3 >> 16);
                byArray[2] = (byte)(0xFFL & l3 >> 8);
                byArray[3] = (byte)(0xFFL & l3);
                aMFObj.setTimecode(bl2 ? 0L : l2);
                n8 += 3;
                bl3 = true;
            }
            aMFObj.setLastSentAbsTimecode(bl2);
            if (n4 >= 64) {
                int n9 = n4 - 64;
                n3 = n9 > 255 ? 3 : 2;
                byte[] byArray4 = new byte[n3];
                switch (n8) {
                    case 12: {
                        byArray4[0] = (byte)(0 + (n3 - 2));
                        break;
                    }
                    case 8: {
                        byArray4[0] = (byte)(64 + (n3 - 2));
                        break;
                    }
                    case 4: {
                        byArray4[0] = (byte)(128 + (n3 - 2));
                        break;
                    }
                    case 1: {
                        byArray4[0] = (byte)(192 + (n3 - 2));
                    }
                }
                byArray4[1] = (byte)(0xFF & n9);
                if (n3 == 3) {
                    byArray4[2] = (byte)(0xFF & n9 >> 8);
                }
                if (iFasterByteArrayWriteReference != null) {
                    iFasterByteArrayWriteReference.write(byArray4, 0, n3, true);
                    byArray2 = new byte[n8 - 1];
                    System.arraycopy(byArray, 1, byArray2, 0, n8 - 1);
                    iFasterByteArrayWriteReference.write(byArray2, 0, byArray2.length, true);
                } else {
                    outputStream.write(byArray4, 0, n3);
                    outputStream.write(byArray, 1, n8 - 1);
                }
                n2 += n8 + n3 - 1;
            } else {
                switch (n8) {
                    case 12: {
                        break;
                    }
                    case 8: {
                        byArray[0] = (byte)(byArray[0] | 0x40);
                        break;
                    }
                    case 4: {
                        byArray[0] = (byte)(byArray[0] | 0x80);
                        break;
                    }
                    case 1: {
                        byArray[0] = (byte)(byArray[0] | 0xC0);
                    }
                }
                if (iFasterByteArrayWriteReference != null) {
                    byte[] byArray5 = new byte[n8];
                    System.arraycopy(byArray, 0, byArray5, 0, n8);
                    iFasterByteArrayWriteReference.write(byArray5, 0, byArray5.length, true);
                } else {
                    outputStream.write(byArray, 0, n8);
                }
                n2 += n8;
            }
            if (bl4) {
                byArray[0] = (byte)(0xFFL & l2 >> 24);
                byArray[1] = (byte)(0xFFL & l2 >> 16);
                byArray[2] = (byte)(0xFFL & l2 >> 8);
                byArray[3] = (byte)(0xFFL & l2);
                if (iFasterByteArrayWriteReference != null) {
                    byte[] byArray6 = new byte[4];
                    System.arraycopy(byArray, 0, byArray6, 0, 4);
                    iFasterByteArrayWriteReference.write(byArray6, 0, byArray6.length, true);
                } else {
                    outputStream.write(byArray, 0, 4);
                }
                n2 = 4;
            }
            if (n6 > 0) {
                if (n6 <= n) {
                    if (iFasterByteArrayWriteReference != null) {
                        iFasterByteArrayWriteReference.write(byArray3, 0, n6, true);
                    } else {
                        outputStream.write(byArray3, 0, n6);
                    }
                } else {
                    int n10 = byArray3.length;
                    n3 = 0;
                    int n11 = 0;
                    do {
                        if (n3 > 0) {
                            if (n4 >= 64) {
                                int n12 = n4 - 64;
                                int n13 = n12 > 255 ? 3 : 2;
                                byArray[0] = (byte)(192 + (n13 - 2));
                                byArray[1] = (byte)(0xFF & n12);
                                if (n13 == 3) {
                                    byArray[2] = (byte)(0xFF & n12 >> 8);
                                }
                                if (iFasterByteArrayWriteReference != null) {
                                    byte[] byArray7 = new byte[n13];
                                    System.arraycopy(byArray, 0, byArray7, 0, n13);
                                    iFasterByteArrayWriteReference.write(byArray7, 0, byArray7.length, true);
                                } else {
                                    outputStream.write(byArray, 0, n13);
                                }
                                n2 += n13;
                            } else {
                                byArray[0] = (byte)(0xFF & n4 | 0xC0);
                                if (iFasterByteArrayWriteReference != null) {
                                    byArray2 = new byte[1];
                                    System.arraycopy(byArray, 0, byArray2, 0, 1);
                                    iFasterByteArrayWriteReference.write(byArray2, 0, byArray2.length, true);
                                } else {
                                    outputStream.write(byArray, 0, 1);
                                }
                                ++n2;
                            }
                            if (bl4) {
                                byArray[0] = (byte)(0xFFL & l2 >> 24);
                                byArray[1] = (byte)(0xFFL & l2 >> 16);
                                byArray[2] = (byte)(0xFFL & l2 >> 8);
                                byArray[3] = (byte)(0xFFL & l2);
                                if (iFasterByteArrayWriteReference != null) {
                                    byte[] byArray8 = new byte[4];
                                    System.arraycopy(byArray, 0, byArray8, 0, 4);
                                    iFasterByteArrayWriteReference.write(byArray8, 0, byArray8.length, true);
                                } else {
                                    outputStream.write(byArray, 0, 4);
                                }
                                n2 = 4;
                            }
                        }
                        if ((n11 = n) > n10 - n3) {
                            n11 = n10 - n3;
                        }
                        if (iFasterByteArrayWriteReference != null) {
                            iFasterByteArrayWriteReference.write(byArray3, n3, n11, true);
                        } else {
                            outputStream.write(byArray3, n3, n11);
                        }
                        n2 += n11;
                    } while ((n3 += n11) != n10);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(StreamUtils.class).error("fastOutput: " + exception.toString());
            exception.printStackTrace();
        }
        return n2;
    }

    public static void loadConfigFile(StreamList streamList, String string) {
        WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("Loading Streams.xml: " + string);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            String string2 = "/Root/Streams/Stream";
            String string3 = "Properties/Property";
            if (document != null) {
                Element element = document.getDocumentElement();
                XPathExpression xPathExpression = xPath.compile(string2);
                XPathExpression xPathExpression2 = xPath.compile(string3);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        Element element2 = (Element)node;
                        Node node2 = XMLUtils.getNodeByTagName(element2, "Name");
                        Node node3 = XMLUtils.getNodeByTagName(element2, "ClassBase");
                        Node node4 = XMLUtils.getNodeByTagName(element2, "ClassPlay");
                        if (node2 == null || node3 == null || node4 == null) continue;
                        String string4 = XMLUtils.getNodeValue(node2);
                        String string5 = XMLUtils.getNodeValue(node3);
                        String string6 = XMLUtils.getNodeValue(node4);
                        if (string6.compareToIgnoreCase("null") == 0) {
                            string6 = null;
                        }
                        StreamItem streamItem = new StreamItem(string4, string5, string6);
                        streamList.getStreamDefs().put(string4, streamItem);
                        Element element3 = (Element)XMLUtils.getNodeByTagName(element2, "Description");
                        if (element3 != null) {
                            streamItem.setDescription(XMLUtils.getNodeValue(element3));
                        }
                        WMSProperties wMSProperties = streamItem.getProperties();
                        NodeList nodeList2 = (NodeList)xPathExpression2.evaluate(node, XPathConstants.NODESET);
                        if (nodeList2 != null) {
                            XMLUtils.loadConfigProperies(nodeList2, wMSProperties);
                        }
                        WMSLoggerFactory.getLogger(StreamUtils.class).debug(streamItem.toString());
                    }
                } else {
                    WMSLoggerFactory.getLogger(StreamUtils.class).error("error parsing stream config file: (" + string + ") error: XPath " + string2 + " missing");
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(StreamUtils.class).error("error parsing stream config file: (" + string + ") error: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

