/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.vhost;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.vhost.VHost;
import com.wowza.wms.vhost.VHostWorkerThread;

public class VHostWatchdog
extends VHostWorkerThread {
    private VHost vhost = null;
    private int checkFreq = 1000;
    private boolean isRunning = true;
    private boolean debuglog = false;

    public VHostWatchdog(VHost vHost, int n) {
        super(vHost);
        this.vhost = vHost;
        this.checkFreq = n;
    }

    public synchronized void halt() {
        if (this.debuglog) {
            WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: halt");
        }
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.debuglog) {
            WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: start");
        }
        block4: while (true) {
            try {
                while (true) {
                    if (this.debuglog) {
                        WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: run: " + this.vhost);
                    }
                    if (this.vhost != null) {
                        this.vhost.doWatchdog();
                    }
                    if (this.debuglog) {
                        WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: beforeWait: " + this.checkFreq);
                    }
                    Thread.currentThread();
                    Thread.sleep(this.checkFreq);
                    if (this.debuglog) {
                        WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: afterWait: " + this.isRunning);
                    }
                    VHostWatchdog vHostWatchdog = this;
                    synchronized (vHostWatchdog) {
                        if (!this.isRunning) {
                            break block4;
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!this.debuglog) continue;
                WMSLoggerFactory.getLogger(VHostWatchdog.class).error("vhostWatchdog: exception: " + exception.toString());
                continue;
            }
            break;
        }
        if (this.debuglog) {
            WMSLoggerFactory.getLogger(VHostWatchdog.class).info("vhostWatchdog: stop");
        }
    }
}

