/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.file;

import com.wowza.io.IRandomAccessReader;
import com.wowza.io.RandomAccessReaderFactory;
import com.wowza.util.XMLUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.HTTPStreamerCupertinoIndexBase;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndexItem;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.model.HTTPStreamerFileInfo;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamDisconnected;
import com.wowza.wms.stream.MediaStreamMap;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPStreamerCupertinoIndexPlaylist
extends HTTPStreamerCupertinoIndexBase {
    private List<PlaylistNode> nodes = new ArrayList<PlaylistNode>();
    private long maxFileSize = 66560L;

    @Override
    public void fillChunk(IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem, LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk) {
    }

    @Override
    public List<String> getStreamNamesRaw() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PlaylistNode playlistNode : this.nodes) {
            arrayList.add(playlistNode.streamName);
        }
        return arrayList;
    }

    @Override
    public List<String> getStreamNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PlaylistNode playlistNode : this.nodes) {
            String string = this.adjustStreamName(playlistNode.streamName);
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public void indexFile(IHTTPStreamerSession iHTTPStreamerSession) {
        IRandomAccessReader iRandomAccessReader;
        block18: {
            String string = this.appInstance.getApplication().getName() + "/" + this.appInstance.getName() + "/" + this.streamExt + ":" + this.streamName;
            iRandomAccessReader = null;
            try {
                int n;
                Object object;
                MediaStreamMap mediaStreamMap = this.appInstance.getStreams();
                MediaStreamDisconnected mediaStreamDisconnected = new MediaStreamDisconnected();
                mediaStreamDisconnected.init(mediaStreamMap, 0, new WMSProperties());
                mediaStreamDisconnected.setName(this.streamName, null, this.streamExt, null, 0.0, -1.0, 1);
                String string2 = "com.wowza.io.DirectRandomAccessReader";
                string2 = this.appInstance.getMediaReaderProperties().getPropertyStr("randomAccessReaderClass", string2);
                String string3 = this.appInstance.getStreamStoragePath();
                iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)string2, (String)string3, (String)this.streamName, (String)this.streamExt, (IMediaStream)mediaStreamDisconnected);
                if (iRandomAccessReader == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerCupertinoIndexPlaylist.class).warn("HTTPStreamerCupertinoIndexPlaylist.indexFile[" + string + "]: File not found.");
                    break block18;
                }
                iRandomAccessReader.open();
                if (iRandomAccessReader.length() > this.maxFileSize) {
                    WMSLoggerFactory.getLogger(HTTPStreamerCupertinoIndexPlaylist.class).warn("HTTPStreamerCupertinoIndexPlaylist.indexFile[" + string + "]: File too large for playlist file: " + iRandomAccessReader.length() + ">" + this.maxFileSize);
                    break block18;
                }
                if (iHTTPStreamerSession != null) {
                    object = new HTTPStreamerFileInfo(this.getStreamName(), iRandomAccessReader.length(), 0.0);
                    iHTTPStreamerSession.putFileInfo(this.getStreamName(), (HTTPStreamerFileInfo)object);
                }
                if ((n = iRandomAccessReader.read(object = new byte[(int)iRandomAccessReader.length()], 0, ((byte[])object).length)) != ((byte[])object).length) {
                    WMSLoggerFactory.getLogger(HTTPStreamerCupertinoIndexPlaylist.class).warn("HTTPStreamerCupertinoIndexPlaylist.indexFile[" + string + "]: Error reading file: " + n + " != " + ((byte[])object).length);
                    break block18;
                }
                try {
                    iRandomAccessReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iRandomAccessReader = null;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(dataInputStream);
                XPathFactory xPathFactory = XMLUtils.newXPathFactory();
                XPath xPath = xPathFactory.newXPath();
                String string4 = "/smil/body/switch/video";
                XPathExpression xPathExpression = xPath.compile(string4);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
                if (nodeList == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerCupertinoIndexPlaylist.class).warn("HTTPStreamerCupertinoIndexPlaylist.indexFile[" + string + "]: No results: " + string4);
                    break block18;
                }
                if (nodeList.getLength() <= 0) {
                    WMSLoggerFactory.getLogger(HTTPStreamerCupertinoIndexPlaylist.class).warn("HTTPStreamerCupertinoIndexPlaylist.indexFile[" + string + "]: Playlist file is empty. Entries must be of the form: " + string4);
                    break block18;
                }
                String string5 = "";
                int n2 = this.streamName.lastIndexOf("/");
                if (n2 > 0) {
                    string5 = this.streamName.substring(0, n2) + "/";
                }
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    Element element = (Element)node;
                    String string6 = string5 + element.getAttribute("src");
                    String string7 = element.getAttribute("system-bitrate");
                    if (string7 == null) {
                        string7 = element.getAttribute("systemBitrate");
                    }
                    long l = 0L;
                    try {
                        l = Long.parseLong(string7);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.nodes.add(new PlaylistNode(string6, l));
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerCupertinoIndexPlaylist.class).error("HTTPStreamerCupertinoIndexPlaylist.indexFile[" + string + "]: " + exception.toString());
            }
        }
        if (iRandomAccessReader != null) {
            try {
                iRandomAccessReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            iRandomAccessReader = null;
        }
    }

    @Override
    public String getPlaylistStr() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#EXTM3U\n");
        for (PlaylistNode playlistNode : this.nodes) {
            stringBuffer.append("#EXT-X-STREAM-INF:PROGRAM-ID=1,BANDWIDTH=" + playlistNode.bitrate + "\n");
            String string = "http://{domain}/{application}/{appInstance}/{stream}/{filename}?{query}";
            string = string.replace("{stream}", playlistNode.streamName);
            string = string.replace("{filename}", "playlist.m3u8");
            stringBuffer.append(string + "\n");
        }
        return stringBuffer.toString();
    }

    class PlaylistNode {
        String streamName = null;
        long bitrate = 0L;

        public PlaylistNode(String string, long l) {
            this.streamName = string;
            this.bitrate = l;
        }
    }
}

