/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer;

import com.wowza.util.HTTPUtils;
import com.wowza.util.IFasterByteArrayWriteReference;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndex;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.CupertinoStreamingURL;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerSessionCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamingCupertinoBlock;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.model.HTTPStreamerAdapterBase;
import com.wowza.wms.httpstreamer.model.HTTPStreamerContext;
import com.wowza.wms.httpstreamer.model.HTTPStreamerRequest;
import com.wowza.wms.httpstreamer.model.HTTPStreamerResponse;
import com.wowza.wms.httpstreamer.model.HTTPStreamerStreamNameParts;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.RtmpResponseMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import com.wowza.wms.vhost.IVHost;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.IoSession;

public class HTTPStreamerAdapterCupertinoStreamer
extends HTTPStreamerAdapterBase {
    protected boolean debugLog = false;
    protected int requestTimeout = 8000;
    protected int tcpTimeToLive = 500;
    protected int tcpKeepAliveTimeout = 5000;
    protected String playlistMimeType = "application/vnd.apple.mpegurl";
    protected String videoMimeType = "video/MP2T";
    protected String keyMimeType = "binary/octet-stream";

    public HTTPStreamerAdapterCupertinoStreamer() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS((byte[])bigInteger.toByteArray(), (String)string);
            if (string2.indexOf(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
        }
    }

    public void init() {
        super.init();
        this.playlistMimeType = this.getProperties().getPropertyStr("playlistMimeType", this.playlistMimeType);
        this.videoMimeType = this.getProperties().getPropertyStr("videoMimeType", this.videoMimeType);
        this.keyMimeType = this.getProperties().getPropertyStr("keyMimeType", this.keyMimeType);
        this.requestTimeout = this.getProperties().getPropertyInt("requestTimeout", this.requestTimeout);
        this.tcpTimeToLive = this.getProperties().getPropertyInt("tcpTimeToLive", this.tcpTimeToLive);
        this.tcpKeepAliveTimeout = this.getProperties().getPropertyInt("tcpKeepAliveTimeout", this.tcpKeepAliveTimeout);
        this.debugLog = WMSLoggerFactory.getLogger(null).isDebugEnabled();
    }

    public boolean canHandle(String string) {
        int n = string.indexOf("?");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        boolean bl = super.canHandle(string);
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).debug("HTTPStreamerAdapterCupertinoStreaming.canHandle[" + string + "]: " + bl);
        }
        return bl;
    }

    public void service(IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        long l = System.currentTimeMillis();
        if (rtmpRequestMessage.getType() == 3) {
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            RtmpRequestMessage rtmpRequestMessage2 = rtmpSessionInfo.getAndClearPendingRequest();
            if (rtmpRequestMessage2 != null) {
                this.serviceMsg(l, ioSession, rtmpRequestMessage2, rtmpResponseMessage);
                if (rtmpSessionInfo.isPendingRequest() && l - rtmpRequestMessage2.getCreateTime() > (long)this.requestTimeout) {
                    WMSLoggerFactory.getLogger(null).warn("HTTPStreamerAdapterCupertinoStreaming.service: Request timeout: " + this.requestTimeout);
                    rtmpSessionInfo.getAndClearPendingRequest();
                    rtmpResponseMessage.setResponseCode(404);
                }
            } else {
                long l2 = l - ioSession.getLastIoTime();
                long l3 = ioSession.getScheduledWriteBytes();
                boolean bl = false;
                if (l3 <= 0L) {
                    rtmpSessionInfo.setLastBytesToWriteBytes(-1L);
                    if (rtmpSessionInfo.isCloseOnIdle()) {
                        if (l2 >= (long)this.tcpTimeToLive) {
                            ioSession.close();
                        }
                    } else if (l2 >= (long)this.tcpKeepAliveTimeout) {
                        ioSession.close();
                        bl = true;
                    }
                } else {
                    long l4 = rtmpSessionInfo.getLastBytesToWriteBytes();
                    long l5 = rtmpSessionInfo.getLastBytesToWriteTimecode();
                    if (l4 == -1L || l4 != l3) {
                        rtmpSessionInfo.setLastBytesToWriteBytes(l3);
                        rtmpSessionInfo.setLastBytesToWriteTimecode(l);
                    } else if (l - l5 > (long)this.tcpKeepAliveTimeout) {
                        ioSession.close();
                        bl = true;
                    }
                }
                if (!bl) {
                    Set set = rtmpSessionInfo.getHTTPSession();
                    for (IHTTPStreamerSession iHTTPStreamerSession : set) {
                        iHTTPStreamerSession.touch(l);
                    }
                }
            }
        } else {
            this.serviceMsg(l, ioSession, rtmpRequestMessage, rtmpResponseMessage);
        }
    }

    public void serviceMsg(long l, IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        try {
            int n;
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            String string = rtmpRequestMessage.getPath();
            if (this.debugLog) {
                WMSLoggerFactory.getLogger(null).debug("HTTPStreamerAdapterCupertinoStreaming.service: " + string);
            }
            HTTPStreamerRequest hTTPStreamerRequest = new HTTPStreamerRequest(rtmpRequestMessage);
            HTTPStreamerResponse hTTPStreamerResponse = new HTTPStreamerResponse(rtmpResponseMessage);
            IVHost iVHost = rtmpRequestMessage.getVHost();
            String string2 = hTTPStreamerRequest.getHeader("range");
            String string3 = hTTPStreamerRequest.getHeader("connection");
            boolean bl = false;
            if (string3 != null && string3.equalsIgnoreCase("close")) {
                bl = true;
            }
            rtmpSessionInfo.setCloseOnIdle(bl);
            boolean bl2 = false;
            if (string2 != null && (string2 = string2.trim()).length() > 0 && (n = string2.indexOf("=")) >= 0 && (string2 = string2.substring(n + 1)).equals("0-1")) {
                bl2 = true;
            }
            if ((n = string.indexOf("?")) >= 0) {
                string = string.substring(0, n);
            }
            if (bl2) {
                this.onCheckAvailibility(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            } else if (string.endsWith(".m3u") || string.endsWith(".m3u8")) {
                this.onPlaylist(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            } else if (string.endsWith(".m3u8key")) {
                this.onEncKey(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            } else if (string.endsWith(".ts")) {
                this.onMediaFile(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).error("HTTPStreamerAdapterCupertinoStreaming.service: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void onCheckAvailibility(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block16: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            try {
                CupertinoStreamingURL cupertinoStreamingURL;
                String string = iHTTPRequest.getHeader("context");
                if (string == null || (cupertinoStreamingURL = new CupertinoStreamingURL(string, true)) == null) break block16;
                String string2 = cupertinoStreamingURL.getAppName();
                String string3 = cupertinoStreamingURL.getAppInstanceName();
                String string4 = cupertinoStreamingURL.getStreamName();
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string2, string3, this.getAdapterName(), true);
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.onCheckAvailibility: Application context not loaded [" + string + "]: " + string2 + "/" + string3);
                    break block16;
                }
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                boolean bl3 = this.isLive(iApplicationInstance);
                boolean bl4 = this.isRepeater(iApplicationInstance);
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(null, iApplicationInstance, bl4, string4);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block16;
                String string5 = "";
                if (hTTPStreamerStreamNameParts.streamExt.equals("smil")) {
                    boolean bl5 = HTTPStreamerSessionCupertino.doesFileExist(iHTTPStreamerApplicationContext, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (!bl5) break block16;
                    string5 = "#E";
                } else if (bl3) {
                    MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                    ILiveStreamPacketizer iLiveStreamPacketizer = mediaStreamMap.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false);
                    if (iLiveStreamPacketizer == null && bl4) {
                        this.startLiveStreamRepeat(iApplicationInstance, hTTPStreamerStreamNameParts.repeaterName);
                        iLiveStreamPacketizer = mediaStreamMap.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false);
                    }
                    if (iLiveStreamPacketizer == null) {
                        if (bl4) {
                            bl = true;
                        } else {
                            WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                        }
                        break block16;
                    }
                    if (!(iLiveStreamPacketizer instanceof LiveStreamPacketizerCupertino)) {
                        WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: LiveStreamPacketizer wrong type [" + string + "]: " + this.liveStreamPacketizer);
                        break block16;
                    }
                    string5 = "#E";
                } else {
                    boolean bl6 = HTTPStreamerSessionCupertino.doesFileExist(iHTTPStreamerApplicationContext, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (!bl6) break block16;
                    string5 = "#E";
                }
                iHTTPResponse.setHeader("Content-Type", "application/x-mpegURL");
                iHTTPResponse.setHeader("Cache-Control", "no-cache");
                iHTTPResponse.setHeader("Date", this.getHTTPDate());
                OutputStream outputStream = iHTTPResponse.getOutputStream();
                outputStream.write(string5.getBytes());
                bl2 = true;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).error("HTTPStreamerAdapterCupertinoStreaming.onPlaylist: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (!bl2) {
            if (bl) {
                rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            } else {
                iHTTPResponse.setResponseCode(404);
            }
        }
    }

    protected IHTTPStreamerSession createSession(IHTTPRequest iHTTPRequest, IApplicationInstance iApplicationInstance, String string, String string2) {
        int n;
        int n2;
        HTTPStreamerSessionCupertino hTTPStreamerSessionCupertino = new HTTPStreamerSessionCupertino();
        String string3 = iHTTPRequest.getHeader("referrer");
        hTTPStreamerSessionCupertino.setReferrer(string3);
        String string4 = iHTTPRequest.getHeader("host");
        int n3 = 80;
        if (string4 != null && (n2 = string4.indexOf(":")) >= 0) {
            try {
                n3 = Integer.parseInt(string4.substring(n2 + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            string4 = string4.substring(0, n2);
        }
        hTTPStreamerSessionCupertino.setServerIp(string4);
        hTTPStreamerSessionCupertino.setServerPort(n3);
        String string5 = iHTTPRequest.getHeader("context");
        String string6 = null;
        if (string5 != null && (n = string5.indexOf("?")) > 0) {
            string6 = string5.substring(n + 1);
            string5 = string5.substring(0, n);
        }
        hTTPStreamerSessionCupertino.setUri(string5);
        hTTPStreamerSessionCupertino.setQueryStr(string6);
        hTTPStreamerSessionCupertino.setUserAgent(iHTTPRequest.getHeader("user-agent"));
        hTTPStreamerSessionCupertino.setCookieStr(iHTTPRequest.getHeader("cookie"));
        hTTPStreamerSessionCupertino.addStreamDomainStr(string2);
        this.createSession((IHTTPStreamerSession)hTTPStreamerSessionCupertino, iApplicationInstance, string);
        return hTTPStreamerSessionCupertino;
    }

    public void onPlaylist(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block40: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            try {
                Object object;
                CupertinoStreamingURL cupertinoStreamingURL;
                String string = iHTTPRequest.getHeader("context");
                if (string == null || (cupertinoStreamingURL = new CupertinoStreamingURL(string, true)) == null) break block40;
                String string2 = cupertinoStreamingURL.getAppName();
                String string3 = cupertinoStreamingURL.getAppInstanceName();
                String string4 = cupertinoStreamingURL.getStreamName();
                String string5 = iHTTPRequest.getHeader("host");
                String string6 = cupertinoStreamingURL.getQueryStr();
                Map map = HTTPUtils.splitQueryStr((String)string6);
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string2, string3, this.getAdapterName(), true);
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.onPlaylist: Application context not loaded [" + string + "]: " + string2 + "/" + string3);
                    break block40;
                }
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                String string7 = this.getStreamDomainStr(iApplicationInstance, string4);
                String string8 = this.parseSessionId(string6);
                HTTPStreamerContext hTTPStreamerContext = iVHost.getHTTPStreamerContext();
                IHTTPStreamerSession iHTTPStreamerSession = null;
                if (string8 != null) {
                    iHTTPStreamerSession = hTTPStreamerContext.getSessions().getSession(string8);
                }
                boolean bl3 = false;
                boolean bl4 = false;
                if (iHTTPStreamerSession == null) {
                    bl3 = true;
                    bl4 = true;
                    iHTTPStreamerSession = this.createSession(iHTTPRequest, iApplicationInstance, string8, string7);
                    if (string8 != null && string8.equals(iHTTPStreamerSession.getSessionId())) {
                        bl3 = false;
                    }
                }
                boolean bl5 = this.isLive(iApplicationInstance);
                boolean bl6 = this.isRepeater(iApplicationInstance);
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl6, string4);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block40;
                if (iHTTPStreamerSession == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.onPlaylist: Should not get here [" + string + "]: " + string2 + "/" + string3);
                    break block40;
                }
                if (bl4) {
                    iHTTPStreamerSession.setStreamExt(hTTPStreamerStreamNameParts.streamExt);
                    iHTTPStreamerSession.setStreamName(hTTPStreamerStreamNameParts.resolvedName);
                }
                map.put("wowzasessionid", iHTTPStreamerSession.getSessionId());
                String string9 = HTTPUtils.assembleQueryStr((Map)map);
                rtmpSessionInfo.addHTTPSession(iHTTPStreamerSession);
                if (iHTTPStreamerSession != null) {
                    if (!iHTTPStreamerSession.isValidated()) {
                        iHTTPStreamerSession.setLiveStreamingPacketizer(this.liveStreamPacketizer);
                        this.markSessionValid(iApplicationInstance, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt, string6, "cupertino", iHTTPStreamerSession, iHTTPRequest.getRemoteAddr());
                        iHTTPStreamerSession.setSessionType(bl5 ? 1 : 2);
                    }
                    iHTTPStreamerSession.touch(l);
                }
                if (!iHTTPStreamerSession.isValidated()) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.onPlaylist: Over license limit");
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block40;
                }
                if (bl4) {
                    this.notifySessionCreate(iHTTPStreamerSession, iApplicationInstance);
                }
                if (!iHTTPStreamerSession.isAcceptSession()) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block40;
                }
                if (!iHTTPStreamerSession.isValidStreamDomainStr(string7)) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block40;
                }
                String string10 = "";
                boolean bl7 = false;
                boolean bl8 = false;
                if (hTTPStreamerStreamNameParts.streamExt.equals("smil")) {
                    object = ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).getIndex(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (object == null) break block40;
                    string10 = object.getPlaylistStr();
                    bl3 = false;
                    bl7 = true;
                    if (iHTTPStreamerSession != null) {
                        iHTTPStreamerSession.addStreamDomainStrs(object.getStreamNamesRaw());
                        if (bl6) {
                            iHTTPStreamerSession.lockRepeaterStreams(object.getStreamNames(), this.liveStreamPacketizer, this.liveStreamRepeater, this.getStreamTypeStr());
                        }
                    }
                } else if (bl3) {
                    object = string;
                    int n = ((String)object).indexOf("?");
                    if (n > 0) {
                        object = ((String)object).substring(0, n);
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("#EXTM3U\n");
                    int n2 = 64000;
                    n2 = iHTTPStreamerApplicationContext.getProperties().getPropertyInt("cupertinoDefaultPlaylistBandwidth", n2);
                    stringBuffer.append("#EXT-X-STREAM-INF:PROGRAM-ID=1,BANDWIDTH=" + n2 + "\n");
                    stringBuffer.append("http://" + string5 + "/" + (String)object + "?" + string9 + "\n");
                    string10 = stringBuffer.toString();
                } else {
                    if (bl5) {
                        String string11;
                        object = iApplicationInstance.getStreams();
                        ILiveStreamPacketizer iLiveStreamPacketizer = object.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, string11 = bl6 ? this.liveStreamRepeater : this.liveStreamPacketizer, false);
                        if (iLiveStreamPacketizer == null && bl6) {
                            this.startLiveStreamRepeat(iApplicationInstance, hTTPStreamerStreamNameParts.repeaterName);
                            iLiveStreamPacketizer = object.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false);
                        }
                        if (iLiveStreamPacketizer == null) {
                            if (bl6) {
                                bl = true;
                            } else {
                                WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                            }
                            break block40;
                        }
                        if (!(iLiveStreamPacketizer instanceof LiveStreamPacketizerCupertino)) {
                            WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: LiveStreamPacketizer wrong type [" + string + "]: " + this.liveStreamPacketizer);
                            break block40;
                        }
                        string10 = ((LiveStreamPacketizerCupertino)iLiveStreamPacketizer).getPlaylistStr();
                        bl8 = ((LiveStreamPacketizerCupertino)iLiveStreamPacketizer).isEmptyPlaylist();
                        if (bl8) {
                            bl = true;
                            break block40;
                        }
                    } else {
                        object = ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).getIndex(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                        if (object == null) break block40;
                        string10 = object.getPlaylistStr();
                    }
                    bl7 = true;
                }
                if (string10 == null) {
                    if (bl6) {
                        bl = true;
                    }
                } else if (string10.length() <= 0) {
                    if (bl6) {
                        bl = true;
                    }
                } else {
                    if (bl7) {
                        string10 = string10.replace("{domain}", string5);
                        string10 = string10.replace("{application}", string2);
                        string10 = string10.replace("{appInstance}", string3);
                        string10 = string10.replace("{stream}", string4);
                        string10 = string10.replace("{query}", string9);
                    }
                    iHTTPResponse.setHeader("Content-Type", this.playlistMimeType);
                    iHTTPResponse.setHeader("Cache-Control", "no-cache");
                    iHTTPResponse.setHeader("Date", this.getHTTPDate());
                    object = iHTTPResponse.getOutputStream();
                    ((OutputStream)object).write(string10.getBytes());
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).error("HTTPStreamerAdapterCupertinoStreaming.onPlaylist: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (!bl2) {
            if (bl) {
                rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            } else {
                iHTTPResponse.setResponseCode(404);
            }
        }
    }

    public void onEncKey(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block19: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            try {
                Object object;
                Object object2;
                CupertinoStreamingURL cupertinoStreamingURL;
                String string = iHTTPRequest.getHeader("context");
                if (string == null || (cupertinoStreamingURL = new CupertinoStreamingURL(string, true)) == null) break block19;
                String string2 = cupertinoStreamingURL.getAppName();
                String string3 = cupertinoStreamingURL.getAppInstanceName();
                String string4 = cupertinoStreamingURL.getStreamName();
                String string5 = cupertinoStreamingURL.getQueryStr();
                Map map = HTTPUtils.splitQueryStr((String)string5);
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string2, string3, this.getAdapterName());
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.onEncKey: Application context not loaded [" + string + "]: " + string2 + "/" + string3);
                    break block19;
                }
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                String string6 = this.getStreamDomainStr(iApplicationInstance, string4);
                boolean bl3 = this.isLive(iApplicationInstance);
                boolean bl4 = this.isRepeater(iApplicationInstance);
                String string7 = this.parseSessionId(string5);
                HTTPStreamerContext hTTPStreamerContext = iVHost.getHTTPStreamerContext();
                IHTTPStreamerSession iHTTPStreamerSession = null;
                if (string7 != null) {
                    iHTTPStreamerSession = hTTPStreamerContext.getSessions().getSession(string7);
                }
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl4, string4);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block19;
                boolean bl5 = true;
                if (iHTTPStreamerSession != null) {
                    if (!iHTTPStreamerSession.isValidated()) {
                        this.markSessionValid(iApplicationInstance, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt, string5, "cupertino", iHTTPStreamerSession, iHTTPRequest.getRemoteAddr());
                    }
                    iHTTPStreamerSession.touch(l);
                    bl5 = iHTTPStreamerSession.isActive();
                    rtmpSessionInfo.addHTTPSession(iHTTPStreamerSession);
                }
                if (!iHTTPStreamerSession.isValidated()) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.onEncKey: Over license limit");
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block19;
                }
                if (!bl5 || iHTTPStreamerSession == null) break block19;
                map.put("wowzasessionid", iHTTPStreamerSession.getSessionId());
                if (!iHTTPStreamerSession.isValidStreamDomainStr(string6)) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block19;
                }
                CupertinoEncInfo cupertinoEncInfo = null;
                if (bl3) {
                    object2 = iApplicationInstance.getStreams();
                    object = object2.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false);
                    if (object == null) {
                        WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: LiveStreamPacketizer not found [" + string + "]: " + this.liveStreamPacketizer);
                        break block19;
                    }
                    if (!(object instanceof LiveStreamPacketizerCupertino)) {
                        WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: LiveStreamPacketizer wrong type [" + string + "]: " + this.liveStreamPacketizer);
                        break block19;
                    }
                    cupertinoEncInfo = ((LiveStreamPacketizerCupertino)object).getEncryptionInfo();
                } else {
                    IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex = object2 = iHTTPStreamerSession == null ? null : ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).getIndex(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (object2 == null) break block19;
                    cupertinoEncInfo = object2.getEncInfo();
                }
                if (cupertinoEncInfo != null && cupertinoEncInfo.isInternal() && (object2 = (Object)cupertinoEncInfo.getEncKeyBytes()) != null) {
                    iApplicationInstance.getModFunctions().onHTTPCupertinoEncryptionKeyRequest((HTTPStreamerSessionCupertino)iHTTPStreamerSession, iHTTPRequest, iHTTPResponse);
                    if (!iHTTPStreamerSession.isAcceptSession()) {
                        iHTTPResponse.setResponseCode(403);
                        bl2 = true;
                    } else {
                        iHTTPResponse.setHeader("Content-Type", this.keyMimeType);
                        iHTTPResponse.setHeader("Cache-Control", "no-cache");
                        iHTTPResponse.setHeader("Date", this.getHTTPDate());
                        object = iHTTPResponse.getOutputStream();
                        ((OutputStream)object).write((byte[])object2);
                        bl2 = true;
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).error("HTTPStreamerAdapterCupertinoStreaming.onEncKey: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (!bl2) {
            if (bl) {
                rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            } else {
                iHTTPResponse.setResponseCode(404);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMediaFile(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block28: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            int n = 0;
            try {
                ILiveStreamPacketizer iLiveStreamPacketizer;
                Object object;
                CupertinoStreamingURL cupertinoStreamingURL;
                String string = iHTTPRequest.getHeader("context");
                if (string == null || (cupertinoStreamingURL = new CupertinoStreamingURL(string, true)) == null) break block28;
                String string2 = cupertinoStreamingURL.getAppName();
                String string3 = cupertinoStreamingURL.getAppInstanceName();
                String string4 = cupertinoStreamingURL.getStreamName();
                String string5 = cupertinoStreamingURL.getQueryStr();
                Map map = HTTPUtils.splitQueryStr((String)string5);
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string2, string3, this.getAdapterName());
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.onMediaFile: Application context not loaded [" + string + "]: " + string2 + "/" + string3);
                    break block28;
                }
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                String string6 = this.getStreamDomainStr(iApplicationInstance, string4);
                boolean bl3 = this.isLive(iApplicationInstance);
                boolean bl4 = this.isRepeater(iApplicationInstance);
                String string7 = this.parseSessionId(string5);
                HTTPStreamerContext hTTPStreamerContext = iVHost.getHTTPStreamerContext();
                IHTTPStreamerSession iHTTPStreamerSession = null;
                if (string7 != null) {
                    iHTTPStreamerSession = hTTPStreamerContext.getSessions().getSession(string7);
                }
                boolean bl5 = false;
                if (iHTTPStreamerSession == null) {
                    iHTTPStreamerSession = this.createSession(iHTTPRequest, iApplicationInstance, string7, string6);
                    bl5 = true;
                }
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl4, string4);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block28;
                if (bl5) {
                    iHTTPStreamerSession.setStreamExt(hTTPStreamerStreamNameParts.streamExt);
                    iHTTPStreamerSession.setStreamName(hTTPStreamerStreamNameParts.resolvedName);
                }
                boolean bl6 = true;
                int n2 = 0;
                if (iHTTPStreamerSession != null) {
                    if (!iHTTPStreamerSession.isValidated()) {
                        this.markSessionValid(iApplicationInstance, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt, string5, "cupertino", iHTTPStreamerSession, iHTTPRequest.getRemoteAddr());
                    }
                    iHTTPStreamerSession.touch(l);
                    bl6 = iHTTPStreamerSession.isActive();
                    n2 = iHTTPStreamerSession.getSessionType();
                    rtmpSessionInfo.addHTTPSession(iHTTPStreamerSession);
                }
                if (!iHTTPStreamerSession.isValidated()) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.onMediaFile: Over license limit");
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block28;
                }
                if (bl5) {
                    this.notifySessionCreate(iHTTPStreamerSession, iApplicationInstance);
                }
                if (!iHTTPStreamerSession.isValidStreamDomainStr(string6)) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block28;
                }
                if (!bl6) break block28;
                if (iHTTPStreamerSession != null && !iHTTPStreamerSession.isAcceptSession()) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block28;
                }
                int n3 = string.lastIndexOf("/");
                if (n3 < 0) break block28;
                String string8 = string.substring(n3 + 1);
                int n4 = string8.indexOf("?");
                if (n4 >= 0) {
                    string8 = string8.substring(0, n4);
                }
                if (n2 == 0) {
                    n2 = bl3 ? 1 : 2;
                }
                LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk = null;
                if (n2 == 2) {
                    Object object2 = object = iHTTPStreamerSession == null ? null : ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).getIndex(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (object == null) break block28;
                    liveStreamPacketizerCupertinoChunk = object.getChunk(string8);
                    ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).logVODChunk(liveStreamPacketizerCupertinoChunk);
                } else {
                    object = iApplicationInstance.getStreams();
                    iLiveStreamPacketizer = object.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false);
                    if (iLiveStreamPacketizer == null && bl4) {
                        this.startLiveStreamRepeat(iApplicationInstance, hTTPStreamerStreamNameParts.repeaterName);
                        iLiveStreamPacketizer = object.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false);
                    }
                    if (iLiveStreamPacketizer == null) {
                        WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                        break block28;
                    }
                    if (!(iLiveStreamPacketizer instanceof LiveStreamPacketizerCupertino)) {
                        WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: LiveStreamPacketizer wrong type [" + string + "]: " + this.liveStreamPacketizer);
                        break block28;
                    }
                    liveStreamPacketizerCupertinoChunk = ((LiveStreamPacketizerCupertino)iLiveStreamPacketizer).getChunkByFilename(string8);
                    ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).logLiveChunk(liveStreamPacketizerCupertinoChunk);
                }
                if (liveStreamPacketizerCupertinoChunk != null) {
                    if (!iHTTPStreamerSession.checkAndSetPlayLogged()) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iHTTPStreamerSession.getStream(), "stream", "play", 200, iHTTPStreamerSession.getStreamName());
                    }
                    iHTTPResponse.setHeader("Content-Type", this.videoMimeType);
                    iHTTPResponse.setHeader("Cache-Control", liveStreamPacketizerCupertinoChunk.isCacheable() ? "public" : "no-cache");
                    iHTTPResponse.setHeader("Date", this.getHTTPDate());
                    object = iHTTPResponse.getOutputStream();
                    iLiveStreamPacketizer = null;
                    if (object instanceof IFasterByteArrayWriteReference) {
                        iLiveStreamPacketizer = (IFasterByteArrayWriteReference)object;
                    }
                    List<LiveStreamingCupertinoBlock> list = liveStreamPacketizerCupertinoChunk.getBlockList();
                    for (LiveStreamingCupertinoBlock liveStreamingCupertinoBlock : list) {
                        if (iLiveStreamPacketizer != null) {
                            iLiveStreamPacketizer.write(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen(), true);
                        } else {
                            ((OutputStream)object).write(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen());
                        }
                        n += liveStreamingCupertinoBlock.getLen();
                    }
                    if (iHTTPStreamerSession != null) {
                        LiveStreamingCupertinoBlock liveStreamingCupertinoBlock;
                        liveStreamingCupertinoBlock = iHTTPStreamerSession.getStream();
                        if (liveStreamingCupertinoBlock != null) {
                            liveStreamingCupertinoBlock.getMediaIOPerformance().incrementMessagesOut((long)n, 1L);
                        }
                        iHTTPStreamerSession.getIOPerformanceCounter().incrementMessagesOut((long)n, 1L);
                    }
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).error("HTTPStreamerAdapterCupertinoStreaming.onMediaFile: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (bl2) return;
        if (bl) {
            rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            return;
        }
        iHTTPResponse.setResponseCode(404);
    }
}

