/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.liverepeater;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoRepeaterHolder;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterStreamId;
import com.wowza.wms.mediacaster.wowza.LiveMediaStreamURL;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.live.NullLiveReceiver;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;

public class CupertinoStreamerLiveRepeaterReceiver
extends NullLiveReceiver {
    private IMediaStream parent = null;
    private byte[] packet = null;
    private String localStreamName = null;
    private String localPacketizerName = null;
    private IApplicationInstance appInstance = null;
    private int tsCount = 0;
    private boolean initPacketizer = true;

    public void init(IMediaStream iMediaStream) {
        super.init(iMediaStream);
        this.parent = iMediaStream;
        this.appInstance = iMediaStream.getStreams().getAppInstance();
        this.localStreamName = this.parent.getName();
        System.out.println("this.localStreamName: " + this.localStreamName);
        MediaCasterStreamId mediaCasterStreamId = MediaCasterItem.parseIdString((String)this.localStreamName);
        String string = mediaCasterStreamId.getName();
        if (string.indexOf("://") >= 0) {
            String string2 = LiveMediaStreamURL.decodeURLToStreamName((String)string);
            if (string2 != null) {
                this.localStreamName = string2;
            }
        } else {
            this.localStreamName = string;
        }
        this.localPacketizerName = this.parent.getLiveStreamPacketizer();
    }

    public void close() {
        super.close();
        MediaStreamMap mediaStreamMap = this.parent.getStreams();
        mediaStreamMap.removeLiveStreamPacketizer(this.localStreamName, this.localPacketizerName);
    }

    public String getContextStr() {
        String string = this.appInstance.getApplication().getName() + "/" + this.appInstance.getName() + "/" + this.localStreamName;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLiveStreamPacketizer() {
        Object object;
        MediaStreamMap mediaStreamMap = this.parent.getStreams();
        WMSLoggerFactory.getLogger(CupertinoStreamerLiveRepeaterReceiver.class).info("CupertinoStreamerLiveRepeaterReceiver.initLiveStreamPacketizer: " + this.getContextStr());
        Object object2 = object = mediaStreamMap.getLiveStreamPacketizerLock();
        synchronized (object2) {
            mediaStreamMap.removeLiveStreamPacketizer(this.localStreamName, this.localPacketizerName);
            ILiveStreamPacketizer iLiveStreamPacketizer = mediaStreamMap.getLiveStreamPacketizer(this.localStreamName, this.localPacketizerName, true);
            iLiveStreamPacketizer.setRepeaterEdge(true);
        }
    }

    public int getAudioMissing(int n) {
        return n - this.audioLevel;
    }

    public int getDataMissing(int n) {
        return n - this.dataLevel;
    }

    public int getVideoMissing(int n) {
        return n - this.videoLevel;
    }

    public void addAudioData(byte[] byArray, int n, int n2, int n3, long l) {
        this.audioLevel += n2;
        if (this.audioLevel >= n3) {
            this.audioLevel = 0;
        }
    }

    public void addDataData(byte[] byArray, int n, int n2, int n3, long l) {
        this.dataLevel += n2;
        if (this.dataLevel >= n3) {
            this.dataLevel = 0;
        }
    }

    private void initVideoObj(int n) {
        if (this.packet == null) {
            this.packet = new byte[n];
            this.videoLevel = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVideoData(byte[] byArray, int n, int n2, int n3, long l) {
        if (this.initPacketizer) {
            this.initLiveStreamPacketizer();
            this.initPacketizer = false;
        }
        this.initVideoObj(n3);
        try {
            System.arraycopy(byArray, n, this.packet, this.videoLevel, n2);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoStreamerLiveRepeaterReceiver.class).error("CupertinoStreamerLiveRepeaterReceiver.addVideoData[1]: " + exception.toString());
        }
        this.videoLevel += n2;
        try {
            MediaStreamMap mediaStreamMap;
            ILiveStreamPacketizer iLiveStreamPacketizer;
            if (this.videoLevel >= n3 && this.packet != null && (iLiveStreamPacketizer = (mediaStreamMap = this.parent.getStreams()).getLiveStreamPacketizer(this.localStreamName, this.localPacketizerName, true)) != null && iLiveStreamPacketizer instanceof LiveStreamPacketizerCupertino) {
                LiveStreamPacketizerCupertino liveStreamPacketizerCupertino = (LiveStreamPacketizerCupertino)iLiveStreamPacketizer;
                long l2 = System.currentTimeMillis();
                liveStreamPacketizerCupertino.touch(l2);
                CupertinoRepeaterHolder cupertinoRepeaterHolder = CupertinoRepeaterHolder.deserialize(this.packet, 0, this.packet.length);
                if (cupertinoRepeaterHolder != null) {
                    switch (cupertinoRepeaterHolder.getRepeaterType()) {
                        case 1: {
                            liveStreamPacketizerCupertino.startChunkTS(cupertinoRepeaterHolder.getChunkId(), true, cupertinoRepeaterHolder.getStreamMode(), cupertinoRepeaterHolder.getVideoCodec(), cupertinoRepeaterHolder.getAudioCodec(), cupertinoRepeaterHolder.getTimecode(), cupertinoRepeaterHolder.getEncUrl(), cupertinoRepeaterHolder.getEncRepeaterBytes());
                            break;
                        }
                        case 2: {
                            this.tsCount = 0;
                            liveStreamPacketizerCupertino.endChunkTS(cupertinoRepeaterHolder.getTimecode());
                            break;
                        }
                        case 3: {
                            ++this.tsCount;
                            liveStreamPacketizerCupertino.addToChunkTS(cupertinoRepeaterHolder.getHolder());
                            break;
                        }
                        case 100: {
                            Object object;
                            String string = cupertinoRepeaterHolder.getRepeaterMessage();
                            if (!string.equals("switchStream")) break;
                            Object object2 = object = mediaStreamMap.getLiveStreamPacketizerLock();
                            synchronized (object2) {
                                mediaStreamMap.removeLiveStreamPacketizer(this.localStreamName, this.localPacketizerName);
                                iLiveStreamPacketizer = mediaStreamMap.getLiveStreamPacketizer(this.localStreamName, this.localPacketizerName, true);
                                iLiveStreamPacketizer.setRepeaterEdge(true);
                                liveStreamPacketizerCupertino = (LiveStreamPacketizerCupertino)iLiveStreamPacketizer;
                                break;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CupertinoStreamerLiveRepeaterReceiver.class).error("CupertinoStreamerLiveRepeaterReceiver.addVideoData[2]: " + exception.toString());
        }
        if (this.videoLevel >= n3) {
            this.videoLevel = 0;
            this.packet = null;
        }
    }
}

