/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoPacketHolder;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.ICupertinoChunkWriter;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.LiveStreamPacketizerSmoothStreaming;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaReaderFactory;
import com.wowza.wms.stream.MediaReaderList;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import java.util.ArrayList;
import java.util.List;

public class CupertinoPacketHandler {
    private long streamTimecodeAdjust = -1L;
    private long streamLastAdjustTimecode = 0L;
    private boolean waitForKeyFrame = true;
    private long lastAudioTimecode = -1L;
    private long lastVideoTimecode = -1L;
    private boolean reportVideoCodecInfo = true;
    private boolean reportAudioCodecInfo = true;
    private AACFrame aacFrame = null;
    private int lastAACSampleRate = -1;
    private long lastAACTimecode = -1L;
    private CupertinoPacketHolder audioGroupPacket = null;
    private int videoCodec = -1;
    private int audioCodec = -1;
    private boolean codecIsLocked = false;
    private long codecLockStartTimecode = -1L;
    private int streamMode = 1;
    private List<CupertinoPacketHolder> savedHolders = new ArrayList<CupertinoPacketHolder>();
    private int audioGroupCount = 3;
    private int waitForCodecTime = 9000;
    private int chunkDurationTarget = 10000;
    private int chunkDurationTolerance = 500;
    private int maxSaveHolderSize = 500;
    private boolean debugAACTimecodes = false;
    private long chunkLastAudioTimecode = -1L;
    private long chunkHitEndKeyTimecode = -1L;
    private boolean chunkHitEndKey = false;
    private long chunkStartTimecode = -1L;
    private boolean isChunkOpen = false;
    private boolean sendEndChunk = false;
    private ICupertinoChunkWriter chunkWriter = null;
    private AMFPacket saveVideoCodecConfig = null;
    private boolean isFirstFrame = true;
    private String contextStr = null;
    private long audioSampleCount = -1L;
    private long audioSampleTimecode = -1L;
    private long audioSampleLast = -1L;

    private IMediaReader getMediaReader(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2) {
        String string3 = string.toLowerCase();
        IMediaReader iMediaReader = MediaReaderFactory.getInstance((IApplicationInstance)iApplicationInstance, (MediaReaderList)iApplicationInstance.getVHost().getMediaReaders(), (String)string3);
        if (iMediaReader != null) {
            String string4 = iApplicationInstance.getStreamStoragePath();
            iMediaReader.init(iApplicationInstance, iMediaStream, string, string4, string2);
            iMediaReader.open(string4, string2);
        }
        return iMediaReader;
    }

    private void doPreroll(IMediaStream iMediaStream) {
        try {
            IMediaReader iMediaReader = null;
            PlaylistCursor playlistCursor = null;
            IApplicationInstance iApplicationInstance = iMediaStream.getStreams().getAppInstance();
            String string = "mp4";
            String string2 = "preroll.mov";
            iMediaReader = this.getMediaReader(iApplicationInstance, iMediaStream, string, string2);
            playlistCursor = new PlaylistCursor();
            long[] lArray = new long[8];
            PlaylistWriteControl playlistWriteControl = playlistCursor.getWriteControl();
            PlaylistReaderWriteResults playlistReaderWriteResults = playlistCursor.getWriteResults();
            playlistWriteControl.setMaxTC(10000L);
            iMediaReader.seek(0L, 3);
            ArrayList arrayList = new ArrayList();
            iMediaReader.writePackets(arrayList, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, null);
            long l = 0L;
            int n = 5;
            for (int i = 0; i < n; ++i) {
                long l2 = 0L;
                System.out.println("****START: " + i);
                int n2 = arrayList.size();
                for (int j = 0; j < n2; ++j) {
                    AMFPacket aMFPacket = (AMFPacket)arrayList.get(j);
                    l2 = aMFPacket.getAbsTimecode();
                    long l3 = l2 + l;
                    aMFPacket.setAbsTimecode(l3);
                    switch (aMFPacket.getType()) {
                        case 8: {
                            break;
                        }
                        case 9: {
                            this.handlePacket(iMediaStream, aMFPacket, false);
                            break;
                        }
                    }
                    aMFPacket.setAbsTimecode(l2);
                }
                l += l2;
            }
            iMediaReader.close();
            this.streamTimecodeAdjust = -1L;
            this.waitForKeyFrame = true;
            this.reportVideoCodecInfo = true;
            this.reportAudioCodecInfo = true;
            System.out.println("****DONE: ");
        }
        catch (Exception exception) {
            System.out.println("doPreroll: " + exception.toString());
        }
    }

    public void startStream(IMediaStream iMediaStream) {
        this.doStreamReset();
        WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).info("CupertinoPacketHandler.startStream[" + this.getContextStr(iMediaStream) + "]");
    }

    public void resetStream(IMediaStream iMediaStream) {
        this.doStreamReset();
        WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).info("CupertinoPacketHandler.resetStream[" + this.getContextStr(iMediaStream) + "]");
    }

    private void doStreamReset() {
        this.streamTimecodeAdjust = -1L;
        this.waitForKeyFrame = true;
    }

    private String getContextStr(IMediaStream iMediaStream) {
        String string = iMediaStream.getStreams().getAppInstance().getApplication().getName() + "/" + iMediaStream.getStreams().getAppInstance().getName() + "/" + iMediaStream.getName();
        return string;
    }

    public void handlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        this.contextStr = this.getContextStr(iMediaStream);
        this.handlePacket(iMediaStream, aMFPacket, false);
    }

    public void handlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket, boolean bl) {
        block46: {
            try {
                Object object;
                int n;
                long l = aMFPacket.getAbsTimecode();
                int n2 = aMFPacket.getType();
                int n3 = aMFPacket.getSize();
                if (n3 <= 0) break block46;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = true;
                boolean bl5 = false;
                if (!this.codecIsLocked) {
                    if (this.videoCodec == -1 && (n = iMediaStream.getPublishVideoCodecId()) != -1) {
                        this.videoCodec = n;
                        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.handlePacket: Video codec: " + FLVUtils.videoCodecToString((int)n));
                    }
                    if (this.audioCodec == -1 && (n = iMediaStream.getPublishAudioCodecId()) != -1) {
                        this.audioCodec = n;
                        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.handlePacket: Audio codec: " + FLVUtils.audioCodecToString((int)n));
                    }
                }
                n = -1;
                int n4 = -1;
                if (n2 == 9) {
                    bl3 = FLVUtils.isVideoCodecConfig((AMFPacket)aMFPacket);
                    bl2 = FLVUtils.isVideoKeyFrame((AMFPacket)aMFPacket);
                    n = FLVUtils.getVideoCodec((int)aMFPacket.getFirstByte());
                    if (bl3 && this.reportVideoCodecInfo) {
                        if (n == 7) {
                            try {
                                object = H264Utils.decodeAVCC((byte[])aMFPacket.getData(), (int)5);
                                if (object != null) {
                                    if (((H264CodecConfigInfo)object).profileIDC != 66 || ((H264CodecConfigInfo)object).levelIDC > 30) {
                                        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn("LiveStreamPacketizerCupertino.handlePacket: Video encoding settings are beyond iPhone/iPod touch recommendations (Baseline/3.0) [" + this.getContextStr(iMediaStream) + "]: " + object.toString());
                                    } else {
                                        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.handlePacket: Video info[" + this.getContextStr(iMediaStream) + "]: " + object.toString());
                                    }
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        this.reportVideoCodecInfo = false;
                    }
                    if (this.waitForKeyFrame) {
                        if (bl2) {
                            this.waitForKeyFrame = false;
                            bl5 = true;
                        } else {
                            bl4 = false;
                            if (bl3) {
                                this.saveVideoCodecConfig = aMFPacket;
                            }
                        }
                    }
                } else if (n2 == 8) {
                    bl3 = FLVUtils.isAudioCodecConfig((AMFPacket)aMFPacket);
                    n4 = FLVUtils.getAudioCodec((int)aMFPacket.getFirstByte());
                    if (bl3) {
                        if (n4 == 10) {
                            this.aacFrame = AACUtils.decodeAACCodecConfig((byte[])aMFPacket.getData(), (int)2);
                        }
                        if (this.reportAudioCodecInfo) {
                            if (n4 == 10) {
                                if (this.aacFrame.getChannels() > 2 || this.aacFrame.getSampleRate() > 48000) {
                                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn("LiveStreamPacketizerCupertino.handlePacket: Audio encoding settings are beyond iPhone/iPod touch recommendations (48KHz/stereo) [" + this.getContextStr(iMediaStream) + "]: " + this.aacFrame.toString());
                                } else {
                                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.handlePacket: Audio info[" + this.getContextStr(iMediaStream) + "]: " + this.aacFrame.toString());
                                }
                            }
                            this.reportAudioCodecInfo = false;
                        }
                    }
                } else {
                    bl4 = false;
                }
                if (bl4) {
                    if (this.streamTimecodeAdjust == -1L) {
                        this.streamTimecodeAdjust = this.streamLastAdjustTimecode - l;
                        l = this.streamLastAdjustTimecode;
                    } else {
                        l += this.streamTimecodeAdjust;
                    }
                    if (l >= 0L || bl3) {
                        this.streamLastAdjustTimecode = l;
                        if (n2 == 9) {
                            if (this.lastVideoTimecode < 0L || l >= this.lastVideoTimecode) {
                                this.lastVideoTimecode = l;
                                if (bl4) {
                                    if (this.saveVideoCodecConfig != null) {
                                        object = new CupertinoPacketHolder(this.saveVideoCodecConfig, 9, n, true, l, l * 90L);
                                        this.saveVideoCodecConfig = null;
                                        this.handleHolder((CupertinoPacketHolder)object);
                                    }
                                    object = new CupertinoPacketHolder(aMFPacket, 9, n, bl3, l, l * 90L);
                                    ((CupertinoPacketHolder)object).setKey(bl2);
                                    this.handleHolder((CupertinoPacketHolder)object);
                                }
                            }
                        } else if (n2 == 8 && (this.lastAudioTimecode < 0L || l >= this.lastAudioTimecode)) {
                            this.lastAudioTimecode = l;
                            long l2 = l * 90L;
                            if (!bl3 && n4 == 10 && this.aacFrame != null) {
                                if (this.lastAACSampleRate == -1 || this.lastAACSampleRate != this.aacFrame.getSampleRate()) {
                                    this.lastAACSampleRate = this.aacFrame.getSampleRate();
                                    this.lastAACTimecode = Math.round((double)(l * (long)this.lastAACSampleRate) / 1000.0);
                                } else {
                                    long l3 = this.lastAACTimecode + (long)this.aacFrame.getSampleCount();
                                    long l4 = Math.round((double)l3 * 1000.0 / (double)this.lastAACSampleRate);
                                    int n5 = (int)Math.abs(l4 - l);
                                    if (this.debugAACTimecodes) {
                                        System.out.println("tc[" + n5 + "]: " + l4 + ":" + l + ":" + this.lastAACSampleRate);
                                    }
                                    if (n5 <= 1) {
                                        l2 = Math.round((double)(l3 * 90000L) / (double)this.lastAACSampleRate);
                                        this.lastAACTimecode = l3;
                                    } else {
                                        this.lastAACTimecode = Math.round((double)(l * (long)this.lastAACSampleRate) / 1000.0);
                                        if (this.debugAACTimecodes) {
                                            System.out.println("reset: " + this.lastAACTimecode);
                                        }
                                    }
                                }
                            }
                            if (bl4) {
                                CupertinoPacketHolder cupertinoPacketHolder = new CupertinoPacketHolder(aMFPacket, 8, n4, bl3, l, l2);
                                if (this.audioGroupPacket == null) {
                                    this.audioGroupPacket = new CupertinoPacketHolder(null, 8, n4, false, l, l2);
                                }
                                this.audioGroupPacket.addHolder(cupertinoPacketHolder);
                                if (this.audioGroupPacket.getPacketCount() >= this.audioGroupCount) {
                                    this.handleHolder(this.audioGroupPacket);
                                    this.audioGroupPacket = null;
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("LiveStreamPacketizerCupertino.handlePacket: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public void handleHolder(CupertinoPacketHolder cupertinoPacketHolder) {
        try {
            int n = this.savedHolders.size();
            HandlerHolderResult handlerHolderResult = this.handleHolderInternal(cupertinoPacketHolder, false, n);
            if (handlerHolderResult.saveHolder) {
                this.savedHolders.add(cupertinoPacketHolder);
            }
            if (handlerHolderResult.flushSavedHolders) {
                ArrayList<CupertinoPacketHolder> arrayList = new ArrayList<CupertinoPacketHolder>();
                for (CupertinoPacketHolder cupertinoPacketHolder2 : this.savedHolders) {
                    HandlerHolderResult handlerHolderResult2 = this.handleHolderInternal(cupertinoPacketHolder2, true, 0);
                    if (!handlerHolderResult2.saveHolder) continue;
                    arrayList.add(cupertinoPacketHolder);
                }
                this.savedHolders.clear();
                this.savedHolders = arrayList;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("LiveStreamPacketizerCupertino.handleHolder: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public HandlerHolderResult handleHolderInternal(CupertinoPacketHolder cupertinoPacketHolder, boolean bl, int n) {
        HandlerHolderResult handlerHolderResult;
        block33: {
            boolean bl2;
            int n2;
            int n3;
            long l;
            long l2;
            block32: {
                handlerHolderResult = new HandlerHolderResult();
                l2 = cupertinoPacketHolder.getTimecode();
                l = l2 + (long)cupertinoPacketHolder.getDuration();
                n3 = cupertinoPacketHolder.getType();
                n2 = cupertinoPacketHolder.getCodec();
                if (this.codecIsLocked) break block32;
                bl2 = false;
                if (this.codecLockStartTimecode == -1L) {
                    this.codecLockStartTimecode = l2;
                }
                if (this.videoCodec != -1 && this.audioCodec != -1) {
                    this.codecIsLocked = true;
                    handlerHolderResult.saveHolder = true;
                    handlerHolderResult.flushSavedHolders = true;
                    bl2 = true;
                } else if (this.videoCodec == -1 && this.audioCodec == 2) {
                    this.codecIsLocked = true;
                    handlerHolderResult.saveHolder = true;
                    handlerHolderResult.flushSavedHolders = true;
                    bl2 = true;
                } else if (n > this.maxSaveHolderSize || l2 - this.codecLockStartTimecode > (long)this.waitForCodecTime) {
                    this.codecIsLocked = true;
                    handlerHolderResult.saveHolder = true;
                    handlerHolderResult.flushSavedHolders = true;
                    bl2 = true;
                } else {
                    handlerHolderResult.saveHolder = true;
                    bl2 = true;
                }
                if (!bl2) break block32;
                if (!this.codecIsLocked) break block33;
                if (this.videoCodec != -1 && this.videoCodec != 7) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn("LiveStreamPacketizerCupertino.handleHolder: Invalid video codec for iPhone/iPod: " + this.videoCodec);
                }
                if (this.videoCodec == 7 && this.audioCodec != -1 && this.audioCodec != 10) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn("LiveStreamPacketizerCupertino.handleHolder: Invalid video/audio codec combination for iPhone/iPod: video:" + this.videoCodec + " audio:" + this.audioCodec);
                }
                if (this.audioCodec != -1 && this.audioCodec != 10 && this.audioCodec != 2) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn("LiveStreamPacketizerCupertino.handleHolder: Invalid audio codec for iPhone/iPod: " + this.audioCodec);
                }
                if (this.audioCodec == 2 && this.videoCodec == -1) {
                    this.streamMode = 2;
                }
                break block33;
            }
            if (n3 != 8 ? n3 == 9 && (n2 != 7 || this.streamMode == 2) : n2 != 10 && n2 != 2) break block33;
            if (this.sendEndChunk) {
                this.endChunk(l2);
                this.chunkLastAudioTimecode = -1L;
                this.chunkHitEndKeyTimecode = -1L;
                this.chunkStartTimecode = -1L;
                this.chunkHitEndKey = false;
                this.sendEndChunk = false;
            }
            if (this.chunkStartTimecode == -1L) {
                this.chunkStartTimecode = l2;
            }
            bl2 = false;
            if (this.videoCodec != -1 && this.audioCodec != -1) {
                boolean bl3 = false;
                if (n3 == 9) {
                    if (this.chunkHitEndKey) {
                        handlerHolderResult.saveHolder = true;
                        bl3 = cupertinoPacketHolder.isKey();
                    } else if (cupertinoPacketHolder.isKey() && l2 - this.chunkStartTimecode > (long)(this.chunkDurationTarget - this.chunkDurationTolerance)) {
                        this.chunkHitEndKeyTimecode = l2;
                        this.chunkHitEndKey = true;
                        handlerHolderResult.saveHolder = true;
                    }
                } else if (n3 == 8) {
                    this.chunkLastAudioTimecode = l;
                }
                if (this.chunkHitEndKey && (n > this.maxSaveHolderSize || bl3 || this.chunkLastAudioTimecode >= this.chunkHitEndKeyTimecode)) {
                    bl2 = true;
                    if (n3 == 8) {
                        handlerHolderResult.saveHolder = true;
                    }
                }
            } else if (this.videoCodec != -1) {
                if (cupertinoPacketHolder.isKey() && (n > this.maxSaveHolderSize || l2 - this.chunkStartTimecode > (long)(this.chunkDurationTarget - this.chunkDurationTolerance))) {
                    this.chunkHitEndKeyTimecode = l2;
                    this.chunkHitEndKey = true;
                    bl2 = true;
                    handlerHolderResult.saveHolder = true;
                }
            } else if (n > this.maxSaveHolderSize || l - this.chunkStartTimecode >= (long)this.chunkDurationTarget) {
                bl2 = true;
            }
            if (!handlerHolderResult.saveHolder) {
                if (!this.isChunkOpen) {
                    this.startChunk(this.chunkStartTimecode);
                    this.isChunkOpen = true;
                }
                this.addToChunk(cupertinoPacketHolder);
            }
            if (bl2) {
                if (!this.isChunkOpen) {
                    System.out.println("*********** Why is chunk not open");
                }
                if (this.isChunkOpen) {
                    this.sendEndChunk = true;
                    this.isChunkOpen = false;
                }
                handlerHolderResult.flushSavedHolders = true;
            }
        }
        return handlerHolderResult;
    }

    private void startChunk(long l) {
        if (this.chunkWriter != null) {
            this.chunkWriter.startChunk(this.streamMode, this.videoCodec, this.audioCodec, l);
        }
    }

    private void endChunk(long l) {
        if (this.chunkWriter != null) {
            this.chunkWriter.endChunk(l);
        }
    }

    private void addToChunk(CupertinoPacketHolder cupertinoPacketHolder) {
        if (this.chunkWriter != null) {
            this.chunkWriter.addToChunk(cupertinoPacketHolder);
        }
    }

    public int getAudioGroupCount() {
        return this.audioGroupCount;
    }

    public void setAudioGroupCount(int n) {
        this.audioGroupCount = n;
    }

    public int getWaitForCodecTime() {
        return this.waitForCodecTime;
    }

    public void setWaitForCodecTime(int n) {
        this.waitForCodecTime = n;
    }

    public int getChunkDurationTarget() {
        return this.chunkDurationTarget;
    }

    public void setChunkDurationTarget(int n) {
        this.chunkDurationTarget = n;
    }

    public int getChunkDurationTolerance() {
        return this.chunkDurationTolerance;
    }

    public void setChunkDurationTolerance(int n) {
        this.chunkDurationTolerance = n;
    }

    public void setChunkWriter(ICupertinoChunkWriter iCupertinoChunkWriter) {
        this.chunkWriter = iCupertinoChunkWriter;
    }

    public boolean isDebugAACTimecodes() {
        return this.debugAACTimecodes;
    }

    public void setDebugAACTimecodes(boolean bl) {
        this.debugAACTimecodes = bl;
    }

    public int getMaxSaveHolderSize() {
        return this.maxSaveHolderSize;
    }

    public void setMaxSaveHolderSize(int n) {
        this.maxSaveHolderSize = n;
    }

    class HandlerHolderResult {
        boolean saveHolder = false;
        boolean flushSavedHolders = false;

        HandlerHolderResult() {
        }
    }
}

