/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer;

import com.wowza.wms.amf.AMFPacket;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CupertinoPacketHolder {
    private AMFPacket packet = null;
    private List<CupertinoPacketHolder> holders = null;
    private long timecode90 = 0L;
    private long timecode = 0L;
    private int duration = 0;
    private int codec = 0;
    private int type = 0;
    private boolean isCodecConfig = false;
    private boolean isKey = false;
    private int packetCount = 0;
    private boolean forceFlush = false;
    private int dataLen = 0;

    public CupertinoPacketHolder() {
    }

    public CupertinoPacketHolder(AMFPacket aMFPacket, long l) {
        this.packet = aMFPacket;
        this.timecode90 = l;
        if (aMFPacket != null) {
            this.dataLen += aMFPacket.getSize();
        }
    }

    public CupertinoPacketHolder(AMFPacket aMFPacket, int n, int n2, boolean bl, long l, long l2) {
        this.packet = aMFPacket;
        this.type = n;
        this.codec = n2;
        this.isCodecConfig = bl;
        this.timecode = l;
        this.timecode90 = l2;
        if (aMFPacket != null && !bl) {
            this.dataLen += aMFPacket.getSize();
        }
    }

    public AMFPacket getPacket() {
        return this.packet;
    }

    public void setTimecode(long l) {
        this.timecode = l;
    }

    public void setTimecode90(long l) {
        this.timecode90 = l;
    }

    public long getTimecode() {
        return this.timecode;
    }

    public long getTimecode90() {
        return this.timecode90;
    }

    public void addHolder(CupertinoPacketHolder cupertinoPacketHolder) {
        if (this.holders == null) {
            this.holders = new ArrayList<CupertinoPacketHolder>();
        }
        this.holders.add(cupertinoPacketHolder);
        if (!cupertinoPacketHolder.isCodecConfig()) {
            ++this.packetCount;
            this.dataLen += cupertinoPacketHolder.getPacket().getSize();
        }
        if (this.holders.size() == 1) {
            this.packet = cupertinoPacketHolder.packet;
            this.timecode = cupertinoPacketHolder.timecode;
            this.timecode90 = cupertinoPacketHolder.timecode90;
        } else if (this.holders.size() > 1) {
            this.duration = (int)(cupertinoPacketHolder.timecode - this.timecode);
        }
    }

    public boolean isGroup() {
        return this.holders != null;
    }

    public int getDuration() {
        return this.duration;
    }

    public List<CupertinoPacketHolder> getHolders() {
        return this.holders;
    }

    public int getPacketCount() {
        return this.packetCount;
    }

    public int getCodec() {
        return this.codec;
    }

    public void setCodec(int n) {
        this.codec = n;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public boolean isCodecConfig() {
        return this.isCodecConfig;
    }

    public void setCodecConfig(boolean bl) {
        this.isCodecConfig = bl;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setKey(boolean bl) {
        this.isKey = bl;
    }

    public boolean isForceFlush() {
        return this.forceFlush;
    }

    public void setForceFlush(boolean bl) {
        this.forceFlush = bl;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    public void setDataLen(int n) {
        this.dataLen = n;
    }
}

