/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.record;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaWriter;
import com.wowza.wms.stream.MediaWriterFactory;
import com.wowza.wms.stream.MediaWriterList;
import com.wowza.wms.stream.live.LiveReceiver;
import com.wowza.wms.stream.record.MediaStreamRecord;
import com.wowza.wms.stream.record.MediaStreamRecordWriter;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RecordReceiver {
    public static final int RECORD_CHUNKTIME = 5000;
    IMediaStream stream = null;
    private ByteBuffer audioData = null;
    private ByteBuffer videoData = null;
    private ByteBuffer dataData = null;
    private List audioPackets = new ArrayList();
    private List videoPackets = new ArrayList();
    private List dataPackets = new ArrayList();
    private List audioTCs = new ArrayList();
    private List videoTCs = new ArrayList();
    private List dataTCs = new ArrayList();
    private List dataTypes = new ArrayList();
    private long audioCurrTC = -1L;
    private long videoCurrTC = -1L;
    private long dataCurrTC = -1L;
    private long commitAudioTC = -1L;
    private long commitAudioFirstTC = -1L;
    private long commitVideoTC = -1L;
    private long commitDataTC = -1L;
    private long commitVideoFirstTC = -1L;
    private long commitDataFirstTC = -1L;
    private int commitAudioCount = 0;
    private int commitVideoCount = 0;
    private int commitDataCount = 0;
    private long commitWatermark = -1L;
    private long commitBase = -1L;
    private boolean commitIsFirstCommit = true;
    private boolean commitAdjustedAudio = false;
    private boolean commitAdjustedVideo = false;
    private boolean commitAdjustedData = false;
    private long commitAdjustedBase = 0L;
    private long duration = 0L;
    private ThreadPoolExecutor runner = null;
    private MediaStreamRecordWriter recordWriter = null;
    private IMediaWriter mediaWriter = null;
    private boolean isReceivePackets = true;
    private boolean isFileOpen = false;
    private boolean versionFile = false;
    private boolean waitForVideoKeyFrame = false;
    private Object codecLock = new Object();
    private int videoCodecId = -1;
    private int audioCodecId = -1;

    public RecordReceiver(IMediaStream iMediaStream) {
        this.stream = iMediaStream;
    }

    private ThreadPoolExecutor getRunner() {
        if (this.runner == null) {
            this.runner = new ThreadPoolExecutor(1, 1, 3000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
        return this.runner;
    }

    private void killRunner() {
        if (this.runner != null) {
            try {
                this.runner.shutdown();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaStreamRecord.class).error("killRunner: " + exception.toString());
            }
        }
        this.runner = null;
    }

    private IMediaWriter getMediaWriter(IMediaStream iMediaStream) {
        String string = iMediaStream.getExt().toLowerCase();
        IMediaWriter iMediaWriter = MediaWriterFactory.getInstance((MediaWriterList)iMediaStream.getStreams().getVHost().getMediaWriters(), (String)string, (IMediaStream)iMediaStream);
        iMediaWriter.setVersionFile(this.versionFile);
        iMediaWriter.setWaitForVideoKeyFrame(this.waitForVideoKeyFrame);
        return iMediaWriter;
    }

    public void init() {
        this.isReceivePackets = true;
    }

    public void startPublishing() {
        if (!this.isReceivePackets) {
            this.resetRecord();
        }
        this.isReceivePackets = true;
        this.isFileOpen = true;
    }

    public void stopPublishing() {
    }

    public void resetRecord() {
        this.audioPackets = new ArrayList();
        this.videoPackets = new ArrayList();
        this.dataPackets = new ArrayList();
        this.audioTCs = new ArrayList();
        this.videoTCs = new ArrayList();
        this.dataTCs = new ArrayList();
        this.dataTypes = new ArrayList();
        this.audioCurrTC = -1L;
        this.videoCurrTC = -1L;
        this.dataCurrTC = -1L;
        this.commitAudioTC = -1L;
        this.commitAudioFirstTC = -1L;
        this.commitVideoTC = -1L;
        this.commitDataTC = -1L;
        this.commitVideoFirstTC = -1L;
        this.commitDataFirstTC = -1L;
        this.commitAudioCount = 0;
        this.commitVideoCount = 0;
        this.commitDataCount = 0;
        this.commitWatermark = -1L;
        this.commitBase = -1L;
        this.commitIsFirstCommit = true;
        this.commitAdjustedAudio = false;
        this.commitAdjustedVideo = false;
        this.commitAdjustedData = false;
        this.commitAdjustedBase = 0L;
        this.mediaWriter = null;
        this.recordWriter = null;
    }

    private void initRecordWriter() {
        if (this.mediaWriter != null) {
            return;
        }
        try {
            this.mediaWriter = this.getMediaWriter(this.stream);
            this.recordWriter = new MediaStreamRecordWriter(this.stream, this.mediaWriter);
            this.duration = 0L;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamRecord.class).error("initRecordWriter: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void startVideoPacket() {
        if (this.videoData != null) {
            WMSLoggerFactory.getLogger(null).warn("RecordReceiver.startVideoPacket: Video packet sync issue.");
            this.videoData = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVideoData(byte[] byArray, int n, int n2, int n3, long l) {
        block7: {
            this.initRecordWriter();
            try {
                if (this.videoData == null) {
                    this.videoData = ByteBuffer.allocate(n3);
                }
                this.videoData.put(byArray, n, n2);
                if (this.videoData.position() != n3) break block7;
                if (n3 > 0) {
                    int n4 = this.videoData.get(0) & 0xF;
                    Object object = this.codecLock;
                    synchronized (object) {
                        this.videoCodecId = n4;
                    }
                }
                this.writeVideoChunk(l);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaStreamRecord.class).error("addVideoData: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public void startDataPacket() {
        if (this.dataData != null) {
            WMSLoggerFactory.getLogger(null).warn("RecordReceiver.startDataPacket: Data packet sync issue.");
            this.dataData = null;
        }
    }

    public void addDataData(byte[] byArray, int n, int n2, int n3, long l) {
        block16: {
            this.initRecordWriter();
            try {
                if (this.dataData == null) {
                    this.dataData = ByteBuffer.allocate(n3);
                }
                this.dataData.put(byArray, n, n2);
                if (this.dataData.position() != n3) break block16;
                boolean bl = true;
                try {
                    this.dataData.flip();
                    byte[] byArray2 = this.dataData.array();
                    if (byArray2 != null && byArray2.length > 0) {
                        AMFDataList aMFDataList;
                        int n4 = 0;
                        if (byArray2[0] == 0) {
                            ++n4;
                        }
                        if ((aMFDataList = new AMFDataList(byArray2, n4, byArray2.length - n4)).size() >= 3 && aMFDataList.get(0).getType() == 2 && aMFDataList.get(1).getType() == 2) {
                            String string = aMFDataList.getString(0);
                            String string2 = aMFDataList.getString(1);
                            if (string.equals("@setDataFrame") && string2.equals("onMetaData")) {
                                bl = false;
                                if (aMFDataList.get(2).getType() == 3) {
                                    AMFDataObj aMFDataObj = (AMFDataObj)aMFDataList.get(2);
                                    List list = aMFDataObj.getKeys();
                                    for (String string3 : list) {
                                        AMFData aMFData = aMFDataObj.get(string3);
                                        if (this.mediaWriter == null) continue;
                                        this.mediaWriter.putMetaData(string3, aMFData);
                                    }
                                } else if (aMFDataList.get(2).getType() == 8) {
                                    AMFDataMixedArray aMFDataMixedArray = (AMFDataMixedArray)aMFDataList.get(2);
                                    List list = aMFDataMixedArray.getKeys();
                                    for (String string4 : list) {
                                        AMFData aMFData = aMFDataMixedArray.get(string4);
                                        if (this.mediaWriter == null) continue;
                                        this.mediaWriter.putMetaData(string4, aMFData);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(LiveReceiver.class).warn("LiveReceiver2: addDataData: parse data frame: " + exception.toString());
                }
                if (bl) {
                    this.writeDataChunk(l, this.stream.getDataType());
                } else {
                    this.dataData = null;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaStreamRecord.class).error("addDataData: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public void startAudioPacket() {
        if (this.audioData != null) {
            WMSLoggerFactory.getLogger(null).warn("RecordReceiver.startAudioPacket: Audio packet sync issue.");
            this.audioData = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAudioData(byte[] byArray, int n, int n2, int n3, long l) {
        block8: {
            this.initRecordWriter();
            try {
                if (this.audioData == null) {
                    this.audioData = ByteBuffer.allocate(n3);
                }
                if (n2 > 0) {
                    this.audioData.put(byArray, n, n2);
                }
                if (this.audioData.position() != n3) break block8;
                if (n3 > 0) {
                    int n4 = this.audioData.get(0) >> 4 & 0xF;
                    Object object = this.codecLock;
                    synchronized (object) {
                        this.audioCodecId = n4;
                    }
                }
                this.writeAudioChunk(l);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaStreamRecord.class).error("addAudioData: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    private void writeVideoChunk(long l) {
        boolean bl = this.videoCurrTC == -1L;
        long l2 = this.videoCurrTC == -1L ? 0L : l - this.videoCurrTC;
        long l3 = bl ? l : l2;
        this.videoCurrTC = l;
        if (this.isReceivePackets) {
            this.videoData.rewind();
            this.videoPackets.add(this.videoData);
            this.videoTCs.add(new Long(l3));
            this.commitChunk(-1L, l3, -1L);
        }
        this.videoData = null;
    }

    private void writeDataChunk(long l, int n) {
        boolean bl = this.dataCurrTC == -1L;
        long l2 = this.dataCurrTC == -1L ? 0L : l - this.dataCurrTC;
        long l3 = bl ? l : l2;
        this.dataCurrTC = l;
        if (this.isReceivePackets) {
            this.dataData.rewind();
            this.dataPackets.add(this.dataData);
            this.dataTCs.add(new Long(l3));
            this.dataTypes.add(new Integer(n));
            this.commitChunk(-1L, -1L, l3);
        }
        this.dataData = null;
    }

    private void writeAudioChunk(long l) {
        boolean bl = this.audioCurrTC == -1L;
        long l2 = this.audioCurrTC == -1L ? 0L : l - this.audioCurrTC;
        long l3 = bl ? l : l2;
        this.audioCurrTC = l;
        if (this.isReceivePackets) {
            this.audioData.rewind();
            this.audioPackets.add(this.audioData);
            this.audioTCs.add(new Long(l3));
            this.commitChunk(l3, -1L, -1L);
        }
        this.audioData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitChunk(long l, long l2, long l3) {
        long l4;
        this.initRecordWriter();
        int n = Math.max(5000, this.stream.getBufferTime());
        if (l >= 0L) {
            ++this.commitAudioCount;
            if (this.commitAudioFirstTC == -1L) {
                this.commitAudioFirstTC = l;
                this.commitAudioTC = l;
            } else {
                this.commitAudioTC += l;
            }
        } else if (l2 >= 0L) {
            ++this.commitVideoCount;
            if (this.commitVideoFirstTC == -1L) {
                this.commitVideoFirstTC = l2;
                this.commitVideoTC = l2;
            } else {
                this.commitVideoTC += l2;
            }
        } else if (l3 >= 0L) {
            ++this.commitDataCount;
            if (this.commitDataFirstTC == -1L) {
                this.commitDataFirstTC = l3;
                this.commitDataTC = l3;
            } else {
                this.commitDataTC += l3;
            }
        }
        if (this.commitWatermark == -1L && this.commitAudioCount > 0 && this.commitVideoCount > 0 && this.commitDataCount > 0) {
            this.commitWatermark = Math.min(Math.min(this.commitAudioFirstTC, this.commitVideoFirstTC), this.commitDataFirstTC);
        }
        if (this.commitWatermark == -1L) {
            if (this.commitAudioCount > 0) {
                l4 = this.commitAudioFirstTC;
                if (this.commitAudioTC > l4 + (long)n) {
                    this.commitWatermark = this.commitAudioFirstTC;
                }
            } else if (this.commitVideoCount > 0) {
                l4 = this.commitVideoFirstTC;
                if (this.commitVideoTC > l4 + (long)n) {
                    this.commitWatermark = this.commitVideoFirstTC;
                }
            } else if (this.commitDataCount > 0 && this.commitDataTC > (l4 = this.commitDataFirstTC) + (long)n) {
                this.commitWatermark = this.commitDataFirstTC;
            }
        }
        if (this.isFileOpen && this.commitWatermark >= 0L) {
            l4 = 0L;
            long l5 = this.commitAudioCount > 0 ? this.commitAudioTC : Long.MAX_VALUE;
            long l6 = this.commitVideoCount > 0 ? this.commitVideoTC : Long.MAX_VALUE;
            long l7 = this.commitDataCount > 0 ? this.commitDataTC : Long.MAX_VALUE;
            l4 = Math.min(l5, l6);
            if (l4 >= this.commitWatermark + (long)n) {
                long l8;
                Object e;
                Object object;
                long l9;
                int n2 = this.audioTCs.size();
                int n3 = this.videoTCs.size();
                int n4 = this.dataTCs.size();
                if (this.commitIsFirstCommit) {
                    l9 = this.commitAudioCount > 0 ? this.commitAudioFirstTC : Long.MAX_VALUE;
                    long l10 = this.commitVideoCount > 0 ? this.commitVideoFirstTC : Long.MAX_VALUE;
                    long l11 = this.commitDataCount > 0 ? this.commitDataFirstTC : Long.MAX_VALUE;
                    this.commitBase = Math.min(l9, Math.min(l10, l11));
                    this.commitAdjustedBase = FLVUtils.adjustFirstPacketTCs((List)this.audioTCs, (List)this.videoTCs, (List)this.dataTCs);
                    this.commitAdjustedAudio = n2 > 0;
                    this.commitAdjustedVideo = n3 > 0;
                    boolean bl = this.commitAdjustedData = n4 > 0;
                }
                if (!this.commitAdjustedAudio && n2 > 0) {
                    l9 = (Long)this.audioTCs.get(0);
                    this.audioTCs.set(0, new Long(l9 - this.commitAdjustedBase));
                    this.commitAdjustedAudio = true;
                }
                if (!this.commitAdjustedVideo && n3 > 0) {
                    l9 = (Long)this.videoTCs.get(0);
                    this.videoTCs.set(0, new Long(l9 - this.commitAdjustedBase));
                    this.commitAdjustedVideo = true;
                }
                if (!this.commitAdjustedData && n4 > 0) {
                    l9 = (Long)this.dataTCs.get(0);
                    this.dataTCs.set(0, new Long(l9 - this.commitAdjustedBase));
                    this.commitAdjustedData = true;
                }
                List list = this.audioPackets;
                List list2 = this.videoPackets;
                List list3 = this.dataPackets;
                List list4 = this.audioTCs;
                List list5 = this.videoTCs;
                List list6 = this.dataTCs;
                List list7 = this.dataTypes;
                this.audioPackets = new ArrayList();
                this.videoPackets = new ArrayList();
                this.dataPackets = new ArrayList();
                this.audioTCs = new ArrayList();
                this.videoTCs = new ArrayList();
                this.dataTCs = new ArrayList();
                this.dataTypes = new ArrayList();
                ListIterator listIterator = null;
                ListIterator listIterator2 = null;
                ListIterator listIterator3 = null;
                listIterator = list4.listIterator(list4.size());
                listIterator2 = list.listIterator(list.size());
                while (listIterator.hasPrevious() && listIterator2.hasPrevious()) {
                    object = listIterator.previous();
                    e = listIterator2.previous();
                    l8 = (Long)object;
                    if (this.commitBase + l8 < this.commitWatermark + (long)n) break;
                    this.audioTCs.add(0, object);
                    this.audioPackets.add(0, e);
                    listIterator.remove();
                    listIterator2.remove();
                }
                listIterator = list5.listIterator(list5.size());
                listIterator2 = list2.listIterator(list2.size());
                while (listIterator.hasPrevious() && listIterator2.hasPrevious()) {
                    object = listIterator.previous();
                    e = listIterator2.previous();
                    l8 = (Long)object;
                    if (this.commitBase + l8 < this.commitWatermark + (long)n) break;
                    this.videoTCs.add(0, object);
                    this.videoPackets.add(0, e);
                    listIterator.remove();
                    listIterator2.remove();
                }
                listIterator = list6.listIterator(list6.size());
                listIterator3 = list7.listIterator(list7.size());
                listIterator2 = list3.listIterator(list3.size());
                while (listIterator.hasPrevious() && listIterator2.hasPrevious() && listIterator3.hasPrevious()) {
                    object = listIterator.previous();
                    e = listIterator3.previous();
                    Object e2 = listIterator2.previous();
                    long l12 = (Long)object;
                    if (this.commitBase + l12 < this.commitWatermark + (long)n) break;
                    this.dataTCs.add(0, object);
                    this.dataTypes.add(0, e);
                    this.dataPackets.add(0, e2);
                    listIterator.remove();
                    listIterator2.remove();
                }
                if (this.recordWriter != null) {
                    object = this.recordWriter;
                    synchronized (object) {
                        this.recordWriter.add(list, list2, list3, list4, list5, list6, list7, this.commitIsFirstCommit, false);
                        if (!this.recordWriter.isRunning()) {
                            this.recordWriter.setRunning(true);
                            this.getRunner().execute(this.recordWriter);
                        }
                    }
                }
                this.commitIsFirstCommit = false;
                this.commitWatermark += (long)n;
            }
        }
    }

    public int getAudioMissing(int n) {
        int n2 = n;
        if (this.audioData != null) {
            n2 = n - this.audioData.position();
        }
        return n2;
    }

    public int getVideoMissing(int n) {
        int n2 = n;
        if (this.videoData != null) {
            n2 = n - this.videoData.position();
        }
        return n2;
    }

    public int getDataMissing(int n) {
        int n2 = n;
        if (this.dataData != null) {
            n2 = n - this.dataData.position();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish() {
        block17: {
            try {
                if (!this.isReceivePackets || this.commitAudioCount + this.commitVideoCount + this.commitDataCount <= 0) break block17;
                this.initRecordWriter();
                if (this.recordWriter == null) break block17;
                MediaStreamRecordWriter mediaStreamRecordWriter = this.recordWriter;
                synchronized (mediaStreamRecordWriter) {
                    long l;
                    int n = this.audioTCs.size();
                    int n2 = this.videoTCs.size();
                    int n3 = this.dataTCs.size();
                    if (this.commitIsFirstCommit && n + n2 + n3 > 0) {
                        l = this.commitAudioCount > 0 ? this.commitAudioFirstTC : Long.MAX_VALUE;
                        long l2 = this.commitVideoCount > 0 ? this.commitVideoFirstTC : Long.MAX_VALUE;
                        long l3 = this.commitDataCount > 0 ? this.commitDataFirstTC : Long.MAX_VALUE;
                        this.commitBase = Math.min(l, Math.min(l2, l3));
                        this.commitAdjustedBase = FLVUtils.adjustFirstPacketTCs((List)this.audioTCs, (List)this.videoTCs, (List)this.dataTCs);
                        this.commitAdjustedAudio = n > 0;
                        this.commitAdjustedVideo = n2 > 0;
                        boolean bl = this.commitAdjustedData = n3 > 0;
                    }
                    if (!this.commitAdjustedAudio && n > 0) {
                        l = (Long)this.audioTCs.get(0);
                        this.audioTCs.set(0, new Long(l - this.commitAdjustedBase));
                        this.commitAdjustedAudio = true;
                    }
                    if (!this.commitAdjustedVideo && n2 > 0) {
                        l = (Long)this.videoTCs.get(0);
                        this.videoTCs.set(0, new Long(l - this.commitAdjustedBase));
                        this.commitAdjustedVideo = true;
                    }
                    if (!this.commitAdjustedData && n3 > 0) {
                        l = (Long)this.dataTCs.get(0);
                        this.dataTCs.set(0, new Long(l - this.commitAdjustedBase));
                        this.commitAdjustedData = true;
                    }
                    this.recordWriter.add(this.audioPackets, this.videoPackets, this.dataPackets, this.audioTCs, this.videoTCs, this.dataTCs, this.dataTypes, this.commitIsFirstCommit, true);
                    if (!this.recordWriter.isRunning()) {
                        this.recordWriter.setRunning(true);
                        this.getRunner().execute(this.recordWriter);
                    }
                }
                mediaStreamRecordWriter = this.recordWriter;
                synchronized (mediaStreamRecordWriter) {
                    if (this.recordWriter.isRunning()) {
                        this.recordWriter.wait();
                    }
                }
                this.killRunner();
                this.duration = this.recordWriter.getDuration();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaStreamRecord.class).error("publish: " + exception.toString());
                exception.printStackTrace();
            }
            finally {
                this.isReceivePackets = false;
                this.isFileOpen = false;
                this.resetRecord();
            }
        }
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    public void updateLoggingValues() {
        String string = (String)WMSLoggerFactory.getGlobalLogValue((String)"x-event");
        if (string != null) {
            if (string.equals("recordstop")) {
                File file = this.stream.getStreamFileForRead();
                String string2 = file.getPath();
                WMSLoggerFactory.putGlobalLogValue((String)"x-file-name", (Object)string2);
                String[] stringArray = string2.split("[.]");
                String string3 = "";
                if (stringArray.length > 0) {
                    string3 = stringArray[stringArray.length - 1];
                }
                if (string3.length() > 0) {
                    WMSLoggerFactory.putGlobalLogValue((String)"x-file-ext", (Object)string3);
                }
                WMSLoggerFactory.putGlobalLogValue((String)"x-file-size", (Object)new Long(file.exists() ? file.length() : 0L));
                WMSLoggerFactory.putGlobalLogValue((String)"x-file-length", (Object)new Double((double)this.duration / 1000.0));
            } else {
                WMSLoggerFactory.putGlobalLogValue((String)"x-file-size", (Object)new Long(0L));
                WMSLoggerFactory.putGlobalLogValue((String)"x-file-length", (Object)new Double(0.0));
            }
        }
    }

    public double length() {
        return (double)this.duration / 1000.0;
    }

    public long size() {
        long l = 0L;
        File file = this.stream.getStreamFileForRead();
        if (file != null) {
            l = file.exists() ? file.length() : 0L;
        }
        return l;
    }

    public boolean isVersionFile() {
        return this.versionFile;
    }

    public void setVersionFile(boolean bl) {
        this.versionFile = bl;
    }

    public boolean isWaitForVideoKeyFrame() {
        return this.waitForVideoKeyFrame;
    }

    public void setWaitForVideoKeyFrame(boolean bl) {
        this.waitForVideoKeyFrame = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVideoCodecId() {
        Object object = this.codecLock;
        synchronized (object) {
            return this.videoCodecId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAudioCodecId() {
        Object object = this.codecLock;
        synchronized (object) {
            return this.audioCodecId;
        }
    }
}

