/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediawriter.h264.util;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediareader.h264.atom.QTAtom;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrack;
import com.wowza.wms.mediawriter.h264.util.QTWriterTmpItem;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QTWriterContext {
    private byte[] workBuffer = new byte[64];
    private String majorBrand = "f4v ";
    private int majorBrandVersion = 0;
    private String[] compatibleBrands = new String[]{"isom", "mp42", "m4v "};
    private Map<Integer, QTWriterContextTrack> tracks = new HashMap<Integer, QTWriterContextTrack>();
    private List<QTWriterContextTrack> tracksOrder = new ArrayList<QTWriterContextTrack>();
    private Stack<Long> startPosStack = new Stack();
    private long timescale = 90000L;
    private long time = 0L;
    private long mdatLocation = -1L;
    private long lastWriteTimecode = -1L;
    private long flushInterval = this.timescale;
    private RandomAccessFile tmpOut = null;
    private boolean isAppend = false;
    private QTWriterTmpItem moovAtomTmpItem = null;
    private long mdatAppendOffset = -1L;
    private QTAtom mdatAppendAtom = null;
    private long moovAppendOffset = -1L;
    private long appendDuration = 0L;
    private boolean debugLog = WMSLoggerFactory.getLogger(QTWriterContext.class).isDebugEnabled();
    private String outPath = "";

    public QTWriterContext() {
        Date date = new Date();
        this.time = date.getTime();
        this.time /= 1000L;
    }

    public void setIsAppend(boolean bl) {
        this.isAppend = bl;
    }

    public boolean isAppend() {
        return this.isAppend;
    }

    public void setTmpOut(RandomAccessFile randomAccessFile) {
        this.tmpOut = randomAccessFile;
    }

    public RandomAccessFile getTmpOut() {
        return this.tmpOut;
    }

    public long getTime() {
        return this.time;
    }

    public byte[] getWorkBuffer() {
        return this.workBuffer;
    }

    public String[] getCompatibleBrands() {
        return this.compatibleBrands;
    }

    public String getMajorBrand() {
        return this.majorBrand;
    }

    public int getMajorBrandVersion() {
        return this.majorBrandVersion;
    }

    public QTWriterContextTrack getVideoTrack() {
        return this.getTrack(0);
    }

    public QTWriterContextTrack getAudioTrack() {
        return this.getTrack(1);
    }

    public QTWriterContextTrack getDataTrack() {
        return this.getTrack(2);
    }

    public List<QTWriterContextTrack> getTracks() {
        ArrayList<QTWriterContextTrack> arrayList = new ArrayList<QTWriterContextTrack>(this.tracksOrder);
        return arrayList;
    }

    public void addTrack(QTWriterContextTrack qTWriterContextTrack) {
        Integer n = new Integer(qTWriterContextTrack.getTrackType());
        this.tracks.put(n, qTWriterContextTrack);
        this.tracksOrder.add(qTWriterContextTrack);
    }

    public QTWriterContextTrack getTrack(int n) {
        Integer n2 = new Integer(n);
        QTWriterContextTrack qTWriterContextTrack = this.tracks.get(n2);
        if (qTWriterContextTrack == null) {
            qTWriterContextTrack = new QTWriterContextTrack(this, n);
            this.tracks.put(n2, qTWriterContextTrack);
            this.tracksOrder.add(qTWriterContextTrack);
        }
        return qTWriterContextTrack;
    }

    public void addPacket(RandomAccessFile randomAccessFile, long l, long l2) {
        if (this.lastWriteTimecode < 0L) {
            this.lastWriteTimecode = l2;
        }
        if (l2 - this.lastWriteTimecode >= this.flushInterval) {
            this.flush(randomAccessFile, false);
            this.lastWriteTimecode = l2;
        }
    }

    public void flush(RandomAccessFile randomAccessFile) {
        this.flush(randomAccessFile, true);
    }

    public void flush(RandomAccessFile randomAccessFile, boolean bl) {
        for (QTWriterContextTrack qTWriterContextTrack : this.tracks.values()) {
            qTWriterContextTrack.flush(randomAccessFile, bl);
        }
    }

    public void pushStartLoc(long l) {
        this.startPosStack.push(l);
    }

    public long popStartLoc() {
        return this.startPosStack.pop();
    }

    public long getTimescale() {
        return this.timescale;
    }

    public void setTimescale(long l) {
        this.timescale = l;
    }

    public long getDuration() {
        long l = 0L;
        for (QTWriterContextTrack qTWriterContextTrack : this.tracks.values()) {
            long l2 = qTWriterContextTrack.getDuration(this.timescale);
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public int getNextTrackId() {
        return this.tracks.size() + 1;
    }

    public long getMdatLocation() {
        return this.mdatLocation;
    }

    public void setMdatLocation(long l) {
        this.mdatLocation = l;
    }

    public QTWriterTmpItem getMoovAtomTmpItem() {
        return this.moovAtomTmpItem;
    }

    public void setMoovAtomTmpItem(QTWriterTmpItem qTWriterTmpItem) {
        this.moovAtomTmpItem = qTWriterTmpItem;
    }

    public long getMdatAppendOffset() {
        return this.mdatAppendOffset;
    }

    public void setMdatAppendOffset(long l) {
        this.mdatAppendOffset = l;
    }

    public long getMoovAppendOffset() {
        return this.moovAppendOffset;
    }

    public void setMoovAppendOffset(long l) {
        this.moovAppendOffset = l;
    }

    public boolean isAppendLoaded() {
        return this.moovAppendOffset != -1L && this.mdatAppendOffset != -1L;
    }

    public boolean isMoovAboveMDat() {
        return this.moovAppendOffset != -1L && this.mdatAppendOffset != -1L && this.moovAppendOffset < this.mdatAppendOffset;
    }

    public long getAppendDuration() {
        return this.appendDuration;
    }

    public void setAppendDuration(long l) {
        this.appendDuration = l;
    }

    public QTAtom getMdatAppendAtom() {
        return this.mdatAppendAtom;
    }

    public void setMdatAppendAtom(QTAtom qTAtom) {
        this.mdatAppendAtom = qTAtom;
    }

    public boolean isDebugLog() {
        return this.debugLog;
    }

    public String getOutPath() {
        return this.outPath;
    }

    public void setOutPath(String string) {
        this.outPath = string;
    }
}

