/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediawriter.h264.util;

import com.wowza.util.BufferUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrack;
import com.wowza.wms.mediawriter.h264.util.QTWriterTmpItem;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class QTWriterContextTrackAtomBase {
    protected List<QTWriterTmpItem> savedBlocks = new ArrayList<QTWriterTmpItem>();
    protected QTWriterContextTrack track = null;
    protected int rowsPerBlock = 0;
    protected int bytesPerRow = 0;
    protected byte[] block = null;
    protected int currRow = 0;
    protected int count = 0;
    protected int appendCount = 0;
    protected int appendBlockCount = 0;

    public QTWriterContextTrackAtomBase(QTWriterContextTrack qTWriterContextTrack, int n, int n2) {
        this.track = qTWriterContextTrack;
        this.rowsPerBlock = n;
        this.bytesPerRow = n2;
        this.block = new byte[n * n2];
    }

    public void insertBlock(int n, String string, long l, int n2) {
        QTWriterTmpItem qTWriterTmpItem = new QTWriterTmpItem(string, l, n2);
        this.savedBlocks.add(n, qTWriterTmpItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushBlock(byte[] byArray, String string, int n) {
        try {
            byte[] byArray2 = new byte[8];
            System.arraycopy(string.getBytes(), 0, byArray2, 0, 4);
            BufferUtils.intToByteArray((int)n, (byte[])byArray2, (int)4, (int)4);
            long l = 0L;
            RandomAccessFile randomAccessFile = this.track.getContext().getTmpOut();
            Object object = randomAccessFile;
            synchronized (object) {
                randomAccessFile.seek(randomAccessFile.length());
                randomAccessFile.write(byArray2);
                l = randomAccessFile.getFilePointer();
                randomAccessFile.write(byArray, 0, n);
                randomAccessFile.getFD().sync();
            }
            object = new QTWriterTmpItem(string, l, n);
            this.savedBlocks.add((QTWriterTmpItem)object);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterContextTrackAtomBase.class).error("QTWriterContextTrackAtomBase.flushBlock: " + exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getSavedBlock(int n) {
        byte[] byArray = null;
        if (n < this.savedBlocks.size()) {
            QTWriterTmpItem qTWriterTmpItem = this.savedBlocks.get(n);
            try {
                RandomAccessFile randomAccessFile;
                byArray = new byte[qTWriterTmpItem.getSize()];
                RandomAccessFile randomAccessFile2 = randomAccessFile = this.track.getContext().getTmpOut();
                synchronized (randomAccessFile2) {
                    randomAccessFile.seek(qTWriterTmpItem.getOffset());
                    randomAccessFile.readFully(byArray);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(QTWriterContextTrackAtomBase.class).error("QTWriterContextTrackAtomBase.getBlock: " + exception.toString());
            }
        }
        return byArray;
    }

    public byte[] getBlock(int n) {
        byte[] byArray = null;
        if (n < this.savedBlocks.size()) {
            return this.getSavedBlock(n);
        }
        if (this.currRow > 0) {
            byArray = new byte[this.currRow * this.bytesPerRow];
            System.arraycopy(this.block, 0, byArray, 0, this.currRow * this.bytesPerRow);
        }
        return byArray;
    }

    public int getBlockCount() {
        return (this.currRow > 0 ? 1 : 0) + this.savedBlocks.size();
    }

    public int getItemCount() {
        return this.count;
    }

    public void flush() {
    }

    public int getAppendCount() {
        return this.appendCount;
    }

    public void setAppendCount(int n) {
        this.appendCount = n;
    }

    public int getAppendBlockCount() {
        return this.appendBlockCount;
    }

    public void setAppendBlockCount(int n) {
        this.appendBlockCount = n;
    }
}

