/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio.support;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionRecycler;
import org.apache.mina.common.support.BaseIoConnector;
import org.apache.mina.common.support.DefaultConnectFuture;
import org.apache.mina.transport.socket.nio.DatagramConnectorConfig;
import org.apache.mina.transport.socket.nio.DatagramServiceConfig;
import org.apache.mina.transport.socket.nio.DatagramSessionConfig;
import org.apache.mina.transport.socket.nio.support.DatagramService;
import org.apache.mina.transport.socket.nio.support.DatagramSessionImpl;
import org.apache.mina.util.NamePreservingRunnable;
import org.apache.mina.util.Queue;

public class DatagramConnectorDelegate
extends BaseIoConnector
implements DatagramService {
    private static volatile int nextId = 0;
    private final IoConnector wrapper;
    private final Executor executor;
    private final int id = nextId++;
    private Selector selector;
    private DatagramConnectorConfig defaultConfig = new DatagramConnectorConfig();
    private final Queue registerQueue = new Queue();
    private final Queue cancelQueue = new Queue();
    private final Queue flushingSessions = new Queue();
    private final Queue trafficControllingSessions = new Queue();
    private Worker worker;

    public DatagramConnectorDelegate(IoConnector ioConnector, Executor executor) {
        this.wrapper = ioConnector;
        this.executor = executor;
    }

    public ConnectFuture connect(SocketAddress socketAddress, IoHandler ioHandler, IoServiceConfig ioServiceConfig) {
        return this.connect(socketAddress, null, ioHandler, ioServiceConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, IoHandler ioHandler, IoServiceConfig ioServiceConfig) {
        Object object;
        if (socketAddress == null) {
            throw new NullPointerException("address");
        }
        if (ioHandler == null) {
            throw new NullPointerException("handler");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + socketAddress.getClass());
        }
        if (socketAddress2 != null && !(socketAddress2 instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected local address type: " + socketAddress2.getClass());
        }
        if (ioServiceConfig == null) {
            ioServiceConfig = this.getDefaultConfig();
        }
        DatagramChannel datagramChannel = null;
        boolean bl = false;
        try {
            datagramChannel = DatagramChannel.open();
            object = ioServiceConfig.getSessionConfig() instanceof DatagramSessionConfig ? (DatagramSessionConfig)ioServiceConfig.getSessionConfig() : (DatagramSessionConfig)this.getDefaultConfig().getSessionConfig();
            datagramChannel.socket().setReuseAddress(object.isReuseAddress());
            datagramChannel.socket().setBroadcast(object.isBroadcast());
            datagramChannel.socket().setReceiveBufferSize(object.getReceiveBufferSize());
            datagramChannel.socket().setSendBufferSize(object.getSendBufferSize());
            if (datagramChannel.socket().getTrafficClass() != object.getTrafficClass()) {
                datagramChannel.socket().setTrafficClass(object.getTrafficClass());
            }
            if (socketAddress2 != null) {
                datagramChannel.socket().bind(socketAddress2);
            }
            datagramChannel.connect(socketAddress);
            datagramChannel.configureBlocking(false);
            bl = true;
        }
        catch (IOException iOException) {
            ConnectFuture connectFuture = DefaultConnectFuture.newFailedFuture(iOException);
            return connectFuture;
        }
        finally {
            if (!bl && datagramChannel != null) {
                try {
                    datagramChannel.disconnect();
                    datagramChannel.close();
                }
                catch (IOException iOException) {
                    ExceptionMonitor.getInstance().exceptionCaught(iOException);
                }
            }
        }
        object = new RegistrationRequest(datagramChannel, ioHandler, ioServiceConfig);
        DatagramConnectorDelegate datagramConnectorDelegate = this;
        synchronized (datagramConnectorDelegate) {
            try {
                this.startupWorker();
            }
            catch (IOException iOException) {
                try {
                    datagramChannel.disconnect();
                    datagramChannel.close();
                }
                catch (IOException iOException2) {
                    ExceptionMonitor.getInstance().exceptionCaught(iOException2);
                }
                return DefaultConnectFuture.newFailedFuture(iOException);
            }
            Queue queue = this.registerQueue;
            synchronized (queue) {
                this.registerQueue.push(object);
            }
        }
        this.selector.wakeup();
        return object;
    }

    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(DatagramConnectorConfig datagramConnectorConfig) {
        if (datagramConnectorConfig == null) {
            throw new NullPointerException("defaultConfig");
        }
        this.defaultConfig = datagramConnectorConfig;
    }

    private synchronized void startupWorker() throws IOException {
        if (this.worker == null) {
            this.selector = Selector.open();
            this.worker = new Worker();
            this.executor.execute(new NamePreservingRunnable(this.worker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(DatagramSessionImpl datagramSessionImpl) {
        DatagramConnectorDelegate datagramConnectorDelegate = this;
        synchronized (datagramConnectorDelegate) {
            try {
                this.startupWorker();
            }
            catch (IOException iOException) {
                return;
            }
            Queue queue = this.cancelQueue;
            synchronized (queue) {
                this.cancelQueue.push(datagramSessionImpl);
            }
        }
        this.selector.wakeup();
    }

    public void flushSession(DatagramSessionImpl datagramSessionImpl) {
        this.scheduleFlush(datagramSessionImpl);
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFlush(DatagramSessionImpl datagramSessionImpl) {
        Queue queue = this.flushingSessions;
        synchronized (queue) {
            this.flushingSessions.push(datagramSessionImpl);
        }
    }

    public void updateTrafficMask(DatagramSessionImpl datagramSessionImpl) {
        this.scheduleTrafficControl(datagramSessionImpl);
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
        selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTrafficControl(DatagramSessionImpl datagramSessionImpl) {
        Queue queue = this.trafficControllingSessions;
        synchronized (queue) {
            this.trafficControllingSessions.push(datagramSessionImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateTrafficMask() {
        if (this.trafficControllingSessions.isEmpty()) {
            return;
        }
        while (true) {
            Queue queue;
            DatagramSessionImpl datagramSessionImpl;
            Object object = this.trafficControllingSessions;
            synchronized (object) {
                datagramSessionImpl = (DatagramSessionImpl)this.trafficControllingSessions.pop();
            }
            if (datagramSessionImpl == null) break;
            object = datagramSessionImpl.getSelectionKey();
            if (object == null) {
                this.scheduleTrafficControl(datagramSessionImpl);
                break;
            }
            if (!((SelectionKey)object).isValid()) continue;
            int n = 1;
            Queue queue2 = queue = datagramSessionImpl.getWriteRequestQueue();
            synchronized (queue2) {
                if (!queue.isEmpty()) {
                    n |= 4;
                }
            }
            int n2 = datagramSessionImpl.getTrafficMask().getInterestOps();
            ((SelectionKey)object).interestOps(n & n2);
        }
    }

    private void processReadySessions(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            SelectionKey selectionKey = (SelectionKey)iterator.next();
            iterator.remove();
            DatagramSessionImpl datagramSessionImpl = (DatagramSessionImpl)selectionKey.attachment();
            DatagramSessionImpl datagramSessionImpl2 = this.getRecycledSession(datagramSessionImpl);
            if (datagramSessionImpl2 != null) {
                datagramSessionImpl = datagramSessionImpl2;
            }
            if (selectionKey.isReadable() && datagramSessionImpl.getTrafficMask().isReadable()) {
                this.readSession(datagramSessionImpl);
            }
            if (!selectionKey.isWritable() || !datagramSessionImpl.getTrafficMask().isWritable()) continue;
            this.scheduleFlush(datagramSessionImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatagramSessionImpl getRecycledSession(IoSession ioSession) {
        IoSessionRecycler ioSessionRecycler = this.getSessionRecycler(ioSession);
        DatagramSessionImpl datagramSessionImpl = null;
        if (ioSessionRecycler != null) {
            IoSessionRecycler ioSessionRecycler2 = ioSessionRecycler;
            synchronized (ioSessionRecycler2) {
                datagramSessionImpl = (DatagramSessionImpl)ioSessionRecycler.recycle(ioSession.getLocalAddress(), ioSession.getRemoteAddress());
                if (datagramSessionImpl != null) {
                    return datagramSessionImpl;
                }
                ioSessionRecycler.put(ioSession);
            }
        }
        return null;
    }

    private IoSessionRecycler getSessionRecycler(IoSession ioSession) {
        IoServiceConfig ioServiceConfig = ioSession.getServiceConfig();
        IoSessionRecycler ioSessionRecycler = ioServiceConfig instanceof DatagramServiceConfig ? ((DatagramServiceConfig)ioServiceConfig).getSessionRecycler() : this.defaultConfig.getSessionRecycler();
        return ioSessionRecycler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSession(DatagramSessionImpl datagramSessionImpl) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(datagramSessionImpl.getReadBufferSize(), false);
        try {
            int n = datagramSessionImpl.getChannel().read(byteBuffer.buf());
            if (n > 0) {
                byteBuffer.flip();
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.limit(), false);
                byteBuffer2.put(byteBuffer);
                byteBuffer2.flip();
                datagramSessionImpl.increaseReadBytes(n);
                datagramSessionImpl.getFilterChain().fireMessageReceived(datagramSessionImpl, byteBuffer2);
            }
        }
        catch (IOException iOException) {
            datagramSessionImpl.getFilterChain().fireExceptionCaught(datagramSessionImpl, iOException);
        }
        finally {
            byteBuffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushSessions() {
        if (this.flushingSessions.size() == 0) {
            return;
        }
        while (true) {
            DatagramSessionImpl datagramSessionImpl;
            Queue queue = this.flushingSessions;
            synchronized (queue) {
                datagramSessionImpl = (DatagramSessionImpl)this.flushingSessions.pop();
            }
            if (datagramSessionImpl == null) break;
            try {
                this.flush(datagramSessionImpl);
            }
            catch (IOException iOException) {
                datagramSessionImpl.getFilterChain().fireExceptionCaught(datagramSessionImpl, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(DatagramSessionImpl datagramSessionImpl) throws IOException {
        DatagramChannel datagramChannel = datagramSessionImpl.getChannel();
        Queue queue = datagramSessionImpl.getWriteRequestQueue();
        while (true) {
            Object object;
            IoFilter.WriteRequest writeRequest;
            Object object2 = queue;
            synchronized (object2) {
                writeRequest = (IoFilter.WriteRequest)queue.first();
            }
            if (writeRequest == null) break;
            object2 = (ByteBuffer)writeRequest.getMessage();
            if (((ByteBuffer)object2).remaining() == 0) {
                object = queue;
                synchronized (object) {
                    queue.pop();
                }
                datagramSessionImpl.increaseWrittenWriteRequests();
                ((ByteBuffer)object2).reset();
                datagramSessionImpl.getFilterChain().fireMessageSent(datagramSessionImpl, writeRequest);
                continue;
            }
            object = datagramSessionImpl.getSelectionKey();
            if (object == null) {
                this.scheduleFlush(datagramSessionImpl);
                break;
            }
            if (!((SelectionKey)object).isValid()) continue;
            int n = datagramChannel.write(((ByteBuffer)object2).buf());
            if (n == 0) {
                ((SelectionKey)object).interestOps(((SelectionKey)object).interestOps() | 4);
                continue;
            }
            if (n <= 0) continue;
            ((SelectionKey)object).interestOps(((SelectionKey)object).interestOps() & 0xFFFFFFFB);
            Queue queue2 = queue;
            synchronized (queue2) {
                queue.pop();
            }
            datagramSessionImpl.increaseWrittenBytes(n);
            datagramSessionImpl.increaseWrittenWriteRequests();
            ((ByteBuffer)object2).reset();
            datagramSessionImpl.getFilterChain().fireMessageSent(datagramSessionImpl, writeRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushNew(DatagramSessionImpl datagramSessionImpl) throws IOException {
        SelectionKey selectionKey = datagramSessionImpl.getSelectionKey();
        if (selectionKey == null) {
            this.scheduleFlush(datagramSessionImpl);
            return false;
        }
        if (!selectionKey.isValid()) {
            return false;
        }
        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
        DatagramChannel datagramChannel = datagramSessionImpl.getChannel();
        Queue queue = datagramSessionImpl.getWriteRequestQueue();
        int n = 0;
        int n2 = ((DatagramSessionConfig)datagramSessionImpl.getConfig()).getSendBufferSize() << 1;
        try {
            while (true) {
                IoFilter.WriteRequest writeRequest = null;
                Object object = queue;
                synchronized (object) {
                    writeRequest = (IoFilter.WriteRequest)queue.first();
                }
                if (writeRequest == null) {
                    break;
                }
                object = (ByteBuffer)writeRequest.getMessage();
                if (((ByteBuffer)object).remaining() == 0) {
                    queue.poll();
                    ((ByteBuffer)object).reset();
                    if (!((ByteBuffer)object).hasRemaining()) {
                        datagramSessionImpl.increaseWrittenMessages();
                    }
                    datagramSessionImpl.getFilterChain().fireMessageSent(datagramSessionImpl, writeRequest);
                    continue;
                }
                int n3 = datagramChannel.write(((ByteBuffer)object).buf());
                if (n3 == 0 || (n += n3) >= n2) {
                    selectionKey.interestOps(selectionKey.interestOps() | 4);
                    boolean bl = false;
                    return bl;
                }
                selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
                queue.poll();
                ((ByteBuffer)object).reset();
                if (!((ByteBuffer)object).hasRemaining()) {
                    datagramSessionImpl.increaseWrittenMessages();
                }
                datagramSessionImpl.getFilterChain().fireMessageSent(datagramSessionImpl, writeRequest);
            }
        }
        finally {
            datagramSessionImpl.increaseWrittenBytes(n);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerNew() {
        if (this.registerQueue.isEmpty()) {
            return;
        }
        while (true) {
            RegistrationRequest registrationRequest;
            Object object = this.registerQueue;
            synchronized (object) {
                registrationRequest = (RegistrationRequest)this.registerQueue.pop();
            }
            if (registrationRequest == null) return;
            object = new DatagramSessionImpl(this.wrapper, this, registrationRequest.config, registrationRequest.channel, registrationRequest.handler, registrationRequest.channel.socket().getRemoteSocketAddress(), registrationRequest.channel.socket().getLocalSocketAddress());
            boolean bl = false;
            try {
                DatagramSessionImpl datagramSessionImpl = this.getRecycledSession((IoSession)object);
                if (datagramSessionImpl != null) {
                    object = datagramSessionImpl;
                } else {
                    this.buildFilterChain(registrationRequest, (IoSession)object);
                    this.getListeners().fireSessionCreated((IoSession)object);
                }
                SelectionKey selectionKey = registrationRequest.channel.register(this.selector, 1, object);
                ((DatagramSessionImpl)object).setSelectionKey(selectionKey);
                registrationRequest.setSession((IoSession)object);
                bl = true;
                continue;
            }
            catch (Throwable throwable) {
                registrationRequest.setException(throwable);
                continue;
            }
            finally {
                if (bl) continue;
                try {
                    registrationRequest.channel.disconnect();
                    registrationRequest.channel.close();
                }
                catch (IOException iOException) {
                    ExceptionMonitor.getInstance().exceptionCaught(iOException);
                }
                continue;
            }
            break;
        }
    }

    private void buildFilterChain(RegistrationRequest registrationRequest, IoSession ioSession) throws Exception {
        this.getFilterChainBuilder().buildFilterChain(ioSession.getFilterChain());
        registrationRequest.config.getFilterChainBuilder().buildFilterChain(ioSession.getFilterChain());
        registrationRequest.config.getThreadModel().buildFilterChain(ioSession.getFilterChain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelKeys() {
        if (this.cancelQueue.isEmpty()) {
            return;
        }
        while (true) {
            DatagramSessionImpl datagramSessionImpl;
            Object object = this.cancelQueue;
            synchronized (object) {
                datagramSessionImpl = (DatagramSessionImpl)this.cancelQueue.pop();
            }
            if (datagramSessionImpl == null) break;
            object = datagramSessionImpl.getSelectionKey();
            DatagramChannel datagramChannel = (DatagramChannel)((SelectionKey)object).channel();
            try {
                datagramChannel.disconnect();
                datagramChannel.close();
            }
            catch (IOException iOException) {
                ExceptionMonitor.getInstance().exceptionCaught(iOException);
            }
            this.getListeners().fireSessionDestroyed(datagramSessionImpl);
            datagramSessionImpl.getCloseFuture().setClosed();
            ((SelectionKey)object).cancel();
            this.selector.wakeup();
        }
    }

    private static class RegistrationRequest
    extends DefaultConnectFuture {
        private final DatagramChannel channel;
        private final IoHandler handler;
        private final IoServiceConfig config;

        private RegistrationRequest(DatagramChannel datagramChannel, IoHandler ioHandler, IoServiceConfig ioServiceConfig) {
            this.channel = datagramChannel;
            this.handler = ioHandler;
            this.config = ioServiceConfig;
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread.currentThread().setName("DatagramConnector-" + DatagramConnectorDelegate.this.id);
            while (true) {
                try {
                    do {
                        int n = DatagramConnectorDelegate.this.selector.select();
                        DatagramConnectorDelegate.this.registerNew();
                        DatagramConnectorDelegate.this.doUpdateTrafficMask();
                        if (n > 0) {
                            DatagramConnectorDelegate.this.processReadySessions(DatagramConnectorDelegate.this.selector.selectedKeys());
                        }
                        DatagramConnectorDelegate.this.flushSessions();
                        DatagramConnectorDelegate.this.cancelKeys();
                    } while (!DatagramConnectorDelegate.this.selector.keys().isEmpty());
                    DatagramConnectorDelegate datagramConnectorDelegate = DatagramConnectorDelegate.this;
                    synchronized (datagramConnectorDelegate) {
                        if (DatagramConnectorDelegate.this.selector.keys().isEmpty() && DatagramConnectorDelegate.this.registerQueue.isEmpty() && DatagramConnectorDelegate.this.cancelQueue.isEmpty()) {
                            DatagramConnectorDelegate.this.worker = null;
                            try {
                                DatagramConnectorDelegate.this.selector.close();
                            }
                            catch (IOException iOException) {
                                ExceptionMonitor.getInstance().exceptionCaught(iOException);
                            }
                            finally {
                                DatagramConnectorDelegate.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException iOException) {
                    ExceptionMonitor.getInstance().exceptionCaught(iOException);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
    }
}

