/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio.support;

import java.net.DatagramSocket;
import java.net.SocketException;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.common.support.BaseIoSessionConfig;
import org.apache.mina.transport.socket.nio.DatagramSessionConfig;

public class DatagramSessionConfigImpl
extends BaseIoSessionConfig
implements DatagramSessionConfig {
    private static boolean SET_RECEIVE_BUFFER_SIZE_AVAILABLE = false;
    private static boolean SET_SEND_BUFFER_SIZE_AVAILABLE = false;
    private static boolean GET_TRAFFIC_CLASS_AVAILABLE = false;
    private static boolean SET_TRAFFIC_CLASS_AVAILABLE = false;
    private static boolean DEFAULT_BROADCAST;
    private static boolean DEFAULT_REUSE_ADDRESS;
    private static int DEFAULT_RECEIVE_BUFFER_SIZE;
    private static int DEFAULT_SEND_BUFFER_SIZE;
    private static int DEFAULT_TRAFFIC_CLASS;
    private boolean broadcast = DEFAULT_BROADCAST;
    private boolean reuseAddress = DEFAULT_REUSE_ADDRESS;
    private int receiveBufferSize = DEFAULT_RECEIVE_BUFFER_SIZE;
    private int sendBufferSize = DEFAULT_SEND_BUFFER_SIZE;
    private int trafficClass = DEFAULT_TRAFFIC_CLASS;

    private static void initialize() {
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = new DatagramSocket();
            DEFAULT_BROADCAST = datagramSocket.getBroadcast();
            DEFAULT_REUSE_ADDRESS = datagramSocket.getReuseAddress();
            DEFAULT_RECEIVE_BUFFER_SIZE = datagramSocket.getReceiveBufferSize();
            DEFAULT_SEND_BUFFER_SIZE = datagramSocket.getSendBufferSize();
            try {
                datagramSocket.setReceiveBufferSize(DEFAULT_RECEIVE_BUFFER_SIZE);
                SET_RECEIVE_BUFFER_SIZE_AVAILABLE = true;
            }
            catch (SocketException socketException) {
                SET_RECEIVE_BUFFER_SIZE_AVAILABLE = false;
            }
            try {
                datagramSocket.setSendBufferSize(DEFAULT_SEND_BUFFER_SIZE);
                SET_SEND_BUFFER_SIZE_AVAILABLE = true;
            }
            catch (SocketException socketException) {
                SET_SEND_BUFFER_SIZE_AVAILABLE = false;
            }
            try {
                DEFAULT_TRAFFIC_CLASS = datagramSocket.getTrafficClass();
                GET_TRAFFIC_CLASS_AVAILABLE = true;
            }
            catch (SocketException socketException) {
                GET_TRAFFIC_CLASS_AVAILABLE = false;
                DEFAULT_TRAFFIC_CLASS = 0;
            }
        }
        catch (SocketException socketException) {
            throw new ExceptionInInitializerError(socketException);
        }
        finally {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
        }
    }

    public static boolean isSetReceiveBufferSizeAvailable() {
        return SET_RECEIVE_BUFFER_SIZE_AVAILABLE;
    }

    public static boolean isSetSendBufferSizeAvailable() {
        return SET_SEND_BUFFER_SIZE_AVAILABLE;
    }

    public static boolean isGetTrafficClassAvailable() {
        return GET_TRAFFIC_CLASS_AVAILABLE;
    }

    public static boolean isSetTrafficClassAvailable() {
        return SET_TRAFFIC_CLASS_AVAILABLE;
    }

    public DatagramSessionConfigImpl() {
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = new DatagramSocket();
            this.broadcast = datagramSocket.getBroadcast();
            this.reuseAddress = datagramSocket.getReuseAddress();
            this.receiveBufferSize = datagramSocket.getReceiveBufferSize();
            this.sendBufferSize = datagramSocket.getSendBufferSize();
            this.trafficClass = datagramSocket.getTrafficClass();
        }
        catch (SocketException socketException) {
            throw new RuntimeIOException("Failed to get the default configuration.", socketException);
        }
        finally {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
        }
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean bl) {
        this.broadcast = bl;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean bl) {
        this.reuseAddress = bl;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int n) {
        this.receiveBufferSize = n;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int n) {
        this.sendBufferSize = n;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int n) {
        this.trafficClass = n;
    }

    static {
        DatagramSessionConfigImpl.initialize();
    }
}

