/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264.hint;

import com.wowza.util.BufferUtils;
import com.wowza.wms.mediareader.h264.hint.QTHintEntry;

public class QTHintEntries {
    private static final int HINTENTRY_MINSIZE = 8;
    public static final int FLAG_HASTLV = 4;
    public static final int FLAG_ISBFRAME = 2;
    public static final int FLAG_ISRFRAME = 1;
    public int entryCount = 0;
    public QTHintEntry[] hintEntries = new QTHintEntry[8];

    public QTHintEntries() {
        for (int i = 0; i < this.hintEntries.length; ++i) {
            this.hintEntries[i] = new QTHintEntry();
        }
    }

    private void checkEntryCount() {
        if (this.entryCount > this.hintEntries.length) {
            QTHintEntry[] qTHintEntryArray = new QTHintEntry[this.entryCount];
            for (int i = 0; i < qTHintEntryArray.length; ++i) {
                qTHintEntryArray[i] = i < this.hintEntries.length ? this.hintEntries[i] : new QTHintEntry();
            }
            this.hintEntries = qTHintEntryArray;
        }
    }

    public void setEntryCount(int n) {
        this.entryCount = n;
        this.checkEntryCount();
    }

    public void parseEntry(byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4 = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)2);
        n3 += 4;
        this.setEntryCount(n4);
        for (int i = 0; i < n4; ++i) {
            Object object;
            int n5;
            QTHintEntry qTHintEntry = this.hintEntries[i];
            qTHintEntry.relativeTransmissionTime = BufferUtils.byteArrayToInt((byte[])byArray, (int)n3, (int)4);
            System.arraycopy(byArray, n3 += 4, qTHintEntry.headerInfo, 0, 2);
            qTHintEntry.headerInfo[0] = (byte)(qTHintEntry.headerInfo[0] | 0x80);
            qTHintEntry.seqNum = BufferUtils.byteArrayToInt((byte[])byArray, (int)(n3 += 2), (int)2);
            System.arraycopy(byArray, n3 += 2, qTHintEntry.flags, 0, 2);
            int n6 = BufferUtils.byteArrayToInt((byte[])byArray, (int)(n3 += 2), (int)2);
            n3 += 2;
            qTHintEntry.setDataCount(n6);
            qTHintEntry.hasTLV = (qTHintEntry.flags[1] & 4) == 4;
            qTHintEntry.isBFrame = (qTHintEntry.flags[1] & 2) == 2;
            qTHintEntry.isRFrame = (qTHintEntry.flags[1] & 1) == 1;
            qTHintEntry.timecodeOffset = 0;
            if (qTHintEntry.hasTLV) {
                int n7;
                n5 = BufferUtils.byteArrayToInt((byte[])byArray, (int)n3, (int)4);
                n3 += 4;
                object = new byte[4];
                int n8 = 4;
                do {
                    n7 = BufferUtils.byteArrayToInt((byte[])byArray, (int)n3, (int)4);
                    n8 += 4;
                    System.arraycopy(byArray, n3 += 4, object, 0, 4);
                    n3 += 4;
                    n8 += 4;
                    String string = new String((byte[])object);
                    if (string.equals("rtpo")) {
                        qTHintEntry.timecodeOffset = BufferUtils.byteArrayToInt((byte[])byArray, (int)n3, (int)4);
                    }
                    n3 += n7 - 8;
                } while ((n8 += n7 - 8) != n5);
            }
            block8: for (n5 = 0; n5 < n6; ++n5) {
                object = qTHintEntry.dataEntries[n5];
                object.dataSource = byArray[n3];
                ++n3;
                switch (object.dataSource) {
                    case 0: {
                        continue block8;
                    }
                    case 1: {
                        object.dataSize = BufferUtils.byteArrayToShort((byte[])byArray, (int)n3, (int)1);
                        System.arraycopy(byArray, ++n3, object.data, 0, 14);
                        n3 += 14;
                        continue block8;
                    }
                    case 2: {
                        object.trackRefIndex = byArray[n3];
                        object.length = BufferUtils.byteArrayToInt((byte[])byArray, (int)(++n3), (int)2);
                        object.sampleNumber = BufferUtils.byteArrayToInt((byte[])byArray, (int)(n3 += 2), (int)4);
                        n3 += 4;
                        if (object.sampleNumber > 0) {
                            --object.sampleNumber;
                        }
                        object.offset = BufferUtils.byteArrayToInt((byte[])byArray, (int)n3, (int)4);
                        object.bytesPerCompressionBlock = BufferUtils.byteArrayToInt((byte[])byArray, (int)(n3 += 4), (int)2);
                        object.samplesPerCompressionBlock = BufferUtils.byteArrayToInt((byte[])byArray, (int)(n3 += 2), (int)2);
                        n3 += 2;
                        continue block8;
                    }
                    case 3: {
                        object.trackRefIndex = byArray[n3];
                        object.length = BufferUtils.byteArrayToInt((byte[])byArray, (int)(++n3), (int)2);
                        object.sampleDescriptionIndex = BufferUtils.byteArrayToInt((byte[])byArray, (int)(n3 += 2), (int)4);
                        object.offset = BufferUtils.byteArrayToInt((byte[])byArray, (int)(n3 += 4), (int)4);
                        object.reserved = BufferUtils.byteArrayToInt((byte[])byArray, (int)(n3 += 4), (int)4);
                        n3 += 4;
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("QTHintEntries: " + this.entryCount + "\n");
        for (int i = 0; i < this.entryCount; ++i) {
            stringBuffer.append("entry: " + i + "\n");
            stringBuffer.append(this.hintEntries[i].toString());
        }
        return stringBuffer.toString();
    }
}

