/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.mina.common.ByteBuffer;

public final class TransportType
implements Serializable {
    private static final long serialVersionUID = 3258132470497883447L;
    private static final Map name2type = new HashMap();
    public static final TransportType SOCKET = new TransportType(new String[]{"SOCKET", "TCP"}, false);
    public static final TransportType DATAGRAM = new TransportType(new String[]{"DATAGRAM", "UDP"}, true);
    public static final TransportType VM_PIPE = new TransportType(new String[]{"VM_PIPE"}, Object.class, false);
    private final String[] names;
    private final transient boolean connectionless;
    private final transient Class envelopeType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(String[] stringArray, TransportType transportType) {
        Map map = name2type;
        synchronized (map) {
            int n;
            for (n = stringArray.length - 1; n >= 0; --n) {
                if (!name2type.containsKey(stringArray[n])) continue;
                throw new IllegalArgumentException("Transport type name '" + stringArray[n] + "' is already taken.");
            }
            for (n = stringArray.length - 1; n >= 0; --n) {
                name2type.put(stringArray[n].toUpperCase(), transportType);
            }
        }
    }

    public static TransportType getInstance(String string) {
        TransportType transportType = (TransportType)name2type.get(string.toUpperCase());
        if (transportType != null) {
            return transportType;
        }
        throw new IllegalArgumentException("Unknown transport type name: " + string);
    }

    public TransportType(String[] stringArray, boolean bl) {
        this(stringArray, ByteBuffer.class, bl);
    }

    public TransportType(String[] stringArray, Class clazz, boolean bl) {
        if (stringArray == null) {
            throw new NullPointerException("names");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("names is empty");
        }
        if (clazz == null) {
            throw new NullPointerException("envelopeType");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                throw new NullPointerException("strVals[" + i + "]");
            }
            stringArray[i] = stringArray[i].toUpperCase();
        }
        TransportType.register(stringArray, this);
        this.names = stringArray;
        this.connectionless = bl;
        this.envelopeType = clazz;
    }

    public boolean isConnectionless() {
        return this.connectionless;
    }

    public Class getEnvelopeType() {
        return this.envelopeType;
    }

    public Set getNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = this.names.length - 1; i >= 0; --i) {
            treeSet.add(this.names[i]);
        }
        return treeSet;
    }

    public String toString() {
        return this.names[0];
    }

    private Object readResolve() throws ObjectStreamException {
        for (int i = this.names.length - 1; i >= 0; --i) {
            try {
                return TransportType.getInstance(this.names[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        throw new InvalidObjectException("Unknown transport type.");
    }
}

