/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediawriter.h264.util;

import com.wowza.util.BufferUtils;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrack;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackAtomBase;

public class QTWriterContextTrackSTSZ
extends QTWriterContextTrackAtomBase {
    public static final int ROWSPERBLOCK = 4096;
    public static final int BYTESPERROW = 4;
    public static final String TYPESTR = "stsz";
    private boolean allSameSize = true;
    private long lastSampleSize = -1L;
    private long appendSampleSize = 0L;
    private boolean appendNeedToExpand = false;

    public QTWriterContextTrackSTSZ(QTWriterContextTrack qTWriterContextTrack) {
        super(qTWriterContextTrack, 4096, 4);
    }

    public boolean isAllSameSize() {
        return this.allSameSize && this.lastSampleSize != -1L;
    }

    public long getFixedSize() {
        return this.lastSampleSize;
    }

    public void addSize(long l) {
        if (this.lastSampleSize == -1L) {
            this.lastSampleSize = l;
        } else if (this.lastSampleSize != l) {
            this.allSameSize = false;
        }
        BufferUtils.longToByteArray((long)l, (byte[])this.block, (int)(this.currRow * this.bytesPerRow), (int)this.bytesPerRow);
        ++this.currRow;
        ++this.count;
        if (this.currRow >= this.rowsPerBlock) {
            this.flushBlock(this.block, TYPESTR, this.currRow * this.bytesPerRow);
            this.currRow = 0;
        }
    }

    public void setIsAllSameSize(boolean bl) {
        this.allSameSize = bl;
    }

    public long getAppendSampleSize() {
        return this.appendSampleSize;
    }

    public void setAppendSampleSize(long l) {
        this.appendSampleSize = l;
    }

    public boolean isAppendNeedToExpand() {
        return this.appendNeedToExpand;
    }

    public void setAppendNeedToExpand(boolean bl) {
        this.appendNeedToExpand = bl;
    }
}

