/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import com.wowza.util.StringUtils;
import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;

public class ElapsedTimer {
    private static final String DATEFORMATSTR = "EEE, MMM d yyyy HH:mm:ss Z";
    private static final String NEVERSTR = "never";
    private Date date = new Date();
    private long time = System.currentTimeMillis();

    public Date getDate() {
        return this.date;
    }

    public String getDateString() {
        return this.formatDate(this.date);
    }

    public long getTime() {
        return System.currentTimeMillis() - this.time;
    }

    public double getTimeSeconds() {
        return (double)this.getTime() / 1000.0;
    }

    public String getTimeString() {
        return this.formatStamp(this.time);
    }

    private String formatDate(Date date) {
        return date == null ? NEVERSTR : FastDateFormat.getInstance((String)DATEFORMATSTR).format(date);
    }

    private String formatStamp(long l) {
        return l == 0L ? NEVERSTR : StringUtils.stampToString(System.currentTimeMillis() - l);
    }
}

