/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import com.wowza.util.IFileProcess;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileUtils {
    public static String toValidFilename(String string) {
        String string2 = string;
        string2 = string2.replace("/", "_");
        string2 = string2.replace("\\", "_");
        string2 = string2.replace(":", "_");
        string2 = string2.replace("*", "_");
        string2 = string2.replace("?", "_");
        string2 = string2.replace("<", "_");
        string2 = string2.replace(">", "_");
        string2 = string2.replace("|", "_");
        return string2;
    }

    public static void copyFile(File file, File file2) {
        try {
            long l;
            FileChannel fileChannel = new FileInputStream(file).getChannel();
            FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
            long l2 = fileChannel.size();
            while ((l = fileChannel.transferTo(0L, l2, fileChannel2)) != 0L && (l2 -= l) > 0L) {
            }
            fileChannel2.force(true);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(FileUtils.class).error("FileUtils.copyFile: " + exception.toString());
        }
    }

    public static void copyFile2(File file, File file2) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        try {
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (fileChannel2 != null) {
                fileChannel2.close();
            }
        }
    }

    public static boolean deleteDirectory(File file) {
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    FileUtils.deleteDirectory(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
        }
        return file.delete();
    }

    public static File versionFile(File file) {
        File file2 = null;
        try {
            String string = file.getParent();
            String string2 = file.getName();
            String string3 = "";
            int n = string2.lastIndexOf(".");
            if (n >= 0) {
                string3 = string2.substring(n);
                string2 = string2.substring(0, n);
            }
            int n2 = 0;
            while (true) {
                File file3;
                if (!(file3 = new File(string + "/" + string2 + "_" + n2 + string3)).exists()) {
                    file2 = file3;
                    file.renameTo(file3);
                    break;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(FileUtils.class).error("FileUtils.versionFile: " + exception.toString());
        }
        return file2;
    }

    public static void traverseDirectory(File file, IFileProcess iFileProcess) {
        try {
            iFileProcess.onFile(file);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(FileUtils.class).error("traverse.notify: " + exception.toString());
        }
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    FileUtils.traverseDirectory(new File(file, stringArray[i]), iFileProcess);
                    continue;
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(FileUtils.class).error("FileUtils.traverse.recurse: " + exception.toString());
                }
            }
        }
    }
}

