/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.client;

import com.wowza.util.NoMBean;
import com.wowza.util.StringUtils;
import com.wowza.wms.client.ConnectionCounterBase;
import com.wowza.wms.client.ConnectionHolder;
import com.wowza.wms.client.IConnectionNotify;
import com.wowza.wms.client.IConnectionValidator;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.stream.MediaStreamBase;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReentrantReadWriteLock;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.FastDateFormat;

public class ConnectionCounter
extends ConnectionCounterBase {
    private long total = 0L;
    private long totalAccepted = 0L;
    private long totalRejected = 0L;
    private long[] totalRejectedByReason = new long[2];
    private long current = 0L;
    private Date lastConnectAcceptedTime = null;
    private long lastConnectAcceptedStamp = 0L;
    private Date lastConnectRejectedTime = null;
    private long lastConnectRejectedStamp = 0L;
    private Date lastDisconnectTime = null;
    private long lastDisconnectStamp = 0L;
    private Date[] lastConnectRejectedByReasonTime = new Date[2];
    private long[] lastConnectRejectedByReasonStamp = new long[2];
    private List connectionListeners = new ArrayList();
    private IConnectionValidator connectionValidator = null;
    private byte[] control = null;
    private WMSReentrantReadWriteLock controlLock = new WMSReentrantReadWriteLock();

    public ConnectionCounter() {
        this.init();
    }

    private void init() {
        for (int i = 0; i < this.totalRejectedByReason.length; ++i) {
            this.totalRejectedByReason[i] = 0L;
            this.lastConnectRejectedByReasonTime[i] = null;
            this.lastConnectRejectedByReasonStamp[i] = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void addConnectionListener(IConnectionNotify iConnectionNotify) {
        List list = this.connectionListeners;
        synchronized (list) {
            this.connectionListeners.add(iConnectionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void removeConnectionListener(IConnectionNotify iConnectionNotify) {
        List list = this.connectionListeners;
        synchronized (list) {
            this.connectionListeners.remove(iConnectionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConnectionAccept(ConnectionHolder connectionHolder, Date date, long l) {
        ArrayList arrayList = null;
        List list = this.connectionListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.connectionListeners);
        }
        for (IConnectionNotify iConnectionNotify : arrayList) {
            iConnectionNotify.onAcceptConnection(this, connectionHolder, date, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRejectConnectionByApplication(ConnectionHolder connectionHolder, int n, Date date, long l) {
        ArrayList arrayList = null;
        List list = this.connectionListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.connectionListeners);
        }
        for (IConnectionNotify iConnectionNotify : arrayList) {
            iConnectionNotify.onRejectConnection(this, connectionHolder, n, date, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDisconnect(ConnectionHolder connectionHolder, boolean bl, Date date, long l) {
        ArrayList arrayList = null;
        List list = this.connectionListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.connectionListeners);
        }
        for (IConnectionNotify iConnectionNotify : arrayList) {
            iConnectionNotify.onDisconnect(this, connectionHolder, bl, date, l);
        }
    }

    @NoMBean
    public synchronized void setConnectionValidator(IConnectionValidator iConnectionValidator) {
        this.connectionValidator = iConnectionValidator;
    }

    @NoMBean
    public boolean validateNewConnection(ConnectionHolder connectionHolder, byte[] byArray) {
        return this.connectionValidator == null ? true : this.connectionValidator.validateConnection(this, connectionHolder, byArray);
    }

    @NoMBean
    public void acceptConnection(ConnectionHolder connectionHolder, byte[] byArray) {
        boolean bl = connectionHolder.grabConnection(true);
        if (bl) {
            Date date = new Date();
            long l = System.currentTimeMillis();
            this.incrementAccept(connectionHolder, date, l, byArray);
        } else {
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r2");
            byte[] byArray2 = bigInteger.toByteArray();
            for (int i = 0; i < byArray.length; ++i) {
                int n = i;
                byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 8) % byArray2.length]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLicense(byte[] byArray) {
        if (this.control == null) {
            this.controlLock.writeLock().lock();
            try {
                if (this.control == null) {
                    this.control = new byte[ModuleConnect.lc.length];
                    System.arraycopy(ModuleConnect.lc, 0, this.control, 0, ModuleConnect.lc.length);
                    BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
                    byte[] byArray2 = bigInteger.toByteArray();
                    for (int i = 0; i < this.control.length; ++i) {
                        int n = i;
                        this.control[n] = (byte)(this.control[n] ^ byArray2[(i + 11) % byArray2.length]);
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.controlLock.writeLock().unlock();
            }
        }
        this.controlLock.readLock().lock();
        try {
            for (int i = 0; i < ModuleConnect.lc.length; ++i) {
                if (byArray[i] == this.control[i]) continue;
                WMSLoggerFactory.getLogger(null).error("ConnectionCounter exit:" + byArray[i] + ":" + this.control[i]);
                System.exit(1);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.controlLock.readLock().unlock();
        }
    }

    @NoMBean
    public void incrementAccept(ConnectionHolder connectionHolder, Date date, long l, byte[] byArray) {
        this.checkLicense(byArray);
        BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r2");
        byte[] byArray2 = bigInteger.toByteArray();
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 8) % byArray2.length]);
        }
        this.localIncrementAccept(connectionHolder, date, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    private void localIncrementAccept(ConnectionHolder connectionHolder, Date date, long l) {
        ConnectionCounter connectionCounter = this;
        synchronized (connectionCounter) {
            this.lastConnectAcceptedTime = date;
            this.lastConnectAcceptedStamp = l;
            ++this.total;
            ++this.totalAccepted;
            ++this.current;
        }
        this.notifyConnectionAccept(connectionHolder, date, l);
    }

    @NoMBean
    public void rejectConnection(ConnectionHolder connectionHolder, int n, byte[] byArray) {
        boolean bl = connectionHolder.grabConnection(false);
        if (bl) {
            Date date = new Date();
            long l = System.currentTimeMillis();
            this.incrementReject(connectionHolder, n, date, l, byArray);
        } else {
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r2");
            byte[] byArray2 = bigInteger.toByteArray();
            for (int i = 0; i < byArray.length; ++i) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] ^ byArray2[(i + 8) % byArray2.length]);
            }
        }
    }

    @NoMBean
    public void incrementReject(ConnectionHolder connectionHolder, int n, Date date, long l, byte[] byArray) {
        this.checkLicense(byArray);
        BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r2");
        byte[] byArray2 = bigInteger.toByteArray();
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = i;
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[(i + 8) % byArray2.length]);
        }
        this.localIncrementReject(connectionHolder, n, date, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    private void localIncrementReject(ConnectionHolder connectionHolder, int n, Date date, long l) {
        ConnectionCounter connectionCounter = this;
        synchronized (connectionCounter) {
            this.lastConnectRejectedTime = date;
            this.lastConnectRejectedStamp = l;
            this.lastConnectRejectedByReasonTime[n] = date;
            this.lastConnectRejectedByReasonStamp[n] = l;
            int n2 = n;
            this.totalRejectedByReason[n2] = this.totalRejectedByReason[n2] + 1L;
            ++this.total;
            ++this.totalRejected;
        }
        this.notifyRejectConnectionByApplication(connectionHolder, n, date, l);
    }

    @NoMBean
    public void disconnect(ConnectionHolder connectionHolder, byte[] byArray) {
        this.checkLicense(byArray);
        BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r2");
        byte[] byArray2 = bigInteger.toByteArray();
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 8) % byArray2.length]);
        }
        boolean[] blArray = connectionHolder.releaseConnection();
        if (blArray[0]) {
            Date date = new Date();
            long l = System.currentTimeMillis();
            this.localDecrement(connectionHolder, blArray[1], date, l);
        }
    }

    @NoMBean
    public void decrement(ConnectionHolder connectionHolder, boolean bl, Date date, long l, byte[] byArray) {
        this.checkLicense(byArray);
        BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r2");
        byte[] byArray2 = bigInteger.toByteArray();
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 8) % byArray2.length]);
        }
        this.localDecrement(connectionHolder, bl, date, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    private void localDecrement(ConnectionHolder connectionHolder, boolean bl, Date date, long l) {
        ConnectionCounter connectionCounter = this;
        synchronized (connectionCounter) {
            this.lastDisconnectTime = date;
            this.lastDisconnectStamp = l;
            if (bl) {
                --this.current;
            }
        }
        this.notifyDisconnect(connectionHolder, bl, date, l);
    }

    public synchronized long getCurrent() {
        return this.current;
    }

    public synchronized long getLastConnectAcceptedStamp() {
        return this.lastConnectAcceptedStamp;
    }

    public synchronized String getLastConnectAcceptedStampString() {
        return this.formatStamp(this.lastConnectAcceptedStamp);
    }

    public synchronized Date getLastConnectAcceptedTime() {
        return this.lastConnectAcceptedTime;
    }

    public synchronized String getLastConnectAcceptedTimeString() {
        return this.formatDate(this.lastConnectAcceptedTime);
    }

    public synchronized long getLastConnectRejectedStamp() {
        return this.lastConnectRejectedStamp;
    }

    public synchronized String getLastConnectRejectedStampString() {
        return this.formatStamp(this.lastConnectRejectedStamp);
    }

    public synchronized Date getLastConnectRejectedTime() {
        return this.lastConnectRejectedTime;
    }

    public synchronized String getLastConnectRejectedTimeString() {
        return this.formatDate(this.lastConnectRejectedTime);
    }

    public synchronized String getLastConnectRejectedByReasonStampString(int n) {
        return this.formatStamp(this.lastConnectRejectedByReasonStamp[n]);
    }

    public synchronized long getLastConnectRejectedByReasonStamp(int n) {
        return this.lastConnectRejectedByReasonStamp[n];
    }

    public synchronized Date getLastConnectRejectedByReasonTime(int n) {
        return this.lastConnectRejectedByReasonTime[n];
    }

    public synchronized String getLastConnectRejectedByReasonTimeString(int n) {
        return this.formatDate(this.lastConnectRejectedByReasonTime[n]);
    }

    public synchronized String getLastDisconnectStampString() {
        return this.formatStamp(this.lastDisconnectStamp);
    }

    public synchronized long getLastDisconnectStamp() {
        return this.lastDisconnectStamp;
    }

    public synchronized Date getLastDisconnectTime() {
        return this.lastDisconnectTime;
    }

    public synchronized String getLastDisconnectTimeString() {
        return this.formatDate(this.lastDisconnectTime);
    }

    public synchronized long getTotal() {
        return this.total;
    }

    public synchronized long getTotalAccepted() {
        return this.totalAccepted;
    }

    public synchronized long getTotalRejected() {
        return this.totalRejected;
    }

    private String formatDate(Date date) {
        return date == null ? "never" : FastDateFormat.getInstance((String)"EEE, MMM d yyyy HH:mm:ss Z").format(date);
    }

    private String formatStamp(long l) {
        return l == 0L ? "never" : StringUtils.stampToString(System.currentTimeMillis() - l);
    }
}

