/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.model;

import com.wowza.util.MD5DigestUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.model.HTTPStreamerSessions;
import com.wowza.wms.util.IIdleNotify;
import com.wowza.wms.util.IdleWorkersUtil;
import com.wowza.wms.vhost.IVHost;
import java.util.UUID;

public class HTTPStreamerContext
implements IIdleNotify {
    private IVHost vhost = null;
    private HTTPStreamerSessions sessions = null;
    private int checkTimeoutInterval = 500;
    private long lastCheckTime = -1L;
    private HTTPStreamerIdleWorker idleRunner = new HTTPStreamerIdleWorker();
    private String guid = null;

    public HTTPStreamerContext(IVHost iVHost) {
        this.vhost = iVHost;
        this.sessions = new HTTPStreamerSessions(iVHost);
        this.guid = UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regenerateGuid() {
        String string = this.guid;
        synchronized (string) {
            this.guid = UUID.randomUUID().toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGuid() {
        String string = this.guid;
        synchronized (string) {
            return this.guid;
        }
    }

    public byte[] getEncKey(IApplicationInstance iApplicationInstance, String string) {
        byte[] byArray = null;
        String string2 = this.getGuid() + ":" + iApplicationInstance.getApplication().getName() + ":" + iApplicationInstance.getName() + ":" + string;
        byte[] byArray2 = MD5DigestUtils.generateHashBytes(string2);
        if (byArray2 != null) {
            byArray = new byte[16];
            System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
        }
        return byArray;
    }

    public HTTPStreamerSessions getSessions() {
        return this.sessions;
    }

    public IVHost getVHost() {
        return this.vhost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onIdle(long l) {
        if (this.lastCheckTime == -1L || l - this.lastCheckTime >= (long)this.checkTimeoutInterval) {
            boolean bl = false;
            HTTPStreamerIdleWorker hTTPStreamerIdleWorker = this.idleRunner;
            synchronized (hTTPStreamerIdleWorker) {
                if (!this.idleRunner.isRunning) {
                    this.idleRunner.isRunning = true;
                    this.idleRunner.timecode = l;
                    bl = true;
                }
            }
            if (bl) {
                this.lastCheckTime = l;
                this.vhost.getHandlerThreadPool().execute(this.idleRunner);
            }
        }
    }

    public void init() {
        IdleWorkersUtil idleWorkersUtil = this.vhost.getIdleWorkers();
        idleWorkersUtil.registerIdleClient(this);
    }

    public void shutdown() {
        IdleWorkersUtil idleWorkersUtil = this.vhost.getIdleWorkers();
        idleWorkersUtil.unregisterIdleClient(this);
    }

    class HTTPStreamerIdleWorker
    implements Runnable {
        boolean isRunning = false;
        long timecode = -1L;

        HTTPStreamerIdleWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HTTPStreamerContext.this.sessions.checkTimeout(this.timecode);
            HTTPStreamerIdleWorker hTTPStreamerIdleWorker = this;
            synchronized (hTTPStreamerIdleWorker) {
                this.isRunning = false;
            }
        }
    }
}

