/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.logging;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.Server;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.vhost.VHostWorkerThread;
import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerFactory;

public class WMSLogger
extends Logger {
    private static WMSLoggerFactory myFactory = WMSLoggerFactory.getInstance();
    private Logger tmpLogger = null;

    public static WMSLogger getLogger(String string) {
        WMSLogger wMSLogger = null;
        Logger logger = Logger.getLogger((String)string, (LoggerFactory)myFactory);
        wMSLogger = logger instanceof WMSLogger ? (WMSLogger)logger : myFactory.forceNewLoggerInstance(string, logger);
        return wMSLogger;
    }

    public WMSLogger(String string, Logger logger) {
        super("__" + string);
        this.tmpLogger = logger;
    }

    public WMSLogger(String string) {
        super(string);
    }

    private int levelToStatus(Level level) {
        return level == Level.FATAL || level == Level.ERROR ? 500 : 200;
    }

    private void setupLogging(Level level, String string, IMediaStream iMediaStream, String string2, String string3, int n, String string4) {
        try {
            Date date = new Date();
            FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd");
            FastDateFormat fastDateFormat2 = FastDateFormat.getInstance((String)"HH:mm:ss");
            FastDateFormat fastDateFormat3 = FastDateFormat.getInstance((String)"z");
            WMSLoggerFactory.putGlobalLogValue("date", fastDateFormat.format(date));
            WMSLoggerFactory.putGlobalLogValue("time", fastDateFormat2.format(date));
            WMSLoggerFactory.putGlobalLogValue("tz", fastDateFormat3.format(date));
            WMSLoggerFactory.putGlobalLogValue("x-severity", level.toString());
            WMSLoggerFactory.putGlobalLogValue("x-status", new Integer(n));
            if (string != null) {
                WMSLoggerFactory.putGlobalLogValue("x-comment", string);
            }
            if (string2 != null) {
                WMSLoggerFactory.putGlobalLogValue("x-category", string2);
            }
            if (string3 != null) {
                WMSLoggerFactory.putGlobalLogValue("x-event", string3);
            }
            if (string4 != null) {
                WMSLoggerFactory.putGlobalLogValue("x-ctx", string4);
                WMSLoggerFactory.putGlobalLogValue("x-ctx-override", string4);
            }
            WMSLoggerFactory.removeGlobalLogValue("x-duration");
            Thread thread = Thread.currentThread();
            if (thread instanceof VHostWorkerThread) {
                ((VHostWorkerThread)thread).updateLoggingValues(string2, iMediaStream);
            } else {
                Server.getInstance().updateLoggingDuration();
            }
            if (iMediaStream != null) {
                iMediaStream.updateLoggingValues();
                if (string2.equals("stream")) {
                    iMediaStream.updateLoggingDuration();
                }
            }
            if (WMSLoggerFactory.getGlobalLogValue("x-duration") == null) {
                Server.getInstance().updateLoggingDuration();
            }
        }
        catch (Exception exception) {
            System.out.println("Logging error: " + exception.toString());
            exception.printStackTrace();
        }
    }

    private void tearDownLogging(Level level, String string, IMediaStream iMediaStream, String string2, String string3, int n, String string4) {
        try {
            if (iMediaStream != null) {
                iMediaStream.clearLoggingValues();
            }
            WMSLoggerFactory.removeGlobalLogValue("x-severity");
            WMSLoggerFactory.removeGlobalLogValue("x-status");
            WMSLoggerFactory.removeGlobalLogValue("x-comment");
            WMSLoggerFactory.removeGlobalLogValue("x-category");
            WMSLoggerFactory.removeGlobalLogValue("x-event");
            WMSLoggerFactory.removeGlobalLogValue("x-ctx");
            WMSLoggerFactory.removeGlobalLogValue("x-ctx-override");
        }
        catch (Exception exception) {
            System.out.println("Logging error: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public boolean isWarnEnabled() {
        return this.isEnabledFor((Priority)Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this.isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isTraceEnabled() {
        return this.isEnabledFor((Priority)Level.TRACE);
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor((Priority)Level.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.isEnabledFor((Priority)Level.INFO);
    }

    public boolean isEnabledFor(Priority priority) {
        boolean bl = false;
        bl = this.tmpLogger != null ? this.tmpLogger.isEnabledFor(priority) : super.isEnabledFor(priority);
        return bl;
    }

    public void log(Level level, String string, IMediaStream iMediaStream, String string2, String string3, int n, String string4) {
        if (!this.isEnabledFor((Priority)level)) {
            return;
        }
        this.setupLogging(level, string, iMediaStream, string2, string3, n, string4);
        if (Server.logNotifier != null) {
            Server.logNotifier.onLog(level, string, iMediaStream, string2, string3, n, string4);
        }
        if (this.tmpLogger != null) {
            this.tmpLogger.log((Priority)level, (Object)string);
        } else {
            super.log((Priority)level, (Object)string);
        }
        this.tearDownLogging(level, string, iMediaStream, string2, string3, n, string4);
    }

    public void log(Level level, String string, IMediaStream iMediaStream, String string2, String string3) {
        this.log(level, string, iMediaStream, string2, string3, this.levelToStatus(level), null);
    }

    public void log(Level level, String string, String string2, String string3) {
        this.log(level, string, null, string2, string3, this.levelToStatus(level), null);
    }

    public void log(Level level, String string) {
        this.log(level, string, null, "server", "comment", this.levelToStatus(level), null);
    }

    public void log(Level level, String string, IMediaStream iMediaStream) {
        this.log(level, string, iMediaStream, "server", "comment", this.levelToStatus(level), null);
    }

    public void info(String string) {
        this.log(Level.INFO, string, null, "server", "comment", 200, null);
    }

    public void info(String string, IMediaStream iMediaStream) {
        this.log(Level.INFO, string, iMediaStream, "server", "comment", 200, null);
    }

    public void info(String string, String string2, String string3) {
        this.log(Level.INFO, string, null, string2, string3, 200, null);
    }

    public void info(String string, String string2, String string3, int n, String string4) {
        this.log(Level.INFO, string, null, string2, string3, n, string4);
    }

    public void info(String string, IMediaStream iMediaStream, String string2, String string3, int n, String string4) {
        this.log(Level.INFO, string, iMediaStream, string2, string3, n, string4);
    }

    public void error(String string) {
        this.log(Level.ERROR, string, null, "server", "comment", 500, null);
    }

    public void error(String string, IMediaStream iMediaStream) {
        this.log(Level.ERROR, string, iMediaStream, "server", "comment", 500, null);
    }

    public void error(String string, String string2, String string3) {
        this.log(Level.ERROR, string, null, string2, string3, 500, null);
    }

    public void error(String string, String string2, String string3, int n, String string4) {
        this.log(Level.ERROR, string, null, string2, string3, n, string4);
    }

    public void error(String string, IMediaStream iMediaStream, String string2, String string3, int n, String string4) {
        this.log(Level.ERROR, string, iMediaStream, string2, string3, n, string4);
    }

    public void fatal(String string) {
        this.log(Level.FATAL, string, null, "server", "comment", 500, null);
    }

    public void fatal(String string, IMediaStream iMediaStream) {
        this.log(Level.FATAL, string, iMediaStream, "server", "comment", 500, null);
    }

    public void fatal(String string, String string2, String string3) {
        this.log(Level.FATAL, string, null, string2, string3, 500, null);
    }

    public void fatal(String string, String string2, String string3, int n, String string4) {
        this.log(Level.FATAL, string, null, string2, string3, n, string4);
    }

    public void fatal(String string, IMediaStream iMediaStream, String string2, String string3, int n, String string4) {
        this.log(Level.FATAL, string, iMediaStream, string2, string3, n, string4);
    }

    public void debug(String string) {
        this.log(Level.DEBUG, string, null, "server", "comment", 200, null);
    }

    public void debug(String string, IMediaStream iMediaStream) {
        this.log(Level.DEBUG, string, iMediaStream, "server", "comment", 200, null);
    }

    public void debug(String string, String string2, String string3) {
        this.log(Level.DEBUG, string, null, string2, string3, 200, null);
    }

    public void debug(String string, String string2, String string3, int n, String string4) {
        this.log(Level.DEBUG, string, null, string2, string3, n, string4);
    }

    public void debug(String string, IMediaStream iMediaStream, String string2, String string3, int n, String string4) {
        this.log(Level.DEBUG, string, iMediaStream, string2, string3, n, string4);
    }

    public void warn(String string) {
        this.log(Level.WARN, string, null, "server", "comment", 200, null);
    }

    public void warn(String string, IMediaStream iMediaStream) {
        this.log(Level.WARN, string, iMediaStream, "server", "comment", 200, null);
    }

    public void warn(String string, String string2, String string3) {
        this.log(Level.WARN, string, null, string2, string3, 200, null);
    }

    public void warn(String string, String string2, String string3, int n, String string4) {
        this.log(Level.WARN, string, null, string2, string3, n, string4);
    }

    public void warn(String string, IMediaStream iMediaStream, String string2, String string3, int n, String string4) {
        this.log(Level.WARN, string, iMediaStream, string2, string3, n, string4);
    }
}

