/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster.rtp;

import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCaster;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.rtp.IRTPSessionDescriptionDataProvider;
import com.wowza.wms.mediacaster.rtp.IRTPSessionDescriptionSessionHandler;
import com.wowza.wms.mediacaster.rtp.RTPSessionDescriptionData;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPSessions;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.IMediaStreamTimecodeControl;
import com.wowza.wms.util.ModuleUtils;
import com.wowza.wms.util.RTPUtils;
import com.wowza.wms.vhost.IVHost;
import java.util.List;
import org.apache.mina.common.IoSession;

public class RTPMediaCaster
extends MediaCaster {
    private boolean isReconnectorRunning = false;
    private String streamName = null;
    private boolean tryConnect = false;
    private RTPSession rtpSession = null;
    private IRTPSessionDescriptionDataProvider rtpSessionDescriptionDataProvider = null;
    private IRTPSessionDescriptionSessionHandler rtpSessionDescriptionSessionHandler = new RTPSessionDescriptionSessionHandler();
    private String rtpSessionDescriptionDataProviderClass = "com.wowza.wms.mediacaster.rtp.RTPSessionDescriptionDataProviderBasic";
    private boolean portWarning = true;
    private int reconnectCount = 0;

    public RTPMediaCaster() {
        this.mediaCasterType = 3;
        WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.create[" + this.hashCode() + "]");
    }

    public void init(MediaCasterStreamItem mediaCasterStreamItem, MediaCasterItem mediaCasterItem, IApplicationInstance iApplicationInstance, String string, String string2) {
        super.init(mediaCasterStreamItem, mediaCasterItem, iApplicationInstance, string, string2);
        WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.init[" + this.hashCode() + "]");
        this.streamTimeout = this.getProperties().getPropertyInt("streamTimeout", this.streamTimeout);
        this.rtpSessionDescriptionDataProviderClass = this.getProperties().getPropertyStr("rtpSessionDescriptionDataProviderClass", this.rtpSessionDescriptionDataProviderClass);
        this.instantiateRTPSessionDescriptionDataProvider();
        this.streamName = string;
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instantiateRTPSessionDescriptionDataProvider() {
        block5: {
            try {
                Class<?> clazz = Class.forName(this.rtpSessionDescriptionDataProviderClass);
                if (clazz == null) break block5;
                Object object = this.lock;
                synchronized (object) {
                    this.rtpSessionDescriptionDataProvider = (IRTPSessionDescriptionDataProvider)clazz.newInstance();
                    this.rtpSessionDescriptionDataProvider.init(this);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPMediaCaster.class).error("RTPMediaCaster.instantiateRTPSessionDescriptionDataProvider (" + this.rtpSessionDescriptionDataProviderClass + "): " + exception.toString());
            }
        }
    }

    public RTPSessionDescriptionData getStreamInfo(String string, int n) {
        if (this.rtpSessionDescriptionDataProvider != null) {
            return this.rtpSessionDescriptionDataProvider.getSessionDescriptionData(this.getAppInstance(), string, n, this.rtpSessionDescriptionSessionHandler, this);
        }
        return null;
    }

    public void onSessionStart(RTPSession rTPSession) {
        if (this.rtpSessionDescriptionDataProvider != null) {
            this.rtpSessionDescriptionDataProvider.sessionStart(rTPSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void openRTPSession(RTPSessionDescriptionData var1_1) {
        var2_2 = this.lock;
        synchronized (var2_2) {
            if (this.rtpSession != null) {
                this.closeRTPSession();
            }
            var3_3 = var1_1.getSessionDescriptionData();
            var4_4 = this.getAppInstance();
            var5_5 = var4_4.getVHost();
            var6_6 = var5_5.getRTPContext();
            var7_7 = var6_6.getSessions();
            var8_8 = var7_7.getNextSessionId();
            var9_9 = var4_4.getApplication().getName() + "/" + var4_4.getName() + "/" + this.streamName;
            var10_10 = RTPUtils.decodeStreamInfo(var6_6, var9_9, var3_3);
            if (var1_1.isPortsNegotiated()) ** GOTO lbl50
            var11_11 = true;
            var12_13 = var10_10.getTrackNames();
            var13_14 = var12_13.iterator();
            while (var13_14.hasNext()) {
                var14_15 /* !! */  = var13_14.next();
                var15_16 = var10_10.getTrack((String)var14_15 /* !! */ );
                if (var15_16 == null) continue;
                var16_17 = var15_16.getRTPInPortNum();
                var17_19 = var15_16.getRTCPInPortNum();
                var18_21 = true;
                var19_24 = true;
                if (var16_17 > 0) {
                    var18_21 = var4_4.isRTPIncomingDatagramPortValid(var16_17);
                }
                if (var15_16.isRTCP() && var17_19 > 0) {
                    var19_24 = var4_4.isRTPIncomingDatagramPortValid(var17_19);
                }
                if (!var18_21) {
                    if (this.portWarning) {
                        WMSLoggerFactory.getLogger(RTPMediaCaster.class).warn("RTPMediaCaster.openRTPSession[" + var9_9 + "]: RTP Incoming port is not valid [rtp]: " + var16_17);
                    }
                    var11_11 = false;
                }
                if (var19_24) continue;
                if (this.portWarning) {
                    WMSLoggerFactory.getLogger(RTPMediaCaster.class).warn("RTPMediaCaster.openRTPSession[" + var9_9 + "]: RTP Incoming port is not valid [rtcp]: " + var17_19);
                }
                var11_11 = false;
            }
            if (!var11_11) {
                this.portWarning = false;
            } else {
                var13_14 = var12_13.iterator();
                while (var13_14.hasNext()) {
                    var14_15 /* !! */  = var13_14.next();
                    var15_16 = var10_10.getTrack((String)var14_15 /* !! */ );
                    if (var15_16 == null || (var16_17 = var15_16.getRTPInPortNum()) <= 0) continue;
                    var6_6.acquireUDPPortPair(var16_17);
                }
lbl50:
                // 2 sources

                var11_12 = new RTPSession(var8_8);
                var7_7.addSession(var11_12);
                var10_10.setMode(2);
                var11_12.addRTSPStream(var10_10);
                var11_12.setAppInstance(var4_4);
                var10_10.setAppName(var4_4.getApplication().getName());
                var10_10.setAppInstanceName(var4_4.getName());
                var12_13 = this.streamName;
                var13_14 = this.mediaCasterStreamItem.getStreamExt();
                var14_15 /* !! */  = ModuleUtils.decodeStreamExtension((String)var12_13, (String)var13_14);
                var12_13 = var14_15 /* !! */ [0];
                var13_14 = var14_15 /* !! */ [1];
                var10_10.setStreamName((String)var12_13);
                var10_10.setStreamNameLogging((String)var12_13);
                var10_10.setStreamExt((String)var13_14);
                var10_10.setStreamType(this.mediaCasterDef.getStreamType());
                var10_10.setCheckSSRC(false);
                var10_10.setCheckIpAddr(true);
                var7_7.notifySessionCreate(var4_4, var11_12);
                var15_16 = new RTPRequestStatus();
                var10_10.announce((RTPRequestStatus)var15_16);
                if (!var10_10.streamExists()) {
                    var10_10.createStream((RTPRequestStatus)var15_16);
                }
                if (var10_10.streamExists()) {
                    this.setStream(var10_10.getStream());
                    var16_18 = var10_10.getTrackNames();
                    for (String var18_23 : var16_18) {
                        var19_26 = var10_10.getTrack(var18_23);
                        if (var19_26 == null) continue;
                        var19_26.setup((RTPRequestStatus)var15_16, null);
                    }
                    var10_10.record((RTPRequestStatus)var15_16);
                    var10_10.getMetadataPacket();
                    this.rtpSession = var11_12;
                    this.onSessionStart(var11_12);
                }
            }
            if (this.rtpSession == null) {
                var7_7.removeSession(var8_8);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRTPSession() {
        WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.closeRTPSession[" + this.hashCode() + ":" + this.appInstance.getContextStr() + ":" + this.streamName + "]");
        Object object = this.lock;
        synchronized (object) {
            if (this.rtpSessionDescriptionDataProvider != null) {
                this.rtpSessionDescriptionDataProvider.sessionStop(this.rtpSession);
            }
            if (this.rtpSession != null) {
                IApplicationInstance iApplicationInstance = this.getAppInstance();
                IVHost iVHost = iApplicationInstance.getVHost();
                RTPContext rTPContext = iVHost.getRTPContext();
                RTPSessions rTPSessions = rTPContext.getSessions();
                RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
                rTPSessions.notifySessionDestroy(iApplicationInstance, this.rtpSession);
                this.rtpSession.shutdown(rTPRequestStatus);
                rTPSessions.removeSession(this.rtpSession);
                IMediaStream iMediaStream = this.getStream();
                if (iMediaStream != null) {
                    iApplicationInstance.getStreams().removeLiveStreamPacketizer(iMediaStream.getName());
                }
                this.setStream(null);
            }
            this.rtpSession = null;
            this.streamMissingTime = -1L;
            this.streamLastSeq = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect() {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            this.tryConnect = true;
            bl = true;
            this.tryToConnect();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToConnect() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isReconnectorRunning) {
                this.isReconnectorRunning = true;
                this.getAppInstance().getVHost().getThreadPool().execute(new Reconnector(this));
            }
        }
    }

    public void registerPlayer(IMediaStreamPlay iMediaStreamPlay) {
    }

    public void unregisterPlayer(IMediaStreamPlay iMediaStreamPlay) {
    }

    public void sessionOpened(IoSession ioSession) {
        WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.sessionOpened: NEVER GET HERE");
    }

    public void sessionClosed(IoSession ioSession) {
        WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.sessionClosed: NEVER GET HERE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.disconnect[" + this.hashCode() + ":" + this.appInstance.getContextStr() + ":" + this.streamName + "]");
            this.tryConnect = false;
            this.closeRTPSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceReset() {
        Object object = this.lock;
        synchronized (object) {
            WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.resetConnection[" + this.hashCode() + ":" + this.appInstance.getContextStr() + ":" + this.streamName + "]: ");
            this.closeRTPSession();
            this.tryToConnect();
        }
    }

    public void resetStreamTimecodes() {
        IMediaStream iMediaStream = this.getStream();
        if (iMediaStream != null) {
            if (iMediaStream instanceof IMediaStreamTimecodeControl) {
                WMSLoggerFactory.getLogger(RTPMediaCaster.class).debug("RTPMediaCaster.resetStreamTimecodes: ");
                ((IMediaStreamTimecodeControl)((Object)iMediaStream)).resetTimecodes();
            } else {
                WMSLoggerFactory.getLogger(RTPMediaCaster.class).warn("RTPMediaCaster.resetStreamTimecodes: missing interface IMediaStreamTimecodeControl");
            }
        }
    }

    public void shutdown(boolean bl) {
        WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.shutdown[" + this.hashCode() + ":" + this.appInstance.getContextStr() + ":" + this.streamName + "]: " + this.streamName);
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWatchdog() {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.rtpSessionDescriptionDataProvider != null) {
                bl = this.rtpSessionDescriptionDataProvider.doIdle(this);
            }
        }
        boolean bl2 = this.validateMediaCaster();
        if (bl2) {
            boolean bl3 = false;
            int n = 0;
            long l = System.currentTimeMillis();
            if (!bl) {
                if (this.streamTimeout <= 0) {
                    n = 1;
                } else {
                    Object object2 = this.lock;
                    synchronized (object2) {
                        if (this.isReconnectorRunning) {
                            n = 5;
                        } else if (this.rtpSession == null) {
                            n = 6;
                        } else {
                            IMediaStream iMediaStream = this.getStream();
                            if (iMediaStream == null) {
                                n = 4;
                            } else {
                                n = 100;
                                List<AMFPacket> list = iMediaStream.getPlayPackets();
                                boolean bl4 = false;
                                if (list.size() == 0) {
                                    bl4 = true;
                                } else {
                                    AMFPacket aMFPacket = list.get(list.size() - 1);
                                    long l2 = aMFPacket.getSeq();
                                    if (l2 != this.streamLastSeq) {
                                        this.streamLastSeq = l2;
                                    } else {
                                        bl4 = true;
                                    }
                                }
                                if (bl4) {
                                    n = 101;
                                    if (this.streamMissingTime == -1L) {
                                        this.streamMissingTime = l;
                                    } else if (l - this.streamMissingTime > (long)this.streamTimeout) {
                                        bl3 = true;
                                    }
                                } else {
                                    this.streamMissingTime = -1L;
                                }
                                if (bl3) {
                                    if (this.resetMediaCaster()) {
                                        this.setStreamRunning(false);
                                        this.setStreamTimeoutLastReset(l);
                                        this.forceReset();
                                    }
                                } else if (!bl4) {
                                    this.setStreamRunning(true);
                                }
                            }
                        }
                    }
                }
            }
            this.setStreamTimeoutReason(n);
            this.setStreamTimeoutLastTime(l);
        }
        return false;
    }

    class RTPSessionDescriptionSessionHandler
    implements IRTPSessionDescriptionSessionHandler {
        RTPSessionDescriptionSessionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDisconnect() {
            Object object = RTPMediaCaster.this.lock;
            synchronized (object) {
                if (RTPMediaCaster.this.tryConnect) {
                    RTPMediaCaster.this.forceReset();
                }
            }
        }
    }

    class Reconnector
    implements Runnable {
        private RTPMediaCaster rtpMediaCaster = null;

        public Reconnector(RTPMediaCaster rTPMediaCaster2) {
            this.rtpMediaCaster = rTPMediaCaster2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            int n = 0;
            Object object = RTPMediaCaster.this.lock;
            synchronized (object) {
                RTPMediaCaster.this.reconnectCount++;
                n = RTPMediaCaster.this.reconnectCount;
            }
            WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.Reconnector[" + this.rtpMediaCaster.hashCode() + ":" + RTPMediaCaster.this.appInstance.getContextStr() + ":" + RTPMediaCaster.this.streamName + "]: start: " + n);
            try {
                int n2 = 0;
                RTPMediaCaster.this.resetStreamTimecodes();
                RTPMediaCaster.this.setStreamRunning(false);
                while (true) {
                    long l = System.currentTimeMillis();
                    int n3 = Math.max(RTPMediaCaster.this.getReconnectDelay(l), 100);
                    WMSLoggerFactory.getLogger(null).debug("RTPMediaCaster#Reconnector.run: reconnectDelay: " + n3);
                    if (n3 > 0) {
                        Thread.sleep(n3);
                    }
                    l = System.currentTimeMillis();
                    RTPMediaCaster.this.setConnectLastAttempt(l);
                    RTPMediaCaster.this.resetStreamTimeout();
                    Object object2 = RTPMediaCaster.this.lock;
                    synchronized (object2) {
                        if (this.rtpMediaCaster == null || !RTPMediaCaster.this.tryConnect) {
                            RTPMediaCaster.this.isReconnectorRunning = false;
                            break;
                        }
                        ((ApplicationInstance)RTPMediaCaster.this.appInstance).notifyMediaCasterConnectStart(this.rtpMediaCaster);
                        RTPSessionDescriptionData rTPSessionDescriptionData = RTPMediaCaster.this.getStreamInfo(RTPMediaCaster.this.streamName, n2);
                        if (rTPSessionDescriptionData.isValid()) {
                            RTPMediaCaster.this.openRTPSession(rTPSessionDescriptionData);
                        }
                        ++n2;
                        if (RTPMediaCaster.this.rtpSession != null) {
                            RTPMediaCaster.this.setConnectLastSuccess(l);
                            RTPMediaCaster.this.isReconnectorRunning = false;
                            ((ApplicationInstance)RTPMediaCaster.this.appInstance).notifyMediaCasterConnectSuccess(this.rtpMediaCaster);
                            RTPMediaCaster.this.portWarning = true;
                            break;
                        }
                        ((ApplicationInstance)RTPMediaCaster.this.appInstance).notifyMediaCasterConnectFailure(this.rtpMediaCaster);
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPMediaCaster.class).error("RTPMediaCaster.Reconnector: " + exception.toString());
                exception.printStackTrace();
            }
            WMSLoggerFactory.getLogger(RTPMediaCaster.class).info("RTPMediaCaster.Reconnector[" + this.rtpMediaCaster.hashCode() + ":" + RTPMediaCaster.this.appInstance.getContextStr() + ":" + RTPMediaCaster.this.streamName + "]: done: " + n);
        }
    }
}

