/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.util.RolloverLong;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.IRTPTimecodeProvider;
import com.wowza.wms.rtp.depacketizer.RTCPEventHandlerGeneric;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerVideoBase;
import com.wowza.wms.rtp.depacketizer.RTPPacket;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPSequence;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPTrack;
import java.net.SocketAddress;

public class RTPDePacketizerScreenCodec
extends RTPDePacketizerVideoBase
implements IRTPDePacketizer,
IRTPTimecodeProvider {
    private RTPSequence seq = new RTPSequence();
    private long lastTimecode = -1L;
    private RTCPEventHandlerGeneric rtcpEventHandler = new RTCPEventHandlerGeneric();
    private RolloverLong timecode = new RolloverLong(32);
    private boolean waitForEnd = false;
    private RTPPacket workingPacket = null;
    private long lastSeq = -1L;
    private boolean waitForStart = true;

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        super.init(rTPContext, rTPDePacketizerItem);
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerScreenCodec.init");
        }
    }

    public boolean canHandle(RTPTrack rTPTrack) {
        String string;
        return rTPTrack.isVideo() && (string = rTPTrack.getSampleType()) != null && string.toLowerCase().startsWith("x-screencodec");
    }

    public void handleRTCPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtcp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTCPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.rtcpHandler.handleRTCPPacket(socketAddress, rTPTrack, byArray, n, n2);
    }

    private void resetWorking() {
        this.workingPacket = null;
    }

    private RTPPacket getWorkingPacket(long l, int n, int n2) {
        if (this.workingPacket == null) {
            this.workingPacket = new RTPPacket();
            this.workingPacket.setType(9);
            this.workingPacket.setCodec(n == 0 ? 3 : 6);
            this.workingPacket.setFrameType(n2);
            this.workingPacket.setTimecode(l);
        }
        return this.workingPacket;
    }

    public void handleRTPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.seq.handleRTPPacket(rTPTrack, byArray, n, n2);
        long l = BufferUtils.byteArrayToLong(byArray, n + 4, 4);
        this.timecode.set(l);
        int n4 = rTPTrack.getTimescale();
        try {
            int n5 = this.skipRTPExtensions(byArray, n, n2, 12);
            int n6 = 0;
            boolean bl = (byArray[n + n5 + n6] & 0x40) == 64;
            boolean bl2 = (byArray[n + n5 + n6] & 0x20) == 32;
            int n7 = byArray[n + n5 + n6] >> 3 & 3;
            int n8 = byArray[n + n5 + n6] >> 1 & 3;
            n6 += 2;
            this.setVideoCodecId(rTPTrack, n8 == 0 ? 3 : 6);
            RTPPacket rTPPacket = null;
            if (this.lastSeq == -1L || this.lastSeq + 1L != this.seq.longValue()) {
                this.waitForStart = true;
            }
            if (this.waitForStart && bl) {
                this.waitForStart = false;
            }
            if (this.waitForStart) {
                this.resetWorking();
            } else {
                rTPPacket = this.getWorkingPacket(this.timecode.get(), n8, n7);
                RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(byArray, n + n5 + n6, n2 - (n5 + n6));
                rTPPacket.addFragment(rTPPacketFragment);
            }
            if (rTPPacket != null && bl2) {
                boolean bl3 = this.rtcpHandler.isTimeSyncReady(rTPTrack, rTPPacket.getTimecode());
                if (!bl3) {
                    this.resetWorking();
                    if (!bl3) {
                        this.checkRTCPMissingWarning();
                    }
                } else {
                    long l2 = this.rtcpHandler.convertTimeSyncTimecode(this.timecode.get(), n4);
                    if (this.debugLog) {
                        rTPPacket.setDebugLog(true);
                    }
                    rTPPacket.write(rTPTrack, l2);
                    this.resetWorking();
                }
            }
            this.lastSeq = this.seq.longValue();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("RTPDePacketizerScreenCodec.handleRTPPacket: " + exception.toString());
        }
    }

    public void startup(RTPTrack rTPTrack) {
        this.waitForEnd = rTPTrack.isWaitForFirstEnd();
        this.rtcpEventHandler.setTimecodeProvider(this);
        this.rtcpHandler.addEventListener(this.rtcpEventHandler);
        this.setupAppInstanceRTCPEventHandler(this, this.rtcpHandler, rTPTrack);
    }

    public void shutdown(RTPTrack rTPTrack) {
    }

    public long getAdjTimecode(RTPTrack rTPTrack) {
        if (this.lastTimecode != -1L && this.rtcpHandler.isTimeSyncReady(rTPTrack, this.lastTimecode)) {
            long l = this.rtcpHandler.convertTimeSyncTimecode(this.lastTimecode, rTPTrack.getTimescale());
            return l;
        }
        return -1L;
    }
}

