/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.util.SystemUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.model.HTTPStreamerSessionBase;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264CodecConfigParts;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterList;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.module.ModuleFunctions;
import com.wowza.wms.rtp.model.IRTPMetadataProvider;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPDescribeInfo;
import com.wowza.wms.rtp.model.RTPPacketizerItem;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPStreamPlayResult;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.transport.IUDPTransport;
import com.wowza.wms.rtp.transport.RTPMulticastTransport;
import com.wowza.wms.rtp.transport.RTPUDPTransportMina;
import com.wowza.wms.rtsp.RTSPCore;
import com.wowza.wms.rtsp.RTSPRequestAdapter;
import com.wowza.wms.rtsp.RTSPStatics;
import com.wowza.wms.rtsp.RTSPTunnelingSession;
import com.wowza.wms.server.RtmpResponseMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaReaderFactory;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.PlaylistSeekResult;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.stream.rtp.MediaStreamRTPPlay;
import com.wowza.wms.stream.rtp.RTPPlayer;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.VHost;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.IoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPStream {
    public static final int SDPLOCATION_STREAM = 0;
    public static final int SDPLOCATION_AUDIO = 1;
    public static final int SDPLOCATION_VIDEO = 2;
    public static final int MODE_UNKNOWN = 0;
    public static final int MODE_PLAY = 1;
    public static final int MODE_PUBLISH = 2;
    public static final int AVSYNCMETHODS_UNKNOWN = 0;
    public static final int AVSYNCMETHODS_SENDERREPORT = 1;
    public static final int AVSYNCMETHODS_SYSTEMCLOCK = 2;
    public static final int AVSYNCMETHODS_RTPTIMECODE = 3;
    public static final String STREAMINFO_SESSIONPROTOCOLVERSION = "protocolversion";
    public static final String STREAMINFO_SESSIONPORIGIN = "origin";
    public static final String STREAMINFO_SESSIONNAME = "name";
    public static final String STREAMINFO_SESSIONINFORMATION = "information";
    public static final String STREAMINFO_SESSIONURI = "uri";
    public static final String STREAMINFO_SESSIONEMAILADDRESS = "emailaddress";
    public static final String STREAMINFO_SESSIONPHONENUMBER = "phonenumber";
    public static final String STREAMINFO_SESSIONCONNECTIONDATA = "connectiondata";
    public static final String STREAMINFO_SESSIONBANDWIDTH = "bandwidth";
    public static final String STREAMINFO_SESSIONTIMING = "timing";
    public static final String STREAMINFO_SESSIONREPEATTIMES = "repeattimes";
    public static final String STREAMINFO_SESSIONTIMEZONES = "timezones";
    public static final String STREAMINFO_SESSIONATTRIBUTES = "attributes";
    private Map<String, RTPTrack> tracks = new HashMap<String, RTPTrack>();
    private Map<String, RTPTrack> tracksInternal = new HashMap<String, RTPTrack>();
    private Map<String, String> seqToTrackId = new HashMap<String, String>();
    private RTPSession session = null;
    private RTPContext context = null;
    private IMediaStream stream = null;
    private String streamId = null;
    private Object streamLock = new Object();
    private boolean resyncAudioVideoOnSR = false;
    private Map<String, String> streamInfo = new HashMap<String, String>();
    private Map<String, String> streamAttributes = new HashMap<String, String>();
    private boolean sentMetadata = false;
    private String streamType = null;
    private String host = null;
    private String outHost = null;
    private String appName = "_defapp_";
    private String appInstanceName = "_definst_";
    private String streamName = "unknown";
    private String streamNameLogging = "unknown";
    private String streamExt = "mp4";
    private String streamQueryStr = "";
    private String rtspBindIpAddress = null;
    private String rtspConnectionIpAddress = "0.0.0.0";
    private String rtspConnectionAddressType = "IP4";
    private String rtspOriginIpAddress = "127.0.0.1";
    private String rtspOriginAddressType = "IP4";
    private boolean rtspAlwaysUseSDPPorts = false;
    private long streamSessionId = -1L;
    private long streamSessionVersion = -1L;
    private String streamSessionIp = null;
    private boolean checkSSRC = true;
    private boolean checkIpAddr = false;
    private IUDPTransport udpTransport = null;
    private int avSyncMethod = 1;
    private int maxRTCPWaitTime = 10000;
    private int mpegtsVideoPID = -1;
    private int mpegtsAudioPID = -1;
    private boolean isRTSP = false;
    private int mode = 0;
    private String transportMode = null;
    private long createTime = System.currentTimeMillis();
    private long ntpRTOffset = -1L;
    private List<String> repeaterStreams = new ArrayList<String>();
    private List<MediaCasterStreamItem> repeaterStreamItems = new ArrayList<MediaCasterStreamItem>();
    private boolean repeaterStreamsLocked = false;
    private boolean appInstancePropsInited = false;
    private int streamReadyTimeout = 10000;
    private String rtpMetadataProviderPath = null;
    private boolean isForceMPEGTSOut = false;
    private boolean isMPEGTSOut = false;
    private boolean isForceRTSPInterleaved = false;
    private boolean isMediaCasterAudio = true;
    private boolean isMediaCasterVideo = true;
    private String rtspSessionName = "WowzaMediaServer";
    private String rtspSessionDescription = null;
    private List<RTSPExtraLine> rtspSessionExtraLines = new ArrayList<RTSPExtraLine>();
    private boolean sendSDESEvents = true;
    private int autoAllocateInterleavePorts = 0;
    private boolean isLive = false;
    private IMediaReader mediaReader = null;
    private boolean enableRTSPVOD = true;
    private int rtspSessionTimeout = 90000;
    private int rtspMaximumPendingWriteBytes = 0;
    private long touchCount = 0L;
    private Object touchObj = new Object();
    private long lastTimeoutCount = -1L;
    private long lastTimeoutTimecode = -1L;
    private boolean isPaused = true;
    private boolean doResetPlayStream = false;
    private boolean isStreamStarted = false;
    private long vodStartTimeTC = 0L;
    private long vodLastTimeTC = 0L;
    private long vodPlayLen = 0L;
    private IOPerformanceCounter streamIOPerformance = null;

    public RTPStream(RTPContext rTPContext, String string) {
        this.context = rTPContext;
        this.streamId = string;
    }

    public RTPContext getRTPContext() {
        return this.context;
    }

    public Object getStreamLock() {
        return this.streamLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrack(RTPTrack rTPTrack) {
        Object object = this.streamLock;
        synchronized (object) {
            rTPTrack.setStream(this);
            this.tracks.put(rTPTrack.getTrackId(), rTPTrack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTrack removeTrack(String string) {
        RTPTrack rTPTrack = null;
        Object object = this.streamLock;
        synchronized (object) {
            rTPTrack = this.tracks.remove(string);
        }
        return rTPTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrackInternal(RTPTrack rTPTrack) {
        Object object = this.streamLock;
        synchronized (object) {
            rTPTrack.setStream(this);
            this.tracksInternal.put(rTPTrack.getTrackId(), rTPTrack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTrack removeTrackInternal(String string) {
        RTPTrack rTPTrack = null;
        Object object = this.streamLock;
        synchronized (object) {
            rTPTrack = this.tracksInternal.remove(string);
        }
        return rTPTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTracks() {
        Object object = this.streamLock;
        synchronized (object) {
            this.tracks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMediaInBytes(long l) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.stream != null) {
                this.stream.incrementMediaInBytes(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTrack sloppyGetTrack(String string) {
        RTPTrack rTPTrack = null;
        Object object = this.streamLock;
        synchronized (object) {
            for (RTPTrack rTPTrack2 : this.tracks.values()) {
                if (string.endsWith(rTPTrack2.getTrackId())) {
                    rTPTrack = rTPTrack2;
                } else if (string.equalsIgnoreCase(rTPTrack2.getTrackId())) {
                    rTPTrack = rTPTrack2;
                }
                if (rTPTrack == null) continue;
                break;
            }
        }
        return rTPTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTrack getTrack(String string) {
        RTPTrack rTPTrack = null;
        Object object = this.streamLock;
        synchronized (object) {
            rTPTrack = this.tracks.get(string);
        }
        return rTPTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrackId(String string, String string2) {
        Object object = this.streamLock;
        synchronized (object) {
            this.seqToTrackId.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTrackId(String string) {
        String string2 = null;
        Object object = this.streamLock;
        synchronized (object) {
            string2 = this.seqToTrackId.get(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTrackNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = this.streamLock;
        synchronized (object) {
            arrayList.addAll(this.tracks.keySet());
        }
        return arrayList;
    }

    public RTPSession getSession() {
        return this.session;
    }

    public void setSession(RTPSession rTPSession) {
        this.session = rTPSession;
    }

    public String getStreamId() {
        return this.streamId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMediaStream getStream() {
        IMediaStream iMediaStream = null;
        Object object = this.streamLock;
        synchronized (object) {
            iMediaStream = this.stream;
        }
        return iMediaStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTrack getAudioTrack() {
        RTPTrack rTPTrack = null;
        Object object = this.streamLock;
        synchronized (object) {
            for (RTPTrack rTPTrack2 : this.tracks.values()) {
                if (!rTPTrack2.isAudio()) continue;
                return rTPTrack2;
            }
        }
        return rTPTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTrack getVideoTrack() {
        RTPTrack rTPTrack = null;
        Object object = this.streamLock;
        synchronized (object) {
            for (RTPTrack rTPTrack2 : this.tracks.values()) {
                if (!rTPTrack2.isVideo()) continue;
                return rTPTrack2;
            }
        }
        return rTPTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTrack getStreamTrack() {
        RTPTrack rTPTrack = null;
        Object object = this.streamLock;
        synchronized (object) {
            for (RTPTrack rTPTrack2 : this.tracks.values()) {
                if (!rTPTrack2.isStreamTrack()) continue;
                return rTPTrack2;
            }
        }
        return rTPTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamInfo(String string, String string2) {
        Object object = this.streamLock;
        synchronized (object) {
            this.streamInfo.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStreamInfo(String string) {
        String string2 = null;
        Object object = this.streamLock;
        synchronized (object) {
            string2 = this.streamInfo.get(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamAttribute(String string, String string2) {
        Object object = this.streamLock;
        synchronized (object) {
            this.streamAttributes.put(string, string2);
        }
    }

    public IVHost getVHost() {
        return this.session.getVHost();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public boolean streamExists() {
        return this.stream != null;
    }

    public boolean isPublishStreamReady() {
        boolean bl;
        block1: {
            IMediaStream iMediaStream;
            block3: {
                boolean bl2;
                IApplicationInstance iApplicationInstance;
                block2: {
                    block0: {
                        bl = false;
                        String string = this.getMediaCasterType();
                        if (string != null) break block0;
                        bl = true;
                        break block1;
                    }
                    iApplicationInstance = this.getAppInstance();
                    if (iApplicationInstance == null) break block1;
                    bl2 = this.isLive();
                    if (bl2) break block2;
                    bl = true;
                    break block1;
                }
                iMediaStream = null;
                IMediaReader iMediaReader = null;
                if (!bl2 ? (iMediaReader = this.mediaReader) == null : (iMediaStream = iApplicationInstance.getStreams().getStream(this.getStreamName())) == null) break block1;
                if (this.streamReadyTimeout <= 0 || iMediaStream.getElapsedTime().getTime() <= (long)this.streamReadyTimeout) break block3;
                bl = true;
                break block1;
            }
            if (!iMediaStream.isPublishStreamReady(this.isMediaCasterAudio, this.isMediaCasterVideo)) break block1;
            AMFPacket[] aMFPacketArray = this.getLastPacketsByType(iMediaStream);
            AMFPacket aMFPacket = aMFPacketArray[0];
            AMFPacket aMFPacket2 = aMFPacketArray[1];
            bl = !(this.isMediaCasterAudio && aMFPacket == null || this.isMediaCasterVideo && aMFPacket2 == null);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockRepeaterStreams(List<String> list) {
        List<String> list2 = this.repeaterStreams;
        synchronized (list2) {
            if (!this.repeaterStreamsLocked) {
                this.repeaterStreamsLocked = true;
                String string = this.getMediaCasterType();
                if (string != null) {
                    IApplicationInstance iApplicationInstance = this.getAppInstance();
                    IVHost iVHost = iApplicationInstance.getVHost();
                    MediaCasterStreamMap mediaCasterStreamMap = iApplicationInstance.getMediaCasterStreams();
                    MediaCasterList mediaCasterList = iVHost.getMediaCasterList();
                    MediaCasterItem mediaCasterItem = mediaCasterList.getMediaCasterDef(string);
                    boolean bl = false;
                    bl = mediaCasterItem.getProperties().getPropertyBoolean("isLiveRepeater", bl);
                    if (mediaCasterItem == null) {
                        WMSLoggerFactory.getLogger(HTTPStreamerSessionBase.class).warn("HTTPStreamerSessionBase.lockRepeaterStreams: MediaCaster type not found: " + string);
                    } else {
                        this.isMediaCasterAudio = mediaCasterItem.getProperties().getPropertyBoolean("isMediaCasterAudio", this.isMediaCasterAudio);
                        this.isMediaCasterAudio = iApplicationInstance.getMediaCasterProperties().getPropertyBoolean("isMediaCasterAudio", this.isMediaCasterAudio);
                        this.isMediaCasterVideo = mediaCasterItem.getProperties().getPropertyBoolean("isMediaCasterVideo", this.isMediaCasterVideo);
                        this.isMediaCasterVideo = iApplicationInstance.getMediaCasterProperties().getPropertyBoolean("isMediaCasterVideo", this.isMediaCasterVideo);
                        WMSReadWriteLock wMSReadWriteLock = mediaCasterStreamMap.getLock();
                        wMSReadWriteLock.writeLock().lock();
                        try {
                            for (String string2 : list) {
                                MediaCasterStreamItem mediaCasterStreamItem;
                                if (bl) {
                                    string2 = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)iApplicationInstance, null, (String)string2);
                                    this.setStreamName(string2);
                                }
                                if ((mediaCasterStreamItem = mediaCasterStreamMap.acquire(string2, mediaCasterItem)) == null) continue;
                                this.repeaterStreamItems.add(mediaCasterStreamItem);
                            }
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(HTTPStreamerSessionBase.class).error("RTPStream.lockRepeaterStreams: " + exception.toString());
                        }
                        finally {
                            wMSReadWriteLock.writeLock().unlock();
                        }
                        for (String string2 : list) {
                            WMSLoggerFactory.getLogger(HTTPStreamerSessionBase.class).info("RTPStream.lockRepeaterStreams: repeaterLock: " + string2);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockRepeaterStreams() {
        List<String> list = this.repeaterStreams;
        synchronized (list) {
            IApplicationInstance iApplicationInstance;
            if (this.repeaterStreamsLocked && this.repeaterStreamItems.size() > 0 && (iApplicationInstance = this.getAppInstance()) != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                MediaCasterStreamMap mediaCasterStreamMap = iApplicationInstance.getMediaCasterStreams();
                WMSReadWriteLock wMSReadWriteLock = mediaCasterStreamMap.getLock();
                wMSReadWriteLock.writeLock().lock();
                try {
                    for (MediaCasterStreamItem object : this.repeaterStreamItems) {
                        if (object == null) continue;
                        object.release();
                        arrayList.add(object.getMediaCasterId());
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(HTTPStreamerSessionBase.class).error("RTPStream.unlockRepeaterStreams: " + exception.toString());
                }
                finally {
                    wMSReadWriteLock.writeLock().unlock();
                }
                for (String string : arrayList) {
                    WMSLoggerFactory.getLogger(HTTPStreamerSessionBase.class).info("RTPStream.unlockRepeaterStreams: repeaterUnLock: " + string);
                }
            }
        }
    }

    public String getMediaCasterType() {
        String string;
        block2: {
            IVHost iVHost;
            StreamItem streamItem;
            string = null;
            IApplicationInstance iApplicationInstance = this.getAppInstance();
            if (iApplicationInstance == null) break block2;
            String string2 = this.getStreamType();
            if (string2 == null) {
                string2 = iApplicationInstance.getStreamType();
            }
            if ((streamItem = (iVHost = iApplicationInstance.getVHost()).getStreamTypes().getStreamDef(string2)) != null) {
                string = streamItem.getProperties().getPropertyStr("mediaCasterType", string);
                string = iApplicationInstance.getStreamProperties().getPropertyStr("mediaCasterType", string);
            }
        }
        return string;
    }

    private IMediaReader getMediaReader(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, boolean bl) {
        IMediaReader iMediaReader = null;
        try {
            iMediaReader = MediaReaderFactory.getInstance(iApplicationInstance, iApplicationInstance.getVHost().getMediaReaders(), string2);
            if (iMediaReader != null) {
                String string3 = iApplicationInstance.getStreamStoragePath();
                iMediaReader.init(iApplicationInstance, iMediaStream, string2, string3, string);
                if (bl) {
                    iMediaReader.open(string3, string);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.getMediaReader: " + exception.toString());
        }
        return iMediaReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createStream(RTPRequestStatus rTPRequestStatus) {
        boolean bl = false;
        try {
            Object object = this.streamLock;
            synchronized (object) {
                IApplicationInstance iApplicationInstance;
                if (this.stream == null && (iApplicationInstance = this.getAppInstance()) != null) {
                    this.setAVSyncMethod(iApplicationInstance.getRTPAVSyncMethod());
                    this.setMaxRTCPWaitTime(iApplicationInstance.getRTPMaxRTCPWaitTime());
                    MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                    int n = mediaStreamMap.getNextStreamIndex();
                    String string = this.getStreamType();
                    if (string == null) {
                        string = iApplicationInstance.getStreamType();
                    }
                    if (!this.isModePublish()) {
                        string = "rtpout";
                    }
                    this.stream = mediaStreamMap.getStreamClientless(n, string);
                    if (this.stream != null) {
                        this.streamIOPerformance = this.stream.getMediaIOPerformance();
                        this.stream.setRTPStream(this);
                        RTPPlayer rTPPlayer = this.getInternalRTPPlayer();
                        if (rTPPlayer != null) {
                            rTPPlayer.setLock(this.streamLock);
                        }
                        ModuleFunctions moduleFunctions = iApplicationInstance.getModFunctions();
                        moduleFunctions.onStreamCreate(this.stream);
                        mediaStreamMap.notifyMediaStreamCreate(this.stream);
                        WMSLoggerFactory.putGlobalLogValue("x-vhost", iApplicationInstance.getVHost().getName());
                        WMSLoggerFactory.putGlobalLogValue("x-app", iApplicationInstance.getApplication().getName());
                        WMSLoggerFactory.putGlobalLogValue("x-appinst", iApplicationInstance.getName());
                        WMSLoggerFactory.getLogger(null).info(null, this.stream, "stream", "create", 200, "streamType:" + string + " streamIndex:" + n);
                        if (this.enableRTSPVOD && !this.isLive()) {
                            this.mediaReader = this.getMediaReader(iApplicationInstance, this.stream, this.getStreamName(), this.getStreamExt(), true);
                        }
                        bl = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.createStream: " + exception.toString());
            exception.printStackTrace();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(RTPRequestStatus rTPRequestStatus) {
        this.unlockRepeaterStreams();
        try {
            Object object = this.streamLock;
            synchronized (object) {
                for (RTPTrack object2 : this.tracks.values()) {
                    try {
                        object2.shutdown(rTPRequestStatus);
                    }
                    catch (Exception mediaStreamMap) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.shutdown: " + mediaStreamMap.toString());
                    }
                }
                this.tracks.clear();
                if (this.mediaReader != null) {
                    this.mediaReader.close();
                    this.mediaReader = null;
                }
                if (this.stream != null) {
                    IApplicationInstance iApplicationInstance = this.getAppInstance();
                    if (iApplicationInstance != null) {
                        WMSLoggerFactory.putGlobalLogValue("x-vhost", iApplicationInstance.getVHost().getName());
                        WMSLoggerFactory.putGlobalLogValue("x-app", iApplicationInstance.getApplication().getName());
                        WMSLoggerFactory.putGlobalLogValue("x-appinst", iApplicationInstance.getName());
                    }
                    if (this.stream.isPlay()) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "stop", 200, this.stream.getName());
                    } else {
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "unpublish", 200, this.stream.getName());
                    }
                    this.stream.close();
                    if (!this.stream.isPlay()) {
                        this.stream.publish();
                        this.stream.stopPublishing();
                    } else if (iApplicationInstance != null) {
                        iApplicationInstance.removePlayStreamByName(this.stream);
                    }
                    if (this.stream.isPlay()) {
                        if (this.stream.isSendPlayStopLogEvent()) {
                            this.stream.setSendPlayStopLogEvent(false);
                            this.stream.notifyActionStop();
                        }
                    } else {
                        this.stream.notifyActionUnPublish(this.stream.getName(), this.stream.isRecord(), this.stream.isAppend());
                    }
                    if (iApplicationInstance != null) {
                        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                        mediaStreamMap.removeStream(this.stream.getSrc());
                    }
                }
                this.stream = null;
                if (this.udpTransport != null) {
                    this.udpTransport.unbindAll();
                }
                this.udpTransport = null;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.shutdown: " + exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IApplicationInstance getAppInstance() {
        Object object;
        IApplication iApplication = null;
        IApplicationInstance iApplicationInstance = null;
        IVHost iVHost = this.getVHost();
        if (this.appName != null && this.appInstanceName != null) {
            object = iVHost.getApplicationLock();
            object.writeLock().lock();
            try {
                iApplication = iVHost.getApplication(this.appName);
                if (iApplication != null) {
                    iApplicationInstance = iApplication.getAppInstance(this.appInstanceName);
                } else {
                    WMSLoggerFactory.getLogger(RTPStream.class).warn("Application folder ([install-location]/applications/" + this.appName + ") is missing");
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPStream.class).error("RTPStream.getAppInstance: " + exception.toString());
            }
            finally {
                object.writeLock().unlock();
            }
        }
        if (iApplicationInstance != null && !this.appInstancePropsInited) {
            try {
                object = this.streamLock;
                synchronized (object) {
                    if (!this.appInstancePropsInited) {
                        WMSProperties wMSProperties;
                        StreamItem streamItem;
                        WMSProperties wMSProperties2 = iApplicationInstance.getRTPProperties();
                        this.setRTSPBindIpAddress(iApplicationInstance.getRTSPBindIpAddress());
                        this.setRTSPConnectionIpAddress(iApplicationInstance.getRTSPConnectionIpAddress());
                        this.setRTSPConnectionAddressType(iApplicationInstance.getRTSPConnectionAddressType());
                        this.setRTSPOriginIpAddress(iApplicationInstance.getRTSPOriginIpAddress());
                        this.setRTSPOriginAddressType(iApplicationInstance.getRTSPOriginAddressType());
                        this.setRTSPBindIpAddress(wMSProperties2.getPropertyStr("rtspBindIpAddress", this.getRTSPBindIpAddress()));
                        this.setRTSPConnectionIpAddress(wMSProperties2.getPropertyStr("rtspConnectionIpAddress", this.getRTSPConnectionIpAddress()));
                        this.setRTSPConnectionAddressType(wMSProperties2.getPropertyStr("rtspConnectionAddressType", this.getRTSPConnectionAddressType()));
                        this.setRTSPOriginIpAddress(wMSProperties2.getPropertyStr("rtspOriginIpAddress", this.getRTSPOriginIpAddress()));
                        this.setRTSPOriginAddressType(wMSProperties2.getPropertyStr("rtspOriginAddressType", this.getRTSPOriginAddressType()));
                        this.streamReadyTimeout = wMSProperties2.getPropertyInt("streamReadyTimeout", this.streamReadyTimeout);
                        this.rtpMetadataProviderPath = wMSProperties2.getPropertyStr("rtpMetadataProvider", this.rtpMetadataProviderPath);
                        this.isForceMPEGTSOut = wMSProperties2.getPropertyBoolean("forceMPEGTSOut", this.isForceMPEGTSOut);
                        this.isForceRTSPInterleaved = wMSProperties2.getPropertyBoolean("forceRTSPInterleaved", this.isForceRTSPInterleaved);
                        this.rtspSessionName = wMSProperties2.getPropertyStr("rtspSessionName", this.rtspSessionName);
                        this.rtspSessionDescription = wMSProperties2.getPropertyStr("rtspSessionDescription", this.rtspSessionDescription);
                        this.sendSDESEvents = wMSProperties2.getPropertyBoolean("sendSDESEvents", this.sendSDESEvents);
                        this.enableRTSPVOD = wMSProperties2.getPropertyBoolean("enableRTSPVOD", this.enableRTSPVOD);
                        this.rtspAlwaysUseSDPPorts = wMSProperties2.getPropertyBoolean("rtspAlwaysUseSDPPorts", this.rtspAlwaysUseSDPPorts);
                        this.setRTSPMaximumPendingWriteBytes(iApplicationInstance.getRTSPMaximumPendingWriteBytes());
                        this.setRTSPSessionTimeout(iApplicationInstance.getRTSPSessionTimeout());
                        String string = this.getStreamType();
                        if (string == null) {
                            string = iApplicationInstance.getStreamType();
                        }
                        if ((streamItem = ((VHost)iVHost).getStreamTypes().getStreamDef(string)) != null && (wMSProperties = streamItem.getProperties()).containsKey("isLive")) {
                            this.isLive = wMSProperties.getPropertyBoolean("isLive", this.isLive);
                        }
                        this.appInstancePropsInited = true;
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.doRecord: " + exception.toString());
                exception.printStackTrace();
            }
        }
        return iApplicationInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        boolean bl = false;
        Object object = this.streamLock;
        synchronized (object) {
            bl = this.isPaused;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDuration() {
        double d = -1.0;
        Object object = this.streamLock;
        synchronized (object) {
            long l;
            if (this.mediaReader != null && (l = this.mediaReader.getDuration()) > 0L) {
                d = (double)l / 1000.0;
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResetPlayStream() {
        boolean bl = false;
        Object object = this.streamLock;
        synchronized (object) {
            bl = this.doResetPlayStream;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResetPlayStream(boolean bl) {
        Object object = this.streamLock;
        synchronized (object) {
            this.doResetPlayStream = bl;
        }
    }

    private RTPPlayer getInternalRTPPlayer() {
        RTPPlayer rTPPlayer;
        block0: {
            rTPPlayer = null;
            IMediaStreamPlay iMediaStreamPlay = this.stream.getPlayer();
            if (iMediaStreamPlay == null || !(iMediaStreamPlay instanceof MediaStreamRTPPlay)) break block0;
            rTPPlayer = ((MediaStreamRTPPlay)iMediaStreamPlay).getInternalPlayer();
        }
        return rTPPlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RTPStreamPlayResult startStream(RTPRequestStatus rTPRequestStatus, int n, double d, double d2) {
        RTPStreamPlayResult rTPStreamPlayResult = new RTPStreamPlayResult();
        rTPStreamPlayResult.setRangeStart(d);
        rTPStreamPlayResult.setRangeStop(d2);
        if (this.stream == null) {
            return rTPStreamPlayResult;
        }
        try {
            Object object = this.streamLock;
            synchronized (object) {
                if (this.mode == 0) {
                    this.mode = n;
                }
                boolean bl = d < 0.0 && !this.isLive();
                this.isPaused = false;
                if (this.isStreamStarted && !bl) {
                    this.doResetPlayStream = true;
                }
                IApplicationInstance iApplicationInstance = this.getAppInstance();
                MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                RTPSession rTPSession = this.getSession();
                if (d < 0.0) {
                    rTPStreamPlayResult.setRangeStart(rTPSession.getRTSPPlayRangeStart());
                    rTPStreamPlayResult.setRangeStop(rTPSession.getRTSPPlayRangeStop());
                } else {
                    rTPSession.setRTSPPlayRangeStart(d);
                    rTPSession.setRTSPPlayRangeStop(d2);
                }
                boolean bl2 = false;
                boolean bl3 = this.stream.isAppend();
                String string = null;
                if (this.mode == 1) {
                    if (!this.isLive() && !bl) {
                        this.vodPlayLen = 0L;
                        this.vodStartTimeTC = 0L;
                        IMediaReader iMediaReader = this.getMediaReader();
                        if (iMediaReader != null) {
                            if (d >= 0.0) {
                                long l = Math.round(d * 1000.0);
                                long l2 = Math.round(d2 * 1000.0);
                                if (l2 > 0L && Math.abs(iMediaReader.getDuration() - l2) <= 2L) {
                                    this.vodPlayLen = l2;
                                }
                                if (l > 0L) {
                                    PlaylistSeekResult playlistSeekResult = iMediaReader.seek(l, 3);
                                    if (playlistSeekResult == null) {
                                        this.vodStartTimeTC = 0L;
                                        iMediaReader.rewind();
                                    } else {
                                        long l3 = 0L;
                                        switch (1) {
                                            case 1: {
                                                boolean bl4;
                                                boolean bl5 = bl4 = playlistSeekResult.getVideoStreamPos() == null ? false : playlistSeekResult.getVideoStreamPos().isValid();
                                                if (bl4) {
                                                    l3 = playlistSeekResult.getResultVideoTimecode();
                                                    iMediaReader.setStreamPosition(playlistSeekResult.getVideoStreamPos());
                                                    break;
                                                }
                                                l3 = playlistSeekResult.getResultTimecode();
                                                iMediaReader.setStreamPosition(playlistSeekResult.getStreamPos());
                                                break;
                                            }
                                            case 3: {
                                                l3 = playlistSeekResult.getResultTimecode();
                                                iMediaReader.setStreamPosition(playlistSeekResult.getStreamPos());
                                                break;
                                            }
                                            case 4: {
                                                l3 = playlistSeekResult.getResultTimecode();
                                                iMediaReader.setStreamPosition(playlistSeekResult.getStreamPos());
                                            }
                                        }
                                        this.vodStartTimeTC = l3;
                                    }
                                } else {
                                    this.vodStartTimeTC = 0L;
                                    iMediaReader.rewind();
                                }
                            } else {
                                this.vodStartTimeTC = 0L;
                                iMediaReader.rewind();
                            }
                        }
                        this.vodLastTimeTC = this.vodStartTimeTC;
                    }
                    int n2 = 1;
                    int n3 = 1;
                    RTPPlayer rTPPlayer = this.getInternalRTPPlayer();
                    if (rTPPlayer != null) {
                        n2 = rTPPlayer.getNextVideoSequence();
                        n3 = rTPPlayer.getNextAudioSequence();
                    }
                    String string2 = null;
                    if (bl) {
                        long l = -1L;
                        List list = null;
                        for (int i = 0; i < 8; ++i) {
                            list = rTPPlayer.peekVODPackets(this, (long)(1000 + i * 1000));
                            for (AMFPacket aMFPacket : list) {
                                int n4 = aMFPacket.getType();
                                if (n4 != 8 && n4 != 9) continue;
                                l = aMFPacket.getAbsTimecode();
                                break;
                            }
                            if (l >= 0L) break;
                        }
                        if (l >= 0L) {
                            double d3 = (double)l / 1000.0;
                            rTPStreamPlayResult.setRangeStart(d3);
                            string2 = this.formatRTPInfo(l, n2, n3);
                            rTPPlayer.resetVODThrottling(l);
                        }
                    } else {
                        string2 = this.getRTPInfo(d, n2, n3);
                    }
                    rTPStreamPlayResult.setRTPInfo(string2);
                }
                IMediaStream iMediaStream = this.stream;
                synchronized (iMediaStream) {
                    if (!this.isStreamStarted) {
                        if (this.isModePublish()) {
                            this.stream.setOpen(true);
                            this.stream.setRecord(bl2);
                            this.stream.setAppend(bl3);
                            this.stream.setName(this.streamName);
                            this.stream.setExt(this.streamExt);
                            this.stream.setQueryStr(this.streamQueryStr);
                            mediaStreamMap.notifyPlayPublish(this.stream);
                            this.stream.startPublishing();
                        } else {
                            this.stream.setOpen(true);
                            this.stream.setPlay(true);
                            this.stream.setName(this.streamName, string, this.streamExt, this.streamQueryStr, 0.0, -1.0, 1);
                            this.stream.setIsPlaying(true);
                            IMediaStreamPlay iMediaStreamPlay = this.stream.getPlayer();
                            if (iMediaStreamPlay != null) {
                                iMediaStreamPlay.reset(true);
                                iMediaStreamPlay.interruptPlay();
                                iMediaStreamPlay.startPlay();
                            }
                        }
                    }
                    WMSLoggerFactory.putGlobalLogValue("x-vhost", iApplicationInstance.getVHost().getName());
                    WMSLoggerFactory.putGlobalLogValue("x-app", iApplicationInstance.getApplication().getName());
                    WMSLoggerFactory.putGlobalLogValue("x-appinst", iApplicationInstance.getName());
                    if (this.isModePublish()) {
                        this.getSession().updateLoggingValues();
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "publish", 200, this.streamName);
                        if (bl2) {
                            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "record", 200, this.streamName);
                        }
                        this.getSession().clearLoggingValues();
                        this.stream.notifyActionPublish(this.streamName, bl2, bl3);
                    } else {
                        boolean bl6 = this.isStreamStarted && !this.isLive();
                        this.getSession().updateLoggingValues();
                        if (bl) {
                            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "unpause", 200, this.streamName);
                        } else if (bl6) {
                            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "seek", 200, this.streamName);
                        } else {
                            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "play", 200, this.streamName);
                        }
                        this.getSession().clearLoggingValues();
                        this.stream.setSendPlayStopLogEvent(true);
                        if (rTPSession != null && !this.isStreamStarted) {
                            iApplicationInstance.registerPlayRTPSession(rTPSession);
                        }
                        if (bl6) {
                            this.stream.notifyActionSeek(this.vodStartTimeTC);
                        } else {
                            this.stream.notifyActionPlay(this.streamName, 0.0, -1.0, 1);
                        }
                    }
                }
                if (this.tracks.size() <= 1 && !this.isStreamStarted) {
                    this.setAVSyncMethod(2);
                }
                for (RTPTrack rTPTrack : this.tracks.values()) {
                    if (this.mode == 1) {
                        rTPTrack.play(rTPRequestStatus, this.isStreamStarted);
                    } else {
                        rTPTrack.record(rTPRequestStatus, this.isStreamStarted);
                    }
                    if (rTPRequestStatus.isGood()) continue;
                    break;
                }
                this.isStreamStarted = true;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.doRecord: " + exception.toString());
            exception.printStackTrace();
        }
        return rTPStreamPlayResult;
    }

    public RTPStreamPlayResult record(RTPRequestStatus rTPRequestStatus) {
        return this.record(rTPRequestStatus, -1.0, -1.0);
    }

    public RTPStreamPlayResult record(RTPRequestStatus rTPRequestStatus, double d, double d2) {
        return this.startStream(rTPRequestStatus, 2, d, d2);
    }

    public RTPStreamPlayResult play(RTPRequestStatus rTPRequestStatus) {
        return this.play(rTPRequestStatus, -1.0, -1.0);
    }

    public RTPStreamPlayResult play(RTPRequestStatus rTPRequestStatus, double d, double d2) {
        return this.startStream(rTPRequestStatus, 1, d, d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachToWMSSession(RtmpSessionInfo rtmpSessionInfo) {
        Object object = this.streamLock;
        synchronized (object) {
            for (RTPTrack rTPTrack : this.tracks.values()) {
                rTPTrack.attachToWMSSession(rtmpSessionInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachFromWMSSession(RtmpSessionInfo rtmpSessionInfo) {
        Object object = this.streamLock;
        synchronized (object) {
            for (RTPTrack rTPTrack : this.tracks.values()) {
                rTPTrack.detachFromWMSSession(rtmpSessionInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(RTPRequestStatus rTPRequestStatus) {
        try {
            Object object = this.streamLock;
            synchronized (object) {
                boolean bl = true;
                this.isPaused = true;
                IMediaStream iMediaStream = this.getStream();
                if (iMediaStream != null) {
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "pause", 200, this.streamName);
                }
                for (RTPTrack rTPTrack : this.tracks.values()) {
                    rTPTrack.pause(rTPRequestStatus);
                    if (rTPRequestStatus.isGood()) continue;
                    break;
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.doRecord: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void announce(RTPRequestStatus rTPRequestStatus) {
        for (RTPTrack rTPTrack : this.tracks.values()) {
            rTPTrack.announce(rTPRequestStatus);
            if (rTPRequestStatus.isGood()) continue;
            break;
        }
    }

    public boolean isResyncAudioVideoOnSR() {
        return this.resyncAudioVideoOnSR;
    }

    public void setResyncAudioVideoOnSR(boolean bl) {
        this.resyncAudioVideoOnSR = bl;
    }

    public byte[] getMetadataPacket() {
        byte[] byArray = null;
        try {
            Object object;
            Object object4;
            Iterator<RTPTrack> iterator;
            AMFDataMixedArray aMFDataMixedArray = new AMFDataMixedArray();
            AMFDataArray aMFDataArray = new AMFDataArray();
            Iterator<RTPTrack> iterator2 = iterator = this.tracksInternal.size() > 0 ? this.tracksInternal.values().iterator() : this.tracks.values().iterator();
            while (iterator.hasNext()) {
                object4 = iterator.next();
                Iterator<String> iterator3 = new AMFDataObj();
                ((AMFDataObj)((Object)iterator3)).put("timescale", new AMFDataItem(((RTPTrack)object4).getTimescale()));
                ((AMFDataObj)((Object)iterator3)).put("language", new AMFDataItem("eng"));
                AMFDataArray object32 = new AMFDataArray();
                AMFDataObj aMFDataObj = new AMFDataObj();
                aMFDataObj.put("sampletype", new AMFDataItem(((RTPTrack)object4).getSampleType()));
                object32.add(aMFDataObj);
                ((AMFDataObj)((Object)iterator3)).put("sampledescription", object32);
                object = ((RTPTrack)object4).getCodecConfig();
                if (((RTPTrack)object4).isAudio()) {
                    ((AMFDataObj)((Object)iterator3)).put("type", "audio");
                    aMFDataMixedArray.put("audiochannels", new AMFDataItem(((RTPTrack)object4).getChannelCount()));
                    aMFDataMixedArray.put("audiosamplerate", new AMFDataItem(((RTPTrack)object4).getTimescale()));
                    aMFDataMixedArray.put("audiocodecid", new AMFDataItem("mp4a"));
                    if (object != null) {
                        ((AMFDataObj)((Object)iterator3)).put("config", BufferUtils.encodeHexString((byte[])object));
                        AACFrame aACFrame = AACUtils.decodeAACCodecConfig((byte[])object, 0);
                        if (aACFrame != null) {
                            ((AMFDataObj)((Object)iterator3)).put("description", aACFrame.toString());
                        }
                    }
                }
                if (((RTPTrack)object4).isVideo()) {
                    ((AMFDataObj)((Object)iterator3)).put("type", "video");
                    int n = ((RTPTrack)object4).getWidth();
                    int n2 = ((RTPTrack)object4).getHeight();
                    aMFDataMixedArray.put("videocodecid", new AMFDataItem("avc1"));
                    if (object != null) {
                        Object object2;
                        H264CodecConfigParts h264CodecConfigParts = H264Utils.breakApartAVCC((byte[])object, 0, ((Object)object).length);
                        if (h264CodecConfigParts != null) {
                            object2 = h264CodecConfigParts.getProfileLevelIdStr();
                            String string = h264CodecConfigParts.getSpropParameterSetsStr();
                            ((AMFDataObj)((Object)iterator3)).put("profile-level-id", (String)object2);
                            ((AMFDataObj)((Object)iterator3)).put("sprop-parameter-sets", string);
                        }
                        if ((object2 = H264Utils.decodeAVCC((byte[])object)) != null) {
                            ((AMFDataObj)((Object)iterator3)).put("description", ((H264CodecConfigInfo)object2).toString());
                            if (n <= 0 && n2 <= 0) {
                                n = ((H264CodecConfigInfo)object2).width;
                                n2 = ((H264CodecConfigInfo)object2).height;
                            }
                        }
                    }
                    if (n > 0 && n > 0) {
                        aMFDataMixedArray.put("width", new AMFDataItem(n));
                        aMFDataMixedArray.put("height", new AMFDataItem(n2));
                    }
                }
                aMFDataArray.add((AMFData)((Object)iterator3));
            }
            aMFDataMixedArray.put("trackinfo", aMFDataArray);
            object4 = new AMFDataObj();
            for (String string : this.streamInfo.keySet()) {
                String string2 = this.streamInfo.get(string);
                if (string2 == null) continue;
                ((AMFDataObj)object4).put(string, new AMFDataItem(string2));
            }
            AMFDataObj aMFDataObj = new AMFDataObj();
            for (String string : this.streamAttributes.keySet()) {
                object = this.streamAttributes.get(string);
                if (object == null) continue;
                aMFDataObj.put(string, new AMFDataItem((String)object));
            }
            ((AMFDataObj)object4).put(STREAMINFO_SESSIONATTRIBUTES, aMFDataObj);
            aMFDataMixedArray.put("rtpsessioninfo", (AMFData)object4);
            AMFDataList aMFDataList = new AMFDataList();
            aMFDataList.add(new AMFDataItem("onMetaData"));
            aMFDataList.add(aMFDataMixedArray);
            byArray = aMFDataList.serialize();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.getMetadataPacket: " + exception.toString());
            exception.printStackTrace();
        }
        return byArray;
    }

    private IRTPMetadataProvider getMetadataProvider() {
        IRTPMetadataProvider iRTPMetadataProvider = null;
        IApplicationInstance iApplicationInstance = this.getAppInstance();
        if (iApplicationInstance != null && this.rtpMetadataProviderPath != null) {
            try {
                Class<?> clazz = Class.forName(this.rtpMetadataProviderPath);
                if (clazz != null) {
                    iRTPMetadataProvider = (IRTPMetadataProvider)clazz.newInstance();
                    if (iRTPMetadataProvider == null) {
                        WMSLoggerFactory.getLogger(RTPStream.class).warn("RTPStream.getMetadataProvider: RTP Metadata provider could not be instantiated: " + this.rtpMetadataProviderPath);
                    }
                } else {
                    WMSLoggerFactory.getLogger(RTPStream.class).warn("RTPDePacketizerBase.getMetadataProvider: RTP Metadata provider could not be found: " + this.rtpMetadataProviderPath);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPStream.class).error("RTPDePacketizerBase.getMetadataProvider: " + exception.toString());
            }
        }
        return iRTPMetadataProvider;
    }

    private void sendMetadata(long l) {
        try {
            IRTPMetadataProvider iRTPMetadataProvider = this.getMetadataProvider();
            byte[] byArray = null;
            byArray = iRTPMetadataProvider != null ? iRTPMetadataProvider.getMetadataPacket(this) : this.getMetadataPacket();
            if (byArray != null) {
                this.stream.setDataType(18);
                this.stream.setDataTC(l, true);
                this.stream.setDataSize(byArray.length);
                this.stream.startDataPacket();
                this.stream.addDataData(byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.sendMetadata: " + exception.toString());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSentMetadataFlag() {
        Object object = this.streamLock;
        synchronized (object) {
            this.sentMetadata = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSendMetadata(long l) {
        Object var3_2 = null;
        Object object = this.streamLock;
        synchronized (object) {
            if (!this.sentMetadata) {
                this.sendMetadata(l);
                this.sentMetadata = true;
            }
        }
    }

    public void extractCodecConfigFromTrackInfo() {
        for (RTPTrack rTPTrack : this.tracks.values()) {
            rTPTrack.extractCodecConfigFromTrackInfo();
        }
    }

    public String getStreamType() {
        return this.streamType;
    }

    public void setStreamType(String string) {
        this.streamType = string;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public String getAppInstanceName() {
        return this.appInstanceName;
    }

    public void setAppInstanceName(String string) {
        this.appInstanceName = string;
    }

    public String getStreamExt() {
        return this.streamExt;
    }

    public void setStreamExt(String string) {
        this.streamExt = string;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String string) {
        this.streamName = string;
    }

    public String getStreamNameLogging() {
        return this.streamNameLogging;
    }

    public void setStreamNameLogging(String string) {
        this.streamNameLogging = string;
    }

    public long getStreamSessionId() {
        return this.streamSessionId;
    }

    public void setStreamSessionId(long l) {
        this.streamSessionId = l;
    }

    public long getStreamSessionVersion() {
        return this.streamSessionVersion;
    }

    public void setStreamSessionVersion(long l) {
        this.streamSessionVersion = l;
    }

    public String getStreamSessionIp() {
        return this.streamSessionIp;
    }

    public void setStreamSessionIp(String string) {
        this.streamSessionIp = string;
    }

    public boolean isCheckSSRC() {
        return this.checkSSRC;
    }

    public void setCheckSSRC(boolean bl) {
        this.checkSSRC = bl;
    }

    public boolean isCheckIpAddr() {
        return this.checkIpAddr;
    }

    public void setCheckIpAddr(boolean bl) {
        this.checkIpAddr = bl;
    }

    public IUDPTransport getUDPTransport(boolean bl) {
        if (this.udpTransport == null) {
            String string = null;
            IMediaStream iMediaStream = this.getStream();
            if (iMediaStream != null) {
                string = iMediaStream.getProperties().getPropertyStr(bl ? "multicastTransportBaseClass" : "udpTransportBaseClass", string);
            }
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName(string);
                    if (clazz != null) {
                        this.udpTransport = (IUDPTransport)clazz.newInstance();
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(RTPStream.class).error("RTPStream.getUDPTransport: Transport base class could not be instantiated[" + string + "]: " + exception.toString());
                }
                if (this.udpTransport == null) {
                    WMSLoggerFactory.getLogger(RTPStream.class).warn("RTPStream.getUDPTransport: Transport base class could not be instantiated: " + string);
                }
            }
            if (this.udpTransport == null) {
                this.udpTransport = bl ? new RTPMulticastTransport() : new RTPUDPTransportMina();
            }
            if (this.udpTransport != null && this.getAppInstance() != null) {
                this.udpTransport.setLoggingContextStr(this.getAppInstance().getContextStr());
            }
        }
        return this.udpTransport;
    }

    public int getAVSyncMethod() {
        return this.avSyncMethod;
    }

    public void setAVSyncMethod(int n) {
        this.avSyncMethod = n;
    }

    public boolean isAVSyncNonSR() {
        return this.avSyncMethod == 2 || this.avSyncMethod == 3;
    }

    public int getMaxRTCPWaitTime() {
        return this.maxRTCPWaitTime;
    }

    public void setMaxRTCPWaitTime(int n) {
        this.maxRTCPWaitTime = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getStreamInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object object = this.streamLock;
        synchronized (object) {
            hashMap.putAll(this.streamInfo);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getStreamAttributes() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object object = this.streamLock;
        synchronized (object) {
            hashMap.putAll(this.streamAttributes);
        }
        return hashMap;
    }

    public static int avSyncNameToId(String string) {
        int n = 0;
        if (string.toLowerCase().startsWith("senderreport")) {
            n = 1;
        } else if (string.toLowerCase().startsWith("systemclock")) {
            n = 2;
        } else if (string.toLowerCase().startsWith("rtptimecode")) {
            n = 3;
        }
        return n;
    }

    public int getMPEGTSVideoPID() {
        return this.mpegtsVideoPID;
    }

    public void setMPEGTSVideoPID(int n) {
        this.mpegtsVideoPID = n;
    }

    public int getMPEGTSAudioPID() {
        return this.mpegtsAudioPID;
    }

    public void setMPEGTSAudioPID(int n) {
        this.mpegtsAudioPID = n;
    }

    public boolean isRTSP() {
        return this.isRTSP;
    }

    public void setRTSP(boolean bl) {
        this.isRTSP = bl;
    }

    public String getStreamQueryStr() {
        return this.streamQueryStr;
    }

    public void setStreamQueryStr(String string) {
        this.streamQueryStr = string;
    }

    public boolean isModePublish() {
        return this.mode == 2;
    }

    public boolean isModePlay() {
        return this.mode == 1;
    }

    public boolean isModeUknown() {
        return this.mode == 0;
    }

    public String getOutHost() {
        return this.outHost;
    }

    public void setOutHost(String string) {
        this.outHost = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void idle(IoSession ioSession, RtmpResponseMessage rtmpResponseMessage) {
        try {
            Object object = this.streamLock;
            synchronized (object) {
                IMediaStreamPlay iMediaStreamPlay;
                IMediaStream iMediaStream;
                long l;
                int n;
                int n2;
                if (ioSession != null && (n2 = this.getRTSPSessionTimeout()) > 0 && (n = this.isTimeout(l = System.currentTimeMillis(), n2)) != 0) {
                    RTSPTunnelingSession rTSPTunnelingSession;
                    String string;
                    IMediaStream iMediaStream2;
                    String string2 = "";
                    IApplicationInstance iApplicationInstance = this.getAppInstance();
                    if (iApplicationInstance != null) {
                        string2 = string2 + iApplicationInstance.getContextStr() + ":";
                    }
                    if ((iMediaStream2 = this.getStream()) != null) {
                        string2 = string2 + iMediaStream2.getName();
                    }
                    WMSLoggerFactory.getLogger(RTSPRequestAdapter.class).warn("RTPStream.idle[" + this.getSession().getSessionId() + ":" + string2 + "]: Close RTSP/RTP session. Session timeout: " + n2);
                    try {
                        ioSession.close();
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(RTSPRequestAdapter.class).error("RTPStream.idle: Close session error: " + exception.toString());
                    }
                    RTPSession rTPSession = this.getSession();
                    if (rTPSession != null && (string = rTPSession.getRTSPTunnelingSessionId()) != null && (rTSPTunnelingSession = rTPSession.getVHost().getRTPContext().getRTSPTunnelingSession(string)) != null) {
                        rTSPTunnelingSession.closeAllPOSTSessions();
                    }
                } else if (!this.isModePublish() && (iMediaStream = this.getStream()) != null && iMediaStream.isPlaying() && (iMediaStreamPlay = iMediaStream.getPlayer()) != null) {
                    long[] lArray = new long[8];
                    n = iMediaStreamPlay.play(rtmpResponseMessage == null ? null : rtmpResponseMessage.getOutputStream(), null, null, null, lArray);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPStream.class).warn("RTPStream.idle: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public AMFPacket[] getLastPacketsByType(IMediaStream iMediaStream) {
        AMFPacket[] aMFPacketArray = new AMFPacket[4];
        int n = iMediaStream.getPublishAudioCodecId();
        int n2 = iMediaStream.getPublishVideoCodecId();
        AMFPacket aMFPacket = null;
        AMFPacket aMFPacket2 = null;
        AMFPacket aMFPacket3 = null;
        AMFPacket aMFPacket4 = null;
        List<AMFPacket> list = iMediaStream.getPlayPackets();
        if (list != null && list.size() > 0) {
            AMFPacket aMFPacket5 = null;
            for (int i = list.size() - 1; i >= 0; --i) {
                int n3;
                aMFPacket5 = list.get(i);
                int n4 = aMFPacket5.getType();
                if (n4 == 8) {
                    if (aMFPacket == null && aMFPacket5.getSize() >= 2) {
                        n3 = aMFPacket5.getSecondByte();
                        if (n != 10 || n3 == 1) {
                            aMFPacket = aMFPacket5;
                            aMFPacket3 = iMediaStream.getAudioCodecConfigPacket(aMFPacket5.getAbsTimecode());
                        }
                    }
                } else if (n4 == 9 && aMFPacket2 == null && aMFPacket5.getSize() >= 2) {
                    n3 = aMFPacket5.getSecondByte();
                    if (n2 != 7 || n3 == 1) {
                        aMFPacket2 = aMFPacket5;
                        aMFPacket4 = iMediaStream.getVideoCodecConfigPacket(aMFPacket5.getAbsTimecode());
                    }
                }
                if (aMFPacket2 != null && aMFPacket != null) break;
            }
        }
        aMFPacketArray[0] = aMFPacket;
        aMFPacketArray[1] = aMFPacket2;
        aMFPacketArray[2] = aMFPacket3;
        aMFPacketArray[3] = aMFPacket4;
        return aMFPacketArray;
    }

    public AMFPacket[] getLastPacketsByType(IMediaReader iMediaReader, double d) {
        AMFPacket[] aMFPacketArray = new AMFPacket[4];
        AMFPacket aMFPacket = null;
        AMFPacket aMFPacket2 = null;
        AMFPacket aMFPacket3 = null;
        AMFPacket aMFPacket4 = null;
        PlaylistCursor playlistCursor = new PlaylistCursor();
        long[] lArray = new long[8];
        PlaylistWriteControl playlistWriteControl = playlistCursor.getWriteControl();
        PlaylistReaderWriteResults playlistReaderWriteResults = playlistCursor.getWriteResults();
        ArrayList<AMFPacket> arrayList = new ArrayList<AMFPacket>();
        long l = d < 0.0 ? 0L : Math.round(d * 1000.0);
        long l2 = 1000L;
        long l3 = 1000L;
        long l4 = l + 12000L;
        IMediaReaderStreamPosition iMediaReaderStreamPosition = iMediaReader.getStreamPosition();
        long l5 = l + l2;
        block0: do {
            arrayList.clear();
            playlistWriteControl.setMaxTC(l5);
            iMediaReader.writePackets(arrayList, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, null);
            for (int i = 0; i < arrayList.size(); ++i) {
                int n;
                int n2;
                AMFPacket aMFPacket5 = (AMFPacket)arrayList.get(i);
                int n3 = aMFPacket5.getType();
                if (n3 == 8) {
                    if (aMFPacket == null && aMFPacket5.getSize() >= 2) {
                        n2 = aMFPacket5.getSecondByte();
                        n = FLVUtils.getAudioCodec(aMFPacket5);
                        if (n == 10 && n2 != 1) {
                            if (n2 == 0) {
                                aMFPacket3 = aMFPacket5;
                            }
                        } else {
                            aMFPacket = aMFPacket5;
                        }
                    }
                } else if (n3 == 9 && aMFPacket2 == null && aMFPacket5.getSize() >= 2) {
                    n2 = aMFPacket5.getSecondByte();
                    n = FLVUtils.getVideoCodec(aMFPacket5);
                    if (n == 7 && n2 != 1) {
                        if (n2 == 0) {
                            aMFPacket4 = aMFPacket5;
                        }
                    } else {
                        aMFPacket2 = aMFPacket5;
                    }
                }
                if (aMFPacket2 != null && aMFPacket != null) continue block0;
            }
        } while ((aMFPacket2 == null || aMFPacket == null) && (l5 += l3) <= l4);
        iMediaReader.setStreamPosition(iMediaReaderStreamPosition);
        aMFPacketArray[0] = aMFPacket;
        aMFPacketArray[1] = aMFPacket2;
        aMFPacketArray[2] = aMFPacket3;
        aMFPacketArray[3] = aMFPacket4;
        return aMFPacketArray;
    }

    public String describe(RTPSession rTPSession, RTPRequestStatus rTPRequestStatus) {
        return this.describe(rTPSession, 0, rTPRequestStatus);
    }

    private String getSessionName(IApplicationInstance iApplicationInstance) {
        String string = this.rtspSessionName;
        if (string != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.wowza.wms.context.VHost", iApplicationInstance.getVHost().getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", iApplicationInstance.getVHost().getHomePath());
            hashMap.put("com.wowza.wms.context.Application", iApplicationInstance.getApplication().getName());
            hashMap.put("com.wowza.wms.context.ApplicationInstance", iApplicationInstance.getName());
            hashMap.put("com.wowza.wms.context.StreamName", this.getStreamName());
            string = SystemUtils.expandEnvironmentVariables(string, hashMap);
        }
        return string;
    }

    private String getSessionDescription(IApplicationInstance iApplicationInstance) {
        String string = this.rtspSessionDescription;
        if (string != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.wowza.wms.context.VHost", iApplicationInstance.getVHost().getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", iApplicationInstance.getVHost().getHomePath());
            hashMap.put("com.wowza.wms.context.Application", iApplicationInstance.getApplication().getName());
            hashMap.put("com.wowza.wms.context.ApplicationInstance", iApplicationInstance.getName());
            hashMap.put("com.wowza.wms.context.StreamName", this.getStreamName());
            string = SystemUtils.expandEnvironmentVariables(string, hashMap);
        }
        return string;
    }

    public void switchSetupToMPEGTS() {
        block6: {
            IApplicationInstance iApplicationInstance = this.getAppInstance();
            if (iApplicationInstance == null) break block6;
            RTPContext rTPContext = iApplicationInstance.getVHost().getRTPContext();
            int n = -1;
            IRTPPacketizer iRTPPacketizer = null;
            if (this.isMPEGTSOut) {
                this.clearTracks();
                boolean bl = this.isLive();
                IMediaStream iMediaStream = null;
                IMediaReader iMediaReader = null;
                if (!(!bl ? (iMediaReader = this.mediaReader) == null : (iMediaStream = iApplicationInstance.getStreams().getStream(this.getStreamName())) == null)) {
                    AMFPacket[] aMFPacketArray = bl ? this.getLastPacketsByType(iMediaStream) : this.getLastPacketsByType(iMediaReader, -1.0);
                    AMFPacket aMFPacket = aMFPacketArray[0];
                    AMFPacket aMFPacket2 = aMFPacketArray[1];
                    AMFPacket aMFPacket3 = aMFPacketArray[2];
                    AMFPacket aMFPacket4 = aMFPacketArray[3];
                    int n2 = 0;
                    RTPPacketizerItem rTPPacketizerItem = rTPContext.getStreamPacketizerItem(iApplicationInstance, n2);
                    if (rTPPacketizerItem == null) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).warn("RTPPlayer.describe: No stream packetizer: " + n2);
                    } else {
                        iRTPPacketizer = rTPPacketizerItem.getInstance(iApplicationInstance, this.getSession());
                        if (iRTPPacketizer == null) {
                            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPPlayer.describe: Cannot create stream packetizer: " + n2);
                        } else {
                            String string = "mpegts-transport";
                            RTPTrack rTPTrack = new RTPTrack("mpegts-transport");
                            this.addTrack(rTPTrack);
                            rTPTrack.setTrackType(0);
                            iRTPPacketizer.extractStreamInfo(rTPTrack, aMFPacket, aMFPacket3);
                            iRTPPacketizer.extractStreamInfo(rTPTrack, aMFPacket2, aMFPacket4);
                            RTPDescribeInfo rTPDescribeInfo = iRTPPacketizer.getDescribeInfo(rTPTrack, iMediaStream, null, null, 0, n);
                            n = rTPDescribeInfo.getTimescale();
                            rTPTrack.setRTPPacketizer(iRTPPacketizer);
                            rTPTrack.setTimescale(n);
                        }
                    }
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public String describe(RTPSession var1_1, int var2_2, RTPRequestStatus var3_3) {
        block32: {
            block33: {
                block31: {
                    var4_4 = new StringBuffer();
                    var5_5 = this.getAppInstance();
                    if (var5_5 != null) break block31;
                    RTSPStatics.setStatus(var3_3, 403);
                    break block32;
                }
                var6_6 = var5_5.getVHost().getRTPContext();
                this.isMPEGTSOut = var2_2 > 0 ? true : (var2_2 < 0 ? false : this.isForceMPEGTSOut);
                var7_7 = "RTP/AVP";
                var8_8 = this.isLive();
                var9_9 = null;
                var10_10 = null;
                if (!var8_8) break block33;
                var9_9 = var5_5.getStreams().getStream(this.getStreamName());
                if (var9_9 != null) ** GOTO lbl-1000
                RTSPStatics.setStatus(var3_3, 404);
                break block32;
            }
            var10_10 = this.mediaReader;
            if (var10_10 == null) {
                RTSPStatics.setStatus(var3_3, 404);
            } else lbl-1000:
            // 2 sources

            {
                var11_11 = "now-";
                if (!this.isLive) {
                    var11_11 = "0- " + (double)var10_10.getDuration() / 1000.0;
                }
                var12_12 = var1_1.getSessionId();
                var13_13 = this.getSessionName((IApplicationInstance)var5_5);
                var14_14 = this.getSessionDescription((IApplicationInstance)var5_5);
                var4_4.append("v=0\r\n");
                var4_4.append("o=- " + var12_12 + " " + var12_12 + " IN " + this.rtspOriginAddressType + " " + this.rtspOriginIpAddress + "\r\n");
                var4_4.append("s=" + var13_13 + "\r\n");
                if (var14_14 != null) {
                    var4_4.append("i=" + var14_14 + "\r\n");
                }
                var4_4.append("c=IN " + this.rtspConnectionAddressType + " " + this.rtspConnectionIpAddress + "\r\n");
                var4_4.append("t=0 0\r\n");
                var4_4.append("a=sdplang:en\r\n");
                var4_4.append("a=range:npt=" + var11_11 + "\r\n");
                var4_4.append("a=control:*\r\n");
                if (this.rtspSessionExtraLines.size() > 0) {
                    for (Object var16_16 : this.rtspSessionExtraLines) {
                        if (var16_16.location != 0) continue;
                        var4_4.append(var16_16.line + "\r\n");
                    }
                }
                var15_15 = var8_8 != false ? this.getLastPacketsByType(var9_9) : this.getLastPacketsByType(var10_10, -1.0);
                var16_16 = var15_15[0];
                var17_17 = var15_15[1];
                var18_18 = var15_15[2];
                var19_19 = var15_15[3];
                var20_20 = -1;
                if (var16_16 != null) {
                    var20_20 = FLVUtils.getAudioCodec((AMFPacket)var16_16);
                }
                var21_21 = -1;
                if (var17_17 != null) {
                    var21_21 = FLVUtils.getVideoCodec(var17_17);
                }
                var22_22 = -1;
                var23_23 = null;
                if (this.isMPEGTSOut) {
                    var24_24 = 0;
                    var25_25 = var6_6.getStreamPacketizerItem((IApplicationInstance)var5_5, var24_24);
                    if (var25_25 == null) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).warn("RTPPlayer.describe: No stream packetizer: " + var24_24);
                    } else {
                        var23_23 = var25_25.getInstance((IApplicationInstance)var5_5, var1_1);
                        if (var23_23 == null) {
                            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPPlayer.describe: Cannot create stream packetizer: " + var24_24);
                        } else {
                            var26_26 = "mpegts-transport";
                            var27_27 = new RTPTrack("mpegts-transport");
                            this.addTrack((RTPTrack)var27_27);
                            var27_27.setTrackType(0);
                            var23_23.extractStreamInfo((RTPTrack)var27_27, (AMFPacket)var16_16, var18_18);
                            var23_23.extractStreamInfo((RTPTrack)var27_27, var17_17, var19_19);
                            var28_28 = var23_23.getDescribeInfo((RTPTrack)var27_27, var9_9, null, null, 0, var22_22);
                            var22_22 = var28_28.getTimescale();
                            var27_27.setRTPPacketizer(var23_23);
                            var27_27.setTimescale(var22_22);
                            var4_4.append("m=video 0 " + var7_7 + " " + var28_28.getSDPTypeId() + "\r\n");
                            var4_4.append(var28_28.getSDPStr());
                            if (this.rtspSessionExtraLines.size() > 0) {
                                for (Iterator<RTSPExtraLine> var30_30 : this.rtspSessionExtraLines) {
                                    if (var30_30.location != 2) continue;
                                    var4_4.append(var30_30.line + "\r\n");
                                }
                            }
                            var4_4.append("a=control:" + (String)var26_26 + "\r\n");
                        }
                    }
                }
                var24_24 = 1;
                if (!this.isMPEGTSOut && var20_20 != -1) {
                    var25_25 = var6_6.getAudioPacketizerItem((IApplicationInstance)var5_5, var20_20);
                    if (var25_25 == null) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).warn("RTPPlayer.describe: No audio packetizer: " + var20_20);
                    } else {
                        var26_26 = var25_25.getInstance((IApplicationInstance)var5_5, var1_1);
                        if (var26_26 == null) {
                            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPPlayer.describe: Cannot create audio packetizer: " + var20_20);
                        } else {
                            var27_27 = "trackID=" + var24_24;
                            ++var24_24;
                            var28_28 = new RTPTrack((String)var27_27);
                            this.addTrack((RTPTrack)var28_28);
                            var28_28.setTrackType(8);
                            var26_26.extractStreamInfo((RTPTrack)var28_28, (AMFPacket)var16_16, var18_18);
                            var29_29 = var26_26.getDescribeInfo((RTPTrack)var28_28, var9_9, (AMFPacket)var16_16, var18_18, 0, var22_22);
                            var28_28.setRTPPacketizer((IRTPPacketizer)(var23_23 != null ? var23_23 : var26_26));
                            var28_28.setTimescale(var29_29.getTimescale());
                            var28_28.setChannelCount(var29_29.getChannels());
                            if (var23_23 == null) {
                                var4_4.append("m=audio 0 " + var7_7 + " " + var29_29.getSDPTypeId() + "\r\n");
                                var4_4.append(var29_29.getSDPStr());
                                if (this.rtspSessionExtraLines.size() > 0) {
                                    for (RTSPExtraLine var31_31 : this.rtspSessionExtraLines) {
                                        if (var31_31.location != 1) continue;
                                        var4_4.append(var31_31.line + "\r\n");
                                    }
                                }
                                var4_4.append("a=control:" + (String)var27_27 + "\r\n");
                            }
                        }
                    }
                }
                if (!this.isMPEGTSOut && var21_21 != -1) {
                    var25_25 = var6_6.getVideoPacketizerItem((IApplicationInstance)var5_5, var21_21);
                    if (var25_25 == null) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).warn("RTPPlayer.describe: No video packetizer: " + var21_21);
                    } else {
                        var26_26 = var25_25.getInstance((IApplicationInstance)var5_5, var1_1);
                        if (var26_26 == null) {
                            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPPlayer.describe: Cannot create video packetizer: " + var21_21);
                        } else {
                            var27_27 = "trackID=" + var24_24;
                            ++var24_24;
                            var28_28 = new RTPTrack((String)var27_27);
                            this.addTrack((RTPTrack)var28_28);
                            var28_28.setTrackType(9);
                            var26_26.extractStreamInfo((RTPTrack)var28_28, var17_17, var19_19);
                            var29_29 = var26_26.getDescribeInfo((RTPTrack)var28_28, var9_9, var17_17, var19_19, 0, var22_22);
                            var28_28.setRTPPacketizer((IRTPPacketizer)(var23_23 != null ? var23_23 : var26_26));
                            var28_28.setTimescale(var29_29.getTimescale());
                            if (var23_23 == null) {
                                var4_4.append("m=video 0 " + var7_7 + " " + var29_29.getSDPTypeId() + "\r\n");
                                var4_4.append(var29_29.getSDPStr());
                                if (this.rtspSessionExtraLines.size() > 0) {
                                    for (RTSPExtraLine var31_31 : this.rtspSessionExtraLines) {
                                        if (var31_31.location != 2) continue;
                                        var4_4.append(var31_31.line + "\r\n");
                                    }
                                }
                                var4_4.append("a=control:" + (String)var27_27 + "\r\n");
                            }
                        }
                    }
                }
            }
        }
        var5_5 = var4_4.length() == 0 ? null : var4_4.toString();
        return var5_5;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public String getTransportMode() {
        return this.transportMode;
    }

    public void setTransportMode(String string) {
        this.transportMode = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNormalizedNTPTimecode(long l) {
        long l2 = l;
        Object object = this.streamLock;
        synchronized (object) {
            if (this.ntpRTOffset == -1L) {
                this.ntpRTOffset = l;
            }
            l2 = this.createTime + (l - this.ntpRTOffset);
        }
        return SystemUtils.toNTPTime(l2);
    }

    public boolean isForceRTSPInterleaved() {
        return this.isForceRTSPInterleaved;
    }

    public void setForceRTSPInterleaved(boolean bl) {
        this.isForceRTSPInterleaved = bl;
    }

    public String getRTPInfo(double d, int n, int n2) {
        String string = null;
        long l = -1L;
        try {
            IApplicationInstance iApplicationInstance;
            RTPTrack rTPTrack = this.getStreamTrack();
            if (rTPTrack == null && (iApplicationInstance = this.getAppInstance()) != null) {
                boolean bl = this.isLive();
                IMediaStream iMediaStream = null;
                IMediaReader iMediaReader = null;
                if (!(!bl ? (iMediaReader = this.mediaReader) == null : (iMediaStream = iApplicationInstance.getStreams().getStream(this.getStreamName())) == null)) {
                    AMFPacket[] aMFPacketArray = bl ? this.getLastPacketsByType(iMediaStream) : this.getLastPacketsByType(iMediaReader, d);
                    AMFPacket aMFPacket = aMFPacketArray[0];
                    AMFPacket aMFPacket2 = aMFPacketArray[1];
                    if (aMFPacket != null || aMFPacket2 != null) {
                        if (aMFPacket2 != null) {
                            l = aMFPacket2.getAbsTimecode();
                        }
                        if (aMFPacket != null) {
                            l = aMFPacket.getAbsTimecode();
                        }
                        if (l >= 0L) {
                            IMediaStreamPlay iMediaStreamPlay;
                            IMediaStream iMediaStream2 = this.getStream();
                            if (bl && iMediaStream2 != null && aMFPacket != null && (iMediaStreamPlay = iMediaStream2.getPlayer()) != null && iMediaStreamPlay instanceof MediaStreamRTPPlay) {
                                ((MediaStreamRTPPlay)iMediaStreamPlay).setRTPTargetPacketSeq(aMFPacket.getSeq());
                            }
                            string = this.formatRTPInfo(l, n, n2);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPPlayer.getRTPInfo: " + exception.toString());
        }
        return string;
    }

    public String formatRTPInfo(long l, int n, int n2) {
        String string = null;
        for (String string2 : this.tracks.keySet()) {
            RTPTrack rTPTrack = this.tracks.get(string2);
            if (rTPTrack == null) continue;
            int n3 = rTPTrack.isVideo() ? n : n2;
            long l2 = rTPTrack.getTimescale();
            long l3 = l * l2 / 1000L;
            string = string == null ? "" : string + ",";
            string = string + "url=" + string2 + ";seq=" + n3 + ";rtptime=" + (l3 %= 0x100000000L);
        }
        return string;
    }

    public String getRTSPSessionName() {
        return this.rtspSessionName;
    }

    public void setRTSPSessionName(String string) {
        this.rtspSessionName = string;
    }

    public String getRTSPSessionDescription() {
        return this.rtspSessionDescription;
    }

    public void setRTSPSessionDescription(String string) {
        this.rtspSessionDescription = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSendSDESEvents() {
        boolean bl = false;
        Object object = this.streamLock;
        synchronized (object) {
            bl = this.sendSDESEvents;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSendSDESEvents(boolean bl) {
        Object object = this.streamLock;
        synchronized (object) {
            this.sendSDESEvents = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMPEGTSOut() {
        boolean bl = false;
        Object object = this.streamLock;
        synchronized (object) {
            bl = this.isMPEGTSOut;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMPEGTSOut(boolean bl) {
        Object object = this.streamLock;
        synchronized (object) {
            this.isMPEGTSOut = bl;
        }
    }

    public String transportFindBestMatch(String string) {
        String string2 = string;
        if (string.indexOf(",") >= 0) {
            try {
                int n;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                ArrayList<String> arrayList = new ArrayList<String>();
                String[] stringArray = string.split("[,]");
                for (n = 0; n < stringArray.length; ++n) {
                    String string3 = stringArray[n].trim();
                    if (string3.length() <= 0) continue;
                    arrayList.add(string3);
                    try {
                        Object object = string3.split("[;]");
                        if (((String[])object).length < 2) continue;
                        hashMap.put(object[0] + ";" + object[1], string3);
                        continue;
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTPTrack.transportFindBestMatch[1]: " + string + ": " + exception.toString());
                    }
                }
                n = this.isMPEGTSOut() ? 1 : 0;
                string2 = null;
                if (n != 0) {
                    string2 = (String)hashMap.get("MP2T/AVP/TCP;unicast");
                    if (string2 == null && (string2 = (String)hashMap.get("MP2T/AVP/UDP;unicast")) == null && (string2 = (String)hashMap.get("MP2T/H2221/TCP;unicast")) == null && (string2 = (String)hashMap.get("MP2T/H2221/UDP;unicast")) == null && (string2 = (String)hashMap.get("MP2T/TCP;unicast")) == null && (string2 = (String)hashMap.get("MP2T/UDP;unicast")) == null) {
                        for (Object object : hashMap.keySet()) {
                            if (!((String)object).startsWith("MP2T") || ((String)object).indexOf("unicast") < 0) continue;
                            string2 = (String)hashMap.get(object);
                            break;
                        }
                    }
                } else {
                    string2 = (String)hashMap.get("RTP/AVP/TCP;unicast");
                    if (string2 == null && (string2 = (String)hashMap.get("RTP/AVP/UDP;unicast")) == null && (string2 = (String)hashMap.get("RTP/TCP;unicast")) == null && (string2 = (String)hashMap.get("RTP/UDP;unicast")) == null) {
                        for (Object object : hashMap.keySet()) {
                            if (!((String)object).startsWith("RTP") || ((String)object).indexOf("unicast") < 0) continue;
                            string2 = (String)hashMap.get(object);
                            break;
                        }
                    }
                }
                if (string2 == null) {
                    string2 = arrayList.size() > 0 ? (String)arrayList.get(0) : string;
                }
                WMSLoggerFactory.getLogger(RTSPCore.class).debug("RTSPBestMatch: " + string2);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTPTrack.transportFindBestMatch[2]: " + string + ": " + exception.toString());
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAutoAllocateInterleavePorts() {
        int n = 0;
        Object object = this.streamLock;
        synchronized (object) {
            n = this.autoAllocateInterleavePorts;
            this.autoAllocateInterleavePorts += 2;
        }
        return n;
    }

    public boolean isLive() {
        return this.isLive;
    }

    public void setLive(boolean bl) {
        this.isLive = bl;
    }

    public IMediaReader getMediaReader() {
        return this.mediaReader;
    }

    public int getRTSPSessionTimeout() {
        return this.rtspSessionTimeout;
    }

    public void setRTSPSessionTimeout(int n) {
        this.rtspSessionTimeout = n;
    }

    public int getRTSPMaximumPendingWriteBytes() {
        return this.rtspMaximumPendingWriteBytes;
    }

    public void setRTSPMaximumPendingWriteBytes(int n) {
        this.rtspMaximumPendingWriteBytes = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTimeout(long l, int n) {
        boolean bl = false;
        long l2 = 0L;
        Object object = this.touchObj;
        synchronized (object) {
            if (this.lastTimeoutCount < 0L || this.touchCount != this.lastTimeoutCount) {
                this.lastTimeoutCount = this.touchCount;
                this.lastTimeoutTimecode = l;
            } else {
                l2 = l - this.lastTimeoutTimecode;
                bl = l2 > (long)n;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch() {
        Object object = this.touchObj;
        synchronized (object) {
            ++this.touchCount;
        }
    }

    public String getRTSPBindIpAddress() {
        return this.rtspBindIpAddress;
    }

    public void setRTSPBindIpAddress(String string) {
        if (string != null && string.length() <= 0) {
            string = null;
        }
        this.rtspBindIpAddress = string;
    }

    public String getRTSPConnectionIpAddress() {
        return this.rtspConnectionIpAddress;
    }

    public void setRTSPConnectionIpAddress(String string) {
        this.rtspConnectionIpAddress = string;
    }

    public String getRTSPConnectionAddressType() {
        return this.rtspConnectionAddressType;
    }

    public void setRTSPConnectionAddressType(String string) {
        this.rtspConnectionAddressType = string;
    }

    public String getRTSPOriginIpAddress() {
        return this.rtspOriginIpAddress;
    }

    public void setRTSPOriginIpAddress(String string) {
        this.rtspOriginIpAddress = string;
    }

    public String getRTSPOriginAddressType() {
        return this.rtspOriginAddressType;
    }

    public void setRTSPOriginAddressType(String string) {
        this.rtspOriginAddressType = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getVODStartTimeTC() {
        long l = -1L;
        Object object = this.streamLock;
        synchronized (object) {
            l = this.vodStartTimeTC;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVODStartTimeTC(long l) {
        Object object = this.streamLock;
        synchronized (object) {
            this.vodStartTimeTC = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getVODLastTimeTC() {
        long l = -1L;
        Object object = this.streamLock;
        synchronized (object) {
            l = this.vodLastTimeTC;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVODLastTimeTC(long l) {
        Object object = this.streamLock;
        synchronized (object) {
            this.vodLastTimeTC = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getVODPlayLen() {
        long l = -1L;
        Object object = this.streamLock;
        synchronized (object) {
            l = this.vodPlayLen;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVODPlayLen(long l) {
        Object object = this.streamLock;
        synchronized (object) {
            this.vodPlayLen = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStreamStarted() {
        boolean bl = false;
        Object object = this.streamLock;
        synchronized (object) {
            bl = this.isStreamStarted;
        }
        return bl;
    }

    public boolean isRTSPAlwaysUseSDPPorts() {
        return this.rtspAlwaysUseSDPPorts;
    }

    public void setRTSPAlwaysUseSDPPorts(boolean bl) {
        this.rtspAlwaysUseSDPPorts = bl;
    }

    public void putRTSPSessionExtraLine(int n, String string) {
        this.rtspSessionExtraLines.add(new RTSPExtraLine(n, string));
    }

    public void clearRTSPSessionExtraLines() {
        this.rtspSessionExtraLines.clear();
    }

    public List<RTSPExtraLine> getRTSPSessionExtraLines() {
        ArrayList<RTSPExtraLine> arrayList = new ArrayList<RTSPExtraLine>();
        arrayList.addAll(this.rtspSessionExtraLines);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOPerformanceCounter getIOPerformance() {
        Object object = this.streamLock;
        synchronized (object) {
            return this.streamIOPerformance;
        }
    }

    class RTSPExtraLine {
        String line = null;
        int location = 0;

        public RTSPExtraLine(int n, String string) {
            this.location = n;
            this.line = string;
        }
    }
}

