/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BufferUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPPacketizerRTCPSenderBase;
import com.wowza.wms.stream.IMediaStream;
import java.io.OutputStream;

public class RTPPacketizerRTCPSender
extends RTPPacketizerRTCPSenderBase {
    public static final int RTCP_FREQUENCY = 5000;
    public static final byte[] SR_PACKET = new byte[]{-128, -56, 0, 6, 0, 0, 96, 78, -51, 100, 29, -18, 96, 0, 2, 34, 0, 0, 8, -102, 0, 0, 0, 1, 0, 0, 3, -8};
    protected long lastSentRTCP = -1L;

    public int sendRTCP(OutputStream outputStream, IRTPPacketizer iRTPPacketizer, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        int n = 0;
        try {
            long l2 = System.currentTimeMillis();
            if (this.lastSentRTCP == -1L || l2 - this.lastSentRTCP > 5000L) {
                this.lastSentRTCP = l2;
                byte[] byArray = new byte[SR_PACKET.length];
                System.arraycopy(SR_PACKET, 0, byArray, 0, byArray.length);
                long l3 = rTPTrack.getSSRC();
                int n2 = rTPTrack.getTimescale();
                long l4 = Math.round((double)(l * (long)n2) / 1000.0);
                int n3 = 0;
                long l5 = rTPTrack.getRTPStream().getNormalizedNTPTimecode(l + (long)n3);
                long l6 = iRTPPacketizer.getPacketCount();
                long l7 = iRTPPacketizer.getRTCPOctetCount();
                int n4 = 4;
                BufferUtils.longToByteArray(l3, byArray, n4, 4);
                BufferUtils.longToByteArray(l5, byArray, n4 += 4, 8);
                BufferUtils.longToByteArray(l4, byArray, n4 += 8, 4);
                BufferUtils.longToByteArray(l6, byArray, n4 += 4, 4);
                BufferUtils.longToByteArray(l7, byArray, n4 += 4, 4);
                n += rTPTrack.sendRCTPMessage(outputStream, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerRTCPSender.class).error("RTPPacketizerRTCPSender.sendRTCP: " + exception.toString());
            exception.printStackTrace();
        }
        return n;
    }
}

