/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtsp;

import com.wowza.util.Base64;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPSessions;
import com.wowza.wms.rtsp.RTSPRequestAdapter;
import com.wowza.wms.rtsp.RTSPRequestMessage;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.RtmpResponseMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.vhost.IVHost;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;

public class RTSPTunnelingSession {
    private Object lock = new Object();
    private RTPContext rtpContext = null;
    private String rtspTunnelingSessionId = null;
    private String rtspSessionId = null;
    private IoSession responseSession = null;
    private Map<IoSession, RequestSession> requestSessions = new HashMap<IoSession, RequestSession>();
    private long closeTime = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IoSession getResponseSession(IVHost iVHost, IoSession ioSession) {
        RTSPTunnelingSession rTSPTunnelingSession;
        String string;
        IoSession ioSession2 = null;
        RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
        if (rtmpSessionInfo != null && (string = rtmpSessionInfo.getRTSPTunnelingSessionId()) != null && (rTSPTunnelingSession = iVHost.getRTPContext().getRTSPTunnelingSession(string)) != null) {
            Object object = rTSPTunnelingSession.lock;
            synchronized (object) {
                ioSession2 = rTSPTunnelingSession.getResponseSession();
            }
        }
        return ioSession2;
    }

    public static String requestToSessionId(RTPContext rTPContext, IoSession ioSession, RtmpRequestMessage rtmpRequestMessage) {
        String string;
        Map<String, String> map;
        int[] nArray;
        Object object;
        String string2 = "127.0.0.1";
        SocketAddress socketAddress = ioSession.getRemoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            object = (InetSocketAddress)socketAddress;
            string2 = ((InetSocketAddress)object).getAddress().toString().replace("/", "");
        }
        object = null;
        byte[] byArray = rtmpRequestMessage.getBody().array();
        if (byArray != null && (nArray = RTSPRequestMessage.quickParseHeader(byArray, 0, byArray.length)) != null && nArray[0] > 0 && (map = RTSPRequestMessage.fullParseHeader(byArray, 0, nArray[0])) != null && (string = map.get("x-sessioncookie")) != null) {
            object = string;
        }
        return object == null ? null : string2 + "|" + (String)object;
    }

    public RTSPTunnelingSession(RTPContext rTPContext, String string) {
        this.rtpContext = rTPContext;
        this.rtspTunnelingSessionId = string;
    }

    public Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoSession getResponseSession() {
        Object object = this.lock;
        synchronized (object) {
            return this.responseSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponseSession(IoSession ioSession) {
        WMSLoggerFactory.getLogger(null).info("RTSPTunnelingSession.newSessionGET[" + this.rtspTunnelingSessionId + "]");
        Object object = this.lock;
        synchronized (object) {
            this.responseSession = ioSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPContext getRTPContext() {
        Object object = this.lock;
        synchronized (object) {
            return this.rtpContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRTSPTunnelingSessionId() {
        Object object = this.lock;
        synchronized (object) {
            return this.rtspTunnelingSessionId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            RequestSession requestSession = this.requestSessions.get(ioSession);
            if (requestSession == null) {
                requestSession = new RequestSession(ioSession);
                this.requestSessions.put(ioSession, requestSession);
                WMSLoggerFactory.getLogger(null).info("RTSPTunnelingSession.newSessionPOST[" + this.rtspTunnelingSessionId + "]");
            }
            if (this.responseSession != null) {
                Object[] objectArray;
                Object[] objectArray2 = rtmpRequestMessage.getBody().array();
                int n = 0;
                int n2 = rtmpRequestMessage.getContentLength();
                if (bl && (objectArray = RTSPRequestMessage.quickParseHeader(objectArray2, 0, objectArray2.length)) != null) {
                    n = objectArray[0];
                    n2 -= n;
                }
                if (n2 >= 0) {
                    int n3;
                    int n4;
                    if (requestSession.leftover != null) {
                        objectArray = new byte[requestSession.leftover.length + n2];
                        n4 = 0;
                        System.arraycopy(requestSession.leftover, 0, objectArray, n4, requestSession.leftover.length);
                        System.arraycopy(objectArray2, n, objectArray, n4 += requestSession.leftover.length, n2);
                        n4 += n2;
                        objectArray2 = objectArray;
                        n = 0;
                        n2 = n4;
                        requestSession.leftover = null;
                    }
                    if (n2 > 0 && (n4 = n2 - (n3 = n2 % 4)) > 0) {
                        byte[] byArray = null;
                        try {
                            String string = new String((byte[])objectArray2, n, n4);
                            byArray = Base64.decode(string);
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(null).warn("RTSPTunnelingSession.handleMessage[" + this.rtspTunnelingSessionId + "]: Base64.decode: " + exception.toString());
                        }
                        if (byArray != null) {
                            int n5 = byArray.length;
                            boolean bl2 = false;
                            int[] nArray = RTSPRequestMessage.quickParseHeader(byArray, 0, n5);
                            if (nArray != null && n5 >= nArray[0] + nArray[1]) {
                                n5 = nArray[0] + nArray[1];
                                bl2 = true;
                            }
                            if (!bl2) {
                                System.out.println("!isFullMessage: " + n2);
                                requestSession.leftover = new byte[n2];
                                System.arraycopy(objectArray2, n, requestSession.leftover, 0, requestSession.leftover.length);
                            } else {
                                int n6 = n5 / 3 * 4 + (n5 % 3 > 0 ? 4 : 0);
                                if (n6 < n2) {
                                    requestSession.leftover = new byte[n2 - n6];
                                    System.arraycopy(objectArray2, n + n6, requestSession.leftover, 0, requestSession.leftover.length);
                                }
                                try {
                                    IVHost iVHost = this.rtpContext.getVHost();
                                    RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)this.responseSession.getAttribute("wmsSessionInfo");
                                    RtmpRequestMessage rtmpRequestMessage2 = new RtmpRequestMessage(rtmpSessionInfo, iVHost.getName(), 34, false);
                                    rtmpRequestMessage2.setVHost(iVHost);
                                    rtmpRequestMessage2.setBody(ByteBuffer.wrap((byte[])byArray, (int)0, (int)n5));
                                    RTSPRequestAdapter.decodeMessage(this.responseSession, rtmpRequestMessage2, rtmpResponseMessage);
                                    String string = rtmpSessionInfo.getRTSPSessionId();
                                    if (this.rtspSessionId == null && string != null) {
                                        this.rtspSessionId = string;
                                    }
                                }
                                catch (Exception exception) {
                                    WMSLoggerFactory.getLogger(null).warn("RTSPTunnelingSession.handleMessage[" + this.rtspTunnelingSessionId + "]: Base64.decode: " + exception.toString());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleIdle(IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        Object object = this.lock;
        synchronized (object) {
            if (this.responseSession != null) {
                RTSPRequestAdapter.handleIdle(this.responseSession, rtmpRequestMessage, rtmpResponseMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCloseTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.closeTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSessionGET(IVHost iVHost, IoSession ioSession) {
        boolean bl = false;
        RTPSessions rTPSessions = null;
        RTPSession rTPSession = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.responseSession == ioSession) {
                if (this.rtspSessionId != null) {
                    rTPSessions = this.rtpContext.getSessions();
                    rTPSession = rTPSessions.getSession(this.rtspSessionId);
                }
                this.responseSession = null;
                this.closeTime = System.currentTimeMillis();
                bl = true;
            }
        }
        if (rTPSessions != null && rTPSession != null) {
            try {
                if (rTPSession.isConnected()) {
                    object = rTPSession.getSessionId();
                    rTPSessions.notifySessionDestroy(rTPSession.getAppInstance(), rTPSession);
                    rTPSession.shutdown();
                    rTPSessions.removeSession(rTPSession);
                    if (rTPSession.isLoggedConnect()) {
                        rTPSession.updateLoggingValues();
                        WMSLoggerFactory.getLoggerObj(rTPSession.getAppInstance()).info(null, null, "rtsp", "disconnect", 200, (String)object);
                        rTPSession.clearLoggingValues();
                        rTPSession.setLoggedConnect(false);
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).error("RTSPTunnelingSession.shutdown[" + this.rtspTunnelingSessionId + "]: " + exception.toString());
            }
        }
        WMSLoggerFactory.getLogger(null).info("RTSPTunnelingSession.closeSessionGET[" + this.rtspTunnelingSessionId + "]: " + bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSessionPOST(IVHost iVHost, IoSession ioSession) {
        RequestSession requestSession = null;
        Object object = this.lock;
        synchronized (object) {
            requestSession = this.requestSessions.remove(ioSession);
        }
        WMSLoggerFactory.getLogger(null).info("RTSPTunnelingSession.closeSessionPOST[" + this.rtspTunnelingSessionId + "]: " + (requestSession != null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllPOSTSessions() {
        ArrayList<RequestSession> arrayList = new ArrayList<RequestSession>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            arrayList.addAll(this.requestSessions.values());
        }
        for (RequestSession requestSession : arrayList) {
            try {
                requestSession.session.close();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).error("RTSPTunnelingSession.closeAllPOSTSessions[" + this.rtspTunnelingSessionId + "]: " + exception.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            this.requestSessions.clear();
            this.responseSession = null;
        }
        WMSLoggerFactory.getLogger(null).info("RTSPTunnelingSession.shutdown[" + this.rtspTunnelingSessionId + "]");
    }

    class RequestSession {
        IoSession session = null;
        byte[] leftover = null;

        public RequestSession(IoSession ioSession) {
            this.session = ioSession;
        }
    }
}

