/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.util.HTTPUtils;
import com.wowza.wms.server.RtmpResponseMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import java.nio.charset.CharsetEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.demux.MessageEncoder;
import org.apache.mina.transport.socket.nio.FastMinaMessage;
import org.apache.mina.util.CharsetUtil;

public class RtmpResponseEncoder
implements MessageEncoder {
    private static final Set TYPES;
    private static final byte[] CRLF;

    public static int outputHeader(RtmpResponseMessage rtmpResponseMessage, ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate((int)1024);
            byteBuffer.setAutoExpand(true);
        }
        try {
            CharsetEncoder charsetEncoder = CharsetUtil.getDefaultCharset().newEncoder();
            byteBuffer.putString((CharSequence)(rtmpResponseMessage.getProtocolStr() + " "), charsetEncoder);
            byteBuffer.putString((CharSequence)String.valueOf(rtmpResponseMessage.getResponseCode()), charsetEncoder);
            String string = HTTPUtils.statusCodeToStr(rtmpResponseMessage.getResponseCode());
            byteBuffer.putString((CharSequence)(" " + string), charsetEncoder);
            byteBuffer.put(CRLF);
            for (Map.Entry<String, String> entry : rtmpResponseMessage.getHeaders().entrySet()) {
                byteBuffer.putString((CharSequence)entry.getKey(), charsetEncoder);
                byteBuffer.putString((CharSequence)": ", charsetEncoder);
                byteBuffer.putString((CharSequence)entry.getValue(), charsetEncoder);
                byteBuffer.put(CRLF);
            }
            byteBuffer.putString((CharSequence)"Content-Length: ", charsetEncoder);
            byteBuffer.putString((CharSequence)String.valueOf(rtmpResponseMessage.isSendBody() ? rtmpResponseMessage.getBodyLength() : 0), charsetEncoder);
            byteBuffer.put(CRLF);
            byteBuffer.put(CRLF);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteBuffer.position();
    }

    public void encodeExpand(IoSession ioSession, Object object, ProtocolEncoderOutput protocolEncoderOutput) throws Exception {
        RtmpResponseMessage rtmpResponseMessage = (RtmpResponseMessage)object;
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)(rtmpResponseMessage.getContentLength() + 1024));
        byteBuffer.setAutoExpand(true);
        try {
            RtmpResponseEncoder.outputHeader(rtmpResponseMessage, byteBuffer);
            int n = 0;
            if (rtmpResponseMessage.isSendBody()) {
                for (ByteBuffer byteBuffer2 : rtmpResponseMessage.getBodyList()) {
                    int n2 = byteBuffer.limit() - byteBuffer.position();
                    byteBuffer.put(byteBuffer2);
                    n += n2;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        byteBuffer.flip();
        protocolEncoderOutput.write(byteBuffer);
    }

    public void encode(IoSession ioSession, Object object, ProtocolEncoderOutput protocolEncoderOutput) throws Exception {
        RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
        if (rtmpSessionInfo.isSSL()) {
            this.encodeExpand(ioSession, object, protocolEncoderOutput);
            return;
        }
        try {
            RtmpResponseMessage rtmpResponseMessage = (RtmpResponseMessage)object;
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)1024);
            byteBuffer.setAutoExpand(true);
            RtmpResponseEncoder.outputHeader(rtmpResponseMessage, byteBuffer);
            int n = rtmpResponseMessage.getContentLength();
            n += byteBuffer.position();
            byteBuffer.flip();
            List<ByteBuffer> list = rtmpResponseMessage.getBodyList();
            if (!rtmpResponseMessage.isSendBody()) {
                list.clear();
            }
            list.add(0, byteBuffer);
            ByteBuffer byteBuffer2 = ByteBuffer.allocate((int)1, (boolean)false);
            byteBuffer2.setExtra((Object)new FastMinaMessage(list, n));
            byteBuffer2.put((byte)0);
            byteBuffer2.flip();
            protocolEncoderOutput.write(byteBuffer2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Set getMessageTypes() {
        return TYPES;
    }

    static {
        HashSet<Class<RtmpResponseMessage>> hashSet = new HashSet<Class<RtmpResponseMessage>>();
        hashSet.add(RtmpResponseMessage.class);
        TYPES = Collections.unmodifiableSet(hashSet);
        CRLF = new byte[]{13, 10};
    }
}

