/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.util.BufferUtils;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.ClientWriteListener;
import com.wowza.wms.http.HTTPRequestAdapter;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerAdapter;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtsp.RTSPRequestAdapter;
import com.wowza.wms.rtsp.RTSPTunnelingSession;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.RtmpResponseMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.util.ApplicationUtils;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.support.IWriteListener;
import org.apache.mina.transport.socket.nio.FastMinaMessage;

public class ServerHandler
extends IoHandlerAdapter {
    public static final String WMSSESSIONINFO = "wmsSessionInfo";
    private String vhostName = "_defaultVHost_";
    private boolean isSecure = false;
    private IServer server = null;
    private IOPerformanceCounter ioPerformanceCounter = new IOPerformanceCounter();
    private HostPort hostPort = null;
    private IVHost vhost = null;
    private boolean ignoreTCPResetForRTMPTConnections = false;
    private boolean ignoreTCPResetForAllConnections = false;
    private boolean debugTCPExceptions = false;

    public static BigInteger sDecode2(String string, int n) {
        int n2;
        string = string.replace("R", "2");
        string = string.replace("T", "0");
        string = string.replace("U", "O");
        string = string.replace("V", "I");
        string = string.replace("W", "L");
        string = string.replace("X", "1");
        string = string.replace("Y", "5");
        while (string.startsWith("S")) {
            string = string.substring(1);
        }
        BigInteger bigInteger = new BigInteger(string, n);
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = new byte[15];
        System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
        for (n2 = 0; n2 < byArray2.length && byArray2[n2] == 0; ++n2) {
        }
        ++n2;
        class Enc {
            private byte[] arr = new byte[256];
            private int r1 = 0;
            private int r2 = 0;

            Enc() {
            }

            public void i1(byte[] byArray, int n, int n2) {
                int n3;
                for (n3 = 0; n3 < 256; ++n3) {
                    this.arr[n3] = (byte)n3;
                }
                n3 = 0;
                for (int i = 0; i < 256; ++i) {
                    n3 = n3 + (this.arr[i] & 0xFF) + byArray[n + i % n2] & 0xFF;
                    byte by = this.arr[n3];
                    this.arr[n3] = this.arr[i];
                    this.arr[i] = by;
                }
            }

            public void i2(byte[] byArray, int n, int n2) {
                byte by = 0;
                int n3 = n + n2;
                do {
                    ++this.r1;
                    this.r1 &= 0xFF;
                    this.r2 = this.r2 + this.arr[this.r1] & 0xFF;
                    by = this.arr[this.r2];
                    this.arr[this.r2] = this.arr[this.r1];
                    this.arr[this.r1] = by;
                    byArray[n] = (byte)(byArray[n] ^ this.arr[this.arr[this.r1] + this.arr[this.r2] & 0xFF]);
                } while (++n < n3);
            }
        }
        Enc enc = new Enc();
        byte[] byArray3 = BufferUtils.decodeHexString(RTMPRequestAdapter.fN(ModuleConnect.getN(123)));
        byte[] byArray4 = BufferUtils.decodeHexString(RTMPRequestAdapter.fN(ModuleConnect.getN(124)));
        enc.i1(byArray4, 0, byArray4.length);
        enc.i2(byArray3, 0, byArray3.length);
        enc.i2(byArray2, n2, byArray2.length - n2);
        byte[] byArray5 = new byte[byArray2.length - 1];
        System.arraycopy(byArray2, 0, byArray5, 0, byArray5.length);
        BigInteger bigInteger2 = new BigInteger(byArray5);
        return bigInteger2;
    }

    public static int dDecode(String string, int n) {
        string = string.replace("R", "2");
        string = string.replace("T", "0");
        string = string.replace("U", "O");
        string = string.replace("V", "I");
        string = string.replace("W", "L");
        string = string.replace("X", "1");
        string = string.replace("Y", "5");
        return Integer.parseInt(string, n);
    }

    public ServerHandler(String string, boolean bl, HostPort hostPort, IServer iServer) {
        this.vhostName = string;
        this.isSecure = bl;
        this.server = iServer;
        this.hostPort = hostPort;
        VHost vHost = (VHost)VHostSingleton.getInstance(this.vhostName);
        if (vHost != null) {
            this.ignoreTCPResetForRTMPTConnections = vHost.getProperties().getPropertyBoolean("ignoreTCPResetForRTMPTConnections", this.ignoreTCPResetForRTMPTConnections);
            this.ignoreTCPResetForAllConnections = vHost.getProperties().getPropertyBoolean("ignoreTCPResetForAllConnections", this.ignoreTCPResetForAllConnections);
            this.debugTCPExceptions = vHost.getProperties().getPropertyBoolean("debugTCPExceptions", this.debugTCPExceptions);
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(ServerHandler.class);
            if (wMSLogger.isDebugEnabled()) {
                this.debugTCPExceptions = true;
            }
            if (this.debugTCPExceptions) {
                WMSLoggerFactory.getLogger(ServerHandler.class).info("ServerHandler[" + string + ":" + hostPort.toString() + "]: debugTCPExceptions:" + this.debugTCPExceptions);
            }
            if (this.ignoreTCPResetForRTMPTConnections) {
                WMSLoggerFactory.getLogger(ServerHandler.class).info("ServerHandler[" + string + ":" + hostPort.toString() + "]: ignoreTCPResetForRTMPTConnections:" + this.ignoreTCPResetForRTMPTConnections);
            }
            if (this.ignoreTCPResetForAllConnections) {
                WMSLoggerFactory.getLogger(ServerHandler.class).info("ServerHandler[" + string + ":" + hostPort.toString() + "]: ignoreTCPResetForAllConnections:" + this.ignoreTCPResetForAllConnections);
            }
        }
    }

    public IOPerformanceCounter getIoPerformanceCounter() {
        return this.ioPerformanceCounter;
    }

    public void sessionClosed(IoSession ioSession) {
        Object object;
        RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute(WMSSESSIONINFO);
        int n = rtmpSessionInfo.getProtocol();
        if (rtmpSessionInfo.isOpen() && n == 1) {
            object = new RtmpResponseMessage(this.vhostName);
            RtmpRequestMessage rtmpRequestMessage = new RtmpRequestMessage(rtmpSessionInfo, this.vhostName, 1, this.isSecure);
            rtmpRequestMessage.setType(4);
            rtmpRequestMessage.setClientId(rtmpSessionInfo.getClientId());
            WMSLoggerFactory.getLogger(VHost.class).debug("sessionClosed: send close");
            this.serviceRequest(ioSession, rtmpSessionInfo, rtmpRequestMessage, (RtmpResponseMessage)object);
        }
        object = (VHost)VHostSingleton.getInstance(this.vhostName);
        ((VHost)object).removeSession(ioSession);
        if (n == 34 || n == 38 || n == 39) {
            RTSPRequestAdapter.closeSession((IVHost)object, ioSession);
        }
    }

    public void sessionOpened(IoSession ioSession) throws Exception {
        try {
            SocketAddress socketAddress;
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute(WMSSESSIONINFO);
            String string = "127.0.0.1";
            String string2 = "127.0.0.1";
            SocketAddress socketAddress2 = ioSession.getRemoteAddress();
            if (socketAddress2 instanceof InetSocketAddress) {
                socketAddress = (InetSocketAddress)socketAddress2;
                string = ((InetSocketAddress)socketAddress).getAddress().toString().replace("/", "");
            }
            if ((socketAddress = ioSession.getLocalAddress()) instanceof InetSocketAddress) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                string2 = inetSocketAddress.getAddress().toString().replace("/", "");
            }
            rtmpSessionInfo.setIpAddress(string);
            rtmpSessionInfo.setLocalIpAddress(string2);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ServerHandler.class).error("sessionOpened: " + exception.toString());
        }
    }

    public void sessionCreated(IoSession ioSession) {
        VHost vHost = (VHost)VHostSingleton.getInstance(this.vhostName);
        RtmpSessionInfo rtmpSessionInfo = new RtmpSessionInfo(this.isSecure, "unknown");
        ioSession.setAttribute(WMSSESSIONINFO, (Object)rtmpSessionInfo);
        rtmpSessionInfo.setServer(this.server);
        rtmpSessionInfo.setHostPort(this.hostPort);
        rtmpSessionInfo.setVHost(vHost);
        vHost.addSession(ioSession);
        this.vhost = vHost;
    }

    private void handleMessageReceived(RtmpSessionInfo rtmpSessionInfo, IoSession ioSession, Object object) {
        Object object2;
        Object object3;
        int n = rtmpSessionInfo.getProtocol();
        if (!rtmpSessionInfo.isIdleRunning()) {
            if (n == 1) {
                ioSession.setIdleTimeInMillis(IdleStatus.BOTH_IDLE, 500L);
            } else {
                ioSession.setIdleTimeInMillis(IdleStatus.BOTH_IDLE, 10000L);
            }
            rtmpSessionInfo.setIdleRunning(true);
        }
        if (!rtmpSessionInfo.isOpen() && !rtmpSessionInfo.isClosed()) {
            Object object4;
            Object object5;
            object3 = (String)MediaStreamBase.sinfo.get("s");
            object2 = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string = RTMPRequestAdapter.fS(((BigInteger)object2).toByteArray(), (String)object3);
            if (string.indexOf("d=") >= 0) {
                int n2;
                int n3 = 0;
                int n4 = 0;
                object5 = string.split("[|]");
                for (n2 = 0; n2 < ((String[])object5).length; ++n2) {
                    String[] stringArray = object5[n2].split("[=]");
                    if (stringArray.length != 2 || !stringArray[0].equals("d") || ((String[])(object4 = stringArray[1].split("[-]"))).length != 2) continue;
                    n3 = Integer.parseInt("20" + object4[0]);
                    n4 = Integer.parseInt("20" + (String)object4[1]);
                }
                n2 = Integer.parseInt(FastDateFormat.getInstance((String)"yyyyMMdd").format(new Date()));
                if (n2 < n3 || n2 > n4) {
                    WMSLoggerFactory.getLogger(ServerHandler.class).error(RTMPRequestAdapter.fN(ModuleConnect.getN(118)));
                    System.exit(0);
                }
                if (!ApplicationUtils.isGood()) {
                    WMSLoggerFactory.getLogger(ServerHandler.class).error(RTMPRequestAdapter.fN(ModuleConnect.getN(119)));
                    System.exit(0);
                }
            }
            Client client = null;
            if (n == 1) {
                RtmpResponseMessage rtmpResponseMessage = new RtmpResponseMessage(this.vhostName);
                object5 = new RtmpRequestMessage(rtmpSessionInfo, this.vhostName, 1, this.isSecure);
                ((RtmpRequestMessage)object5).setType(1);
                ((RtmpRequestMessage)object5).setClientId(-1);
                this.serviceRequest(ioSession, rtmpSessionInfo, (RtmpRequestMessage)object5, rtmpResponseMessage);
                RtmpRequestMessage rtmpRequestMessage = (RtmpRequestMessage)object;
                int n5 = rtmpResponseMessage.getClientId();
                rtmpSessionInfo.setClientId(n5);
                rtmpRequestMessage.setClientId(n5);
                object4 = (VHost)VHostSingleton.getInstance(this.vhostName);
                client = (Client)((VHost)object4).getClient(n5);
                if (client != null) {
                    client.setIoSession(ioSession);
                    ioSession.addWriteListener((IWriteListener)client.getWriteListener());
                }
            }
            VHost vHost = (VHost)VHostSingleton.getInstance(this.vhostName);
            vHost.notifySessionOpen(ioSession, n, client);
            rtmpSessionInfo.setOpen(true);
        }
        object3 = (RtmpRequestMessage)object;
        object2 = new RtmpResponseMessage(this.vhostName);
        ((RtmpRequestMessage)object3).setVHostName(this.vhostName);
        if (n == 1) {
            ((RtmpRequestMessage)object3).setClientId(rtmpSessionInfo.getClientId());
        }
        ((RtmpResponseMessage)object2).setProtocolStr(((RtmpRequestMessage)object3).getProtocolStr());
        this.ioPerformanceCounter.incrementMessagesIn(((RtmpRequestMessage)object3).getContentLength());
        this.serviceRequest(ioSession, rtmpSessionInfo, (RtmpRequestMessage)object3, (RtmpResponseMessage)object2);
    }

    private void handleSessionIdle(RtmpSessionInfo rtmpSessionInfo, IoSession ioSession) {
        int n = rtmpSessionInfo.getProtocol();
        if (n == 1) {
            if (rtmpSessionInfo.isOpen()) {
                RtmpResponseMessage rtmpResponseMessage = new RtmpResponseMessage(this.vhostName);
                RtmpRequestMessage rtmpRequestMessage = new RtmpRequestMessage(rtmpSessionInfo, this.vhostName, 1, this.isSecure);
                rtmpRequestMessage.setType(3);
                rtmpRequestMessage.setLastReadTime(System.currentTimeMillis() - ioSession.getLastReadTime());
                rtmpRequestMessage.setClientId(rtmpSessionInfo.getClientId());
                this.serviceRequest(ioSession, rtmpSessionInfo, rtmpRequestMessage, rtmpResponseMessage);
            }
        } else if (n == 34 || n == 38) {
            if (rtmpSessionInfo.isOpen()) {
                RtmpResponseMessage rtmpResponseMessage = new RtmpResponseMessage(this.vhostName);
                RtmpRequestMessage rtmpRequestMessage = new RtmpRequestMessage(rtmpSessionInfo, this.vhostName, 34, this.isSecure);
                rtmpRequestMessage.setProtocol(n);
                rtmpRequestMessage.setType(3);
                rtmpRequestMessage.setLastReadTime(System.currentTimeMillis() - ioSession.getLastReadTime());
                this.serviceRequest(ioSession, rtmpSessionInfo, rtmpRequestMessage, rtmpResponseMessage);
            }
        } else if (n == 37) {
            if (rtmpSessionInfo.isOpen()) {
                RtmpResponseMessage rtmpResponseMessage = new RtmpResponseMessage(this.vhostName);
                RtmpRequestMessage rtmpRequestMessage = new RtmpRequestMessage(rtmpSessionInfo, this.vhostName, 37, this.isSecure);
                rtmpRequestMessage.setType(3);
                rtmpRequestMessage.setLastReadTime(System.currentTimeMillis() - ioSession.getLastReadTime());
                this.serviceRequest(ioSession, rtmpSessionInfo, rtmpRequestMessage, rtmpResponseMessage);
            }
        } else {
            ioSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoSession ioSession, Object object) {
        RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute(WMSSESSIONINFO);
        Object object2 = ioSession;
        synchronized (object2) {
            if (rtmpSessionInfo.getInHandler() > 0) {
                rtmpSessionInfo.addMessageQueue(object);
                return;
            }
            rtmpSessionInfo.incInHandler();
        }
        object2 = object;
        while (true) {
            if (object2 == null) {
                this.handleSessionIdle(rtmpSessionInfo, ioSession);
            } else {
                this.handleMessageReceived(rtmpSessionInfo, ioSession, object2);
            }
            IoSession ioSession2 = ioSession;
            synchronized (ioSession2) {
                boolean bl;
                boolean bl2 = bl = object2 == null;
                if (rtmpSessionInfo.isMessageQueueEmpty()) {
                    rtmpSessionInfo.decInHandler();
                    break;
                }
                object2 = rtmpSessionInfo.getFirstMessageQueue();
                if (object2 == null && bl) {
                    rtmpSessionInfo.decInHandler();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionIdle(IoSession ioSession, IdleStatus idleStatus) {
        RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute(WMSSESSIONINFO);
        Object object = ioSession;
        synchronized (object) {
            if (rtmpSessionInfo.getInHandler() > 0) {
                rtmpSessionInfo.addMessageQueue(null);
                return;
            }
            rtmpSessionInfo.incInHandler();
        }
        object = null;
        while (true) {
            if (object == null) {
                this.handleSessionIdle(rtmpSessionInfo, ioSession);
            } else {
                this.handleMessageReceived(rtmpSessionInfo, ioSession, object);
            }
            IoSession ioSession2 = ioSession;
            synchronized (ioSession2) {
                boolean bl;
                boolean bl2 = bl = object == null;
                if (rtmpSessionInfo.isMessageQueueEmpty()) {
                    rtmpSessionInfo.decInHandler();
                    break;
                }
                object = rtmpSessionInfo.getFirstMessageQueue();
                if (object == null && bl) {
                    rtmpSessionInfo.decInHandler();
                    break;
                }
            }
        }
    }

    public void exceptionCaught(IoSession ioSession, Throwable throwable) {
        String string = throwable.toString();
        if (string == null) {
            string = "unknown";
        }
        boolean bl = this.isTCPReset(string);
        RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute(WMSSESSIONINFO);
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(ServerHandler.class);
        if (this.debugTCPExceptions) {
            wMSLogger.info("ServerHandler.exceptionCaught[" + this.hostPort.toString() + ":" + rtmpSessionInfo.getIpAddress() + "]: " + string);
        }
        if (this.ignoreTCPResetForAllConnections && bl) {
            wMSLogger.info("ServerHandler.exceptionCaught[" + this.hostPort.toString() + ":" + rtmpSessionInfo.getIpAddress() + "]: ignoreTCPResetForAllConnections: " + string);
            return;
        }
        int n = rtmpSessionInfo.getProtocol();
        if (rtmpSessionInfo.isOpen() && n == 1) {
            RtmpResponseMessage rtmpResponseMessage = new RtmpResponseMessage(this.vhostName);
            RtmpRequestMessage rtmpRequestMessage = new RtmpRequestMessage(rtmpSessionInfo, this.vhostName, 1, this.isSecure);
            rtmpRequestMessage.setType(4);
            rtmpRequestMessage.setClientId(rtmpSessionInfo.getClientId());
            this.serviceRequest(ioSession, rtmpSessionInfo, rtmpRequestMessage, rtmpResponseMessage);
        }
        if (n == 3) {
            if (this.ignoreTCPResetForRTMPTConnections && bl) {
                wMSLogger.info("ServerHandler.exceptionCaught[" + this.hostPort.toString() + ":" + rtmpSessionInfo.getIpAddress() + "]: ignoreTCPResetForRTMPTConnections: " + string);
            } else {
                ioSession.close();
            }
        }
    }

    private boolean isTCPReset(String string) {
        return string.indexOf("reset") >= 0 && string.indexOf("peer") >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceRequest(IoSession ioSession, RtmpSessionInfo rtmpSessionInfo, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        rtmpRequestMessage.setVHost(this.vhost);
        rtmpRequestMessage.setHostPort(this.hostPort);
        int n = rtmpSessionInfo.getProtocol();
        switch (n) {
            case 37: {
                IHTTPStreamerAdapter iHTTPStreamerAdapter = rtmpSessionInfo.getHTTPStreamerAdapter();
                if (iHTTPStreamerAdapter == null) break;
                iHTTPStreamerAdapter.service(ioSession, rtmpRequestMessage, rtmpResponseMessage);
                break;
            }
            case 32: 
            case 33: {
                HTTPRequestAdapter.service(rtmpRequestMessage, rtmpResponseMessage);
                break;
            }
            case 34: 
            case 38: 
            case 39: {
                RTSPRequestAdapter.service(ioSession, rtmpRequestMessage, rtmpResponseMessage);
                break;
            }
            default: {
                RTMPRequestAdapter.service(rtmpRequestMessage, rtmpResponseMessage);
            }
        }
        n = rtmpSessionInfo.getProtocol();
        int n2 = rtmpResponseMessage.getContentLength();
        if (n2 > 0 || n == 32 || n == 38 || n == 39 || n == 33 || n == 37) {
            rtmpResponseMessage.notifyResponseStart();
            this.ioPerformanceCounter.incrementMessagesOut(rtmpResponseMessage.getContentLength());
            switch (n) {
                case 1: 
                case 16: 
                case 17: {
                    if (rtmpSessionInfo.isSSL()) {
                        ByteBuffer byteBuffer = rtmpResponseMessage.getBody();
                        ioSession.write((Object)byteBuffer);
                        break;
                    }
                    ByteBuffer byteBuffer = ByteBuffer.allocate((int)1, (boolean)false);
                    FastMinaMessage fastMinaMessage = new FastMinaMessage(rtmpResponseMessage.getBodyList(), rtmpResponseMessage.getContentLength());
                    byteBuffer.setExtra((Object)fastMinaMessage);
                    ioSession.write((Object)byteBuffer);
                    break;
                }
                case 34: {
                    for (ByteBuffer byteBuffer : rtmpResponseMessage.getBodyList()) {
                        ioSession.write((Object)byteBuffer);
                    }
                    break;
                }
                case 38: {
                    for (ByteBuffer byteBuffer : rtmpResponseMessage.getBodyList()) {
                        ioSession.write((Object)byteBuffer);
                    }
                    break;
                }
                case 39: {
                    IoSession ioSession2 = RTSPTunnelingSession.getResponseSession(this.vhost, ioSession);
                    if (ioSession2 == null) break;
                    for (ByteBuffer byteBuffer : rtmpResponseMessage.getBodyList()) {
                        ioSession2.write((Object)byteBuffer);
                    }
                    break;
                }
                case 37: {
                    if (!rtmpResponseMessage.isResponseValid()) break;
                    ioSession.write((Object)rtmpResponseMessage);
                    break;
                }
                case 3: 
                case 32: 
                case 33: {
                    ClientWriteListener clientWriteListener;
                    Client client;
                    VHost vHost;
                    int n3 = rtmpRequestMessage.getClientId();
                    if (n3 > 0 && (vHost = (VHost)VHostSingleton.getInstance(this.vhostName)) != null && (client = (Client)vHost.getClient(n3)) != null && (clientWriteListener = client.getWriteListener()) != null) {
                        ioSession.addWriteListener((IWriteListener)clientWriteListener);
                    }
                    rtmpResponseMessage.setClientId(n3);
                    vHost = ioSession.write((Object)rtmpResponseMessage);
                    if (vHost == null || n != 3) break;
                    vHost.join();
                    break;
                }
            }
            rtmpResponseMessage.notifyResponseStop();
            rtmpResponseMessage.clearBody();
        }
        if (rtmpResponseMessage.isDidClose()) {
            rtmpSessionInfo.setOpen(false);
            rtmpSessionInfo.setClosed(true);
            rtmpSessionInfo.setClientId(-1);
            ioSession.close();
        }
        if (rtmpResponseMessage.isImmediateIdle()) {
            IoSession ioSession3 = ioSession;
            synchronized (ioSession3) {
                rtmpSessionInfo.addMessageQueue(null);
            }
        }
    }
}

