/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transport.udp;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UDPPortManager {
    public static final int UDPSTARTINGPORT = 6970;
    private int portRecycleTime = 600000;
    private int nextPort = 6970;
    private Map<Integer, AvailablePortHolder> availablePorts = new HashMap<Integer, AvailablePortHolder>();
    private List<Integer> usedPorts = new ArrayList<Integer>();
    private List<Integer> portByNumberPorts = new ArrayList<Integer>();
    private Object portLock = new Object();
    private Set<SocketAddress> usedSockets = new HashSet<SocketAddress>();

    public Object getLock() {
        return this.usedSockets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireSocketAddress(SocketAddress socketAddress) {
        boolean bl = false;
        Set<SocketAddress> set = this.usedSockets;
        synchronized (set) {
            if (!this.usedSockets.contains(socketAddress)) {
                bl = true;
                this.usedSockets.add(socketAddress);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseSocketAddress(SocketAddress socketAddress) {
        boolean bl = false;
        Set<SocketAddress> set = this.usedSockets;
        synchronized (set) {
            bl = this.usedSockets.remove(socketAddress);
        }
        return bl;
    }

    public void setDatagramStaringPort(int n) {
        this.nextPort = n;
    }

    public int getDatagramStartingPort() {
        return this.nextPort;
    }

    public int getPortRecycleTime() {
        return this.portRecycleTime;
    }

    public void setPortRecycleTime(int n) {
        this.portRecycleTime = n;
    }

    public int[] expandToPortPair(int n) {
        int[] nArray = new int[]{-1, -1};
        if (n % 2 == 0) {
            nArray[0] = n;
            nArray[1] = n + 1;
        } else {
            nArray[0] = n - 1;
            nArray[1] = n + 2;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int acquireUDPPortPair(int n) {
        int n2 = -1;
        Object object = this.portLock;
        synchronized (object) {
            if (n % 2 == 0) {
                Integer n3 = new Integer(n);
                if (!this.usedPorts.contains(n)) {
                    n2 = n;
                    this.usedPorts.add(n2);
                    this.portByNumberPorts.add(n2);
                    if (this.availablePorts.containsKey(n3)) {
                        this.availablePorts.remove(n3);
                    }
                }
            } else {
                int n4 = n - 1;
                int n5 = n + 1;
                Integer n6 = new Integer(n4);
                Integer n7 = new Integer(n5);
                if (!this.usedPorts.contains(n4) && !this.usedPorts.contains(n5)) {
                    n2 = n;
                    this.usedPorts.add(n4);
                    this.usedPorts.add(n5);
                    this.portByNumberPorts.add(n4);
                    this.portByNumberPorts.add(n5);
                    if (this.availablePorts.containsKey(n6)) {
                        this.availablePorts.remove(n6);
                    }
                    if (this.availablePorts.containsKey(n7)) {
                        this.availablePorts.remove(n7);
                    }
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int acquireUDPPortPair() {
        int n = -1;
        Object object = this.portLock;
        synchronized (object) {
            if (this.availablePorts.size() > 0) {
                long l = System.currentTimeMillis();
                for (Integer n2 : this.availablePorts.keySet()) {
                    int n3 = n2;
                    AvailablePortHolder availablePortHolder = this.availablePorts.get(n2);
                    if (!availablePortHolder.canRecycle(l)) continue;
                    n = n3;
                    break;
                }
                if (n >= 0) {
                    this.availablePorts.remove(new Integer(n));
                }
            }
            if (n < 0) {
                do {
                    n = this.nextPort;
                    this.nextPort += 2;
                } while (this.usedPorts.contains(n));
                this.usedPorts.add(n);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseUDPPortPair(int n) {
        Object object = this.portLock;
        synchronized (object) {
            if (n % 2 == 0) {
                Integer n2 = new Integer(n);
                if (!this.portByNumberPorts.contains(n2)) {
                    this.availablePorts.put(n2, new AvailablePortHolder(n));
                }
                this.usedPorts.remove(n2);
                this.portByNumberPorts.remove(n2);
            } else {
                int n3 = n - 1;
                int n4 = n + 1;
                if (!this.usedPorts.contains(n3) && !this.usedPorts.contains(n4)) {
                    Integer n5 = new Integer(n3);
                    Integer n6 = new Integer(n4);
                    if (!this.portByNumberPorts.contains(n5)) {
                        this.availablePorts.put(n5, new AvailablePortHolder(n3));
                    }
                    if (!this.portByNumberPorts.contains(n6)) {
                        this.availablePorts.put(n6, new AvailablePortHolder(n4));
                    }
                    this.usedPorts.remove(n5);
                    this.usedPorts.remove(n6);
                    this.portByNumberPorts.remove(n5);
                    this.portByNumberPorts.remove(n6);
                }
            }
        }
    }

    class AvailablePortHolder {
        public int port;
        public long timecode = -1L;

        public AvailablePortHolder(int n) {
            this.port = n;
            this.timecode = System.currentTimeMillis();
        }

        public boolean canRecycle(long l) {
            return l - this.timecode >= (long)UDPPortManager.this.portRecycleTime;
        }
    }
}

