/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.file;

import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndex;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndexItem;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.LiveStreamPacketizerCupertinoUtils;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.util.ModuleUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTTPStreamerCupertinoIndexBase
implements IHTTPStreamerCupertinoIndex {
    protected List<IHTTPStreamerCupertinoIndexItem> items = new ArrayList<IHTTPStreamerCupertinoIndexItem>();
    protected String titleStr = "";
    protected CupertinoEncInfo encInfo = null;
    protected IHTTPStreamerApplicationContext appContext = null;
    protected IApplicationInstance appInstance = null;
    protected String streamExt = null;
    protected String streamName = null;
    protected IMediaStream stream = null;
    protected IHTTPStreamerSession httpStreamerSession = null;
    protected int chunkDurationTarget = 10000;
    private boolean init = true;
    private boolean relativePlaylistItems = true;
    protected int streamMode = 1;

    @Override
    public void init(IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext, IHTTPStreamerSession iHTTPStreamerSession, String string, String string2, String string3) {
        this.appContext = iHTTPStreamerApplicationContext;
        this.appInstance = iHTTPStreamerApplicationContext.getAppInstance();
        this.streamExt = string2;
        this.streamName = string3;
        this.httpStreamerSession = iHTTPStreamerSession;
        WMSProperties wMSProperties = iHTTPStreamerApplicationContext.getProperties();
        WMSProperties wMSProperties2 = this.appInstance.getProperties();
        this.relativePlaylistItems = wMSProperties.getPropertyBoolean("relativePlaylistItems", this.relativePlaylistItems);
        this.relativePlaylistItems = wMSProperties2.getPropertyBoolean("relativePlaylistItems", this.relativePlaylistItems);
    }

    protected String adjustStreamName(String string) {
        String string2 = "";
        String string3 = "mp4";
        if ((string = ((ApplicationInstance)this.appInstance).internalResolvePlayAlias(string, this.httpStreamerSession)) != null) {
            String[] stringArray = ModuleUtils.decodeStreamExtension((String)string, (String)string3);
            string = stringArray[0];
            string3 = stringArray[1];
            boolean bl = string.indexOf("://") >= 0;
            int n = string.indexOf("?");
            if (!bl && n >= 0) {
                string2 = string.substring(n + 1);
                string = string.substring(0, n);
            }
        }
        return string;
    }

    @Override
    public void close() {
    }

    @Override
    public void open() {
    }

    @Override
    public IHTTPStreamerApplicationContext getApplicationContext() {
        return this.appContext;
    }

    @Override
    public List<String> getStreamNamesRaw() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.streamName);
        return arrayList;
    }

    @Override
    public List<String> getStreamNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.adjustStreamName(this.streamName);
        if (string != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public LiveStreamPacketizerCupertinoChunk getChunk(String string) {
        LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk;
        block1: {
            IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem;
            liveStreamPacketizerCupertinoChunk = null;
            int n = LiveStreamPacketizerCupertinoUtils.chunkFilenameToIndex(string);
            if (n <= 0) break block1;
            int n2 = n - 1;
            IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem2 = iHTTPStreamerCupertinoIndexItem = n2 < this.items.size() ? this.items.get(n - 1) : null;
            if (iHTTPStreamerCupertinoIndexItem != null) {
                liveStreamPacketizerCupertinoChunk = new LiveStreamPacketizerCupertinoChunk(n);
                this.fillChunk(iHTTPStreamerCupertinoIndexItem, liveStreamPacketizerCupertinoChunk);
            }
        }
        return liveStreamPacketizerCupertinoChunk;
    }

    public void init() {
        if (this.init) {
            WMSProperties wMSProperties = this.appContext.getProperties();
            WMSProperties wMSProperties2 = this.appContext.getAppInstance().getHTTPStreamerProperties();
            this.chunkDurationTarget = wMSProperties.getPropertyInt("chunkDurationTarget", this.chunkDurationTarget);
            this.chunkDurationTarget = wMSProperties2.getPropertyInt("chunkDurationTarget", this.chunkDurationTarget);
            this.chunkDurationTarget = wMSProperties.getPropertyInt("cupertinoChunkDurationTarget", this.chunkDurationTarget);
            this.chunkDurationTarget = wMSProperties2.getPropertyInt("cupertinoChunkDurationTarget", this.chunkDurationTarget);
            this.init = false;
        }
    }

    @Override
    public String getPlaylistStr() {
        this.init();
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        long l2 = 0L;
        String string = Math.round(this.chunkDurationTarget / 1000) + "";
        stringBuffer.append("#EXTM3U\n");
        if (this.encInfo != null) {
            Object object = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\"".replace("{encmethod}", "AES-128");
            String object2 = this.encInfo.getEncUrl();
            if (object2 != null) {
                String string2 = "?";
                if (object2.indexOf("?") >= 0) {
                    string2 = "&";
                }
                object = ((String)object).replace("{enckeyurl}", object2 + string2 + "{query}");
            }
            stringBuffer.append((String)object + "\n");
        }
        stringBuffer.append("#EXT-X-TARGETDURATION:" + string + "\n");
        stringBuffer.append("#EXT-X-MEDIA-SEQUENCE:1\n");
        for (IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem : this.items) {
            int n = (int)Math.round((double)(iHTTPStreamerCupertinoIndexItem.getStopTimecode() - l) / 1000.0);
            if (n <= 0) {
                n = 1;
            }
            l += (long)(n * 1000);
            String string3 = this.relativePlaylistItems ? "{filename}?{query}" : "{domain}/{application}/{appInstance}/{stream}/{filename}?{query}";
            stringBuffer.append("#EXTINF:" + n + "," + this.titleStr + "\n");
            stringBuffer.append(string3.replace("{filename}", "media_{index}{ext}".replace("{index}", ++l2 + "")).replace("{ext}", LiveStreamPacketizerCupertinoUtils.streamModeToFileExtension(this.streamMode)) + "\n");
        }
        stringBuffer.append("#EXT-X-ENDLIST\n");
        return stringBuffer.toString();
    }

    @Override
    public int addIndexItem(IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem) {
        this.items.add(iHTTPStreamerCupertinoIndexItem);
        return this.items.size() - 1;
    }

    @Override
    public int getIndexCount() {
        return this.items.size();
    }

    @Override
    public IHTTPStreamerCupertinoIndexItem getIndexItem(int n) {
        if (n < this.items.size()) {
            return this.items.get(n);
        }
        return null;
    }

    @Override
    public String getTitleStr() {
        return this.titleStr;
    }

    @Override
    public void setTitleStr(String string) {
        this.titleStr = string;
    }

    @Override
    public boolean isDoEncryption() {
        return this.encInfo != null;
    }

    @Override
    public CupertinoEncInfo getEncInfo() {
        return this.encInfo;
    }

    @Override
    public String getEncURL() {
        return this.encInfo == null ? null : this.encInfo.getEncUrl();
    }

    @Override
    public IHTTPStreamerSession getHttpStreamerSession() {
        return this.httpStreamerSession;
    }

    @Override
    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public int getStreamMode() {
        return this.streamMode;
    }

    @Override
    public void setStreamMode(int n) {
        this.streamMode = n;
    }
}

