/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.file;

import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.HTTPStreamerCupertinoIndexItemH264;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndex;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndexItem;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IMediaReaderCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoPacketHolder;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunker;
import com.wowza.wms.httpstreamer.model.HTTPStreamerFileInfo;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.mediareader.h264.H264ReadAheadPacket;
import com.wowza.wms.mediareader.h264.H264StreamPosition;
import com.wowza.wms.mediareader.h264.MediaReaderH264;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import java.util.ArrayList;

public class MediaReaderH264Cupertino
extends MediaReaderH264
implements IMediaReaderCupertino {
    private int chunkDurationTolerance = 500;
    private int chunkDurationTarget = 10000;
    private int audioGroupCount = 3;
    private LiveStreamPacketizerCupertinoChunker chunker = null;
    private boolean init = true;
    private boolean reportVideoCodecInfo = true;
    private boolean reportAudioCodecInfo = true;
    private boolean forceH264BaselineProfile = false;

    private void init(IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex) {
        if (this.init) {
            IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = iHTTPStreamerCupertinoIndex.getApplicationContext();
            if (iHTTPStreamerApplicationContext != null) {
                WMSProperties wMSProperties = iHTTPStreamerApplicationContext.getProperties();
                WMSProperties wMSProperties2 = iHTTPStreamerApplicationContext.getAppInstance().getHTTPStreamerProperties();
                this.chunkDurationTolerance = wMSProperties.getPropertyInt("chunkDurationTolerance", this.chunkDurationTolerance);
                this.chunkDurationTolerance = wMSProperties2.getPropertyInt("chunkDurationTolerance", this.chunkDurationTolerance);
                this.chunkDurationTolerance = wMSProperties.getPropertyInt("cupertinoChunkDurationTolerance", this.chunkDurationTolerance);
                this.chunkDurationTolerance = wMSProperties2.getPropertyInt("cupertinoChunkDurationTolerance", this.chunkDurationTolerance);
                this.chunkDurationTarget = wMSProperties.getPropertyInt("chunkDurationTarget", this.chunkDurationTarget);
                this.chunkDurationTarget = wMSProperties2.getPropertyInt("chunkDurationTarget", this.chunkDurationTarget);
                this.chunkDurationTarget = wMSProperties.getPropertyInt("cupertinoChunkDurationTarget", this.chunkDurationTarget);
                this.chunkDurationTarget = wMSProperties2.getPropertyInt("cupertinoChunkDurationTarget", this.chunkDurationTarget);
                this.audioGroupCount = wMSProperties.getPropertyInt("audioGroupCount", this.audioGroupCount);
                this.audioGroupCount = wMSProperties2.getPropertyInt("audioGroupCount", this.audioGroupCount);
                this.audioGroupCount = wMSProperties.getPropertyInt("cupertinoAudioGroupCount", this.audioGroupCount);
                this.audioGroupCount = wMSProperties2.getPropertyInt("cupertinoAudioGroupCount", this.audioGroupCount);
                this.forceH264BaselineProfile = wMSProperties.getPropertyBoolean("forceH264BaselineProfile", this.forceH264BaselineProfile);
                this.forceH264BaselineProfile = wMSProperties.getPropertyBoolean("cupertinoForceH264BaselineProfile", this.forceH264BaselineProfile);
                this.forceH264BaselineProfile = wMSProperties2.getPropertyBoolean("forceH264BaselineProfile", this.forceH264BaselineProfile);
                this.forceH264BaselineProfile = wMSProperties2.getPropertyBoolean("cupertinoForceH264BaselineProfile", this.forceH264BaselineProfile);
            }
            this.init = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexFile(IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex) {
        this.init(iHTTPStreamerCupertinoIndex);
        Object object = this.lock;
        synchronized (object) {
            try {
                long l;
                int n = this.cursor.getVideoKeyFrameCount();
                if (n > 0) {
                    l = 0L;
                    long l2 = 0L;
                    int n2 = 0;
                    for (int i = 0; i < n; ++i) {
                        long l3;
                        long l4;
                        long l5 = this.cursor.getVideoKeyFrameSample(i);
                        if (l5 < 0L || (l4 = this.cursor.videoTimecodeToTimeMillis(l3 = this.cursor.videoSampleToTimecode(l5))) - l < (long)(this.chunkDurationTarget - this.chunkDurationTolerance)) continue;
                        HTTPStreamerCupertinoIndexItemH264 hTTPStreamerCupertinoIndexItemH264 = new HTTPStreamerCupertinoIndexItemH264();
                        hTTPStreamerCupertinoIndexItemH264.setIndex(++n2);
                        hTTPStreamerCupertinoIndexItemH264.setStartTimecode(l);
                        hTTPStreamerCupertinoIndexItemH264.setStopTimecode(l4);
                        hTTPStreamerCupertinoIndexItemH264.setStartVideoSample(l2);
                        hTTPStreamerCupertinoIndexItemH264.setLastVideoSample(l5);
                        iHTTPStreamerCupertinoIndex.addIndexItem(hTTPStreamerCupertinoIndexItemH264);
                        l = l4;
                        l2 = l5;
                    }
                    if (n > 0) {
                        HTTPStreamerCupertinoIndexItemH264 hTTPStreamerCupertinoIndexItemH264 = new HTTPStreamerCupertinoIndexItemH264();
                        hTTPStreamerCupertinoIndexItemH264.setIndex(++n2);
                        hTTPStreamerCupertinoIndexItemH264.setStartTimecode(l);
                        hTTPStreamerCupertinoIndexItemH264.setStopTimecode(this.duration);
                        hTTPStreamerCupertinoIndexItemH264.setStartVideoSample(l2);
                        hTTPStreamerCupertinoIndexItemH264.setLastVideoSample(-1L);
                        iHTTPStreamerCupertinoIndex.addIndexItem(hTTPStreamerCupertinoIndexItemH264);
                    }
                } else {
                    long l6;
                    iHTTPStreamerCupertinoIndex.setStreamMode(this.audioCodec == 2 ? 2 : 3);
                    l = 0L;
                    int n3 = 0;
                    do {
                        if (l + (l6 = (long)this.chunkDurationTarget) > this.duration) {
                            l6 = this.duration - l;
                        }
                        if (l6 <= 0L) break;
                        HTTPStreamerCupertinoIndexItemH264 hTTPStreamerCupertinoIndexItemH264 = new HTTPStreamerCupertinoIndexItemH264();
                        hTTPStreamerCupertinoIndexItemH264.setIndex(++n3);
                        hTTPStreamerCupertinoIndexItemH264.setStartTimecode(l);
                        hTTPStreamerCupertinoIndexItemH264.setStopTimecode(l + l6);
                        hTTPStreamerCupertinoIndexItemH264.setStartVideoSample(-1L);
                        hTTPStreamerCupertinoIndexItemH264.setLastVideoSample(-1L);
                        iHTTPStreamerCupertinoIndex.addIndexItem(hTTPStreamerCupertinoIndexItemH264);
                    } while ((l += l6) < this.duration);
                }
                IHTTPStreamerSession iHTTPStreamerSession = iHTTPStreamerCupertinoIndex.getHttpStreamerSession();
                if (iHTTPStreamerSession != null) {
                    HTTPStreamerFileInfo hTTPStreamerFileInfo = new HTTPStreamerFileInfo(iHTTPStreamerCupertinoIndex.getStreamName(), this.length, (double)this.duration / 1000.0);
                    iHTTPStreamerSession.putFileInfo(iHTTPStreamerCupertinoIndex.getStreamName(), hTTPStreamerFileInfo);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderH264Cupertino.class).error("MediaReaderH264Cupertino.indexFile:" + exception.toString());
            }
        }
    }

    private LiveStreamPacketizerCupertinoChunker getChunker() {
        if (this.chunker == null) {
            this.chunker = new LiveStreamPacketizerCupertinoChunker();
            this.chunker.setAudioGroupCount(this.audioGroupCount);
            this.chunker.setForceH264BaselineProfile(this.forceH264BaselineProfile);
            if (this.forceH264BaselineProfile) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("MediaReaderH264Cupertino.getChunker[" + this.appInstance.getContextStr() + "/" + this.mediaName + "]: Forcing H.264 profile to Baseline level 3.0");
            }
        }
        return this.chunker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillChunk(IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem, LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk) {
        Object object = this.lock;
        synchronized (object) {
            block45: {
                try {
                    long l;
                    LiveStreamPacketizerCupertinoChunker liveStreamPacketizerCupertinoChunker = this.getChunker();
                    long l2 = iHTTPStreamerCupertinoIndexItem.getStartTimecode();
                    long l3 = iHTTPStreamerCupertinoIndexItem.getStopTimecode();
                    long l4 = ((HTTPStreamerCupertinoIndexItemH264)iHTTPStreamerCupertinoIndexItem).getStartVideoSample();
                    long l5 = ((HTTPStreamerCupertinoIndexItemH264)iHTTPStreamerCupertinoIndexItem).getLastVideoSample();
                    liveStreamPacketizerCupertinoChunk.setStartTimecode(l2);
                    liveStreamPacketizerCupertinoChunk.setDuration(l3 - l2);
                    if (l4 >= 0L) {
                        long l6;
                        long l7 = this.cursor.getVideoSample();
                        if (l7 != l4) {
                            long l8 = this.cursor.videoSampleToTimecode(l4);
                            long l9 = this.cursor.videoTimecodeToTimeMillis(l8);
                            long l10 = this.cursor.audioTimeMillisToTimecode(l9);
                            l6 = this.cursor.audioTimecodeToSample(l10);
                            if ((l10 = this.cursor.audioSampleToTimecode(l6)) < l8 && this.cursor.getAudioSampleValid(l6 + 1L)) {
                                l10 = this.cursor.audioSampleToTimecode(++l6);
                            }
                            H264StreamPosition h264StreamPosition = new H264StreamPosition(l6, l4);
                            this.setStreamPosition((IMediaReaderStreamPosition)h264StreamPosition);
                            this.cursor.resetVideoAtEnd();
                            this.cursor.resetAudioAtEnd();
                        }
                        ArrayList<CupertinoPacketHolder> arrayList = new ArrayList<CupertinoPacketHolder>();
                        long l11 = -1L;
                        long l12 = -1L;
                        do {
                            Object object2;
                            Object object3;
                            int n = this.cursor.isCurrentAudio() ? 8 : 9;
                            l6 = this.cursor.getTimeMillis();
                            long l13 = this.cursor.getTimeScaled(90000);
                            long l14 = this.cursor.getSample();
                            long l15 = this.getSampleDesc(this.cursor, l14, n);
                            AMFPacket aMFPacket = null;
                            int n2 = 1;
                            int n3 = 0;
                            switch (n) {
                                case 8: {
                                    if (l11 != l15) {
                                        byte[] byArray = this.getAudioCodecConfig(l15);
                                        if (byArray != null) {
                                            aMFPacket = new AMFPacket(8, 0, byArray.length + 2);
                                            aMFPacket.setAbsTimecode(l6);
                                            arrayList.add(new CupertinoPacketHolder(aMFPacket, l13));
                                            object3 = aMFPacket.getData();
                                            object3[0] = (H264ReadAheadPacket)-81;
                                            System.arraycopy(byArray, 0, object3, 2, byArray.length);
                                            if (this.reportAudioCodecInfo) {
                                                object2 = AACUtils.decodeAACCodecConfig((byte[])byArray, (int)0);
                                                if (object2 != null) {
                                                    if (object2.getChannels() > 2 || object2.getSampleRate() > 48000) {
                                                        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn("MediaReaderH264Cupertino.handlePacket: Audio encoding settings are beyond iPhone/iPod touch recommendations (48KHz/stereo) [" + this.stream.getContextStr() + "]: " + object2.toString());
                                                    } else {
                                                        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("MediaReaderH264Cupertino.handlePacket: Audio info[" + this.stream.getContextStr() + "]: " + object2.toString());
                                                    }
                                                }
                                                this.reportAudioCodecInfo = false;
                                            }
                                        }
                                        l11 = l15;
                                    }
                                    if (this.audioCodec != 10) break;
                                    ++n2;
                                    break;
                                }
                                case 9: {
                                    if (l12 != l15) {
                                        byte[] byArray = this.getVideoCodecConfig(l15);
                                        if (byArray != null) {
                                            aMFPacket = new AMFPacket(9, 0, byArray.length + 5);
                                            aMFPacket.setAbsTimecode(l6);
                                            arrayList.add(new CupertinoPacketHolder(aMFPacket, l13));
                                            object3 = aMFPacket.getData();
                                            object3[0] = (H264ReadAheadPacket)23;
                                            System.arraycopy(byArray, 0, object3, 5, byArray.length);
                                            if (this.reportVideoCodecInfo) {
                                                try {
                                                    object2 = H264Utils.decodeAVCC((byte[])aMFPacket.getData(), (int)5);
                                                    if (object2 != null) {
                                                        if (object2.profileIDC != 66 || object2.levelIDC > 30) {
                                                            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn("MediaReaderH264Cupertino.handlePacket: Video encoding settings are beyond iPhone/iPod touch recommendations (Baseline/3.0) [" + this.stream.getContextStr() + "]: " + object2.toString());
                                                        } else {
                                                            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("MediaReaderH264Cupertino.handlePacket: Video info[" + this.stream.getContextStr() + "]: " + object2.toString());
                                                        }
                                                    }
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                                this.reportVideoCodecInfo = false;
                                            }
                                        }
                                        l12 = l15;
                                    }
                                    n2 += 4;
                                    n3 = this.cursor.getCTTSMillis();
                                }
                            }
                            int n4 = 0;
                            object3 = this.getReadAheadPacket(n, l14);
                            if (object3 != null) {
                                n4 = (int)object3.getSize();
                            }
                            if (n4 > 0) {
                                aMFPacket = new AMFPacket(n, 0, n4 + n2);
                                aMFPacket.setAbsTimecode(l6);
                                arrayList.add(new CupertinoPacketHolder(aMFPacket, l13));
                                object2 = aMFPacket.getData();
                                object2[0] = this.getFirstByte(this.cursor);
                                if (n2 > 1) {
                                    object2[1] = 1;
                                }
                                if (n2 > 2) {
                                    object2[2] = (byte)(n3 >> 16 & 0xFF);
                                    object2[3] = (byte)(n3 >> 8 & 0xFF);
                                    object2[4] = (byte)(n3 >> 0 & 0xFF);
                                }
                                byte[] byArray = object3.getBuffer();
                                int n5 = object3.boffset;
                                System.arraycopy(byArray, n5, object2, n2, n4);
                            }
                            this.cursor.moveNextSample();
                            if (this.cursor.isAtEnd()) break;
                            l7 = this.cursor.getVideoSample();
                        } while (l5 < 0L || l7 < l5);
                        liveStreamPacketizerCupertinoChunker.fillChunk(liveStreamPacketizerCupertinoChunk, arrayList, this.videoCodec, this.audioCodec);
                        break block45;
                    }
                    liveStreamPacketizerCupertinoChunk.setStreamMode(this.audioCodec == 2 ? 2 : 3);
                    long l16 = this.cursor.isAtEnd() ? 0L : this.cursor.getTimeMillis();
                    long l17 = l = this.cursor.isAtEnd() ? 0L : this.cursor.getTimeScaled(90000);
                    if (l16 < l2 || l16 >= l2 + (long)(this.chunkDurationTarget / 2)) {
                        long l18 = this.cursor.audioTimeMillisToTimecode(l2);
                        long l19 = this.cursor.audioTimecodeToSample(l18);
                        this.cursor.setAudioSample(l19);
                    }
                    ArrayList<CupertinoPacketHolder> arrayList = new ArrayList<CupertinoPacketHolder>();
                    long l20 = -1L;
                    do {
                        int n = this.cursor.isCurrentAudio() ? 8 : 9;
                        long l21 = this.cursor.getTimeMillis();
                        long l22 = this.cursor.getTimeScaled(90000);
                        long l23 = this.cursor.getSample();
                        long l24 = this.getSampleDesc(this.cursor, l23, n);
                        AMFPacket aMFPacket = null;
                        int n6 = 1;
                        int n7 = 0;
                        if (n == 8) {
                            Object object4;
                            Object object5;
                            if (l20 != l24) {
                                byte[] byArray = this.getAudioCodecConfig(l24);
                                if (byArray != null) {
                                    aMFPacket = new AMFPacket(8, 0, byArray.length + 2);
                                    aMFPacket.setAbsTimecode(l21);
                                    arrayList.add(new CupertinoPacketHolder(aMFPacket, l22));
                                    object5 = aMFPacket.getData();
                                    object5[0] = (H264ReadAheadPacket)-81;
                                    System.arraycopy(byArray, 0, object5, 2, byArray.length);
                                    if (this.reportAudioCodecInfo) {
                                        object4 = AACUtils.decodeAACCodecConfig((byte[])byArray, (int)0);
                                        if (object4 != null) {
                                            if (object4.getChannels() > 2 || object4.getSampleRate() > 48000) {
                                                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn("MediaReaderH264Cupertino.handlePacket: Audio encoding settings are beyond iPhone/iPod touch recommendations (48KHz/stereo) [" + this.stream.getContextStr() + "]: " + object4.toString());
                                            } else {
                                                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("MediaReaderH264Cupertino.handlePacket: Audio info[" + this.stream.getContextStr() + "]: " + object4.toString());
                                            }
                                        }
                                        this.reportAudioCodecInfo = false;
                                    }
                                }
                                l20 = l24;
                            }
                            if (this.audioCodec == 10) {
                                ++n6;
                            }
                            int n8 = 0;
                            object5 = this.getReadAheadPacket(n, l23);
                            if (object5 != null) {
                                n8 = (int)object5.getSize();
                            }
                            if (n8 > 0) {
                                aMFPacket = new AMFPacket(n, 0, n8 + n6);
                                aMFPacket.setAbsTimecode(l21);
                                arrayList.add(new CupertinoPacketHolder(aMFPacket, l22));
                                object4 = aMFPacket.getData();
                                object4[0] = this.getFirstByte(this.cursor);
                                if (n6 > 1) {
                                    object4[1] = 1;
                                }
                                if (n6 > 2) {
                                    object4[2] = (byte)(n7 >> 16 & 0xFF);
                                    object4[3] = (byte)(n7 >> 8 & 0xFF);
                                    object4[4] = (byte)(n7 >> 0 & 0xFF);
                                }
                                byte[] byArray = object5.getBuffer();
                                int n9 = object5.boffset;
                                System.arraycopy(byArray, n9, object4, n6, n8);
                            }
                        }
                        this.cursor.moveNextSample();
                    } while (!this.cursor.isAtEnd() && this.cursor.getTimeMillis() < l3);
                    liveStreamPacketizerCupertinoChunker.fillChunk(liveStreamPacketizerCupertinoChunk, arrayList, -1, this.audioCodec);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(MediaReaderH264Cupertino.class).error("MediaReaderH264Cupertino.fillChunk: " + exception.toString());
                    exception.printStackTrace();
                }
            }
        }
    }
}

