/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoRepeaterHolderSerialized;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoTSHolder;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class CupertinoRepeaterHolder {
    public static final int REPEATER_START = 1;
    public static final int REPEATER_END = 2;
    public static final int REPEATER_TS = 3;
    public static final int REPEATER_RESET = 4;
    public static final int REPEATER_MSG = 100;
    private int chunkId = 0;
    private int streamMode = 0;
    private int videoCodec = 0;
    private int audioCodec = 0;
    private long timecode = 0L;
    private CupertinoTSHolder holder = null;
    private long sequence = 0L;
    private int repeaterType = 0;
    private String encUrl = "";
    private byte[] encRepeaterBytes = null;
    private String repeaterMessage = null;

    public CupertinoRepeaterHolder() {
    }

    public CupertinoRepeaterHolder(long l, int n, int n2, int n3, int n4, String string, long l2, byte[] byArray) {
        this.sequence = l;
        this.chunkId = n;
        this.streamMode = n2;
        this.videoCodec = n3;
        this.audioCodec = n4;
        this.encUrl = string;
        this.timecode = l2;
        this.encRepeaterBytes = byArray;
        this.repeaterType = 1;
    }

    public CupertinoRepeaterHolder(long l, int n, long l2) {
        this.sequence = l;
        this.chunkId = n;
        this.timecode = l2;
        this.repeaterType = 2;
    }

    public CupertinoRepeaterHolder(long l, int n, CupertinoTSHolder cupertinoTSHolder) {
        this.sequence = l;
        this.chunkId = n;
        this.holder = cupertinoTSHolder;
        this.timecode = cupertinoTSHolder.getTimecode();
        this.repeaterType = 3;
    }

    public CupertinoRepeaterHolder(long l) {
        this.sequence = l;
        this.repeaterType = 4;
    }

    public static CupertinoRepeaterHolder deserialize(byte[] byArray, int n, int n2) {
        CupertinoRepeaterHolder cupertinoRepeaterHolder = new CupertinoRepeaterHolder();
        try {
            if (n2 >= 4) {
                int n3 = 0;
                int n4 = BufferUtils.byteArrayToInt((byte[])byArray, (int)(n + n3), (int)2);
                if (n4 > n2 - (n3 += 2)) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("CupertinoRepeaterHolder.deserialize: Bad header size: " + n4 + ":" + n2);
                } else {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n + n3, n4);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    n3 += n4;
                    byte by = dataInputStream.readByte();
                    cupertinoRepeaterHolder.repeaterType = dataInputStream.readByte();
                    cupertinoRepeaterHolder.timecode = dataInputStream.readLong();
                    cupertinoRepeaterHolder.sequence = dataInputStream.readLong();
                    cupertinoRepeaterHolder.chunkId = dataInputStream.readInt();
                    switch (cupertinoRepeaterHolder.repeaterType) {
                        case 1: {
                            cupertinoRepeaterHolder.streamMode = dataInputStream.readInt();
                            cupertinoRepeaterHolder.videoCodec = dataInputStream.readInt();
                            cupertinoRepeaterHolder.audioCodec = dataInputStream.readInt();
                            cupertinoRepeaterHolder.encUrl = dataInputStream.readUTF();
                            short s = dataInputStream.readShort();
                            if (s <= 0) break;
                            cupertinoRepeaterHolder.encRepeaterBytes = new byte[s];
                            dataInputStream.read(cupertinoRepeaterHolder.encRepeaterBytes);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            byte by2 = dataInputStream.readByte();
                            long l = dataInputStream.readLong();
                            int n5 = dataInputStream.readInt();
                            byte by3 = dataInputStream.readByte();
                            boolean bl = dataInputStream.readByte() != 0;
                            cupertinoRepeaterHolder.holder = new CupertinoTSHolder(by2, by3, byArray, n + n3, n2 - n3, cupertinoRepeaterHolder.timecode, l);
                            break;
                        }
                        case 100: {
                            cupertinoRepeaterHolder.repeaterMessage = dataInputStream.readUTF();
                            break;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("CupertinoRepeaterHolder.deserialize: " + exception.toString());
            cupertinoRepeaterHolder = null;
        }
        return cupertinoRepeaterHolder;
    }

    public static CupertinoRepeaterHolder createRepeaterMessage(String string) {
        CupertinoRepeaterHolder cupertinoRepeaterHolder = new CupertinoRepeaterHolder();
        cupertinoRepeaterHolder.setRepeaterType(100);
        cupertinoRepeaterHolder.setRepeaterMessage(string);
        return cupertinoRepeaterHolder;
    }

    public CupertinoRepeaterHolderSerialized serialize() {
        CupertinoRepeaterHolderSerialized cupertinoRepeaterHolderSerialized = new CupertinoRepeaterHolderSerialized();
        cupertinoRepeaterHolderSerialized.timecode = this.timecode;
        cupertinoRepeaterHolderSerialized.type = this.repeaterType;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeByte(this.repeaterType);
            dataOutputStream.writeLong(this.timecode);
            dataOutputStream.writeLong(this.sequence);
            dataOutputStream.writeInt(this.chunkId);
            switch (this.repeaterType) {
                case 1: {
                    cupertinoRepeaterHolderSerialized.type = 9;
                    dataOutputStream.writeInt(this.streamMode);
                    dataOutputStream.writeInt(this.videoCodec);
                    dataOutputStream.writeInt(this.audioCodec);
                    dataOutputStream.writeUTF(this.encUrl);
                    if (this.encRepeaterBytes != null) {
                        dataOutputStream.writeShort(this.encRepeaterBytes.length);
                        dataOutputStream.write(this.encRepeaterBytes);
                        break;
                    }
                    dataOutputStream.writeShort(0);
                    break;
                }
                case 2: {
                    cupertinoRepeaterHolderSerialized.type = 9;
                    break;
                }
                case 3: {
                    cupertinoRepeaterHolderSerialized.type = 9;
                    dataOutputStream.writeByte(this.holder.getType());
                    dataOutputStream.writeLong(this.holder.getTimecode90());
                    dataOutputStream.writeInt(this.holder.getDuration());
                    dataOutputStream.writeByte(this.holder.getCodec());
                    dataOutputStream.writeByte(this.holder.isKey() ? 1 : 0);
                    cupertinoRepeaterHolderSerialized.data = this.holder.getBlock();
                    cupertinoRepeaterHolderSerialized.doffset = this.holder.getOffset();
                    cupertinoRepeaterHolderSerialized.dlen = this.holder.getLen();
                    break;
                }
                case 100: {
                    dataOutputStream.writeUTF(this.repeaterMessage);
                    break;
                }
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n = byArray.length;
            BufferUtils.intToByteArray((int)(n - 2), (byte[])byArray, (int)0, (int)2);
            cupertinoRepeaterHolderSerialized.header = byArray;
            cupertinoRepeaterHolderSerialized.hoffset = 0;
            cupertinoRepeaterHolderSerialized.hlen = n;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("CupertinoRepeaterHolder.serialize: " + exception.toString());
        }
        return cupertinoRepeaterHolderSerialized;
    }

    public int getChunkId() {
        return this.chunkId;
    }

    public void setChunkId(int n) {
        this.chunkId = n;
    }

    public int getStreamMode() {
        return this.streamMode;
    }

    public void setStreamMode(int n) {
        this.streamMode = n;
    }

    public int getVideoCodec() {
        return this.videoCodec;
    }

    public void setVideoCodec(int n) {
        this.videoCodec = n;
    }

    public int getAudioCodec() {
        return this.audioCodec;
    }

    public void setAudioCodec(int n) {
        this.audioCodec = n;
    }

    public long getTimecode() {
        return this.timecode;
    }

    public void setTimecode(long l) {
        this.timecode = l;
    }

    public CupertinoTSHolder getHolder() {
        return this.holder;
    }

    public void setHolder(CupertinoTSHolder cupertinoTSHolder) {
        this.holder = cupertinoTSHolder;
    }

    public long getSequence() {
        return this.sequence;
    }

    public void setSequence(long l) {
        this.sequence = l;
    }

    public int getRepeaterType() {
        return this.repeaterType;
    }

    public void setRepeaterType(int n) {
        this.repeaterType = n;
    }

    public String getEncUrl() {
        return this.encUrl;
    }

    public void setEncUrl(String string) {
        this.encUrl = string;
    }

    public byte[] getEncRepeaterBytes() {
        return this.encRepeaterBytes;
    }

    public void setEncRepeaterBytes(byte[] byArray) {
        this.encRepeaterBytes = byArray;
    }

    public String getRepeaterMessage() {
        return this.repeaterMessage;
    }

    public void setRepeaterMessage(String string) {
        this.repeaterMessage = string;
    }
}

