/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.mp3;

import com.wowza.io.IRandomAccessReader;
import com.wowza.io.RandomAccessReaderFactory;
import com.wowza.io.ScheduledRandomAccessReaderWrapper;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.mp3.MP3Utils;
import com.wowza.wms.mediareader.mp3.MP3StreamPosition;
import com.wowza.wms.mediareader.mp3.MediaReaderMP3NodeData;
import com.wowza.wms.stream.FastPlaySettings;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaReaderItem;
import com.wowza.wms.stream.PlaylistSeekResult;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Header;
import org.farng.mp3.AbstractMP3FragmentBody;
import org.farng.mp3.MP3File;
import org.farng.mp3.id3.AbstractID3v2;
import org.farng.mp3.id3.AbstractID3v2Frame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaReaderMP3
implements IMediaReader {
    public static final int SYNCBLOCKSIZE = 10240;
    protected IRandomAccessReader fileStream = null;
    protected ScheduledRandomAccessReaderWrapper fileReader = null;
    protected Bitstream bitstream = null;
    protected boolean errorReported = false;
    protected IMediaStream stream = null;
    protected Object lock = new Object();
    protected String mediaReaderType = "mp3";
    protected String mediaReaderExt = "mp3";
    protected byte[] syncHeader;
    protected byte[] packetHeader;
    protected byte[] workBuffer;
    protected MediaReaderItem mediaReaderItem = null;
    protected MediaReaderMP3NodeData nodeData = null;
    protected int frequency = 0;
    protected int bitrate = 0;
    protected int samplesPerFrame = 0;
    protected long streamSize = 0L;
    protected long headerOffset = 0L;
    protected long tailOffset = 0L;
    protected long maxFrames = 0L;
    protected long duration = -1L;
    protected long length = 0L;
    protected int channels = 0;
    protected List metaData = null;
    protected boolean justID3Tags = false;
    protected boolean readID3Tags = true;
    protected String basePath = "";
    protected String mediaName = "";
    protected String mediaExtension = "mp3";
    protected long currentSample = 0L;
    protected boolean bitrateErrorSent = false;
    protected int readAheadSize = 16384;
    protected int readAheadTrigger = this.readAheadSize / 2;
    protected String randomAccessReaderClass = "com.wowza.io.DirectRandomAccessReader";
    protected IApplicationInstance appInstance = null;
    protected boolean calculateMoreAccurateFrameSize = false;
    protected int calculateMoreAccurateFrameWindow = 100;
    protected boolean isVBR = false;
    protected long saveLastAudioPos = 0L;
    protected int saveLastAudioSize = 0;
    protected Header h = null;

    public MediaReaderMP3() {
        this.syncHeader = new byte[4];
        this.packetHeader = new byte[1];
        this.workBuffer = new byte[12];
        this.packetHeader[0] = 47;
    }

    public void setProperties(WMSProperties wMSProperties) {
        this.justID3Tags = wMSProperties.getPropertyBoolean("mp3JustID3Tags", false);
        this.readID3Tags = wMSProperties.getPropertyBoolean("mp3ReadID3Tags", this.readID3Tags);
        this.readAheadSize = wMSProperties.getPropertyInt("mp3ReadAheadSize", this.readAheadSize);
        this.readAheadTrigger = this.readAheadSize / 2;
        this.readAheadTrigger = wMSProperties.getPropertyInt("mp3ReadAheadTrigger", this.readAheadTrigger);
        this.randomAccessReaderClass = wMSProperties.getPropertyStr("randomAccessReaderClass", this.randomAccessReaderClass);
        this.calculateMoreAccurateFrameSize = wMSProperties.getPropertyBoolean("calculateMoreAccurateFrameSize", this.calculateMoreAccurateFrameSize);
        this.calculateMoreAccurateFrameWindow = wMSProperties.getPropertyInt("calculateMoreAccurateFrameWindow", this.calculateMoreAccurateFrameWindow);
        if (WMSLoggerFactory.getLogger(MediaReaderMP3.class).isDebugEnabled()) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug("MediaReaderMP3.mp3ReadAheadSize: " + this.readAheadSize);
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug("MediaReaderMP3.mp3ReadAheadTrigger: " + this.readAheadTrigger);
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug("MediaReaderMP3.mp3JustID3Tags: " + this.justID3Tags);
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug("MediaReaderMP3.mp3ReadID3Tags: " + this.readID3Tags);
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug("MediaReaderMP3.randomAccessReaderClass: " + this.randomAccessReaderClass);
        }
    }

    public void setMediaReaderItem(MediaReaderItem mediaReaderItem) {
        this.mediaReaderItem = mediaReaderItem;
    }

    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
        this.appInstance = iApplicationInstance;
        this.stream = iMediaStream;
        this.lock = iMediaStream == null ? this.lock : iMediaStream;
        this.mediaReaderExt = this.mediaReaderType = this.mediaReaderType.toLowerCase();
        this.basePath = string2;
        this.mediaName = string3;
        this.mediaExtension = this.mediaReaderItem.getFileExtension();
        this.fileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
        this.fileReader = new ScheduledRandomAccessReaderWrapper(this.stream, this.fileStream, this.readAheadSize, this.readAheadTrigger);
        iApplicationInstance.notifyMediaReaderInit((IMediaReader)this, iMediaStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String string, String string2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.fileStream.isOpen()) {
                this.close();
            }
            try {
                this.fileStream.open();
                this.fileReader.open();
                this.bitstream = new Bitstream((IRandomAccessReader)this.fileReader);
                this.errorReported = false;
                this.appInstance.notifyMediaReaderOpen((IMediaReader)this, this.stream);
                this.readMetadata();
                this.appInstance.notifyMediaReaderExtractMetaData((IMediaReader)this, this.stream);
            }
            catch (Exception exception) {
                if (!this.errorReported) {
                    WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("open: " + exception.toString());
                }
                this.errorReported = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.bitstream != null) {
                    this.bitstream.close();
                }
                this.bitstream = null;
                try {
                    if (this.fileReader != null) {
                        WMSLoggerFactory.getLogger(null).debug("MediaReaderMP3.close[fileReader]");
                        this.fileReader.close();
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("close[fileReader]: " + exception.toString());
                }
                try {
                    if (this.fileStream != null) {
                        WMSLoggerFactory.getLogger(null).debug("MediaReaderMP3.close[fileStream]");
                        this.fileStream.close();
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("close[fileStream]: " + exception.toString());
                }
                this.frequency = 0;
                this.samplesPerFrame = 0;
                this.streamSize = 0L;
                this.maxFrames = 0L;
                this.headerOffset = 0L;
                this.tailOffset = 0L;
                this.duration = -1L;
                this.length = 0L;
                this.bitrate = 0;
            }
            this.appInstance.notifyMediaReaderClose((IMediaReader)this, this.stream);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("close: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public boolean isOpen() {
        if (this.fileStream != null) {
            return this.fileStream.isOpen();
        }
        return false;
    }

    protected void readMetadata() throws Exception {
        try {
            this.length = this.fileStream.length();
            Header header = this.bitstream.readFrame();
            if (header != null) {
                this.frequency = header.frequency();
                this.bitrate = header.bitrate();
                this.samplesPerFrame = header.samples_per_frame();
                this.headerOffset = this.bitstream.header_pos();
                this.tailOffset = this.bitstream.tail_size();
                this.streamSize = this.length - this.headerOffset - this.tailOffset;
                this.isVBR = header.vbr();
                this.maxFrames = header.max_number_of_frames((int)this.streamSize);
                this.duration = this.frequency > 0 ? Math.round(1000.0 * (double)this.samplesPerFrame * (double)this.maxFrames / (double)this.frequency) : 0L;
                switch (header.mode()) {
                    case 0: {
                        this.channels = 2;
                        break;
                    }
                    case 1: {
                        this.channels = 2;
                        break;
                    }
                    case 2: {
                        this.channels = 2;
                        break;
                    }
                    case 3: {
                        this.channels = 1;
                    }
                }
                if (this.readID3Tags) {
                    this.decodeID3V2Tags();
                }
                this.bitstream.closeFrame();
            }
        }
        catch (Exception exception) {
            if (!this.errorReported) {
                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("open[1]: " + exception.toString());
            }
            this.errorReported = true;
        }
        if (this.calculateMoreAccurateFrameSize && !this.isVBR) {
            try {
                double d;
                this.bitstream.rewind();
                long l = -1L;
                int n = 0;
                int n2 = 0;
                while (true) {
                    if (l > 0L) {
                        int n3 = (int)(this.fileReader.getFilePointer() - l);
                        n += n3;
                        if (++n2 > this.calculateMoreAccurateFrameWindow) break;
                    }
                    l = this.fileReader.getFilePointer();
                    Header header = this.bitstream.readFrame();
                    if (header == null) break;
                    this.bitstream.closeFrame();
                }
                if (n2 > 0 && !((d = (double)n / (double)n2) <= 0.0)) {
                    this.maxFrames = (int)Math.round((double)this.streamSize / d);
                    if (this.frequency > 0) {
                        this.duration = Math.round(1000.0 * (double)this.samplesPerFrame * (double)this.maxFrames / (double)this.frequency);
                    }
                }
            }
            catch (Exception exception) {
                if (!this.errorReported) {
                    WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("open[2]: " + exception.toString());
                }
                this.errorReported = true;
            }
        }
        try {
            this.bitstream.rewind();
            this.packetHeader[0] = 34;
            this.packetHeader[0] = (byte)(this.packetHeader[0] + (this.channels - 1));
            if (this.frequency >= 32000) {
                this.packetHeader[0] = (byte)(this.packetHeader[0] | 0xC);
            } else if (this.frequency >= 22050) {
                this.packetHeader[0] = (byte)(this.packetHeader[0] | 8);
            } else if (this.frequency >= 11025) {
                this.packetHeader[0] = (byte)(this.packetHeader[0] | 4);
            }
            if (this.isConfigDecodeCapable(this.stream)) {
                this.packetHeader[0] = 46;
                if (this.channels >= 2) {
                    this.packetHeader[0] = (byte)(this.packetHeader[0] | 1);
                }
            }
        }
        catch (Exception exception) {
            if (!this.errorReported) {
                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("open[2]: " + exception.toString());
            }
            this.errorReported = true;
        }
        if (this.duration <= 0L) {
            throw new Exception("MP3 file format not valid. Zero duration. Seek will not function properly: " + this.mediaName);
        }
    }

    protected boolean isConfigDecodeCapable(IMediaStream iMediaStream) {
        IClient iClient;
        if (iMediaStream != null && (iClient = iMediaStream.getClient()) != null) {
            int[] nArray = new int[]{9, 0, 0, 0};
            return iClient.testFlashVersion(nArray) >= 0;
        }
        return false;
    }

    protected void decodeID3V2Tags() {
        IRandomAccessReader iRandomAccessReader = null;
        try {
            Object object;
            String string;
            Object object2;
            AbstractID3v2 abstractID3v2;
            Object object3;
            iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
            iRandomAccessReader.open();
            int n = 0;
            AMFDataObj aMFDataObj = new AMFDataObj();
            MP3File mP3File = new MP3File(iRandomAccessReader, false);
            if (mP3File != null) {
                Map map = object3 = this.stream != null ? this.stream.getStreams().getVHost().getMp3TagMap() : new HashMap();
                if (mP3File.hasID3v2Tag()) {
                    abstractID3v2 = mP3File.getID3v2Tag();
                    object2 = abstractID3v2.iterator();
                    while (object2.hasNext()) {
                        string = "unknown";
                        object = "unknown";
                        try {
                            AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)object2.next();
                            AbstractMP3FragmentBody abstractMP3FragmentBody = abstractID3v2Frame.getBody();
                            if (abstractMP3FragmentBody == null) continue;
                            object = abstractID3v2Frame.getIdentifier();
                            Object object4 = object;
                            if (((String)object4).length() > 4) {
                                object4 = ((String)object4).substring(0, 4);
                            }
                            if ((string = abstractMP3FragmentBody.getBriefDescription()) == null) continue;
                            Map map2 = (Map)object3.get(object4);
                            if (map2 != null) {
                                String string2 = (String)map2.get("name");
                                if (string2 != null) {
                                    aMFDataObj.put(string2, (AMFData)new AMFDataItem(string));
                                } else {
                                    aMFDataObj.put((String)object, (AMFData)new AMFDataItem(string));
                                }
                            } else {
                                aMFDataObj.put((String)object, (AMFData)new AMFDataItem(string));
                            }
                            ++n;
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug("decodeID3V2Tags: body): key:" + (String)object + " value:" + string + " error:" + unsupportedOperationException.toString());
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("decodeID3V2Tags: body): key:" + (String)object + " value:" + string + " error:" + exception.toString());
                        }
                    }
                }
                if (mP3File.hasID3v1Tag()) {
                    abstractID3v2 = mP3File.getID3v1Tag();
                    try {
                        if (abstractID3v2.getSongTitle() != null && abstractID3v2.getSongTitle().length() > 0) {
                            object2 = "v1SongTitle";
                            string = abstractID3v2.getSongTitle();
                            object = (Map)object3.get(object2);
                            if (object != null) {
                                aMFDataObj.put((String)object.get("name"), (AMFData)new AMFDataItem(string));
                            } else {
                                aMFDataObj.put((String)object2, (AMFData)new AMFDataItem(string));
                            }
                            ++n;
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug("v1SongTitle: " + unsupportedOperationException.toString());
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("v1SongTitle: " + exception.toString());
                    }
                    try {
                        if (abstractID3v2.getLeadArtist() != null && abstractID3v2.getLeadArtist().length() > 0) {
                            object2 = "v1LeadArtist";
                            string = abstractID3v2.getLeadArtist();
                            object = (Map)object3.get(object2);
                            if (object != null) {
                                aMFDataObj.put((String)object.get("name"), (AMFData)new AMFDataItem(string));
                            } else {
                                aMFDataObj.put((String)object2, (AMFData)new AMFDataItem(string));
                            }
                            ++n;
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug("v1LeadArtist: " + unsupportedOperationException.toString());
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("v1LeadArtist: " + exception.toString());
                    }
                    try {
                        if (abstractID3v2.getAlbumTitle() != null && abstractID3v2.getAlbumTitle().length() > 0) {
                            object2 = "v1AlbumTitle";
                            string = abstractID3v2.getAlbumTitle();
                            object = (Map)object3.get(object2);
                            if (object != null) {
                                aMFDataObj.put((String)object.get("name"), (AMFData)new AMFDataItem(string));
                            } else {
                                aMFDataObj.put((String)object2, (AMFData)new AMFDataItem(string));
                            }
                            ++n;
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug("v1AlbumTitle: " + unsupportedOperationException.toString());
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("v1AlbumTitle: " + exception.toString());
                    }
                    try {
                        if (abstractID3v2.getYearReleased() != null && abstractID3v2.getYearReleased().length() > 0) {
                            object2 = "v1YearReleased";
                            string = abstractID3v2.getYearReleased();
                            object = (Map)object3.get(object2);
                            if (object != null) {
                                aMFDataObj.put((String)object.get("name"), (AMFData)new AMFDataItem(string));
                            } else {
                                aMFDataObj.put((String)object2, (AMFData)new AMFDataItem(string));
                            }
                            ++n;
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug("v1YearReleased: " + unsupportedOperationException.toString());
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("v1YearReleased: " + exception.toString());
                    }
                    try {
                        if (abstractID3v2.getSongComment() != null && abstractID3v2.getSongComment().length() > 0) {
                            object2 = "v1SongComment";
                            string = abstractID3v2.getSongComment();
                            object = (Map)object3.get(object2);
                            if (object != null) {
                                aMFDataObj.put((String)object.get("name"), (AMFData)new AMFDataItem(string));
                            } else {
                                aMFDataObj.put((String)object2, (AMFData)new AMFDataItem(string));
                            }
                            ++n;
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug("v1SongComment: " + unsupportedOperationException.toString());
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("v1SongComment: " + exception.toString());
                    }
                    try {
                        if (abstractID3v2.getSongGenre() != null && abstractID3v2.getSongGenre().length() > 0) {
                            object2 = "v1SongGenre";
                            string = abstractID3v2.getSongGenre();
                            object = (Map)object3.get(object2);
                            if (object != null) {
                                aMFDataObj.put((String)object.get("name"), (AMFData)new AMFDataItem(string));
                            } else {
                                aMFDataObj.put((String)object2, (AMFData)new AMFDataItem(string));
                            }
                            ++n;
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug("v1SongGenre: " + unsupportedOperationException.toString());
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("v1SongGenre: " + exception.toString());
                    }
                    try {
                        if (abstractID3v2.getTrackNumberOnAlbum() != null && abstractID3v2.getTrackNumberOnAlbum().length() > 0) {
                            object2 = "v1TrackNumberOnAlbum";
                            string = abstractID3v2.getTrackNumberOnAlbum();
                            object = (Map)object3.get(object2);
                            if (object != null) {
                                aMFDataObj.put((String)object.get("name"), (AMFData)new AMFDataItem(string));
                            } else {
                                aMFDataObj.put((String)object2, (AMFData)new AMFDataItem(string));
                            }
                            ++n;
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug("v1TrackNumberOnAlbum: " + unsupportedOperationException.toString());
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("v1TrackNumberOnAlbum: " + exception.toString());
                    }
                }
            }
            if (!(object3 = WMSLoggerFactory.getLogger(MediaReaderMP3.class)).isDebugEnabled()) {
                object3 = null;
            }
            this.metaData = null;
            if (n > 0) {
                if (this.metaData == null) {
                    this.metaData = new ArrayList();
                }
                if (object3 != null) {
                    for (int i = 0; i < n; ++i) {
                        object2 = aMFDataObj.getKey(i);
                        string = (AMFDataItem)aMFDataObj.get((String)object2);
                        object3.debug("onID3: " + (String)object2 + "=" + string.toString());
                    }
                }
                abstractID3v2 = new AMFDataList();
                abstractID3v2.add((AMFData)new AMFDataItem("onID3"));
                abstractID3v2.add((AMFData)aMFDataObj);
                object2 = abstractID3v2.serialize();
                this.metaData.add(ByteBuffer.wrap((byte[])object2));
            }
            if (this.duration > 0L) {
                if (this.metaData == null) {
                    this.metaData = new ArrayList();
                }
                aMFDataObj = new AMFDataObj();
                double d = (double)this.duration / 1000.0;
                aMFDataObj.put("duration", (AMFData)new AMFDataItem(d));
                if (object3 != null) {
                    object3.debug("onMetaData: duration=" + d);
                }
                string = new AMFDataList();
                string.add((AMFData)new AMFDataItem("onMetaData"));
                string.add((AMFData)aMFDataObj);
                object = string.serialize();
                this.metaData.add(ByteBuffer.wrap((byte[])object));
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("decodeID3V2Tags: " + exception.toString());
            exception.printStackTrace();
        }
        try {
            if (iRandomAccessReader != null) {
                iRandomAccessReader.close();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("decodeID3V2Tags: " + exception.toString());
        }
    }

    public List getMetadata() {
        return this.metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewind() {
        if (this.bitstream == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.bitstream.rewind();
        }
    }

    protected long sample2TC(long l) {
        return l * 1000L / (long)this.frequency;
    }

    protected long tc2Sample(long l) {
        return l * (long)this.frequency / 1000L;
    }

    public void touchClient() {
        block0: {
            IClient iClient;
            if (this.stream == null || (iClient = this.stream.getClient()) == null) break block0;
            iClient.touch();
        }
    }

    public PlaylistSeekResult seek(long l, int n) {
        MP3StreamPosition mP3StreamPosition;
        long l2;
        long l3;
        PlaylistSeekResult playlistSeekResult = null;
        if (l <= 0L) {
            l = 0L;
        }
        if (!this.fileStream.exists()) {
            return null;
        }
        if (this.duration > 0L) {
            if (l > this.duration) {
                l = this.duration;
            }
            l3 = -1L;
            l2 = 0L;
            mP3StreamPosition = null;
            if (l <= 0L) {
                l3 = this.headerOffset;
                l2 = 0L;
            } else {
                long l4 = this.headerOffset + this.streamSize * l / this.duration;
                if (l4 >= this.headerOffset + this.streamSize) {
                    l3 = this.headerOffset + this.streamSize;
                    l2 = this.maxFrames * (long)this.samplesPerFrame;
                } else {
                    try {
                        mP3StreamPosition = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
                        mP3StreamPosition.open();
                        long l5 = 10240L;
                        if (l4 + l5 > mP3StreamPosition.length()) {
                            long l6;
                            long l7 = l6 = this.maxFrames > 0L ? this.streamSize / this.maxFrames : 256L;
                            if (l6 > 0L && l6 < l4) {
                                l4 -= l6;
                            }
                            l5 = mP3StreamPosition.length() - l4;
                        }
                        mP3StreamPosition.seek(l4);
                        byte[] byArray = new byte[(int)l5];
                        this.touchClient();
                        mP3StreamPosition.read(byArray, 0, byArray.length);
                        this.touchClient();
                        int n2 = MP3Utils.decodeFirstChunkMP3((byte[])byArray, (int)0, (long)byArray.length, (int)this.bitrate);
                        this.touchClient();
                        if (n2 >= 0) {
                            l3 = l4 + (long)n2;
                            l2 = this.maxFrames * (long)this.samplesPerFrame * l / this.duration;
                        } else if ((double)l * 100.0 / (double)this.duration > 95.0) {
                            l3 = this.headerOffset + this.streamSize;
                            l2 = this.maxFrames * (long)this.samplesPerFrame;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                if (mP3StreamPosition != null) {
                    mP3StreamPosition.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            mP3StreamPosition = null;
            if (l3 >= 0L) {
                playlistSeekResult = new PlaylistSeekResult(0L);
                MP3StreamPosition mP3StreamPosition2 = new MP3StreamPosition(l3, l2);
                playlistSeekResult.setResults((IMediaReaderStreamPosition)mP3StreamPosition2, this.sample2TC(l2), 8, 0);
                playlistSeekResult.setVideoStreamPos(null);
            }
        }
        if (playlistSeekResult == null) {
            l3 = this.headerOffset;
            l2 = 0L;
            playlistSeekResult = new PlaylistSeekResult(0L);
            mP3StreamPosition = new MP3StreamPosition(l3, l2);
            playlistSeekResult.setResults((IMediaReaderStreamPosition)mP3StreamPosition, 0L, 8, 0);
            playlistSeekResult.setVideoStreamPos(null);
        }
        return playlistSeekResult;
    }

    public IMediaReaderStreamPosition getStreamPosition() {
        MP3StreamPosition mP3StreamPosition = new MP3StreamPosition();
        try {
            mP3StreamPosition.setSample(this.currentSample);
            if (this.fileStream != null) {
                mP3StreamPosition.setFilePos(this.fileStream.getFilePointer());
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("getFilePointer: " + exception.toString());
        }
        return mP3StreamPosition;
    }

    public void setStreamPosition(IMediaReaderStreamPosition iMediaReaderStreamPosition) {
        MP3StreamPosition mP3StreamPosition = (MP3StreamPosition)iMediaReaderStreamPosition;
        try {
            if (this.fileReader != null) {
                this.fileReader.seek(mP3StreamPosition.getFilePos());
            }
            this.currentSample = mP3StreamPosition.getSample();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("getFilePointer: " + exception.toString());
        }
    }

    public int rewriteLastPacket(int n, long l, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, long[] lArray, FastPlaySettings fastPlaySettings) {
        return 0;
    }

    public void startPlayback() {
    }

    public int writeGeneratedKeyFrame(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        int n = 0;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writePackets(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        int n = 0;
        if (this.justID3Tags) {
            playlistReaderWriteResults.setHitEnd(true);
            return n;
        }
        if (this.duration <= 0L) {
            playlistReaderWriteResults.setHitEnd(true);
            return n;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.bitstream == null) {
                playlistReaderWriteResults.setHitEnd(true);
                return n;
            }
        }
        object = null;
        int n2 = 0;
        long l = playlistWriteControl.getMaxTC();
        long l2 = playlistCursor.getLastAudioTC();
        long l3 = this.currentSample;
        try {
            while ((object = this.bitstream.readFrame()) != null) {
                Object object2 = this.lock;
                synchronized (object2) {
                    if (playlistCursor.isBreakLoop()) {
                        break;
                    }
                    boolean bl2 = playlistCursor.isSendAbsAudioTC();
                    if (this.bitstream.framesize <= 0) {
                        if (!this.bitrateErrorSent) {
                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("MediaReaderMP3.writePackets: Negative frame size (" + this.bitstream.framesize + "). May be due to unsupported MP3 bitrate higher than 128 kbps.");
                            this.bitrateErrorSent = true;
                        }
                        break;
                    }
                    int n3 = aMFObj.getId();
                    int n4 = this.stream.getSrc();
                    int n5 = this.bitstream.framesize + 5;
                    int n6 = 8;
                    AMFObj aMFObj4 = aMFObj;
                    boolean bl3 = aMFObj4.isNew();
                    boolean bl4 = bl3 | bl2;
                    aMFObj4.setNew(false);
                    long l4 = 0L;
                    if (playlistCursor.isSendAbsAudioTC()) {
                        playlistCursor.setSendAbsAudioTC(false);
                        l4 = this.sample2TC(l3);
                        if ((l4 += playlistCursor.getStartTCOffset()) < 0L) {
                            this.bitstream.closeFrame();
                            continue;
                        }
                    } else {
                        l4 = this.sample2TC(l3) - l2;
                    }
                    playlistCursor.setLastAudioTC(l2 += l4);
                    playlistCursor.incAudioPacketCount();
                    playlistCursor.setLastTC(l2);
                    this.currentSample = l3 += (long)this.samplesPerFrame;
                    playlistReaderWriteResults.setLastTC(l2);
                    playlistReaderWriteResults.incAudioPackets();
                    ++n2;
                    int n7 = 1;
                    if (bl) {
                        l4 = 0L;
                    }
                    this.workBuffer[0] = (byte)(0xFF & n3);
                    if (bl4 || aMFObj4.getSrc() != n4) {
                        this.workBuffer[8] = (byte)(0xFF & n4);
                        this.workBuffer[9] = (byte)(0xFF & n4 >> 8);
                        this.workBuffer[10] = (byte)(0xFF & n4 >> 16);
                        this.workBuffer[11] = (byte)(0xFF & n4 >> 24);
                        aMFObj4.setSrc(n4);
                        n7 += 4;
                        bl4 = true;
                    }
                    if (bl4 || aMFObj4.getSize() != n5) {
                        this.workBuffer[4] = (byte)(0xFF & n5 >> 16);
                        this.workBuffer[5] = (byte)(0xFF & n5 >> 8);
                        this.workBuffer[6] = (byte)(0xFF & n5);
                        this.workBuffer[7] = (byte)n6;
                        aMFObj4.setSize(n5);
                        aMFObj4.setType(n6);
                        n7 += 4;
                        bl4 = true;
                    }
                    boolean bl5 = false;
                    if (bl4 || aMFObj4.getTimecode() != l4) {
                        if (l4 >= 0xFFFFFFL) {
                            this.workBuffer[1] = -1;
                            this.workBuffer[2] = -1;
                            this.workBuffer[3] = -1;
                            bl5 = true;
                        } else {
                            this.workBuffer[1] = (byte)(0xFFL & l4 >> 16);
                            this.workBuffer[2] = (byte)(0xFFL & l4 >> 8);
                            this.workBuffer[3] = (byte)(0xFFL & l4);
                        }
                        aMFObj4.setTimecode(l4);
                        n7 += 3;
                        bl4 = true;
                    }
                    if (n3 >= 64) {
                        byte[] byArray = new byte[2];
                        switch (n7) {
                            case 12: {
                                byArray[0] = 0;
                                break;
                            }
                            case 8: {
                                byArray[0] = 64;
                                break;
                            }
                            case 4: {
                                byArray[0] = -128;
                                break;
                            }
                            case 1: {
                                byArray[0] = -64;
                            }
                        }
                        byArray[1] = (byte)(n3 - 64 & 0xFF);
                        outputStream.write(byArray, 0, 2);
                        outputStream.write(this.workBuffer, 1, n7 - 1);
                        n += n7 + 1;
                    } else {
                        switch (n7) {
                            case 12: {
                                break;
                            }
                            case 8: {
                                this.workBuffer[0] = (byte)(this.workBuffer[0] | 0x40);
                                break;
                            }
                            case 4: {
                                this.workBuffer[0] = (byte)(this.workBuffer[0] | 0x80);
                                break;
                            }
                            case 1: {
                                this.workBuffer[0] = (byte)(this.workBuffer[0] | 0xC0);
                            }
                        }
                        outputStream.write(this.workBuffer, 0, n7);
                        n += n7;
                    }
                    if (bl5) {
                        this.workBuffer[0] = (byte)(0xFFL & l4 >> 24);
                        this.workBuffer[1] = (byte)(0xFFL & l4 >> 16);
                        this.workBuffer[2] = (byte)(0xFFL & l4 >> 8);
                        this.workBuffer[3] = (byte)(0xFFL & l4);
                        outputStream.write(this.workBuffer, 0, 4);
                        n = 4;
                    }
                    object.getSyncHeader(this.syncHeader);
                    outputStream.write(this.packetHeader, 0, 1);
                    ++n;
                    outputStream.write(this.syncHeader, 0, 4);
                    n += 4;
                    lArray[1] = lArray[1] + 1L;
                    if (n5 > 0) {
                        int n8 = this.bitstream.framesize;
                        int n9 = 0;
                        int n10 = 0;
                        int n11 = 5;
                        do {
                            if (n11 == 0) {
                                if (n3 >= 64) {
                                    this.workBuffer[0] = -64;
                                    this.workBuffer[1] = (byte)(n3 - 64 & 0xFF);
                                    outputStream.write(this.workBuffer, 0, 2);
                                    n += 2;
                                } else {
                                    this.workBuffer[0] = (byte)(0xFF & n3 | 0xC0);
                                    outputStream.write(this.workBuffer, 0, 1);
                                    ++n;
                                }
                                if (bl5) {
                                    this.workBuffer[0] = (byte)(0xFFL & l4 >> 24);
                                    this.workBuffer[1] = (byte)(0xFFL & l4 >> 16);
                                    this.workBuffer[2] = (byte)(0xFFL & l4 >> 8);
                                    this.workBuffer[3] = (byte)(0xFFL & l4);
                                    outputStream.write(this.workBuffer, 0, 4);
                                    n = 4;
                                }
                            }
                            if ((n10 = playlistCursor.getWriteControl().getChunkSize() - n11) > n8 - n9) {
                                n10 = n8 - n9;
                            }
                            try {
                                outputStream.write(this.bitstream.frame_bytes, n9, n10);
                                n += n10;
                            }
                            catch (Exception exception) {
                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("MediaReaderMP3.writePackets: Problem reading input file[" + n9 + ":" + n10 + "]: " + exception.toString());
                            }
                            n11 = 0;
                        } while ((n9 += n10) != n8);
                    }
                    this.bitstream.closeFrame();
                    if (l == 0L) {
                        if (n2 > 0) {
                            break;
                        }
                    } else if (l2 >= l) {
                        break;
                    }
                }
            }
            if (object == null) {
                playlistReaderWriteResults.setHitEnd(true);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("writePackets: " + exception.toString());
            exception.printStackTrace();
        }
        playlistReaderWriteResults.setTotalSize(n);
        lArray[0] = lArray[0] + (long)n;
        return n;
    }

    public long getDuration() {
        long l = 0L;
        if (this.duration >= 0L) {
            return this.duration;
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        long l2 = 0L;
        long l3 = 0L;
        Bitstream bitstream = null;
        IRandomAccessReader iRandomAccessReader = null;
        try {
            iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
            iRandomAccessReader.open();
            bitstream = new Bitstream(iRandomAccessReader);
            Header header = bitstream.readFrame();
            if (header != null) {
                n = header.frequency();
                n2 = header.samples_per_frame();
                long l4 = bitstream.header_pos();
                long l5 = bitstream.tail_size();
                l2 = iRandomAccessReader.length() - l4 - l5;
                bl = header.vbr();
                int n3 = header.max_number_of_frames((int)l2);
                l3 = n > 0 ? Math.round(1000.0 * (double)n2 * (double)n3 / (double)n) : 0L;
                bitstream.closeFrame();
            }
            bitstream.close();
            iRandomAccessReader.close();
            l = l3;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.calculateMoreAccurateFrameSize && !bl) {
            try {
                double d;
                bitstream.rewind();
                long l6 = -1L;
                int n4 = 0;
                int n5 = 0;
                while (true) {
                    if (l6 > 0L) {
                        int n6 = (int)(iRandomAccessReader.getFilePointer() - l6);
                        n4 += n6;
                        if (++n5 > this.calculateMoreAccurateFrameWindow) break;
                    }
                    l6 = iRandomAccessReader.getFilePointer();
                    Header header = bitstream.readFrame();
                    if (header == null) break;
                    bitstream.closeFrame();
                }
                if (n5 > 0 && !((d = (double)n4 / (double)n5) <= 0.0)) {
                    int n7 = (int)Math.round((double)l2 / d);
                    if (n > 0) {
                        l3 = Math.round(1000.0 * (double)n2 * (double)n7 / (double)n);
                    }
                    l = l3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (iRandomAccessReader != null) {
            try {
                iRandomAccessReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        iRandomAccessReader = null;
        return l;
    }

    public long getLength() {
        return this.fileStream != null ? this.fileStream.length() : 0L;
    }

    public String getPath() {
        return this.fileStream.getPath();
    }

    public String getMediaExtension() {
        return this.mediaExtension;
    }

    public int sendZeroLengthPacket(int n, int n2, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writePackets(List<AMFPacket> list, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings) {
        int n = 0;
        if (this.justID3Tags) {
            playlistReaderWriteResults.setHitEnd(true);
            return n;
        }
        if (this.duration <= 0L) {
            playlistReaderWriteResults.setHitEnd(true);
            return n;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.bitstream == null) {
                playlistReaderWriteResults.setHitEnd(true);
                return n;
            }
        }
        object = null;
        int n2 = 0;
        long l = playlistWriteControl.getMaxTC();
        long l2 = playlistCursor.getLastAudioTC();
        long l3 = this.currentSample;
        try {
            while ((object = this.bitstream.readFrame()) != null) {
                Object object2 = this.lock;
                synchronized (object2) {
                    if (playlistCursor.isBreakLoop()) {
                        break;
                    }
                    if (this.bitstream.framesize <= 0) {
                        if (!this.bitrateErrorSent) {
                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("MediaReaderMP3.writePackets: Negative frame size (" + this.bitstream.framesize + "). May be due to unsupported MP3 bitrate higher than 128 kbps.");
                            this.bitrateErrorSent = true;
                        }
                        break;
                    }
                    long l4 = 0L;
                    if (playlistCursor.isSendAbsAudioTC()) {
                        playlistCursor.setSendAbsAudioTC(false);
                        l4 = this.sample2TC(l3);
                        if ((l4 += playlistCursor.getStartTCOffset()) < 0L) {
                            this.bitstream.closeFrame();
                            continue;
                        }
                    } else {
                        l4 = this.sample2TC(l3) - l2;
                    }
                    playlistCursor.setLastAudioTC(l2 += l4);
                    playlistCursor.incAudioPacketCount();
                    playlistCursor.setLastTC(l2);
                    this.currentSample = l3 += (long)this.samplesPerFrame;
                    playlistReaderWriteResults.setLastTC(l2);
                    playlistReaderWriteResults.incAudioPackets();
                    ++n2;
                    AMFPacket aMFPacket = this.createPacket((Header)object);
                    aMFPacket.setAbsTimecode(l2);
                    list.add(aMFPacket);
                    int n3 = aMFPacket.getSize();
                    n += n3;
                    lArray[0] = lArray[0] + (long)n3;
                    lArray[1] = lArray[1] + 1L;
                    this.bitstream.closeFrame();
                    if (l == 0L) {
                        if (n2 > 0) {
                            break;
                        }
                    } else if (l2 >= l) {
                        break;
                    }
                }
            }
            if (object == null) {
                playlistReaderWriteResults.setHitEnd(true);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("writePackets: " + exception.toString());
            exception.printStackTrace();
        }
        playlistReaderWriteResults.setTotalSize(n);
        lArray[0] = lArray[0] + (long)n;
        return n;
    }

    protected AMFPacket createPacket(Header header) {
        int n = 8;
        AMFPacket aMFPacket = new AMFPacket(n, 0, this.bitstream.framesize + 4 + 1);
        try {
            byte[] byArray = aMFPacket.getData();
            byArray[0] = this.packetHeader[0];
            header.getSyncHeader(this.syncHeader);
            aMFPacket.addDataEx(this.syncHeader, 0, 1, 4);
            aMFPacket.addDataEx(this.bitstream.frame_bytes, 0, 5, this.bitstream.framesize);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("MediaReaderMP3.createPacket: " + exception.toString());
            exception.printStackTrace();
        }
        return aMFPacket;
    }
}

