﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Web.Media.SmoothStreaming;
using System.Windows.Interop;

namespace LiveSilverlightStreaming
{
    public partial class MainPage : UserControl
    { 
        Boolean manifestReady = false;
        Boolean manifestChanged = true;       
        double playerWidth;
        double playerHeight;
        double currentWidth;
        double currentHeight;
          
        public MainPage()
        {
            InitializeComponent();
            
            SmoothPlayer.ManifestReady += new EventHandler<EventArgs>(SmoothPlayer_ManifestReady);
            SmoothPlayer.MediaOpened += new RoutedEventHandler(SmoothPlayer_MediaOpened); //new EventHandler<EventArgs>(SmoothPlayer_MediaOpened);
            App.Current.Host.Content.FullScreenChanged +=new EventHandler(Content_FullScreenChanged);
        }
       
        void UserControl_Loaded(object sender, RoutedEventArgs e)
        {
            //SmoothPlayer.SmoothStreamingSource = new Uri(ManifestURL.Text);
            SmoothPlayer.Volume = .5;
            VolumeBar.Value = 5;
        }

        void SmoothPlayer_ManifestReady(object sender, EventArgs e)
        {
            manifestReady = true;
            SmoothPlayer.Volume = VolumeBar.Value * .1;
            PlayButton.IsEnabled = true;
            currentWidth = this.Width;
            currentHeight = this.Height;
            
            if (!manifestChanged)
                PlayButton.Content = "Play";

            output.Text = "";
        }

        void SmoothPlayer_MediaOpened(object sender, EventArgs e)
        { 
            double frameAspectRatio = 640 / 320;
            double videoWidth = SmoothPlayer.NaturalVideoWidth;
            double videoHeight = SmoothPlayer.NaturalVideoHeight;
            double videoAspectRatio = videoWidth / videoHeight;

            playerHeight = currentHeight;
            playerWidth = currentWidth;

            if (videoAspectRatio > frameAspectRatio)
            {
                playerHeight = currentHeight / videoAspectRatio;
            }
            else
            {
                playerWidth = currentHeight * videoAspectRatio;
            }

            SmoothPlayer.Height = playerHeight;
            SmoothPlayer.Width = playerWidth;
            
            if (manifestChanged)
            {
                manifestChanged = false;
                PlayButton_Click(null, null);
            }
            output.Text = "";
        }


        void PlayButton_Click(object sender, RoutedEventArgs e)
        {
            output.Text = "";

            if (!manifestReady)
            {
                SmoothPlayer.SmoothStreamingSource = new Uri(ManifestURL.Text);
                return;
            }

            if (manifestChanged)
            {
                SmoothPlayer.SmoothStreamingSource = new Uri(ManifestURL.Text);
                return;
            }

            if (manifestReady && (String)PlayButton.Content=="Play")
            {
                SmoothPlayer.Play();

                PlayButton.Content = "Stop";
                fullScreenButton.Visibility = System.Windows.Visibility.Visible;
            }
            else if ((String)PlayButton.Content=="Stop")
            {
                SmoothPlayer.Stop();
                SmoothPlayer.SmoothStreamingSource = null;
                manifestChanged = true;
                PlayButton.Content = "Play";
                fullScreenButton.Visibility = System.Windows.Visibility.Collapsed;
            }
            else
            {
                output.Text = "Manifest Not Loaded";
            }
        }

        void Content_FullScreenChanged(object sender, EventArgs e)
        {
            Boolean isFullScreen = Application.Current.Host.Content.IsFullScreen;

            if (!isFullScreen)
            {
                Grid.SetRowSpan(SmoothPlayer, 1);
                SmoothPlayer.Width = playerWidth;
                SmoothPlayer.Height = playerHeight;
                grid2.Visibility = System.Windows.Visibility.Visible;
                SmoothPlayer.Background = new SolidColorBrush(Colors.White);
                SmoothPlayer.HorizontalAlignment = HorizontalAlignment.Left;
                LayoutRoot.Background = new SolidColorBrush(Colors.White);
                SmoothPlayer.Margin = new Thickness(10, 0, 0, 0);

            }
        }

        void Fullscreen_Click(object sender, RoutedEventArgs e)
        {
            Application.Current.Host.Content.IsFullScreen = (Application.Current.Host.Content.IsFullScreen) ? false : true;

            if (!Application.Current.Host.Content.IsFullScreen)
            {
                Grid.SetRowSpan(SmoothPlayer, 1);
                SmoothPlayer.Width = playerWidth;
                SmoothPlayer.Height = playerHeight;
                grid2.Visibility = System.Windows.Visibility.Visible;
                SmoothPlayer.Background = new SolidColorBrush(Colors.White);
                SmoothPlayer.HorizontalAlignment = HorizontalAlignment.Left;
                LayoutRoot.Background = new SolidColorBrush(Colors.White);
                SmoothPlayer.Margin = new Thickness(10, 0, 0, 0);
            }
            else
            {
                Grid.SetRowSpan(SmoothPlayer, 2);
                SmoothPlayer.Width = this.Width;
                SmoothPlayer.Height = this.Height;
                grid2.Visibility = System.Windows.Visibility.Collapsed;
                SmoothPlayer.Background = new SolidColorBrush(Colors.Black);
                SmoothPlayer.HorizontalAlignment = HorizontalAlignment.Center;
                LayoutRoot.Background = new SolidColorBrush(Colors.Black);
                SmoothPlayer.Margin = new Thickness(0, 0, 0, 0);
            }
        }

        void VolumeBar_ValueChanged(object sender, RoutedPropertyChangedEventArgs<double> e)
        {
            SmoothPlayer.Volume = VolumeBar.Value * .1;
        }

        void ManifestURL_TextChanged(object sender, TextChangedEventArgs e)
        {
            manifestChanged = true;
            PlayButton.IsEnabled = true;
        }
    }
}