﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Web.Media.SmoothStreaming;
using System.Windows.Threading;
using System.Windows.Interop;

namespace SimpleSilverlightStreaming
{
    public partial class MainPage : UserControl
    { 
        DispatcherTimer timer = new DispatcherTimer();
        Boolean manifestReady = false;
        Boolean manifestChanged = true;       
        double playerWidth;
        double playerHeight;
        double currentWidth;
        double currentHeight;
          
        public MainPage()
        {
            InitializeComponent();
            
            timer.Interval = TimeSpan.FromMilliseconds(200);
            timer.Start();
            timer.Tick += new EventHandler(timer_Tick);

            SmoothPlayer.ManifestReady += new EventHandler<EventArgs>(SmoothPlayer_ManifestReady);
            SmoothPlayer.MediaOpened += new RoutedEventHandler(SmoothPlayer_MediaOpened); //new EventHandler<EventArgs>(SmoothPlayer_MediaOpened);
            App.Current.Host.Content.FullScreenChanged +=new EventHandler(Content_FullScreenChanged);
        }
       
        void UserControl_Loaded(object sender, RoutedEventArgs e)
        {
            //SmoothPlayer.SmoothStreamingSource = new Uri(ManifestURL.Text);
            SmoothPlayer.Volume = .5;
            VolumeBar.Value = 5;
        }

        void SmoothPlayer_ManifestReady(object sender, EventArgs e)
        {
            manifestReady = true;
            SeekBar.Maximum = SmoothPlayer.EndPosition.TotalSeconds;
            SmoothPlayer.Volume = VolumeBar.Value * .1;
            PlayButton.IsEnabled = true;
            PauseButton.Content = "Pause";
            currentWidth = this.Width;
            currentHeight = this.Height;
            
            if (!manifestChanged)
                PlayButton.Content = "Play";
        }

        void SmoothPlayer_MediaOpened(object sender, EventArgs e)
        { 
            double frameAspectRatio = 640 / 320;
            double videoWidth = SmoothPlayer.NaturalVideoWidth;
            double videoHeight = SmoothPlayer.NaturalVideoHeight;
            double videoAspectRatio = videoWidth / videoHeight;

            playerHeight = currentHeight;
            playerWidth = currentWidth;

            if (videoAspectRatio > frameAspectRatio)
            {
                playerHeight = currentHeight / videoAspectRatio;
            }
            else
            {
                playerWidth = currentHeight * videoAspectRatio;
            }

            SmoothPlayer.Height = playerHeight;
            SmoothPlayer.Width = playerWidth;
            
            if (manifestChanged)
            {
                manifestChanged = false;
                PlayButton_Click(null, null);
            }
        }

        void timer_Tick(object sender, EventArgs e)
        {
             SeekBar.Value = SmoothPlayer.Position.TotalSeconds;
        }

        void PlayButton_Click(object sender, RoutedEventArgs e)
        {
            output.Text = "";

            if (manifestChanged)
            {
                SmoothPlayer.SmoothStreamingSource = new Uri(ManifestURL.Text);
                PlayButton.IsEnabled = false;
                SeekBar.IsEnabled = false;
                PauseButton.IsEnabled = false;
                RewButton.IsEnabled = false;
                
                return;
            }

            if (manifestReady && (String)PlayButton.Content=="Play")
            {
                SmoothPlayer.Play();
                timer.Start();

                PlayButton.Content = "Stop";
                PauseButton.IsEnabled = true;
                SeekBar.IsEnabled = true;
                RewButton.IsEnabled = true;
                fullScreenButton.Visibility = System.Windows.Visibility.Visible;
            }
            else if ((String)PlayButton.Content=="Stop")
            {
                SmoothPlayer.Stop();
                timer.Stop();

                SeekBar.Value = 0;
                SeekBar.IsEnabled = false;
                PlayButton.Content = "Play";
                PauseButton.Content = "Pause";
                PauseButton.IsEnabled = false;
                RewButton.IsEnabled = false;
                fullScreenButton.Visibility = System.Windows.Visibility.Collapsed;
                SmoothPlayer.SmoothStreamingSource = null;
                manifestChanged = true;
            }
            else
            {
                output.Text = "Manifest Not Loaded";
            }
        }

        void PauseButton_Click(object sender, RoutedEventArgs e)
        {
            if (PauseButton.Content.ToString() == "Pause")
            {
                SmoothPlayer.Pause();
                timer.Stop();

                PauseButton.Content = "Play";
            }
            else
            {
                SmoothPlayer.Play();
                timer.Start();

                PauseButton.Content = "Pause";
            }   
        }
 
        void Content_FullScreenChanged(object sender, EventArgs e)
        {
            Boolean isFullScreen = Application.Current.Host.Content.IsFullScreen;
   
            if (!isFullScreen)
            {
                Grid.SetRowSpan(SmoothPlayer, 1);
                SmoothPlayer.Width = playerWidth;
                SmoothPlayer.Height = playerHeight;
                grid2.Visibility = System.Windows.Visibility.Visible;
                SmoothPlayer.Background = new SolidColorBrush(Colors.White);
                SmoothPlayer.Margin = new Thickness(10, 10, 0, 0);
            }
        }

        void Fullscreen_Click(object sender, RoutedEventArgs e)
        {
            Application.Current.Host.Content.IsFullScreen = (Application.Current.Host.Content.IsFullScreen) ? false : true;
            
            if (!Application.Current.Host.Content.IsFullScreen)
            {
                Grid.SetRowSpan(SmoothPlayer, 1);
                SmoothPlayer.Width = playerWidth;
                SmoothPlayer.Height = playerHeight;
                grid2.Visibility = System.Windows.Visibility.Visible;
                SmoothPlayer.Background = new SolidColorBrush(Colors.White);
                SmoothPlayer.Margin = new Thickness(10, 10, 0, 0);
            }
            else
            {
               Grid.SetRowSpan(SmoothPlayer, 2);
               SmoothPlayer.Width = this.Width;
               SmoothPlayer.Height = this.Height;
               grid2.Visibility = System.Windows.Visibility.Collapsed;
               SmoothPlayer.Background = new SolidColorBrush(Colors.Black);
               SmoothPlayer.Margin = new Thickness(0, 0, 0, 0);
            }
        }

        void SeekBar_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            SmoothPlayer.Position = TimeSpan.FromSeconds(SeekBar.Value);
        }

        void SeekBar_MouseEnter(object sender, MouseEventArgs e)
        {
            timer.Stop();
        }

        void SeekBar_MouseLeave(object sender, MouseEventArgs e)
        {
            if (PlayButton.Content.ToString()=="Play")
                timer.Start();
        }

        void VolumeBar_ValueChanged(object sender, RoutedPropertyChangedEventArgs<double> e)
        {
            SmoothPlayer.Volume = VolumeBar.Value * .1;
        }

        void RewButton_Click(object sender, RoutedEventArgs e)
        {
            SmoothPlayer.Position = TimeSpan.FromSeconds(0);
            SeekBar.Value = 0;
        }

        void ManifestURL_TextChanged(object sender, TextChangedEventArgs e)
        {
            manifestChanged = true;
            PlayButton.IsEnabled = true;
        }
    }
}