/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class HTTPRandomAccessFile {
    public static final int MAXHEADERSIZE = 2048;
    public static final int TIMEOUT = 4000;
    public static final String CRLF = "\r\n";
    private String host = null;
    private int port = 80;
    private String path = "/";
    private Socket socket = null;
    private InputStream inStream = null;
    private OutputStream outStream = null;
    private long length = 0L;
    private Date lastModified = null;
    private StringBuffer msgBuf = new StringBuffer();
    private FastDateFormat dateFormat = FastDateFormat.getInstance((String)"E, dd MMM yyyy HH:mm:ss zzz");
    private long location = 0L;
    private InetSocketAddress socketAddress = null;
    private boolean doReconnect = false;
    protected String[] parseDateFormats = new String[1];

    public HTTPRandomAccessFile() {
        this.parseDateFormats[0] = "E, dd MMM yyyy HH:mm:ss zzz";
    }

    public void open(String string) throws IOException {
        System.out.println("HTTPRandomAccessFile.open: " + string);
        URL uRL = new URL(string);
        this.host = uRL.getHost();
        if (uRL.getPort() > 0) {
            this.port = uRL.getPort();
        }
        if (uRL.getPath() != null) {
            this.path = uRL.getPath();
        }
        this.socketAddress = new InetSocketAddress(this.host, this.port);
        this.doConnect();
        this.msgBuf.setLength(0);
        this.msgBuf.append("HEAD " + this.path + " HTTP/1.1" + CRLF);
        this.msgBuf.append("Host: " + this.host + CRLF);
        this.msgBuf.append("Connection: keep-alive\r\n");
        this.msgBuf.append("Proxy-Connection: Keep-Alive\r\n");
        this.msgBuf.append(CRLF);
        SendResult sendResult = this.sendRequest(this.msgBuf.toString().getBytes(), true);
        if (sendResult.status == 404) {
            throw new IOException("HTTPRandomAccessFile.open: File not found [" + sendResult.status + "]: " + string);
        }
        if (sendResult.status >= 300) {
            throw new IOException("HTTPRandomAccessFile.open: Error retrieving url [" + sendResult.status + "]: " + string);
        }
        this.length = sendResult.contentLength;
    }

    public void close() {
        this.doClose();
    }

    private void doClose() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            this.socket = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doConnect() throws IOException {
        System.out.println("doConnect: " + this.socketAddress);
        this.doClose();
        this.socket = new Socket();
        this.socket.setKeepAlive(true);
        this.socket.setSendBufferSize(Math.max(8192, 2048));
        this.socket.setReceiveBufferSize(133120);
        this.socket.connect(this.socketAddress);
        this.inStream = this.socket.getInputStream();
        this.outStream = this.socket.getOutputStream();
    }

    private void reconnect() {
        try {
            this.doConnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseHeader(SendResult sendResult, byte[] byArray, int n, int n2, boolean bl) {
        try {
            for (int i = 0; i < n2; ++i) {
                String[] stringArray;
                if (byArray[i + n] != 13 || i + 3 >= n2 || byArray[i + n] != 13 || byArray[i + n + 1] != 10 || byArray[i + n + 2] != 13 || byArray[i + n + 3] != 10) continue;
                sendResult.gotHeader = true;
                sendResult.headerLength = i + 4;
                String string = new String(byArray, n, (int)sendResult.headerLength);
                while (((stringArray = string.substring(0, 1)).equals("\n") || stringArray.equals("\r")) && (string = string.substring(1)).length() != 0) {
                }
                string = string.replace(CRLF, "\n").replace("\r", "\n");
                stringArray = string.split("\n");
                for (int j = 0; j < stringArray.length; ++j) {
                    if (stringArray[j].length() == 0) continue;
                    if (j == 0) {
                        String[] stringArray2 = stringArray[j].split(" ");
                        if (stringArray2.length <= 1) continue;
                        try {
                            sendResult.status = Integer.parseInt(stringArray2[1].substring(1));
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    int n3 = stringArray[j].indexOf(":");
                    if (n3 < 0) continue;
                    String string2 = stringArray[j].substring(0, n3).trim();
                    String string3 = stringArray[j].substring(n3 + 1).trim();
                    if (string2.equalsIgnoreCase("Content-Length")) {
                        try {
                            sendResult.contentLength = Long.parseLong(string3);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (!bl || !string2.equalsIgnoreCase("Last-Modified")) continue;
                    try {
                        this.lastModified = DateUtils.parseDate((String)string3, (String[])this.parseDateFormats);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("HTTPRandomAccessFile.parseHeader: " + exception.toString());
        }
    }

    public long read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public long read(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2 + 2048];
        long[] lArray = this.readDirect(byArray2, 0, n2);
        long l = lArray[1];
        if (l > (long)n2) {
            l = n2;
        }
        if (l > 0L) {
            System.arraycopy(byArray2, (int)lArray[0], byArray, n, (int)l);
        }
        return l;
    }

    public long[] readDirect(byte[] byArray, int n, int n2) {
        long[] lArray = new long[2];
        try {
            if (this.doReconnect) {
                this.reconnect();
            }
            this.msgBuf.setLength(0);
            this.msgBuf.append("GET " + this.path + " HTTP/1.1" + CRLF);
            this.msgBuf.append("Host: " + this.host + CRLF);
            this.msgBuf.append("Range: bytes=" + this.location + "-" + (this.location + (long)n2 - 1L) + CRLF);
            this.msgBuf.append(CRLF);
            SendResult sendResult = this.sendRequest(this.msgBuf.toString().getBytes(), byArray, n, n2, false);
            lArray[0] = sendResult.headerLength;
            lArray[1] = sendResult.contentLength;
            long l = lArray[1];
            if (l > (long)n2) {
                l = n2;
            }
            this.location += l;
        }
        catch (Exception exception) {
            System.out.println("HTTPRandomAccessFile.read: " + exception.toString());
        }
        return lArray;
    }

    public SendResult sendRequest(byte[] byArray, boolean bl) {
        byte[] byArray2 = new byte[2048];
        return this.sendRequest(byArray, byArray2, 0, 0, bl);
    }

    public SendResult sendRequest(byte[] byArray, byte[] byArray2, int n, int n2, boolean bl) {
        SendResult sendResult = new SendResult();
        try {
            int n3;
            this.outStream.write(byArray);
            int n4 = 0;
            while ((n3 = byArray2.length - n4) != 0) {
                int n5 = this.inStream.read(byArray2, n4, n3);
                if (n5 == -1) continue;
                n4 += n5;
                if (!sendResult.gotHeader) {
                    this.parseHeader(sendResult, byArray2, 0, n4, bl);
                }
                if (!sendResult.gotHeader || (long)n4 < sendResult.size() && !bl) continue;
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("HTTPRandomAccessFile.sendRequest: " + exception.toString());
        }
        return sendResult;
    }

    public long getFilePointer() {
        return this.location;
    }

    public void seek(long l) {
        this.location = l;
    }

    public long lastModified() {
        return this.lastModified != null ? this.lastModified.getTime() : 0L;
    }

    public long length() {
        return this.length;
    }

    public boolean isDoReconnect() {
        return this.doReconnect;
    }

    public void setDoReconnect(boolean bl) {
        this.doReconnect = bl;
    }

    class SendResult {
        public long contentLength = 0L;
        public long headerLength = 0L;
        public long contentRead = 0L;
        public int status = 500;
        public boolean gotHeader = false;
        public boolean gotMessage = false;

        SendResult() {
        }

        public long size() {
            return this.contentLength + this.headerLength;
        }
    }
}

