/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.amf;

import com.wowza.wms.amf.AMF3Utils;
import com.wowza.wms.amf.AMFDataTrait;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Map;

public class AMFDataContextSerialize {
    private int objectEncoding = 0;
    private int targetEncoding = 0;
    private Map<String, Integer> refStrings;
    private int refStringsIndex = 0;
    private Map<Object, Integer> refObjects;
    private int refObjectsIndex = 0;
    private Map<AMFDataTrait, Integer> refTraits;
    private int refTraitsIndex = 0;

    public AMFDataContextSerialize() {
    }

    public AMFDataContextSerialize(int n) {
        this.objectEncoding = n;
    }

    public int getObjectEncoding() {
        return this.objectEncoding;
    }

    public void setObjectEncoding(int n) {
        this.objectEncoding = n;
    }

    public int getTargetEncoding() {
        return this.targetEncoding;
    }

    public void setTargetEncoding(int n) {
        this.targetEncoding = n;
    }

    public boolean isAMF3() {
        return this.objectEncoding != 0;
    }

    public boolean isAMF0() {
        return this.objectEncoding == 0;
    }

    public int getStringReference(String string) {
        Integer n;
        if (this.refStrings == null) {
            this.refStrings = new HashMap<String, Integer>();
        }
        if ((n = this.refStrings.get(string)) == null) {
            this.refStrings.put(string, new Integer(this.refStringsIndex));
            ++this.refStringsIndex;
        } else {
            return n;
        }
        return -1;
    }

    public int getObjectReference(Object object) {
        Integer n;
        if (this.refObjects == null) {
            this.refObjects = new HashMap<Object, Integer>();
        }
        if ((n = this.refObjects.get(object)) == null) {
            this.refObjects.put(object, new Integer(this.refObjectsIndex));
            ++this.refObjectsIndex;
        } else {
            return n;
        }
        return -1;
    }

    public int getTraitReference(AMFDataTrait aMFDataTrait) {
        Integer n;
        if (this.refTraits == null) {
            this.refTraits = new HashMap<AMFDataTrait, Integer>();
        }
        if ((n = this.refTraits.get(aMFDataTrait)) == null) {
            this.refTraits.put(aMFDataTrait, new Integer(this.refTraitsIndex));
            ++this.refTraitsIndex;
        } else {
            return n;
        }
        return -1;
    }

    public void writeString(DataOutputStream dataOutputStream, String string) {
        try {
            if (this.isAMF0()) {
                WMSLoggerFactory.getLogger(AMFDataContextSerialize.class).error("AMFDataContextSerialize.writeString: Only valid for AMF3.");
            }
            if (string.length() > 0) {
                int n = this.getStringReference(string);
                if (n >= 0) {
                    AMF3Utils.serializeInt(dataOutputStream, n <<= 1);
                } else {
                    AMF3Utils.serializeString(dataOutputStream, string);
                }
            } else {
                AMF3Utils.serializeZeroLengthString(dataOutputStream);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataContextSerialize.class).error("AMFDataContextSerialize.writeString: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

