/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.http;

import com.wowza.util.HTTPUtils;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.ConnectionCounter;
import com.wowza.wms.http.HTTPServerVersion;
import com.wowza.wms.http.HTTProvider2Base;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HTTPConnectionCountsXML
extends HTTProvider2Base {
    private void outputConnectionInfo(StringBuffer stringBuffer, ConnectionCounter connectionCounter) {
        stringBuffer.append("<ConnectionsCurrent>" + connectionCounter.getCurrent() + "</ConnectionsCurrent>");
        stringBuffer.append("<ConnectionsTotal>" + connectionCounter.getTotal() + "</ConnectionsTotal>");
        stringBuffer.append("<ConnectionsTotalAccepted>" + connectionCounter.getTotalAccepted() + "</ConnectionsTotalAccepted>");
        stringBuffer.append("<ConnectionsTotalRejected>" + connectionCounter.getTotalRejected() + "</ConnectionsTotalRejected>");
    }

    private void outputIOPerformanceInfo(StringBuffer stringBuffer, IOPerformanceCounter iOPerformanceCounter) {
        stringBuffer.append("<MessagesInBytesRate>" + iOPerformanceCounter.getMessagesInBytesRate() + "</MessagesInBytesRate>");
        stringBuffer.append("<MessagesOutBytesRate>" + iOPerformanceCounter.getMessagesOutBytesRate() + "</MessagesOutBytesRate>");
    }

    private int toCount(Integer n, MyCounter myCounter) {
        int n2 = n == null ? 0 : n;
        myCounter.total += n2;
        return n2;
    }

    public void onHTTPRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        Object object;
        Object object2;
        if (!this.doHTTPAuthentication(iVHost, iHTTPRequest, iHTTPResponse)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = iHTTPRequest.getQueryString();
        Map<String, String> map = HTTPUtils.splitQueryStr(string);
        boolean bl = false;
        bl = this.properties.getPropertyBoolean("isFlat", bl);
        if (map.containsKey("flat")) {
            bl = true;
        }
        try {
            object2 = VHostSingleton.getVHostNames();
            stringBuffer.append("<?xml version=\"1.0\"?>\n<WowzaMediaServer>");
            object = Server.getInstance();
            if (!bl) {
                this.outputConnectionInfo(stringBuffer, object.getConnectionCounter());
                this.outputIOPerformanceInfo(stringBuffer, object.getIoPerformanceCounter());
            }
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                IVHost iVHost2 = VHostSingleton.getInstance(string2);
                if (iVHost2 == null) continue;
                if (!bl) {
                    stringBuffer.append("<VHost>");
                    stringBuffer.append("<Name>" + URLEncoder.encode(string2, "UTF-8") + "</Name>");
                    stringBuffer.append("<TimeRunning>" + iVHost2.getTimeRunningSeconds() + "</TimeRunning>");
                    stringBuffer.append("<ConnectionsLimit>" + iVHost2.getConnectionLimit() + "</ConnectionsLimit>");
                    this.outputConnectionInfo(stringBuffer, iVHost2.getConnectionCounter());
                    this.outputIOPerformanceInfo(stringBuffer, iVHost2.getIoPerformanceCounter());
                }
                List list = iVHost2.getApplicationNames();
                for (String string3 : list) {
                    IApplication iApplication = iVHost2.getApplication(string3);
                    if (iApplication == null) continue;
                    if (!bl) {
                        stringBuffer.append("<Application>");
                        stringBuffer.append("<Name>" + URLEncoder.encode(string3, "UTF-8") + "</Name>");
                        stringBuffer.append("<Status>loaded</Status>");
                        stringBuffer.append("<TimeRunning>" + iApplication.getTimeRunningSeconds() + "</TimeRunning>");
                        this.outputConnectionInfo(stringBuffer, iApplication.getConnectionCounter());
                        this.outputIOPerformanceInfo(stringBuffer, iApplication.getIoPerformanceCounter());
                    }
                    List<String> list2 = iApplication.getAppInstanceNames();
                    for (String string4 : list2) {
                        IApplicationInstance iApplicationInstance = iApplication.getAppInstance(string4);
                        if (iApplicationInstance == null) continue;
                        if (!bl) {
                            stringBuffer.append("<ApplicationInstance>");
                            stringBuffer.append("<Name>" + URLEncoder.encode(iApplicationInstance.getName(), "UTF-8") + "</Name>");
                            stringBuffer.append("<TimeRunning>" + iApplicationInstance.getTimeRunningSeconds() + "</TimeRunning>");
                            this.outputConnectionInfo(stringBuffer, iApplicationInstance.getConnectionCounter());
                            this.outputIOPerformanceInfo(stringBuffer, iApplicationInstance.getIOPerformanceCounter());
                        }
                        Map<String, Integer> map2 = iApplicationInstance.getPlayStreamCountsByName();
                        Map<String, Integer> map3 = iApplicationInstance.getHTTPStreamerSessionCountsByName(0);
                        Map<String, Integer> map4 = iApplicationInstance.getHTTPStreamerSessionCountsByName(1);
                        Map<String, Integer> map5 = iApplicationInstance.getRTPSessionCountsByName();
                        List<String> list3 = iApplicationInstance.getStreams().getPublishStreamNames();
                        HashSet<String> hashSet = new HashSet<String>();
                        hashSet.addAll(list3);
                        hashSet.addAll(map2.keySet());
                        hashSet.addAll(map3.keySet());
                        hashSet.addAll(map4.keySet());
                        hashSet.addAll(map5.keySet());
                        for (String string5 : hashSet) {
                            MyCounter myCounter = new MyCounter();
                            if (bl) {
                                int n = this.toCount(map2.get(string5), myCounter);
                                int n2 = this.toCount(map4.get(string5), myCounter);
                                int n3 = this.toCount(map3.get(string5), myCounter);
                                int n4 = this.toCount(map5.get(string5), myCounter);
                                stringBuffer.append("<Stream ");
                                stringBuffer.append("vhostName=\"" + URLEncoder.encode(string2, "UTF-8") + "\" ");
                                stringBuffer.append("applicationName=\"" + URLEncoder.encode(string3, "UTF-8") + "\" ");
                                stringBuffer.append("appInstanceName=\"" + URLEncoder.encode(string4, "UTF-8") + "\" ");
                                stringBuffer.append("streamName=\"" + URLEncoder.encode(string5, "UTF-8") + "\" ");
                                stringBuffer.append("sessionsFlash=\"" + n + "\" ");
                                stringBuffer.append("sessionsCupertino=\"" + n2 + "\" ");
                                stringBuffer.append("sessionsSmooth=\"" + n3 + "\" ");
                                stringBuffer.append("sessionsRTSP=\"" + n4 + "\" ");
                                stringBuffer.append("sessionsTotal=\"" + myCounter.total + "\" ");
                                stringBuffer.append("/>");
                                continue;
                            }
                            stringBuffer.append("<Stream>");
                            stringBuffer.append("<Name>" + URLEncoder.encode(string5, "UTF-8") + "</Name>");
                            stringBuffer.append("<SessionsFlash>" + this.toCount(map2.get(string5), myCounter) + "</SessionsFlash>");
                            stringBuffer.append("<SessionsCupertino>" + this.toCount(map4.get(string5), myCounter) + "</SessionsCupertino>");
                            stringBuffer.append("<SessionsSmooth>" + this.toCount(map3.get(string5), myCounter) + "</SessionsSmooth>");
                            stringBuffer.append("<SessionsRTSP>" + this.toCount(map5.get(string5), myCounter) + "</SessionsRTSP>");
                            stringBuffer.append("<SessionsTotal>" + myCounter.total + "</SessionsTotal>");
                            stringBuffer.append("</Stream>");
                        }
                        if (bl) continue;
                        stringBuffer.append("</ApplicationInstance>");
                    }
                    if (bl) continue;
                    stringBuffer.append("</Application>");
                }
                if (bl) continue;
                stringBuffer.append("</VHost>");
            }
            stringBuffer.append("</WowzaMediaServer>");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPServerVersion.class).error("HTTPServerInfoXML.onHTTPRequest: " + exception.toString());
            exception.printStackTrace();
        }
        try {
            iHTTPResponse.setHeader("Content-Type", "text/xml");
            object2 = iHTTPResponse.getOutputStream();
            object = stringBuffer.toString().getBytes();
            ((OutputStream)object2).write((byte[])object);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPServerVersion.class).error("HTTPServerInfoXML.onHTTPRequest: " + exception.toString());
            exception.printStackTrace();
        }
    }

    class MyCounter {
        int total = 0;

        MyCounter() {
        }
    }
}

