/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.request;

import com.wowza.util.BufferUtils;
import com.wowza.util.IFasterByteArrayOutputStream;
import com.wowza.wms.application.Application;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.ClientWorker;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.IModulePingResult;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.FCSRequestAdapter;
import com.wowza.wms.request.IRTMPEncrypt;
import com.wowza.wms.request.RequestConnectHandshake;
import com.wowza.wms.request.RequestProcessData;
import com.wowza.wms.request.RequestProcessFunctions;
import com.wowza.wms.response.ResponseFunctions;
import com.wowza.wms.response.ResponseStreams;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.RtmpResponseMessage;
import com.wowza.wms.server.ServerHandler;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;

public class RTMPRequestAdapter {
    static final byte[] RESPONSE_SEQ_VALS = new byte[]{1, 1, 1, 1, 1, 1, 3, 5, 9, 17};
    static long lastSharedObjectUpdates = -1L;

    public static String fN(String string) {
        byte[] byArray = Application.getX();
        BigInteger bigInteger = new BigInteger(string, 36);
        byte[] byArray2 = bigInteger.toByteArray();
        for (int i = 0; i < byArray2.length; ++i) {
            int n = i;
            byArray2[n] = (byte)(byArray2[n] ^ byArray[i % byArray.length]);
        }
        return new String(byArray2);
    }

    public static String fS(byte[] byArray, String string) {
        BigInteger bigInteger = new BigInteger(string, 36);
        byte[] byArray2 = bigInteger.toByteArray();
        for (int i = 0; i < byArray2.length; ++i) {
            int n = i;
            byArray2[n] = (byte)(byArray2[n] ^ byArray[i % byArray.length]);
        }
        return new String(byArray2);
    }

    public static String sDescramble2(String string, int n) {
        String string2 = "";
        String string3 = string.substring(11, 12);
        int n2 = ServerHandler.dDecode(string3, n);
        int[] nArray = ModuleConnect.getS2(n2);
        String string4 = string.substring(0, 11) + string.substring(12, 21) + string.substring(22, 25);
        int n3 = string4.length();
        string2 = string4;
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray[i];
            string2 = string2.substring(0, n4) + string4.substring(i, i + 1) + string2.substring(n4 + 1, n3);
        }
        return string2;
    }

    public static String sUnpretty(String string) {
        String[] stringArray = string.split("[-]");
        String string2 = "";
        for (int i = 0; i < stringArray.length && i < 5; ++i) {
            string2 = string2 + stringArray[i];
        }
        return string2;
    }

    public static String sBaggage(String string) {
        String[] stringArray = string.split("[-]");
        if (stringArray.length > 5) {
            return stringArray[5];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void service(RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = -1;
        try {
            Object object;
            boolean bl;
            Object object2;
            int n3;
            int n4 = rtmpRequestMessage.getType();
            if (n4 == 5) {
                FCSRequestAdapter.service(rtmpRequestMessage, rtmpResponseMessage);
                return;
            }
            n2 = rtmpRequestMessage.getClientId();
            IVHost iVHost = VHostSingleton.getInstance(rtmpRequestMessage.getVHostName());
            if (n2 == -1) {
                if (WMSLoggerFactory.getLogger(RTMPRequestAdapter.class).isDebugEnabled()) {
                    WMSLoggerFactory.getLogger(RTMPRequestAdapter.class).debug("open");
                }
                Client client = (Client)iVHost.getClient(-1, true);
                n2 = client.getClientId();
                rtmpResponseMessage.setClientId(n2);
                int n5 = rtmpRequestMessage.getProtocol();
                if (n5 == 3) {
                    String string = n2 + "\n";
                    int n6 = string.length();
                    client.incrementTotalOutBytes(n6);
                    OutputStream outputStream = rtmpResponseMessage.getOutputStream();
                    outputStream.write(string.getBytes());
                }
                client.setProtocol(n5);
                client.setSSL(rtmpRequestMessage.isSSL());
                client.setServerHostPort(rtmpRequestMessage.getSessionInfo().getHostPort());
                return;
            }
            Client client = (Client)iVHost.getClient(n2);
            if (client == null) {
                return;
            }
            client.touch();
            client.setThreadContext();
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(RTMPRequestAdapter.class);
            if (!wMSLogger.isDebugEnabled()) {
                wMSLogger = null;
            }
            if (client.getLastRequestType() != n4) {
                client.resetResponseIndex();
            }
            client.setLastRequestType(n4);
            boolean bl2 = true;
            switch (n4) {
                case 2: {
                    Object object3;
                    client.touch();
                    n3 = rtmpRequestMessage.getContentLength();
                    int n7 = rtmpRequestMessage.getHeaderLength();
                    object2 = rtmpRequestMessage.getBody();
                    client.incrementTotalInBytes(n3);
                    int n8 = client.getHandshake();
                    if (n8 == 0) {
                        byte[] byArray = RTMPRequestAdapter.getReqBytes(client, (ByteBuffer)object2, n7, n3);
                        if (wMSLogger != null) {
                            wMSLogger.info("handshake0: " + byArray.length);
                        }
                        if (byArray.length >= 1537) {
                            client.setHandshake(1);
                            client.setLastHandshakeByte(byArray[1536]);
                            boolean bl3 = byArray[0] == 6;
                            client.setEncrypted(bl3);
                            int n9 = 0;
                            OutputStream outputStream = rtmpResponseMessage.getOutputStream();
                            byte[] byArray2 = null;
                            int n10 = 1;
                            if (byArray[5] == 0) {
                                byArray2 = new byte[1536];
                                System.arraycopy(byArray, 1, byArray2, 0, 1536);
                            } else {
                                n10 = RequestConnectHandshake.getClientHandshakeLocation(byArray, 1);
                                byArray2 = RequestConnectHandshake.generateServerHandshake(byArray, 1, n10, bl3);
                            }
                            byte[] byArray3 = new byte[4];
                            int n11 = 0;
                            if (rtmpRequestMessage.getProtocol() == 1) {
                                byArray3[0] = byArray[0];
                                outputStream.write(byArray3, 0, 1);
                                ++n11;
                            } else {
                                byArray3[0] = 1;
                                byArray3[1] = byArray[0];
                                outputStream.write(byArray3, 0, 2);
                                n11 += 2;
                            }
                            if (bl3) {
                                outputStream.write(RequestConnectHandshake.generateServerHandshake(client, byArray, 1, n10, bl3));
                            } else {
                                outputStream.write(RequestConnectHandshake.clientHandshakeRTMPFMS3);
                            }
                            outputStream.write(byArray2);
                            n9 = RequestConnectHandshake.clientHandshakeRTMPFMS3.length + byArray2.length + n11;
                            client.incrementTotalOutBytes(n9);
                            if (byArray.length > 1537) {
                                client.setLeftOverData(byArray, 1537, byArray.length - 1537);
                            }
                            bl2 = false;
                            return;
                        }
                        client.setLeftOverData(byArray, 0, byArray.length);
                        return;
                    }
                    bl = false;
                    byte[] byArray = null;
                    if (n8 == 1) {
                        byArray = RTMPRequestAdapter.getReqBytes(client, (ByteBuffer)object2, n7, n3);
                        if (wMSLogger != null) {
                            wMSLogger.debug("Handshake[1]: length:" + byArray.length);
                        }
                        if (byArray.length > 1536) {
                            long l2 = 0xFFFFFFFFFFFFFFFFL & (long)BufferUtils.byteArrayToInt(byArray, 0);
                            client.setTimebase(l2);
                            n8 = 2;
                            client.setHandshake(n8);
                            object3 = byArray;
                            byArray = new byte[byArray.length - 1536];
                            System.arraycopy(object3, 1536, byArray, 0, byArray.length);
                        } else {
                            client.setLeftOverData(byArray, 0, byArray.length);
                            return;
                        }
                    }
                    if (n8 == 2) {
                        boolean bl4 = false;
                        if (byArray == null) {
                            byArray = RTMPRequestAdapter.getReqBytes(client, (ByteBuffer)object2, n7, n3);
                        }
                        if (wMSLogger != null) {
                            wMSLogger.debug("Handshake[2]: length:" + byArray.length);
                        }
                        if (rtmpRequestMessage.getProtocol() == 3) {
                            bl4 = true;
                        } else if (byArray.length > 12) {
                            int n12 = BufferUtils.byteArrayToInt(byArray, 4, 3, false);
                            int n13 = n12 / client.getReceiveChunkSize();
                            if (n12 % client.getReceiveChunkSize() == 0) {
                                --n13;
                            }
                            if (byArray.length < 12 + n12 + n13) {
                                client.setLeftOverData(byArray, 0, byArray.length);
                            } else {
                                bl4 = true;
                            }
                        } else {
                            client.setLeftOverData(byArray, 0, byArray.length);
                        }
                        if (bl4) {
                            n3 = byArray.length;
                            object2 = ByteBuffer.wrap((byte[])byArray);
                            client.setHandshake(3);
                            object = rtmpRequestMessage.getSessionInfo().getIpAddress();
                            if (object != null) {
                                client.setIp((String)object);
                            }
                            object3 = new ArrayList();
                            RequestProcessData.processNextRequest(iVHost, client, (ByteBuffer)object2, 0, n3, (List)object3);
                            client.touch();
                            RequestProcessFunctions.processFunctions(iVHost, client, (List)object3);
                            client.touch();
                            bl = true;
                        } else {
                            return;
                        }
                    }
                    if (!bl) {
                        IRTMPEncrypt iRTMPEncrypt = client.getRTMPEncryptHandlerIn();
                        if (iRTMPEncrypt != null) {
                            object = object2.array();
                            iRTMPEncrypt.encrypt((byte[])object, n7, n3);
                        }
                        ClientWorker.processNextReq(iVHost, client, (ByteBuffer)object2, n7, n3);
                    }
                    client.touch();
                    break;
                }
                case 3: {
                    client.touch();
                    if (rtmpRequestMessage.getProtocol() == 1) {
                        RTMPRequestAdapter.validateConnection(rtmpRequestMessage, client);
                    }
                    client.checkPingTimeout();
                    if (!client.isShutdownClient()) break;
                    RTMPRequestAdapter.closeConnection(client, rtmpRequestMessage, rtmpResponseMessage);
                    bl2 = false;
                    break;
                }
                case 4: {
                    RTMPRequestAdapter.closeConnection(client, rtmpRequestMessage, rtmpResponseMessage);
                }
            }
            if (bl2) {
                IRTMPEncrypt iRTMPEncrypt;
                boolean bl5;
                rtmpResponseMessage.addResponseListener(client.getWriteListener());
                client.touch();
                n3 = client.canSendData() ? 1 : 0;
                if (n3 != 0) {
                    client.getPlayResponse();
                    client.getSharedObjectUpdates();
                    client.getStreamSendDirectMessages();
                }
                client.touch();
                ResponseFunctions responseFunctions = client.getRespFunctions();
                object2 = client.getRespStreams();
                IFasterByteArrayOutputStream iFasterByteArrayOutputStream = (IFasterByteArrayOutputStream)rtmpResponseMessage.getOutputStream();
                bl = false;
                int n14 = 0;
                boolean bl6 = bl5 = rtmpRequestMessage.getProtocol() != 1;
                if (n3 != 0 && (responseFunctions.isPending() || ((ResponseStreams)object2).isPending())) {
                    client.resetResponseIndex();
                    if (rtmpRequestMessage.getProtocol() != 1) {
                        object = new byte[]{1};
                        iFasterByteArrayOutputStream.write((byte[])object);
                        n14 += ((byte[])object).length;
                        bl = true;
                    }
                    n14 += responseFunctions.output(iFasterByteArrayOutputStream, client.getSendChunkSize());
                    client.touch();
                    n14 += ((ResponseStreams)object2).output(iFasterByteArrayOutputStream, client);
                    client.touch();
                    bl5 = false;
                }
                if (bl5) {
                    object = null;
                    n14 = 1;
                    int n15 = client.incResponseIndex();
                    object = new byte[]{n15 >= RESPONSE_SEQ_VALS.length ? (byte)33 : RESPONSE_SEQ_VALS[n15]};
                    client.touch();
                    iFasterByteArrayOutputStream.write((byte[])object);
                    bl = true;
                }
                n = n14;
                if (n14 > 0) {
                    long l3 = client.incrementTotalOutBytes(n14);
                }
                if (n3 != 0) {
                    client.doneSendData();
                }
                if (client.clearImmediateIdle()) {
                    rtmpResponseMessage.setImmediateIdle(true);
                }
                if ((iRTMPEncrypt = client.getRTMPEncryptHandlerOut()) != null) {
                    iFasterByteArrayOutputStream.encrypt(iRTMPEncrypt, bl);
                }
            }
            if (rtmpRequestMessage.getProtocol() == 1 && n4 == 2) {
                client.setLastValidateTime(System.currentTimeMillis());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        long l4 = System.currentTimeMillis();
        long l5 = l4 - l;
    }

    private static byte[] getReqBytes(Client client, ByteBuffer byteBuffer, int n, int n2) {
        byte[] byArray = null;
        byte[] byArray2 = client.getLeftOverData();
        client.clearLeftOverData();
        IRTMPEncrypt iRTMPEncrypt = client.getRTMPEncryptHandlerIn();
        if (byArray2 != null) {
            byArray = new byte[byArray2.length + n2];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            byteBuffer.position(n);
            byteBuffer.get(byArray, byArray2.length, n2);
            if (iRTMPEncrypt != null) {
                iRTMPEncrypt.encrypt(byArray, byArray2.length, n2);
            }
        } else {
            byArray = new byte[n2];
            byteBuffer.position(n);
            byteBuffer.get(byArray);
            if (iRTMPEncrypt != null) {
                iRTMPEncrypt.encrypt(byArray, 0, n2);
            }
        }
        byteBuffer.release();
        return byArray;
    }

    private static void closeConnection(Client client, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        int n = client.getClientId();
        IVHost iVHost = VHostSingleton.getInstance(rtmpRequestMessage.getVHostName());
        if (iVHost != null) {
            WMSLoggerFactory.getLogger(VHost.class).debug("sessionClosed: closeConnection: vhost:" + rtmpRequestMessage.getVHostName() + " clientId:" + n);
            iVHost.removeClient(n);
            rtmpResponseMessage.setDidClose(true);
        }
    }

    private static void validateConnection(RtmpRequestMessage rtmpRequestMessage, Client client) {
        long l = System.currentTimeMillis();
        long l2 = client.getLastValidateTime();
        long l3 = client.getValidationFrequency();
        boolean bl = false;
        long l4 = 0L;
        long l5 = client.getMaximumPendingWriteBytes();
        if (l5 > 0L) {
            IoSession ioSession = client.getIoSession();
            l4 = ioSession == null ? 0 : ioSession.getScheduledWriteBytes();
            boolean bl2 = bl = l4 > l5;
        }
        if (l2 == 0L) {
            client.setLastValidateTime(l);
        } else if (!(client.isFlashMediaLiveEncoder() || client.isValidatingConnection() || l3 <= 0L || l - l2 <= l3 && !bl)) {
            client.setValidatingConnection(true);
            long l6 = System.currentTimeMillis();
            client.setLastValidateTime(l6);
            class ValidateResult
            implements IModulePingResult {
                private long startValidateTime = 0L;
                private long startSessionBytesWritten = 0L;
                private long startWriteId = -1L;
                private long startWriteBytes = 0L;

                public ValidateResult(Client client, long l) {
                    this.startValidateTime = l;
                    IoSession ioSession = client.getIoSession();
                    if (ioSession != null) {
                        this.startSessionBytesWritten = ioSession.getWrittenBytes();
                        this.startWriteId = ioSession.getFirstWriteRequestId();
                        this.startWriteBytes = ioSession.getScheduledWriteBytes();
                    }
                }

                public void onResult(IClient iClient, long l, int n, boolean bl) {
                    boolean bl2;
                    Client client = (Client)iClient;
                    IoSession ioSession = client.getIoSession();
                    long l2 = 0L;
                    long l3 = -1L;
                    long l4 = client.getLastPingWriteId();
                    int n2 = 0;
                    if (ioSession != null) {
                        l2 = ioSession.getWrittenBytes();
                        n2 = ioSession.getScheduledWriteBytes();
                        l3 = ioSession.getFirstWriteRequestId();
                    }
                    if (bl2 = false) {
                        WMSLoggerFactory.getLogger(null).info("pingResult[" + client.getClientId() + "]: result:" + bl + " startValidateTime:" + this.startValidateTime + " lastValidateTime:" + client.getLastValidateTime() + " startWriteBytes:" + this.startWriteBytes + " startSessionBytesWritten:" + this.startSessionBytesWritten + " currentSessionBytesWritten:" + l2);
                    }
                    if (!(bl || l4 != -1L && l4 == l3)) {
                        if (this.startSessionBytesWritten > 0L && l2 > 0L && this.startWriteBytes > 0L && this.startSessionBytesWritten != l2) {
                            if (bl2) {
                                WMSLoggerFactory.getLogger(VHost.class).info("clientValidation [" + client.getClientId() + "] byteWrittenChanged[start:" + this.startWriteBytes + "]: " + this.startSessionBytesWritten + ":" + l2);
                            }
                            bl = true;
                        }
                        if (this.startValidateTime != client.getLastValidateTime()) {
                            if (bl2) {
                                WMSLoggerFactory.getLogger(VHost.class).info("clientValidation [" + client.getClientId() + "] validationTimeChanged: " + this.startValidateTime + ":" + client.getLastValidateTime());
                            }
                            bl = true;
                        }
                    }
                    client.setLastPingWriteId(l3);
                    String string = "";
                    long l5 = client.getMaximumPendingWriteBytes();
                    if (l5 > 0L && (long)n2 > l5) {
                        bl = false;
                        string = string + ": [MaximumPendingWriteBytes: writeBytes:" + n2 + ", maximumPendingWriteBytes:" + l5 + "]";
                    }
                    if (l4 != -1L && l4 == l3) {
                        string = string + ": [ClientWriteId: client:" + l4 + " current: " + l3 + " start:" + this.startWriteId + "]";
                    }
                    if (!bl) {
                        WMSLoggerFactory.getLogger(VHost.class).info("client connectionClosed [" + client.getClientId() + "] pingtimeout" + string, "session", "comment", 401, client.getClientId() + "");
                        client.setShutdownClient(true);
                    } else {
                        client.setValidatingConnection(false);
                        client.setLastValidateTime(System.currentTimeMillis());
                    }
                }
            }
            client.ping(new ValidateResult(client, l6));
        }
        if (client.isValidatingConnection()) {
            // empty if block
        }
    }
}

